/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.basicdata;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

@ExcludeFromJacocoGeneratedReport
public class IndustryAttrEditPlugIn
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final String FIRST_INDUSTRY = "firstindustry";
    private static final String SECOND_INDUSTRY = "secondindustry";
    private static final String THIRD_INDUSTRY = "thirdindustry";
    private static final String FOURTH_INDUSTRY = "fourthindustry";

    protected Map<String, String> getIndustryMap() {
        HashMap industryMap = Maps.newHashMapWithExpectedSize((int)4);
        industryMap.put(FIRST_INDUSTRY, FIRST_INDUSTRY);
        industryMap.put(SECOND_INDUSTRY, SECOND_INDUSTRY);
        industryMap.put(THIRD_INDUSTRY, THIRD_INDUSTRY);
        industryMap.put(FOURTH_INDUSTRY, FOURTH_INDUSTRY);
        return industryMap;
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        super.propertyChanged(propertyChangedArgs);
        String propertyName = propertyChangedArgs.getProperty().getName();
        if (HRStringUtils.equals((String)propertyName, (String)this.getIndustryMap().get(FIRST_INDUSTRY))) {
            this.setNextIndustryFieldInfo(this.getIndustryMap().get(FIRST_INDUSTRY), this.getIndustryMap().get(SECOND_INDUSTRY));
            this.setNullAndEnableForIndustryField(this.getIndustryMap().get(THIRD_INDUSTRY), Boolean.FALSE);
            this.setNullAndEnableForIndustryField(this.getIndustryMap().get(FOURTH_INDUSTRY), Boolean.FALSE);
        } else if (HRStringUtils.equals((String)propertyName, (String)this.getIndustryMap().get(SECOND_INDUSTRY))) {
            this.setNextIndustryFieldInfo(this.getIndustryMap().get(SECOND_INDUSTRY), this.getIndustryMap().get(THIRD_INDUSTRY));
            this.setNullAndEnableForIndustryField(this.getIndustryMap().get(FOURTH_INDUSTRY), Boolean.FALSE);
        } else if (HRStringUtils.equals((String)propertyName, (String)this.getIndustryMap().get(THIRD_INDUSTRY))) {
            this.setNextIndustryFieldInfo(this.getIndustryMap().get(THIRD_INDUSTRY), this.getIndustryMap().get(FOURTH_INDUSTRY));
        }
    }

    private void setNextIndustryFieldInfo(String currentIndustry, String nextIndustry) {
        DynamicObject industryDyn = this.getModel().getDataEntity().getDynamicObject(currentIndustry);
        if (ObjectUtils.isEmpty((Object)industryDyn)) {
            this.setNullAndEnableForIndustryField(nextIndustry, Boolean.FALSE);
        } else {
            this.setNullAndEnableForIndustryField(nextIndustry, Boolean.TRUE);
        }
    }

    private void setNullAndEnableForIndustryField(String industryField, Boolean enableFlag) {
        this.getModel().setValue(industryField, null);
        this.getView().setEnable(enableFlag, new String[]{industryField});
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        Set<Map.Entry<String, String>> entries = this.getIndustryMap().entrySet();
        for (Map.Entry<String, String> entry : entries) {
            BasedataEdit inDustryEdit = (BasedataEdit)this.getView().getControl(entry.getValue());
            inDustryEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.setCaption(beforeF7SelectEvent.getProperty().getDisplayName().getLocaleValue());
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        QFilter qFilter = null;
        if (HRStringUtils.equals((String)fieldKey, (String)this.getIndustryMap().get(SECOND_INDUSTRY))) {
            DynamicObject firstIndustryDyn = this.getModel().getDataEntity().getDynamicObject(this.getIndustryMap().get(FIRST_INDUSTRY));
            qFilter = this.buildIndustryFilter(firstIndustryDyn);
        } else if (HRStringUtils.equals((String)fieldKey, (String)this.getIndustryMap().get(THIRD_INDUSTRY))) {
            DynamicObject secondIndustryDyn = this.getModel().getDataEntity().getDynamicObject(this.getIndustryMap().get(SECOND_INDUSTRY));
            qFilter = this.buildIndustryFilter(secondIndustryDyn);
        } else if (HRStringUtils.equals((String)fieldKey, (String)this.getIndustryMap().get(FOURTH_INDUSTRY))) {
            DynamicObject thirdIndustryDyn = this.getModel().getDataEntity().getDynamicObject(this.getIndustryMap().get(THIRD_INDUSTRY));
            qFilter = this.buildIndustryFilter(thirdIndustryDyn);
        }
        showParameter.getListFilterParameter().setFilter(qFilter);
    }

    private QFilter buildIndustryFilter(DynamicObject industryDyn) {
        if (ObjectUtils.isEmpty((Object)industryDyn) || ObjectUtils.isEmpty((Object)industryDyn.getLocaleString("name")) || ObjectUtils.isEmpty((Object)industryDyn.getLocaleString("name").getLocaleValue()) || !industryDyn.getLocaleString("name").getLocaleValue().contains("_")) {
            return null;
        }
        String industryDynName = industryDyn.getLocaleString("name").getLocaleValue();
        String parentIndustry = industryDynName.substring(0, industryDynName.indexOf("_"));
        QFilter industryFilter = new QFilter("name", "like", (Object)(parentIndustry + "%"));
        return industryFilter;
    }
}

