/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.control;

import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class AddressEditPlugin
extends HRDynamicFormBasePlugin {
    private static final Log logger = LogFactory.getLog(AddressEditPlugin.class);
    private static final String BTN_CONFIRM = "btnconfirm";
    private static final String FIELD_ADDRESSAD = "addressad";
    private static final String FIELD_FULLADDRESS = "fulladdress";
    private static final String DISPLAYNAME_ADDRESSAD = "displayname_addressad";
    private static final String DISPLAYNAME_FULLADDRESS = "displayname_fulladdress";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{BTN_CONFIRM});
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.setFieldDisplayName();
        this.setDefaultValue();
    }

    private void setDefaultValue() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String addressADId = (String)formShowParameter.getCustomParam(FIELD_ADDRESSAD);
        if (formShowParameter.getCustomParam(FIELD_FULLADDRESS) == null) {
            return;
        }
        Map fullAddressMap = null;
        try {
            String fullAddressStr = HRJSONUtils.toString((Object)formShowParameter.getCustomParam(FIELD_FULLADDRESS));
            fullAddressMap = HRJSONUtils.convertJSONObjectToMap((Object)fullAddressStr);
        }
        catch (IOException e1) {
            logger.error((Throwable)e1);
        }
        catch (Exception e1) {
            logger.error((Throwable)e1);
        }
        if (fullAddressMap == null || fullAddressMap.size() == 0) {
            return;
        }
        this.getModel().setValue(FIELD_ADDRESSAD, (Object)addressADId);
        this.getModel().setValue(FIELD_FULLADDRESS, (Object)LocaleString.fromMap((Map)fullAddressMap));
    }

    private void setFieldDisplayName() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String addressadDisplayname = (String)formShowParameter.getCustomParam(DISPLAYNAME_ADDRESSAD);
        String fulladdressDisplayname = (String)formShowParameter.getCustomParam(DISPLAYNAME_FULLADDRESS);
        FieldEdit addressADEdit = (FieldEdit)this.getControl(FIELD_ADDRESSAD);
        addressADEdit.setCaption(new LocaleString(addressadDisplayname));
        FieldEdit fulladdressEdit = (FieldEdit)this.getControl(FIELD_FULLADDRESS);
        fulladdressEdit.setCaption(new LocaleString(fulladdressDisplayname));
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)key, (String)BTN_CONFIRM)) {
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put(FIELD_ADDRESSAD, this.getModel().getValue(FIELD_ADDRESSAD));
            returnData.put(FIELD_FULLADDRESS, this.getModel().getValue(FIELD_FULLADDRESS));
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        }
    }
}

