/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.flow;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.upgrade.ClassManager;
import kd.bos.workflow.component.WorkflowDesigner;
import kd.bos.workflow.design.plugin.IWorkflowDesigner;
import kd.hr.hbp.business.flow.chart.FlowChartVo;
import kd.hr.hbp.business.flow.chart.NodeInfo;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FlowChartEdit
extends AbstractFormPlugin
implements IWorkflowDesigner {
    private static final String NODE_ID_TO_CHART_ID_MAP = "nodeIdToChartIdMap";
    private static final String FLOWCHART_ROW_COUNT = "flowchartRowCount";

    public Map<String, Object> getDesignerInitData(Map<String, Object> params) {
        HashMap<String, Object> data = new HashMap<String, Object>(1);
        try {
            FlowChartVo flowChartVo;
            Object isServiceGetVo = this.getView().getFormShowParameter().getCustomParam("customIsServiceGetVo");
            if ("true".equals(String.valueOf(isServiceGetVo))) {
                flowChartVo = this.getFlowChartVo();
            } else {
                JSONObject flowChartJsonObj = (JSONObject)this.getView().getFormShowParameter().getCustomParam("customFlowChartVoKey");
                flowChartVo = (FlowChartVo)flowChartJsonObj.toJavaObject(FlowChartVo.class);
            }
            data.put("graph_xml", this.getGraphXml(flowChartVo));
        }
        catch (Exception e) {
            IFormView parentView = this.getView().getParentView();
            parentView.showErrMessage(ExceptionUtils.getStackTrace((Throwable)e), e.toString());
            this.getView().sendFormAction(parentView);
            this.getView().close();
            throw e;
        }
        return data;
    }

    private FlowChartVo getFlowChartVo() {
        String servicePath = (String)this.getView().getFormShowParameter().getCustomParam("customFlowServicePath");
        Object dyId = this.getView().getFormShowParameter().getCustomParam("customFlowChartDyId");
        String metaNumber = (String)this.getView().getFormShowParameter().getCustomParam("customFlowChartDyMetaNumber");
        try {
            Class clazz = ClassManager.forName((String)servicePath);
            Method getFlowChartVoMethod = clazz.getMethod("getFlowChartVo", Object.class, String.class);
            return (FlowChartVo)getFlowChartVoMethod.invoke(clazz.newInstance(), dyId, metaNumber);
        }
        catch (NoSuchMethodException e) {
            throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe\u670d\u52a1\u4e2d\u627e\u4e0d\u5230\u9ed8\u8ba4\u7684\u6d41\u7a0b\u56fe\u670d\u52a1\u63a5\u53e3\u5b9e\u73b0\u65b9\u6cd5\u201c{0}\u201d\u3002", (String)"FlowChartEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "getFlowChartVo"));
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6d41\u7a0b\u56fe\u670d\u52a1\u6267\u884c\u5931\u8d25\u3002", (String)"FlowChartEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("refresh".equals(operate.getOperateKey())) {
            WorkflowDesigner designer = (WorkflowDesigner)this.getView().getControl("flowdesigner");
            Map<String, Object> data = this.getDesignerInitData(new HashMap<String, Object>(0));
            designer.open("WorkflowModel", data);
        }
    }

    public String getGraphXml(FlowChartVo flowChartVo) {
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        xml.append("<mxGraphModel grid=\"0\">");
        xml.append("    <root>");
        xml.append("        <mxCell id=\"node_0\" />");
        xml.append("        <mxCell id=\"node_1\" type=\"Diagram\" parent=\"node_0\">");
        xml.append("            <Object process_id=\"hbp_flow_chart\" as=\"properties\" />");
        xml.append("        </mxCell>");
        String startNodeId = "hbp_flow_chart_StartSignalEvent";
        String startNodeName = flowChartVo.getStartNodeName();
        NodeInfo startNode = (NodeInfo)flowChartVo.getNodeInfoMap().get(flowChartVo.getStartNodeId());
        if (Objects.isNull(startNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u8282\u70b9\u83b7\u53d6\u4e3a\u7a7a\u3002", (String)"FlowChartEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
        String startNodeStatus = startNode.getStatus().getCode();
        String startNodeStyle = "shape=ierp.bpmn.StartSignalEvent_" + startNodeStatus + ";whiteSpace=wrap;spacingLeft=50;spacingRight=10;overflow=hidden;";
        double startNodeWidth = 115.0;
        double startNodeHeight = 45.0;
        double startNodeX = 356.0;
        double startNodeY = 0.0;
        xml.append(this.getOneNodeStr(startNodeId, startNodeName, startNodeStyle, "StartSignalEvent", "node_1", 1, false, startNodeWidth, startNodeHeight, startNodeX, startNodeY));
        Map<String, Object> nodeParams = this.paintDynamicNode(xml, flowChartVo, startNodeX - 17.5, startNodeY);
        int nodeRowNum = (Integer)nodeParams.get(FLOWCHART_ROW_COUNT);
        String endNodeId = "hbp_flow_chart_EndNoneEvent";
        String endNodeName = flowChartVo.getEndNodeName();
        NodeInfo endNode = (NodeInfo)flowChartVo.getNodeInfoMap().get(flowChartVo.getEndNodeId());
        if (Objects.isNull(endNode)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u675f\u8282\u70b9\u83b7\u53d6\u4e3a\u7a7a\u3002", (String)"FlowChartEdit_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
        String endNodeStatus = endNode.getStatus().getCode();
        String endNodeStyle = "shape=ierp.bpmn.EndNoneEvent_" + endNodeStatus + ";whiteSpace=wrap;spacingLeft=50;spacingRight=10;overflow=hidden;";
        double endNodeWidth = 115.0;
        double endNodeHeight = 45.0;
        double endNodeX = 356.0;
        double endNodeY = 100 * (nodeRowNum - 1);
        xml.append(this.getOneNodeStr(endNodeId, endNodeName, endNodeStyle, "StartSignalEvent", "node_1", 1, false, endNodeWidth, endNodeHeight, endNodeX, endNodeY));
        this.paintLine(flowChartVo, xml, startNodeId, nodeParams, endNodeId);
        xml.append("    </root>");
        xml.append("</mxGraphModel>");
        return xml.toString();
    }

    private void paintLine(FlowChartVo flowChartVo, StringBuilder xml, String startNodeId, Map<String, Object> nodeParams, String endNodeId) {
        Map nodeIdToNextIdMap = flowChartVo.getNodeIdToNextIdMap();
        Map nodeIdMap = (Map)nodeParams.get(NODE_ID_TO_CHART_ID_MAP);
        nodeIdMap.put(flowChartVo.getStartNodeId(), startNodeId);
        nodeIdMap.put(flowChartVo.getEndNodeId(), endNodeId);
        int lineCount = 1;
        String FLOWCHART_LINE_STYLE = "html=1;jettySize=auto;orthogonalLoop=1;strokeColor=#7F93BC;";
        for (Map.Entry entry : nodeIdToNextIdMap.entrySet()) {
            String nodeId = (String)entry.getKey();
            List subNodeIds = (List)entry.getValue();
            String sourceId = (String)nodeIdMap.get(nodeId);
            String lineIdPre = "hbp_flow_chart_SequenceFlow";
            for (String subNodeId : subNodeIds) {
                String targetId = (String)nodeIdMap.get(subNodeId);
                String lineId = lineIdPre + lineCount;
                String lineStyle = "html=1;jettySize=auto;orthogonalLoop=1;strokeColor=#7F93BC;exitX=0.5;exitY=1;entryX=0.5;entryY=0";
                String kneePoint = "";
                xml.append(this.getOneLineStr(lineId, lineStyle, "SequenceFlow", "node_1", 1, sourceId, targetId, kneePoint));
                ++lineCount;
            }
        }
    }

    private Map<String, Object> paintDynamicNode(StringBuilder xml, FlowChartVo flowChartVo, double startNodeX, double startNodeY) {
        Map nodeIdToNextIdMap = flowChartVo.getNodeIdToNextIdMap();
        Map nodeInfoMap = flowChartVo.getNodeInfoMap();
        LinkedHashMap<String, Integer> nodeRowMap = new LinkedHashMap<String, Integer>(nodeIdToNextIdMap.size());
        int totalRowNum = this.setNodeRowMap(flowChartVo, nodeRowMap);
        List<List<String>> batchSortedNodeIdList = this.getBatchSortedNodeIdList(nodeRowMap, totalRowNum);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        HashMap<String, String> nodeIdMap = new HashMap<String, String>(nodeIdToNextIdMap.size());
        int count = 0;
        for (int i = 1; i < batchSortedNodeIdList.size(); ++i) {
            List<String> nodeIds = batchSortedNodeIdList.get(i);
            int size = nodeIds.size();
            int middleColumn = size / 2;
            boolean isOdd = size % 2 != 0;
            for (int j = 0; j < size; ++j) {
                String nodeId = nodeIds.get(j);
                if (flowChartVo.getEndNodeId().equals(nodeId)) continue;
                ++count;
                NodeInfo nodeInfo = (NodeInfo)nodeInfoMap.get(nodeId);
                if (Objects.isNull(nodeInfo)) {
                    throw new KDBizException(MessageFormat.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8282\u70b9[{0}]\u4fe1\u606f\u4e3a\u7a7a", (String)"FlowChartEdit_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), nodeId));
                }
                String nodeName = nodeInfo.getName();
                String nodeStyle = nodeInfo.getType().getCode();
                String id = "hbp_flow_chart_AutoTask" + count;
                String style = "shape=ierp.bpmn." + nodeStyle + "_" + nodeInfo.getStatus().getCode() + ";whiteSpace=wrap;spacingLeft=50;spacingRight=10;overflow=hidden;";
                double width = 150.0;
                double height = 45.0;
                double x = isOdd ? (j < middleColumn ? startNodeX - (double)(middleColumn - j) * (width + 50.0) : startNodeX + (double)(j - middleColumn) * (width + 50.0)) : (j < middleColumn ? startNodeX - (double)(middleColumn - j) * (width + 50.0) : startNodeX + (double)(j - middleColumn + 1) * (width + 50.0));
                double y = startNodeY + (double)(i * 100);
                xml.append(this.getOneNodeStr(id, nodeName, style, "AutoTask", "node_1", 1, false, width, height, x, y));
                nodeIdMap.put(nodeId, id);
            }
        }
        result.put(NODE_ID_TO_CHART_ID_MAP, nodeIdMap);
        result.put(FLOWCHART_ROW_COUNT, totalRowNum);
        return result;
    }

    private String getOneNodeStr(String id, String value, String style, String type, String parent, int vertex, boolean clickable, double width, double height, double x, double y) {
        StringBuilder nodeStr = new StringBuilder();
        nodeStr.append("        <mxCell id=\"").append(id).append("\" ");
        nodeStr.append("value=\"").append(value).append("\" ");
        nodeStr.append("style=\"").append(style).append("\" ");
        nodeStr.append("type=\"").append(type).append("\" ");
        nodeStr.append("parent=\"").append(parent).append("\" ");
        nodeStr.append("vertex=\"").append(vertex).append("\" ");
        nodeStr.append("clickable=\"").append(clickable).append("\">");
        nodeStr.append("            <Object paramName=\"paramValue\" as=\"properties\" />");
        nodeStr.append("            <mxGeometry width=\"").append(width).append("\" ");
        nodeStr.append("height=\"").append(height).append("\" ");
        nodeStr.append("x=\"").append(x).append("\" ");
        nodeStr.append("y=\"").append(y).append("\" ");
        nodeStr.append("as=\"").append("geometry").append("\"/>");
        nodeStr.append("        </mxCell>");
        return nodeStr.toString();
    }

    private String getOneLineStr(String id, String style, String type, String parent, int edge, String source, String target, String kneePoint) {
        StringBuilder lineStr = new StringBuilder();
        lineStr.append("        <mxCell id=\"").append(id).append("\" ");
        lineStr.append("style=\"").append(style).append("\" ");
        lineStr.append("type=\"").append(type).append("\" ");
        lineStr.append("parent=\"").append(parent).append("\" ");
        lineStr.append("edge=\"").append(edge).append("\" ");
        lineStr.append("source=\"").append(source).append("\" ");
        lineStr.append("target=\"").append(target).append("\">");
        lineStr.append("<mxGeometry relative=\"1\" as=\"geometry\" >");
        lineStr.append("<Array as=\"points\">");
        lineStr.append(kneePoint);
        lineStr.append("</Array>");
        lineStr.append("</mxGeometry>");
        lineStr.append("        </mxCell>");
        return lineStr.toString();
    }

    private int setNodeRowMap(FlowChartVo flowChartVo, Map<String, Integer> nodeRowMap) {
        Map nodeIdToNextIdMap = flowChartVo.getNodeIdToNextIdMap();
        nodeRowMap.put(flowChartVo.getStartNodeId(), 1);
        ArrayList<String> needSetRowNodes = new ArrayList<String>((Collection)nodeIdToNextIdMap.get(flowChartVo.getStartNodeId()));
        ArrayList<String> nextNodes = new ArrayList<String>(needSetRowNodes);
        return this.setNodeMapInfoDoLoop(nodeIdToNextIdMap, nodeRowMap, needSetRowNodes, nextNodes, 1);
    }

    private int setNodeMapInfoDoLoop(Map<String, List<String>> nodeNextMap, Map<String, Integer> result, List<String> needSetRowNodes, List<String> nextNodes, int rowNum) {
        ++rowNum;
        for (String nodeId : nextNodes) {
            result.put(nodeId, rowNum);
            needSetRowNodes.remove(nodeId);
            needSetRowNodes.addAll((Collection<String>)nodeNextMap.get(String.valueOf(nodeId)));
        }
        if (needSetRowNodes.isEmpty()) {
            return rowNum;
        }
        rowNum = this.setNodeMapInfoDoLoop(nodeNextMap, result, needSetRowNodes, new ArrayList<String>(needSetRowNodes), rowNum);
        return rowNum;
    }

    private List<List<String>> getBatchSortedNodeIdList(Map<String, Integer> nodeRowMap, int totalRowNum) {
        ArrayList<List<String>> batchSortedNodeIdList = new ArrayList<List<String>>(totalRowNum);
        for (int i = 0; i < totalRowNum; ++i) {
            ArrayList<String> rowNodes = new ArrayList<String>(10);
            for (Map.Entry<String, Integer> entry : nodeRowMap.entrySet()) {
                if (entry.getValue() != i + 1) continue;
                rowNodes.add(entry.getKey());
            }
            batchSortedNodeIdList.add(rowNodes);
        }
        return batchSortedNodeIdList;
    }
}

