/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.flow;

import java.util.EventObject;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.hr.hbp.business.flow.helper.FlowJobHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class JobFlowInsEdit
extends HRDataBaseEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillShowParameter baseShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if (Objects.nonNull(baseShowParameter.getPkId())) {
            DynamicObjectCollection flowDetail = this.getModel().getEntryEntity("hrflowentry");
            Map<String, DynamicObject> entryMap = flowDetail.stream().collect(Collectors.toMap(dy -> dy.getString("entryboid"), dy -> dy));
            for (DynamicObject detail : flowDetail) {
                String idsStr = detail.getString("frontnodeentryids");
                String frontNodeName = this.getNewFrontNodeName(entryMap, idsStr);
                detail.set("frontnodename", (Object)frontNodeName);
            }
            this.getModel().setDataChanged(false);
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (Objects.nonNull(operationResult) && operationResult.isSuccess() && "showflowchart".equalsIgnoreCase(operate.getOperateKey())) {
            this.openFlowChart();
        }
    }

    private void openFlowChart() {
        Object id;
        BillShowParameter baseShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        Object boId = baseShowParameter.getCustomParam("boid");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hbp_flow_chart");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setClientParam("billId", (Object)"hbp_flow_chart");
        formShowParameter.setShowTitle(true);
        formShowParameter.setShowFullScreen(true);
        Object object = Objects.nonNull(baseShowParameter.getPkId()) ? baseShowParameter.getPkId() : (id = Objects.nonNull(boId) ? boId : null);
        if (Objects.nonNull(id)) {
            formShowParameter.setCustomParam("customIsServiceGetVo", (Object)Boolean.TRUE);
            formShowParameter.setCustomParam("customFlowChartDyId", id);
            formShowParameter.setCustomParam("customFlowChartDyMetaNumber", (Object)baseShowParameter.getFormId());
            formShowParameter.setCustomParam("customFlowServicePath", (Object)"kd.hr.hbp.business.flow.chart.FlowInsChartServiceImpl");
            this.getView().showForm(formShowParameter);
        }
    }

    private String getNewFrontNodeName(Map<String, DynamicObject> entryBoIdToDy, String newFrontIds) {
        StringBuilder name = new StringBuilder();
        if (HRStringUtils.isNotEmpty((String)newFrontIds)) {
            String[] entryBoIds;
            for (String id : entryBoIds = newFrontIds.split(";")) {
                String flowEntryEntityName;
                DynamicObject entryDy = entryBoIdToDy.get(id);
                if (!Objects.nonNull(entryDy) || !HRStringUtils.isNotEmpty((String)(flowEntryEntityName = FlowJobHelper.getFlowEntryEntityName((DynamicObject)entryDy, (boolean)true)))) continue;
                name.append(flowEntryEntityName).append(';');
            }
        }
        return name.toString();
    }
}

