/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.flow;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class TreeFieldF7Edit
extends HRDataBaseEdit
implements TreeNodeClickListener {
    private static final String FIELD_SELECT_VALUE = "selectvalue";
    private static final String FIELD_SELECT_DISPLAY_NAME = "selectdisplayname";
    private static final String CONTROL_TREE_FIELD = "treefield";
    public static final String CUSTOM_PARAM_TREE_NODES = "treeNodes";
    public static final String CUSTOM_PARAM_SELECT_VALUE = "selectValue";
    public static final String CUSTOM_PARAM_SELECT_DISPLAY_NAME = "selectDisplayName";
    public static final String CUSTOM_PARAM_FORM_TITLE = "formTitle";
    public static final String META_NUMBER_TREE_FIELD_F7 = "hbp_treefield_f7";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
        TreeView tv = (TreeView)this.getView().getControl(CONTROL_TREE_FIELD);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter showParameter = e.getFormShowParameter();
        String formTitle = (String)showParameter.getCustomParam(CUSTOM_PARAM_FORM_TITLE);
        if (HRStringUtils.isNotEmpty((String)formTitle)) {
            showParameter.setCaption(formTitle);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String json = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_PARAM_TREE_NODES);
        String oldSelectFieldValue = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_PARAM_SELECT_VALUE);
        String oldSelectFieldDisplayName = (String)this.getView().getFormShowParameter().getCustomParam(CUSTOM_PARAM_SELECT_DISPLAY_NAME);
        this.getModel().setValue(FIELD_SELECT_VALUE, (Object)oldSelectFieldValue);
        this.getModel().setValue(FIELD_SELECT_DISPLAY_NAME, (Object)oldSelectFieldDisplayName);
        this.getView().updateView(FIELD_SELECT_VALUE);
        this.getView().updateView(FIELD_SELECT_DISPLAY_NAME);
        if (HRStringUtils.isNotEmpty((String)json)) {
            this.fillTreeNodes(json, oldSelectFieldValue);
        } else {
            this.addTreeRootNode();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (BTN_OK.equalsIgnoreCase(ctlSource.getKey())) {
            String currNodeId = (String)this.getModel().getValue(FIELD_SELECT_VALUE);
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                String displayName = (String)this.getModel().getValue(FIELD_SELECT_DISPLAY_NAME);
                HashMap result = Maps.newHashMapWithExpectedSize((int)2);
                result.put(CUSTOM_PARAM_SELECT_VALUE, currNodeId);
                result.put(CUSTOM_PARAM_SELECT_DISPLAY_NAME, displayName);
                this.getView().returnDataToParent((Object)result);
            } else {
                this.getView().returnDataToParent(null);
            }
            this.getView().close();
        } else if (BTN_CANCEL.equalsIgnoreCase(ctlSource.getKey())) {
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent treeNodeEvent) {
        String parentNodeId = (String)treeNodeEvent.getParentNodeId();
        if (HRStringUtils.isEmpty((String)parentNodeId)) {
            return;
        }
        String currNodeValue = (String)treeNodeEvent.getNodeId();
        TreeView treeView = (TreeView)treeNodeEvent.getSource();
        Map focusNode = treeView.getTreeState().getFocusNode();
        this.getModel().setValue(FIELD_SELECT_VALUE, (Object)currNodeValue);
        this.getModel().setValue(FIELD_SELECT_DISPLAY_NAME, focusNode.get("text"));
    }

    public void treeNodeDoubleClick(TreeNodeEvent treeNodeEvent) {
        String parentNodeId = (String)treeNodeEvent.getParentNodeId();
        if (HRStringUtils.isEmpty((String)parentNodeId)) {
            return;
        }
        String currNodeId = (String)treeNodeEvent.getNodeId();
        if ("0".equals(currNodeId)) {
            currNodeId = "";
        }
        if (!StringUtils.isBlank((CharSequence)currNodeId)) {
            TreeView treeView = (TreeView)treeNodeEvent.getSource();
            Map focusNode = treeView.getTreeState().getFocusNode();
            HashMap result = Maps.newHashMapWithExpectedSize((int)2);
            result.put(CUSTOM_PARAM_SELECT_VALUE, currNodeId);
            result.put(CUSTOM_PARAM_SELECT_DISPLAY_NAME, focusNode.get("text").toString());
            this.getView().returnDataToParent((Object)result);
            this.getView().close();
        }
    }

    private void fillTreeNodes(String strJson, String focusNodeId) {
        TreeNode focusNode;
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)strJson, TreeNode.class);
        TreeView tree = (TreeView)this.getView().getControl(CONTROL_TREE_FIELD);
        tree.addNode(rootNode);
        if (HRStringUtils.isNotEmpty((String)focusNodeId) && Objects.nonNull(focusNode = this.getFocusNode(rootNode, focusNodeId))) {
            tree.focusNode(focusNode);
        }
    }

    private void addTreeRootNode() {
        TreeNode root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5b57\u6bb5\u5217\u8868", (String)"TreeFieldF7Edit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        TreeView tree = (TreeView)this.getView().getControl(CONTROL_TREE_FIELD);
        tree.addNode(root);
    }

    private TreeNode getFocusNode(TreeNode currentNode, String focusId) {
        if (HRStringUtils.isNotEmpty((String)currentNode.getId()) && currentNode.getId().equals(focusId)) {
            return currentNode;
        }
        if (Objects.nonNull(currentNode.getChildren()) && currentNode.getChildren().size() > 0) {
            for (TreeNode childNode : currentNode.getChildren()) {
                TreeNode focusNode = this.getFocusNode(childNode, focusId);
                if (focusNode == null) continue;
                return focusNode;
            }
            return null;
        }
        return null;
    }
}

