/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.formula;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.Html;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.entity.freemarker.FormulaDescFreemarkerVO;
import kd.hr.hbp.business.service.formula.entity.item.DataGradeResultItem;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.entity.item.ParamItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.helper.FormulaViewServiceHelper;
import kd.hr.hbp.business.service.formula.utils.FormulaCacheUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaTreeNodeUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;
import kd.hr.hbp.business.util.FreemarkerUtil;
import kd.hr.hbp.common.util.HRStringUtils;

public class FormulaFuncTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final Log LOG = LogFactory.getLog(FormulaFuncTreePlugin.class);
    private static final String FUNCTREE = "functree";
    private static final String SEARCHFUNC = "searchfunc";
    private static final String DESCHTML = "deschtml";
    private static final String TEMPLATE_NAME = "FormulaEditDesc";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(FUNCTREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl(SEARCHFUNC);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String parentNodeId = (String)evt.getParentNodeId();
        if (HRStringUtils.isEmpty((String)parentNodeId)) {
            return;
        }
        Html html = (Html)this.getView().getControl(DESCHTML);
        String desc = "";
        FunctionItem funcData = FormulaCacheUtils.findFuncById((String)String.valueOf(evt.getNodeId()), (IFormView)this.getView());
        try {
            if (Objects.nonNull(funcData)) {
                if (!funcData.isHasChild()) {
                    desc = new FreemarkerUtil(FormulaFuncTreePlugin.class, "/formula/template").process((Object)new FormulaDescFreemarkerVO(funcData), TEMPLATE_NAME);
                }
            } else {
                DataGradeResultItem dataGradeItem = FormulaCacheUtils.findDataGradeById((String)String.valueOf(evt.getNodeId()), (IFormView)this.getView());
                if (Objects.nonNull(dataGradeItem) && !dataGradeItem.isHasChild() && Objects.nonNull(dataGradeItem.getParentItem())) {
                    desc = new FreemarkerUtil(FormulaFuncTreePlugin.class, "/formula/template").process((Object)new FormulaDescFreemarkerVO(dataGradeItem), TEMPLATE_NAME);
                }
            }
        }
        catch (Exception exception) {
            this.getView().showErrorNotification("freemarker_analysis_error:" + exception.getMessage());
        }
        html.setConent(desc);
        this.getView().setVisible(Boolean.TRUE, new String[]{DESCHTML});
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        String parentNodeId = (String)evt.getParentNodeId();
        if (HRStringUtils.isEmpty((String)parentNodeId) || FormulaViewServiceHelper.isViewStatus((IFormView)this.getView())) {
            return;
        }
        StringBuilder value = new StringBuilder();
        FunctionItem funcData = FormulaCacheUtils.findFuncById((String)String.valueOf(evt.getNodeId()), (IFormView)this.getView());
        if (Objects.nonNull(funcData)) {
            if (funcData.isHasChild()) {
                return;
            }
            String prefix = funcData.getItemCategory() + "[%s]";
            value.append(String.format(prefix, funcData.getName()));
            List paramList = funcData.getParams();
            this.appendParams(value, paramList);
            value.append(')');
        } else {
            DataGradeResultItem dataGradeResultItem = FormulaCacheUtils.findDataGradeById((String)String.valueOf(evt.getNodeId()), (IFormView)this.getView());
            if (Objects.isNull(dataGradeResultItem) || dataGradeResultItem.isHasChild()) {
                return;
            }
            String prefix = dataGradeResultItem.getItemCategory() + "[%s]";
            value.append(String.format(prefix, dataGradeResultItem.getParentItem().getName()));
            List paramList = dataGradeResultItem.getParentItem().getDataGradeParams();
            this.appendParams(value, paramList);
            value.append(", ").append(dataGradeResultItem.getName());
            value.append(')');
        }
        CustomControl formulaEditor = (CustomControl)this.getView().getControl("formulaeditor");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("method", "insertValue");
        data.put("value", value.toString());
        data.put("date", String.valueOf(new Date().getTime()));
        formulaEditor.setData(data);
    }

    private void appendParams(StringBuilder value, List<ParamItem> paramList) {
        value.append('(');
        if (paramList != null && paramList.size() > 0) {
            int size = paramList.size();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    value.append(',').append(' ');
                    continue;
                }
                value.append(' ');
            }
        }
    }

    public void search(SearchEnterEvent arg) {
        String searchText = arg.getText();
        List functionNodeItem = FormulaCacheUtils.getListCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_fuc_tree_node_cache_key", TreeNodeItem.class);
        List dataGradeNodeItem = FormulaCacheUtils.getListCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_data_grade_tree_node_cache_key", DataGradeResultItem.class);
        List dataGradeTreeItemList = FormulaUtils.getDataGradeTreeItemList((List)dataGradeNodeItem);
        boolean isFunctionFind = this.searchByCache(functionNodeItem, searchText, FormulaTreeNodeUtils.getFunctionRootItem());
        boolean isDataGradeFind = this.searchByCache(dataGradeTreeItemList, searchText, FormulaTreeNodeUtils.getDataGradeRootItem());
        if (!isFunctionFind && !isDataGradeFind) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"FormulaFuncTreePlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean searchByCache(List<TreeNodeItem> treeNodeItems, String searchText, TreeNodeItem rootNode) {
        List<Object> findNodeItems;
        if (HRStringUtils.isNotEmpty((String)searchText)) {
            findNodeItems = treeNodeItems.stream().filter(treeNodeItem -> HRStringUtils.isNotEmpty((String)treeNodeItem.getName()) && treeNodeItem.getName().contains(searchText)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(findNodeItems)) {
                this.renderTree(rootNode, findNodeItems);
                return false;
            }
            List parentNodeItem = FormulaTreeNodeUtils.getAllParentTreeNodeItem(findNodeItems, treeNodeItems);
            List childNodeItem = FormulaTreeNodeUtils.getAllChildTreeNodeItem(findNodeItems, treeNodeItems);
            findNodeItems.addAll(parentNodeItem);
            findNodeItems.addAll(childNodeItem);
        } else {
            findNodeItems = treeNodeItems;
        }
        if (findNodeItems != null && !findNodeItems.isEmpty()) {
            findNodeItems.add(rootNode);
        }
        this.renderTree(rootNode, findNodeItems);
        return true;
    }

    private void renderTree(TreeNodeItem rootNode, List<TreeNodeItem> findNodeItems) {
        TreeView treeView = (TreeView)this.getView().getControl(FUNCTREE);
        treeView.deleteNode(rootNode.getId());
        treeView.expand(rootNode.getId());
        FormulaTreeNodeUtils.loadTreeNodeItemList(findNodeItems).ifPresent(arg_0 -> ((TreeView)treeView).addNodes(arg_0));
    }
}

