/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.formula;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.entity.floatcontrol.SelectItem;
import kd.hr.hbp.business.service.formula.entity.item.CalItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.service.formula.enums.CalItemTypeEnum;
import kd.hr.hbp.business.service.formula.helper.FormulaViewServiceHelper;
import kd.hr.hbp.business.service.formula.utils.FormulaCacheUtils;
import kd.hr.hbp.business.service.formula.utils.FormulaTreeNodeUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.formula.FloatResult;

public class FormulaItemTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final String ITEMTREEVIEW = "itemtreeview";
    private static final String SEARCHAP = "searchap";
    private static final String FORMULAEDITOR = "formulaeditor";
    private static final String FLOAT = "float";
    private static final String APPEND_LOAD_DATA = "appendLoadData";
    private static final String SEARCH_LIST_ITEM = "searchListItem";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(ITEMTREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        String parentId = (String)evt.getParentNodeId();
        if (HRStringUtils.isEmpty((String)parentId)) {
            return;
        }
        FloatResult floatResult = this.getItemValue(nodeId, 0, null);
        if (floatResult != null && !HRObjectUtils.isEmpty(floatResult.getItems())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FLOAT});
            this.showFloat(floatResult, nodeId, false, false);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{FLOAT});
        }
    }

    private FloatResult getItemValue(String nodeId, int start, String searchValue) {
        CalItem calItem = this.getCalItemByNodeId(nodeId);
        if (Objects.nonNull(calItem)) {
            if (CalItemTypeEnum.BASE_DATA == calItem.getItemType() && HRStringUtils.isNotEmpty((String)calItem.getEntityNumber()) && HRStringUtils.isNotEmpty((String)calItem.getPropertyField())) {
                return this.getBaseDataFloatList(calItem, start, searchValue);
            }
            if (CalItemTypeEnum.ENUM == calItem.getItemType() && HRStringUtils.isNotEmpty((String)calItem.getEntityNumber()) && HRStringUtils.isNotEmpty((String)calItem.getPropertyField())) {
                return this.getEnumItemFloatList(calItem, start, searchValue);
            }
        }
        return null;
    }

    private CalItem getCalItemByNodeId(String nodeId) {
        Map calItemMap = FormulaCacheUtils.getMapCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_cal_item_node_id_cache_key", CalItem.class);
        return (CalItem)calItemMap.get(nodeId);
    }

    private void showFloat(FloatResult floatResult, String nodeId, boolean isAppend, boolean isSearchInit) {
        CustomControl floatControl = (CustomControl)this.getView().getControl(FLOAT);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("listItem", floatResult.getItems());
        data.put("treeDom", "itemlistflex");
        data.put("nodeId", nodeId);
        data.put("nextStart", floatResult.getNextStart());
        if (isAppend) {
            data.put("isAppend", "true");
        }
        if (isSearchInit) {
            data.put("isSearchInit", "true");
        }
        data.put("isEnd", String.valueOf(floatResult.isEnd()));
        data.put("date", String.valueOf(new Date().getTime()));
        floatControl.setData(data);
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        Optional<TreeNodeItem> first;
        String nodeId = evt.getNodeId().toString();
        String parentId = (String)evt.getParentNodeId();
        if (HRStringUtils.isEmpty((String)parentId) || FormulaViewServiceHelper.isViewStatus((IFormView)this.getView())) {
            return;
        }
        List treeNodeItems = FormulaCacheUtils.getListCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_cal_item_tree_node_cache_key", TreeNodeItem.class);
        if (!HRStringUtils.isEmpty((String)nodeId) && (first = treeNodeItems.stream().filter(treeNodeItem -> nodeId.equals(treeNodeItem.getId())).findFirst()).isPresent()) {
            TreeNodeItem nodeItem = first.get();
            if (treeNodeItems.stream().noneMatch(treeNodeItem -> nodeItem.getId().equals(treeNodeItem.getParentId()))) {
                CustomControl formulaEditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
                HashMap<String, String> data = new HashMap<String, String>();
                String itemPrefix = nodeItem.getItemCategory() + "[%s]";
                data.put("method", "insertValue");
                data.put("value", String.format(itemPrefix, nodeItem.getName().trim()));
                data.put("date", String.valueOf(new Date().getTime()));
                formulaEditor.setData(data);
            }
        }
    }

    public void search(SearchEnterEvent arg) {
        List findNodeItems;
        String searchText = arg.getText();
        List treeNodeItems = FormulaCacheUtils.getListCustValueFromFormulaPageCache((IFormView)this.getView(), (String)"formula_cal_item_tree_node_cache_key", TreeNodeItem.class);
        if (HRStringUtils.isNotEmpty((String)searchText)) {
            findNodeItems = treeNodeItems.stream().filter(treeNodeItem -> HRStringUtils.isNotEmpty((String)treeNodeItem.getName()) && treeNodeItem.getName().contains(searchText)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(findNodeItems)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22,\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"FormulaItemTreePlugin_8", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                return;
            }
            findNodeItems.addAll(FormulaTreeNodeUtils.getAllParentTreeNodeItem(findNodeItems, treeNodeItems));
        } else {
            findNodeItems = treeNodeItems;
        }
        FormulaTreeNodeUtils.loadTreeNodeItemList((List)findNodeItems).ifPresent(nodeList -> {
            TreeView treeView = (TreeView)this.getView().getControl(ITEMTREEVIEW);
            treeView.deleteAllNodes();
            treeView.addNodes(nodeList);
        });
    }

    public void customEvent(CustomEventArgs e) {
        String key = e.getKey();
        String name = e.getEventName();
        String args = e.getEventArgs();
        if (HRStringUtils.equals((String)key, (String)FLOAT) && !FormulaViewServiceHelper.isViewStatus((IFormView)this.getView())) {
            CustomControl formulaEditor = (CustomControl)this.getView().getControl(FORMULAEDITOR);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("method", name);
            data.put("value", args);
            if (FormulaViewServiceHelper.isViewStatus((IFormView)this.getView())) {
                data.put("method", "readOnly");
                data.put("readOnly", "true");
            }
            data.put("date", String.valueOf(new Date().getTime()));
            formulaEditor.setData(data);
        }
        if (HRStringUtils.equals((String)key, (String)FLOAT) && (HRStringUtils.equals((String)name, (String)APPEND_LOAD_DATA) || HRStringUtils.equals((String)name, (String)SEARCH_LIST_ITEM)) && HRStringUtils.isNotEmpty((String)args)) {
            JSONObject param = JSONObject.parseObject((String)args);
            int start = param.getIntValue("start");
            String nodeId = param.getString("nodeId");
            String searchValue = param.getString("searchValue");
            boolean isAppend = HRStringUtils.equals((String)"true", (String)param.getString("isAppend"));
            FloatResult floatResult = this.getItemValue(nodeId, start, searchValue);
            if (floatResult == null) {
                return;
            }
            int offset = 0;
            if (floatResult.getItems() != null) {
                offset = floatResult.getItems().size();
            }
            boolean isSearchInit = HRStringUtils.equals((String)SEARCH_LIST_ITEM, (String)name);
            floatResult.setNextStart(start + offset);
            this.showFloat(floatResult, nodeId, isAppend, isSearchInit);
        }
    }

    private FloatResult getBaseDataFloatList(CalItem calItem, int start, String searchValue) {
        String entityNumber = calItem.getEntityNumber();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        HRBaseServiceHelper queryHelper = new HRBaseServiceHelper(entityNumber);
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)10);
        QFilter[] qFilters = calItem.getqFilters();
        DynamicProperty enable = dataEntityType.getProperty("enable");
        if (Objects.isNull(qFilters)) {
            if (enable != null) {
                qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            }
        } else {
            for (QFilter qFilter : qFilters) {
                String property;
                DynamicProperty dynamicProperty;
                if (HRStringUtils.isEmpty((String)qFilter.getProperty()) || !Objects.nonNull(dynamicProperty = dataEntityType.getProperty(property = qFilter.getProperty().split("\\.")[0]))) continue;
                qFilterList.add(qFilter);
            }
            if (qFilterList.isEmpty() && enable != null) {
                qFilterList.add(new QFilter("enable", "=", (Object)"1"));
            }
        }
        String propertyField = calItem.getPropertyField();
        if (HRStringUtils.isNotEmpty((String)searchValue)) {
            String[] fields = propertyField.split(",");
            QFilter firstFilter = null;
            for (String field : fields) {
                QFilter likeFilter = QFilter.like((String)field, (String)searchValue);
                if (firstFilter == null) {
                    firstFilter = likeFilter;
                    continue;
                }
                firstFilter.or(likeFilter);
            }
            if (firstFilter != null) {
                qFilterList.add(firstFilter);
            }
        }
        DynamicObject[] baseDataArray = queryHelper.queryOriginalArray("id," + propertyField, qFilterList.toArray(new QFilter[0]), calItem.getOrders());
        ArrayList selectItems = Lists.newArrayListWithExpectedSize((int)baseDataArray.length);
        if (baseDataArray.length == 0) {
            return new FloatResult(selectItems, true);
        }
        HashSet hashSet = Sets.newHashSetWithExpectedSize((int)baseDataArray.length);
        for (DynamicObject baseData : baseDataArray) {
            SelectItem selectItem = SelectItem.getSelectItemByBaseData((CalItem)calItem, (DynamicObject)baseData);
            if (hashSet.contains(selectItem.getShowKey())) continue;
            hashSet.add(selectItem.getShowKey());
            selectItems.add(selectItem);
        }
        List<SelectItem> result = selectItems.stream().skip(start).limit(20L).collect(Collectors.toList());
        boolean isEnd = start + result.size() == selectItems.size();
        return new FloatResult(result, isEnd);
    }

    private FloatResult getEnumItemFloatList(CalItem calItem, int start, String searchValue) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)calItem.getEntityNumber());
        DynamicProperty property = mainEntityType.getProperty(calItem.getPropertyField());
        if (property instanceof ComboProp) {
            List<SelectItem> selectItems;
            ComboProp prop = (ComboProp)property;
            List comboItems = prop.getComboItems();
            if (comboItems == null) {
                return null;
            }
            if (HRStringUtils.isNotEmpty((String)searchValue)) {
                comboItems = comboItems.stream().filter(item -> item.getName().getLocaleValue().contains(searchValue)).collect(Collectors.toList());
            }
            boolean isEnd = start + (selectItems = comboItems.stream().skip(start).limit(20L).map(item -> SelectItem.getSelectItemByValueMapItem((CalItem)calItem, (ValueMapItem)item)).collect(Collectors.toList())).size() == comboItems.size();
            return new FloatResult(selectItems, isEnd);
        }
        throw new KDBizException(MessageFormat.format("{} is not a enum field in metadata {}", calItem.getPropertyField(), calItem.getEntityNumber()));
    }
}

