/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.formula;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.function.helper.HRFunctionHelper;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.entity.item.ResultItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.formula.FormulaSettingEdit;
import org.apache.commons.collections4.CollectionUtils;

public class FuncDemoSettingEdit
extends FormulaSettingEdit {
    private static final Log LOGGER = LogFactory.getLog(FuncDemoSettingEdit.class);
    private static final String FUNCTREE = "functree";

    @Override
    protected Optional<List<TreeNodeItem>> getTreeNodeItemList() {
        return Optional.empty();
    }

    @Override
    protected Optional<List<ResultItem>> getResultItemList() {
        return Optional.empty();
    }

    @Override
    public void beforeBindData(EventObject eventObject) {
        this.initFunctionTree();
    }

    @Override
    protected boolean checkAndParseExpBeforeSave() {
        boolean checkSuccess = false;
        try {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("UNIT_TEST1", this.getModel().getDataEntity().get("integerfield5"));
            params.put("UNIT_TEST2", this.getModel().getDataEntity().get("number"));
            params.put("UNIT_TEST3", this.getModel().getDataEntity().get("integerfield6"));
            params.put("UNIT_TEST5", this.getModel().getDataEntity().get("name"));
            Object result = HRFunctionHelper.executeFunction((String)this.getModel().getDataEntity().getString("originalexp"), params);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u51fd\u6570\u8868\u8fbe\u5f0f\u6267\u884c\u7ed3\u679c\u4e3a\uff1a%s\u3002", (String)"FormulaSettingEdit_8", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), result));
        }
        catch (Exception e1) {
            LOGGER.error("checkAndParseExpBeforeSave_error:", (Throwable)e1);
            String msg = e1.getMessage();
            if (msg == null) {
                msg = ResManager.loadKDString((String)"\u516c\u5f0f\u914d\u7f6e\u4e0d\u6b63\u786e\u3002", (String)"FormulaSettingEdit_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
            }
            this.getView().showTipNotification(msg);
            checkSuccess = false;
        }
        return checkSuccess;
    }

    private void initFunctionTree() {
        TreeView treeView = (TreeView)this.getView().getControl(FUNCTREE);
        HRPageCache pageCache = new HRPageCache(this.getView());
        List functionItems = (List)pageCache.get("hbp_function_item_cache_key", List.class);
        if (CollectionUtils.isEmpty((Collection)functionItems)) {
            String bizAppNumber = this.getView().getFormShowParameter().getFormConfig().getBizAppNumber();
            functionItems = (List)HRFunctionHelper.getFuncItemList((String)bizAppNumber).get();
            pageCache.put("hbp_function_item_cache_key", (Object)functionItems);
        } else {
            ArrayList functionItemList = Lists.newArrayListWithCapacity((int)functionItems.size());
            for (Object obj : functionItems) {
                if (!(obj instanceof Map)) continue;
                functionItemList.add(JSONObject.parseObject((String)SerializationUtils.toJsonString(obj), FunctionItem.class));
            }
            functionItems = functionItemList;
        }
        ArrayList nodes = Lists.newArrayListWithCapacity((int)10);
        for (FunctionItem groupFunc : functionItems) {
            TreeNode tn1 = new TreeNode(null, groupFunc.getId(), groupFunc.getName(), true);
            tn1.setIsOpened(true);
            if (CollectionUtils.isEmpty((Collection)groupFunc.getChildren())) continue;
            for (FunctionItem function : groupFunc.getChildren()) {
                TreeNode tn2 = new TreeNode(groupFunc.getId(), function.getId(), function.getName(), false);
                tn2.setLeaf(true);
                tn1.addChild(tn2);
            }
            nodes.add(tn1);
        }
        treeView.addNodes((List)nodes);
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operationKey = evt.getOperationKey();
        if (HRStringUtils.isNotEmpty((String)operationKey)) {
            switch (operationKey) {
                case "save": 
                case "submit": 
                case "saveandnew": 
                case "confirmchange": 
                case "confirmchangenoaudit": {
                    if (this.checkAndParseExpBeforeSave()) break;
                    evt.setCancel(true);
                    break;
                }
            }
        }
    }
}

