/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.formula;

import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.Html;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.function.helper.HRFunctionHelper;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.helper.FormulaViewServiceHelper;
import kd.hr.hbp.business.service.formula.utils.FormulaCacheUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class FuncDemoTreePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    private static final Log LOG = LogFactory.getLog(FuncDemoTreePlugin.class);
    private static final String FUNCTREE = "functree";
    private static final String SEARCHFUNC = "searchfunc";
    private static final String DESCHTML = "deschtml";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(FUNCTREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getView().getControl(SEARCHFUNC);
        search.addEnterListener((SearchEnterListener)this);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String parentNodeId = (String)evt.getParentNodeId();
        if (HRStringUtils.isEmpty((String)parentNodeId)) {
            return;
        }
        Html html = (Html)this.getView().getControl(DESCHTML);
        List functionItems = FormulaCacheUtils.getFunctionItemsFromPageCache((IFormView)this.getView(), (String)"hbp_function_item_cache_key", FunctionItem.class);
        Optional functionItemOptional = HRFunctionHelper.getFunctionItem((List)functionItems, (String)String.valueOf(evt.getNodeId()));
        html.setConent(((FunctionItem)functionItemOptional.get()).getFuncDescription());
        this.getView().setVisible(Boolean.TRUE, new String[]{DESCHTML});
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
        String parentNodeId = (String)evt.getParentNodeId();
        if (HRStringUtils.isEmpty((String)parentNodeId) || FormulaViewServiceHelper.isViewStatus((IFormView)this.getView())) {
            return;
        }
        List functionItems = FormulaCacheUtils.getFunctionItemsFromPageCache((IFormView)this.getView(), (String)"hbp_function_item_cache_key", FunctionItem.class);
        Optional functionItemOptional = HRFunctionHelper.getFunctionItem((List)functionItems, (String)String.valueOf(evt.getNodeId()));
        CustomControl formulaEditor = (CustomControl)this.getView().getControl("formulaeditor");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("method", "insertValue");
        data.put("value", ((FunctionItem)functionItemOptional.get()).getFuncFullName());
        data.put("date", String.valueOf(new Date().getTime()));
        formulaEditor.setData(data);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
    }
}

