/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.funcentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.events.SetFilterContainerFlatEvent;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.funcentity.FunctionEntityService;
import kd.hr.hbp.business.service.funcentity.model.FunctionEntityRowMeta;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.funcentity.dataprovider.FunctionBizEntityDataProvider;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbsFunctionBizEntityList
extends AbstractTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(AbsFunctionBizEntityList.class);
    private static final String CACHE_DATA_KEY = "FunctionBizEntityList_CACHE_DATA_KEY_";
    private static final long CACHE_TIME_OUT = 300000L;
    private static final String ROOT_NODE_ID = "ROOT_NODE_ID";
    private static final String CLOUD_NODE_SUFFIX = "_CLOUD_NODE_SUFFIX";
    private static final String APP_NODE_SUFFIX = "_APP_NODE_SUFFIX";
    private FunctionEntityRowMeta rowMeta;
    private final CachedDataSet functionEntityCacheDS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbsFunctionBizEntityList() {
        block19: {
            CachedDataSet cachedDataSet = null;
            try {
                this.rowMeta = this.init();
                String CACHE_DATA_KEY_WITH_MULTI_LANG = CACHE_DATA_KEY + RequestContext.get().getLang().name();
                try {
                    cachedDataSet = Algo.getCacheDataSet((String)CACHE_DATA_KEY_WITH_MULTI_LANG);
                }
                catch (AlgoException exception) {
                    LOGGER.error("FunctionBizEntityList_data_cache_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
                }
                if (cachedDataSet != null) break block19;
                LOGGER.info("get_new_FunctionBizEntity_data_cache");
                try (DataSet functionEntityDS = FunctionEntityService.getFunctionEntityDS((FunctionEntityRowMeta)this.rowMeta);){
                    CacheHint hint = new CacheHint();
                    hint.setCacheId(CACHE_DATA_KEY_WITH_MULTI_LANG);
                    hint.setTimeout(300000L);
                    cachedDataSet = functionEntityDS.cache(hint);
                }
            }
            catch (Exception exception) {
                LOGGER.error("FunctionBizEntityList_init_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            }
            finally {
                Algo.closeAllDataSet();
                this.functionEntityCacheDS = cachedDataSet;
            }
        }
    }

    private FunctionEntityRowMeta init() {
        return this.getRowMeta();
    }

    protected abstract FunctionEntityRowMeta getRowMeta();

    public void pageRelease(EventObject eventObject) {
        try {
            super.pageRelease(eventObject);
        }
        catch (Exception exception) {
            LOGGER.error("FunctionBizEntityList_pageRelease_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String customListTitle = (String)this.getView().getFormShowParameter().getCustomParam("LIST_CUSTOM_TITLE_KEY");
        if (HRStringUtils.isNotEmpty((String)customListTitle)) {
            this.getView().setFormTitle(new LocaleString(customListTitle));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        String customListTitle = (String)this.getView().getFormShowParameter().getCustomParam("LIST_CUSTOM_TITLE_KEY");
        if (HRStringUtils.isNotEmpty((String)customListTitle)) {
            this.getView().setFormTitle(new LocaleString(customListTitle));
            ((FilterContainer)args.getFilterContainerInitEvent().getSource()).setTitle(new LocaleString(customListTitle));
        }
    }

    public void filterContainerSetFlat(SetFilterContainerFlatEvent args) {
        super.filterContainerSetFlat(args);
    }

    public void initializeTree(EventObject evt) {
        try {
            this.initCloudAppTree();
        }
        catch (Exception exception) {
            LOGGER.error("FunctionBizEntityList_initializeTree_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        }
    }

    public void initTreeToolbar(EventObject evt) {
        try {
            super.initTreeToolbar(evt);
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel"});
        }
        catch (Exception exception) {
            LOGGER.error("FunctionBizEntityList_initTreeToolbar_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        try {
            super.beforeCreateListDataProvider(args);
            args.setListDataProvider((IListDataProvider)new FunctionBizEntityDataProvider(this.functionEntityCacheDS, this.rowMeta, this.getView().getFormShowParameter()));
        }
        catch (Exception exception) {
            LOGGER.error("FunctionBizEntityList_beforeCreateListDataProvider_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent event) {
        try {
            String currentNodeId = String.valueOf(event.getNodeId());
            if (currentNodeId.endsWith(APP_NODE_SUFFIX)) {
                currentNodeId = currentNodeId.replace(APP_NODE_SUFFIX, "");
                event.addQFilter(new QFilter(this.rowMeta.getAppIdAlias(), "=", (Object)currentNodeId));
            } else if (currentNodeId.endsWith(CLOUD_NODE_SUFFIX)) {
                currentNodeId = currentNodeId.replace(CLOUD_NODE_SUFFIX, "");
                event.addQFilter(new QFilter(this.rowMeta.getCloudIdAlias(), "=", (Object)currentNodeId));
            }
        }
        catch (Exception exception) {
            LOGGER.error("FunctionBizEntityList_buildTreeListFilter_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        }
    }

    public void search(SearchEnterEvent evt) {
        super.search(evt);
        try {
            String searchText = evt.getText();
            if (HRStringUtils.isNotEmpty((String)searchText)) {
                List treeNodes;
                TreeNode rootNode = this.getTreeModel().getRoot();
                IPageCache pageCache = this.getView().getPageCache();
                String matchNodesCacheKey = this.getView().getPageId() + "_matchNodes";
                String oldSearchTextCacheKey = this.getView().getPageId() + "_oldSearchText";
                String searchIndexCacheKey = this.getView().getPageId() + "_searchIndex";
                String oldSearchText = pageCache.get(oldSearchTextCacheKey);
                pageCache.put(oldSearchTextCacheKey, searchText);
                String matchNodesCache = pageCache.get(matchNodesCacheKey);
                TreeView treeView = this.getTreeListView().getTreeView();
                if (searchText.equals(oldSearchText) && HRStringUtils.isNotEmpty((String)matchNodesCache)) {
                    treeNodes = SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class);
                } else {
                    treeNodes = rootNode.getTreeNodeListByText((List)Lists.newLinkedList(), searchText, 10);
                    pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                    pageCache.put(searchIndexCacheKey, String.valueOf(0));
                }
                if (treeNodes.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b8c\u6210\u641c\u7d22\uff0c\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"WarningSceneTreeListPlugin_0", (String)"", (Object[])new Object[0]));
                } else {
                    if (HRStringUtils.isNotEmpty((String)pageCache.get(searchIndexCacheKey))) {
                        int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                        if (indexCache == treeNodes.size()) {
                            indexCache = 0;
                        }
                        this.focusNode(treeView, (TreeNode)treeNodes.get(indexCache));
                        pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
                    } else {
                        this.focusNode(treeView, (TreeNode)treeNodes.get(0));
                        pageCache.put(searchIndexCacheKey, String.valueOf(0));
                    }
                    pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("FunctionBizEntityList_search_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        }
    }

    private void focusNode(TreeView treeView, TreeNode searchTreeNode) {
        treeView.showNode(searchTreeNode.getId());
        treeView.treeNodeClick(searchTreeNode.getParentid(), searchTreeNode.getId());
        treeView.checkNode(searchTreeNode);
        treeView.focusNode(searchTreeNode);
    }

    private void initCloudAppTree() {
        Algo algo = Algo.create((String)"kd.hr.hbp.formplugin.web.funcentity.FunctionBizEntityList");
        try (DataSet cloudAppEntityDS = this.functionEntityCacheDS.toDataSet(algo, false);){
            TreeNode root = new TreeNode("", ROOT_NODE_ID, ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"FunctionBizEntityList_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            LinkedHashMap cloudToAppMap = Maps.newLinkedHashMap();
            for (Object cloudAppEntity : cloudAppEntityDS) {
                String cloudId = cloudAppEntity.getString(this.rowMeta.getCloudIdAlias());
                Map appMap = (Map)cloudToAppMap.get(cloudId);
                if (appMap == null) {
                    String cloudName = cloudAppEntity.getString(this.rowMeta.getCloudNameAlias());
                    root.addChild(new TreeNode(ROOT_NODE_ID, cloudId + CLOUD_NODE_SUFFIX, cloudName));
                    appMap = Maps.newLinkedHashMap();
                    cloudToAppMap.put(cloudId, appMap);
                }
                String appId = cloudAppEntity.getString(this.rowMeta.getAppIdAlias());
                String appName = cloudAppEntity.getString(this.rowMeta.getAppNameAlias());
                appMap.put(appId, appName);
            }
            List cloudNodes = root.getChildren();
            for (TreeNode cloudNode : cloudNodes) {
                String cloudId = cloudNode.getId().replace(CLOUD_NODE_SUFFIX, "");
                Map appMap = (Map)cloudToAppMap.get(cloudId);
                if (appMap == null || appMap.isEmpty()) continue;
                for (Map.Entry appEntry : appMap.entrySet()) {
                    cloudNode.addChild(new TreeNode(cloudNode.getId(), (String)appEntry.getKey() + APP_NODE_SUFFIX, (String)appEntry.getValue()));
                }
            }
            root.setExpend(true);
            root.setIsOpened(true);
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
        }
    }
}

