/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.funcentity.dataprovider;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.FilterFunction;
import kd.bos.algo.Row;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.form.FormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QEmptyValue;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.funcentity.annotation.EntityFieldProperty;
import kd.hr.hbp.business.service.funcentity.model.FunctionEntityRowMeta;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.funcentity.AbsFunctionBizEntityList;
import kd.hr.hbp.formplugin.web.funcentity.dataprovider.FuzzyQueryDSFunction;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class FunctionBizEntityDataProvider
extends ListDataProvider {
    private static final Log LOGGER = LogFactory.getLog(AbsFunctionBizEntityList.class);
    private static final char SPACE_CHAR = ' ';
    private static final String FILTER_PARAM_PREFIX = "filter_param_";
    private final CachedDataSet functionEntityCacheDS;
    private final FunctionEntityRowMeta rowMeta;
    private final FormShowParameter formShowParameter;
    private Integer dataCount;
    private int paramIndex = 0;

    public FunctionBizEntityDataProvider(CachedDataSet functionEntityCacheDS, FunctionEntityRowMeta rowMeta, FormShowParameter formShowParameter) {
        this.functionEntityCacheDS = functionEntityCacheDS;
        this.rowMeta = rowMeta;
        this.formShowParameter = formShowParameter;
    }

    public DynamicObjectCollection getData(int start, int limit) {
        this.initContext(start, limit);
        QueryBuilder queryBuilder = this.getQueryBuilder();
        DynamicObjectType returnEntityType = queryBuilder.getReturnEntityType();
        DynamicObjectCollection collection = new DynamicObjectCollection(returnEntityType, null);
        try {
            List<QFilter> totalFilter = this.getAfterFilteringQFilters();
            List<QFilter> paramFilters = totalFilter.stream().filter(filter -> "1".equals(filter.getProperty())).collect(Collectors.toList());
            List<QFilter> baseFilters = totalFilter.stream().filter(filter -> !"1".equals(filter.getProperty())).collect(Collectors.toList());
            List<DynamicObject> resultItemBySearch = this.getEntityDyByDataSet(start, limit, paramFilters, returnEntityType, baseFilters);
            if (!CollectionUtils.isEmpty(resultItemBySearch)) {
                collection.addAll(resultItemBySearch);
            }
            QueryResult queryResult = this.getQueryResult();
            queryResult.setDataCount(this.getRealCount());
            queryResult.setCollection(collection);
        }
        catch (Exception exception) {
            LOGGER.error("FunctionBizEntityDataProvider_getData_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRealCount() {
        try {
            if (this.dataCount == null) {
                List<QFilter> totalFilter = this.getAfterFilteringQFilters();
                DataSet allDSByFilter = this.getAllDSByFilter(totalFilter.stream().filter(filter -> "1".equals(filter.getProperty())).collect(Collectors.toList()), totalFilter.stream().filter(filter -> !"1".equals(filter.getProperty())).collect(Collectors.toList()));
                int n = allDSByFilter.count(this.rowMeta.getEntityIdAlias(), false);
                return n;
            }
            int totalFilter = this.dataCount;
            return totalFilter;
        }
        catch (Exception exception) {
            LOGGER.error("FunctionBizEntityDataProvider_getRealCount_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            int n = 0;
            return n;
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DynamicObject> getEntityDyByDataSet(int start, int limit, List<QFilter> paramFilters, DynamicObjectType objectType, List<QFilter> baseFilters) {
        try {
            if (this.functionEntityCacheDS == null) {
                ArrayList arrayList = Lists.newArrayListWithExpectedSize((int)0);
                return arrayList;
            }
            DataSet cloudAppEntityDS = this.getAllDSByFilter(paramFilters, baseFilters);
            DataSet copy = cloudAppEntityDS.copy();
            this.dataCount = copy.count(this.rowMeta.getEntityIdAlias(), false);
            cloudAppEntityDS = cloudAppEntityDS.range(start, limit);
            List<DynamicObject> list = this.dataSetToDyList(objectType, cloudAppEntityDS);
            return list;
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    private DataSet getAllDSByFilter(List<QFilter> paramFilters, List<QFilter> baseFilters) {
        Algo algo = Algo.create((String)"kd.hr.hbp.formplugin.web.funcentity.dataprovider.FunctionBizEntityDataProvider");
        DataSet cloudAppEntityDS = this.functionEntityCacheDS.toDataSet(algo, false);
        if (!baseFilters.isEmpty()) {
            Tuple2<String, Map<String, Object>> filterExpAndParamsMap = this.buildFilterExpAndParamsMap(baseFilters);
            cloudAppEntityDS = cloudAppEntityDS.filter((String)filterExpAndParamsMap.t1, (Map)filterExpAndParamsMap.t2);
        }
        if (!paramFilters.isEmpty()) {
            cloudAppEntityDS = cloudAppEntityDS.filter((FilterFunction)new FuzzyQueryDSFunction(this.rowMeta, paramFilters));
        }
        return cloudAppEntityDS;
    }

    private List<DynamicObject> dataSetToDyList(DynamicObjectType objectType, DataSet cloudAppEntityDS) {
        if (objectType == null || cloudAppEntityDS == null) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList resultDys = Lists.newArrayListWithExpectedSize((int)10);
        Map fieldNameToEntityFieldPropertyMap = this.rowMeta.getFieldNameToEntityFieldPropertyMap();
        kd.bos.algo.Field[] fields = cloudAppEntityDS.getRowMeta().getFields();
        HashMap refBaseDataMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Row cloudAppEntity : cloudAppEntityDS) {
            HashMap refBaseDataFieldToIdMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObject entity = new DynamicObject(objectType);
            String entityId = cloudAppEntity.getString(this.rowMeta.getEntityNumberAlias()) + "__" + cloudAppEntity.getString(this.rowMeta.getAppIdAlias());
            for (kd.bos.algo.Field field : fields) {
                String[] entityFieldProperties = (String[])fieldNameToEntityFieldPropertyMap.get(field.getAlias());
                if (entityFieldProperties == null || entityFieldProperties.length <= 0) continue;
                for (String entityFieldProperty : entityFieldProperties) {
                    String[] keys = entityFieldProperty.split("\\.");
                    DynamicProperty property = objectType.getProperty(keys[0]);
                    if (property instanceof BasedataProp) {
                        DynamicProperty refBdFieldProperty;
                        DynamicObject refDyObj;
                        if (keys.length == 1) {
                            this.getRefDyObj(cloudAppEntity, field.getAlias(), (BasedataProp)property, refBaseDataMap, refBaseDataFieldToIdMap);
                            continue;
                        }
                        if (keys.length != 2 || (refDyObj = this.getRefDyObj(cloudAppEntity, this.rowMeta.getEntityFieldPropertyToRowFieldName(keys[0]), (BasedataProp)property, refBaseDataMap, refBaseDataFieldToIdMap)) == null || (refBdFieldProperty = refDyObj.getDynamicObjectType().getProperty(keys[1])) == null) continue;
                        refDyObj.set((IDataEntityProperty)refBdFieldProperty, cloudAppEntity.get(field.getAlias()));
                        continue;
                    }
                    if (property == null) continue;
                    Object isF7ReturnIdIncludeAppId = this.formShowParameter.getCustomParam("IS_F7_RETURN_ID_INCLUDE_APP_ID_KEY");
                    if ("true".equals(String.valueOf(isF7ReturnIdIncludeAppId))) {
                        if (property instanceof PKFieldProp || "id".equals(property.getName())) {
                            entity.set((IDataEntityProperty)property, (Object)entityId);
                            continue;
                        }
                        entity.set((IDataEntityProperty)property, cloudAppEntity.get(field.getAlias()));
                        continue;
                    }
                    entity.set((IDataEntityProperty)property, cloudAppEntity.get(field.getAlias()));
                }
            }
            for (Map.Entry entry : refBaseDataFieldToIdMap.entrySet()) {
                entity.set((String)entry.getKey(), refBaseDataMap.get(entry.getValue()));
            }
            resultDys.add(entity);
        }
        return resultDys;
    }

    private List<QFilter> getAfterFilteringQFilters() {
        try {
            List qFilters = super.getQFilters();
            Field[] fields = this.rowMeta.getClass().getDeclaredFields();
            Iterator iterator = qFilters.iterator();
            while (iterator.hasNext()) {
                QFilter qFilter = (QFilter)iterator.next();
                if (this.checkQFilter(qFilter, fields)) continue;
                iterator.remove();
            }
            return qFilters;
        }
        catch (Exception exception) {
            LOGGER.error("FunctionBizEntityDataProvider_getQFilters_error_{}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
            return Lists.newArrayListWithExpectedSize((int)0);
        }
    }

    private boolean checkQFilter(QFilter qFilter, Field[] fields) throws IllegalAccessException {
        String property = qFilter.getProperty();
        boolean hasFind = false;
        block0: for (Field field : fields) {
            String[] values;
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Object value = field.get(this.rowMeta);
            if (property.equals(value)) {
                hasFind = true;
                break;
            }
            EntityFieldProperty fieldProperty = field.getAnnotation(EntityFieldProperty.class);
            if (fieldProperty == null) continue;
            for (String propertyName : values = fieldProperty.value()) {
                if (!property.equals(propertyName) && (!property.startsWith(propertyName) || !property.endsWith(".id"))) continue;
                hasFind = true;
                qFilter.__setProperty(String.valueOf(value));
                continue block0;
            }
        }
        if (!hasFind && !"1".equals(property)) {
            return false;
        }
        List nests = qFilter.getNests(true);
        Iterator iterator = nests.iterator();
        boolean hasOr = false;
        while (iterator.hasNext()) {
            QFilter nestFilter;
            boolean nestHasFind;
            QFilter.QFilterNest next = (QFilter.QFilterNest)iterator.next();
            if (!next.isAnd()) {
                hasOr = true;
            }
            if (nestHasFind = this.checkQFilter(nestFilter = next.getFilter(), fields)) continue;
            if (hasOr) {
                return false;
            }
            iterator.remove();
        }
        return true;
    }

    public Tuple2<String, Map<String, Object>> buildFilterExpAndParamsMap(List<QFilter> qFilters) {
        ArrayList exprList = Lists.newArrayList();
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        for (QFilter qFilter : qFilters) {
            String filterExpStr = this.filterToExp(qFilter, params);
            if (!HRStringUtils.isNotEmpty((String)filterExpStr)) continue;
            filterExpStr = "(" + filterExpStr + ")";
            exprList.add(filterExpStr);
        }
        String expr = String.join((CharSequence)" and ", exprList);
        return new Tuple2((Object)expr, (Object)params);
    }

    public String filterToExp(QFilter filter, Map<String, Object> params) {
        StringBuilder builder = new StringBuilder();
        if (filter.getCP().equalsIgnoreCase("not exists")) {
            QFilter qFilter = new QFilter(filter.getProperty(), "=", (Object)QEmptyValue.value);
            this.filterToExpBuilder(qFilter, params, builder);
        } else {
            this.filterToExpBuilder(filter, params, builder);
        }
        String property = filter.getProperty();
        List nests = filter.getNests(false);
        for (QFilter.QFilterNest nest : nests) {
            QFilter nestQFilter;
            builder.insert(0, '(');
            if (!HRStringUtils.equals((String)property, (String)"1")) {
                if (nest.isAnd()) {
                    builder.append(" and");
                } else {
                    builder.append(" or");
                }
            }
            if (!(nestQFilter = nest.getFilter()).getNests(false).isEmpty()) {
                builder.append(' ').append(this.filterToExp(nestQFilter, params));
            } else {
                builder.append(' ');
                this.filterToExpBuilder(nestQFilter, params, builder);
            }
            builder.append(')');
            property = nestQFilter.getProperty();
        }
        return builder.toString();
    }

    private void filterToExpBuilder(QFilter filter, Map<String, Object> params, StringBuilder builder) {
        if (HRStringUtils.equals((String)filter.getProperty(), (String)"1")) {
            return;
        }
        Object filterValue = this.getFilterValue(filter);
        String propertyAlias = filter.getProperty();
        String cp = filter.getCP();
        if (filter.isExpressValue()) {
            builder.append(propertyAlias);
            builder.append(' ').append(cp).append(' ');
            builder.append(filterValue);
        } else if (cp.equalsIgnoreCase("is null") || cp.equalsIgnoreCase("is not null")) {
            builder.append(propertyAlias);
            builder.append(' ').append(cp);
        } else if (cp.equalsIgnoreCase("like") || cp.equalsIgnoreCase("not like")) {
            builder.append(propertyAlias);
            builder.append(' ').append(cp).append(' ');
            builder.append('\"').append("%").append(this.handleSpecialChar(String.valueOf(filterValue))).append("%").append('\"');
        } else if (cp.equalsIgnoreCase("in") || cp.equalsIgnoreCase("not in")) {
            builder.append('(').append(propertyAlias);
            builder.append(' ').append(cp).append(' ');
            String paramKey = this.buildParamKey();
            builder.append(paramKey).append(')');
            params.put(paramKey, filterValue);
        } else {
            builder.append('(');
            if (filter.getValue() == QEmptyValue.value && filterValue == null) {
                builder.append(propertyAlias).append(" is null ");
            } else {
                builder.append(propertyAlias);
                builder.append(' ').append(cp).append(' ');
                String paramKey = this.buildParamKey();
                builder.append(paramKey);
                params.put(paramKey, filterValue);
                if (filter.getValue() == QEmptyValue.value) {
                    builder.append(" or ").append(propertyAlias).append(" is null ");
                    paramKey = this.buildParamKey();
                    builder.append(" or ").append(propertyAlias).append(" = ").append(paramKey);
                    params.put(paramKey, "");
                }
            }
            builder.append(')');
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private String handleSpecialChar(String value) {
        return value.replace("\"", "\\\"");
    }

    private String buildParamKey() {
        return FILTER_PARAM_PREFIX + this.paramIndex++;
    }

    private Object getFilterValue(QFilter filter) {
        Object filterValue = filter.getOriginValue();
        if (filterValue == QEmptyValue.value) {
            filterValue = " ";
        }
        return filterValue;
    }

    private DynamicObject getRefDyObj(Row cloudAppEntity, String fieldAlias, BasedataProp property, Map<String, DynamicObject> refBaseDataMap, Map<String, String> refBaseDataFieldToIdMap) {
        if (fieldAlias == null) {
            return null;
        }
        Object pkValue = cloudAppEntity.get(fieldAlias);
        DynamicObject refBaseData = refBaseDataMap.get(String.valueOf(pkValue));
        if (refBaseData == null) {
            DynamicObjectType dynamicComplexPropertyType = property.getDynamicComplexPropertyType();
            ISimpleProperty primaryKey = dynamicComplexPropertyType.getPrimaryKey();
            if (primaryKey instanceof LongProp) {
                pkValue = Long.parseLong(String.valueOf(pkValue));
            }
            refBaseData = new DynamicObject(dynamicComplexPropertyType, pkValue);
            refBaseDataMap.put(String.valueOf(pkValue), refBaseData);
        }
        refBaseDataFieldToIdMap.put(property.getName(), String.valueOf(pkValue));
        return refBaseData;
    }
}

