/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.function;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.function.FunctionSubPageService;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.CloseCheckFormPlugin;

public class ReportFunctionSubPagePlugin
extends CloseCheckFormPlugin {
    private static final Log LOGGER = LogFactory.getLog(ReportFunctionSubPagePlugin.class);
    protected static final String FUNCTION_FORM_ID = "hbp_functiontemplate";
    protected static final String FUNCTION_VIEW_PAGE_ID = "functionViewPageId";
    protected static final String ENTRY_FIELD = "fieldentry";
    protected static final String FIELD_NAME = "fieldName";
    protected static final String FIELD_NUMBER = "fieldNumber";
    protected static final String FIELD_TYPE = "valueType";
    protected static final String BASE_DATA_NUM = "baseDataNum";
    protected static final String FIELDS = "fields";
    protected static final String METHOD_KEY = "method";
    protected static final String METHOD_CHANGE = "change";
    protected static final String UPDATE_TYPE = "updateType";
    protected static final String UPDATE_TYPE_REPLACE_ALL = "replaceAll";
    protected static final String DISPLAY_FUNCTION_TEXT = "displayfunctiontext";
    protected static final String KEY_DISPLAY_EXPR = "displayExpression";
    protected static final String CONTROL_EXPRESSION = "expressioncontrol";
    protected static final String CACHE_KEY_FIELD_MAP = "fieldMapKey";
    protected final Set<Character> specialChar = Stream.of(Character.valueOf('['), Character.valueOf(']'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('*'), Character.valueOf('/'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('\"'), Character.valueOf(','), Character.valueOf(' '), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('<'), Character.valueOf('!'), Character.valueOf('\"')).collect(Collectors.toSet());
    protected static final Pattern numberPattern = Pattern.compile("^([-+])?\\d+(\\.\\d+)?$");
    FunctionSubPageService functionSubPageService = new FunctionSubPageService();

    @Override
    @ExcludeFromJacocoGeneratedReport
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String contentKey = this.getPageCache().get("contentKey");
        if (HRStringUtils.isNotEmpty((String)contentKey)) {
            String fieldsStr = this.getPageCache().get(FIELDS);
            List fields = HRStringUtils.isNotEmpty((String)fieldsStr) ? (List)SerializationUtils.fromJsonString((String)fieldsStr, List.class) : Collections.emptyList();
            String expr = this.getPageCache().get("expr");
            String functionExecuteServiceClassName = this.getPageCache().get("functionExecuteServiceClassName");
            this.initFuncPageView(contentKey, fields, functionExecuteServiceClassName, expr);
        }
    }

    protected void initFuncPageView(String contentControlNum, List<Map<String, Object>> fields, String functionExecuteServiceClassName, String expr) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(FUNCTION_FORM_ID);
        formShowParameter.getOpenStyle().setTargetKey(contentControlNum);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        if (fields != null) {
            HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)fields.size());
            HashMap enumEntityNumMap = Maps.newHashMapWithExpectedSize((int)fields.size());
            for (Map<String, Object> map : fields) {
                String enumEntityNum;
                String name;
                Object nameObj = map.get(FIELD_NAME);
                if (nameObj instanceof String) {
                    name = (String)nameObj;
                } else {
                    LocaleString nameLocaleStr = (LocaleString)SerializationUtils.fromJsonString((String)JSONObject.toJSONString((Object)nameObj), LocaleString.class);
                    name = nameLocaleStr.getLocaleValue();
                }
                map.put(FIELD_NAME, name);
                String number = (String)map.get(FIELD_NUMBER);
                String baseDataNum = (String)map.get(BASE_DATA_NUM);
                if ((number.endsWith(".name") || number.endsWith(".number")) && HRStringUtils.isNotEmpty((String)baseDataNum)) {
                    baseDataMap.put("$" + number + "$", baseDataNum);
                }
                if (!HRStringUtils.isNotEmpty((String)(enumEntityNum = (String)map.get("enumEntityNum")))) continue;
                enumEntityNumMap.put("$" + number + "$", enumEntityNum);
            }
            this.getPageCache().put("baseDataMap", SerializationUtils.toJsonString((Object)baseDataMap));
            this.getPageCache().put("enumEntityNumMap", SerializationUtils.toJsonString((Object)enumEntityNumMap));
        }
        formShowParameter.setCustomParam(FIELDS, fields);
        String displayExpr = expr;
        if (fields != null) {
            Map fieldMap = fields.stream().collect(Collectors.toMap(field -> (String)field.get(FIELD_NUMBER), Function.identity(), (k1, k2) -> k1));
            this.getPageCache().put(CACHE_KEY_FIELD_MAP, SerializationUtils.toJsonString(fieldMap));
            displayExpr = this.replaceFieldName(expr, fields);
        }
        formShowParameter.setCustomParam(DISPLAY_FUNCTION_TEXT, (Object)displayExpr);
        formShowParameter.setCustomParam("functionExecuteServiceClassName", (Object)functionExecuteServiceClassName);
        formShowParameter.setCustomParam("status", this.getView().getFormShowParameter().getCustomParam("status"));
        formShowParameter.setCustomParam("bizAppNumber", (Object)this.getView().getFormShowParameter().getAppId());
        this.getView().showForm(formShowParameter);
        this.getPageCache().put("functionExecuteServiceClassName", functionExecuteServiceClassName);
        this.getPageCache().put(FUNCTION_VIEW_PAGE_ID, formShowParameter.getPageId());
    }

    protected Map<String, Object> parseFunctionExpr(StringBuilder errorMsg) {
        String functionViewPageId = this.getPageCache().get(FUNCTION_VIEW_PAGE_ID);
        IFormView functionView = this.getView().getView(functionViewPageId);
        if (null != functionView) {
            String expr = (String)functionView.getModel().getValue(DISPLAY_FUNCTION_TEXT);
            String fieldStr = functionView.getPageCache().get(FIELDS);
            String baseDataMapStr = this.getPageCache().get("baseDataMap");
            Map baseDataMap = Maps.newHashMapWithExpectedSize((int)16);
            if (HRStringUtils.isNotEmpty((String)baseDataMapStr)) {
                baseDataMap = (Map)SerializationUtils.fromJsonString((String)baseDataMapStr, Map.class);
            }
            String enumEntityNumMapStr = this.getPageCache().get("enumEntityNumMap");
            Map enumEntityNumMap = Maps.newHashMapWithExpectedSize((int)16);
            if (HRStringUtils.isNotEmpty((String)baseDataMapStr)) {
                enumEntityNumMap = (Map)SerializationUtils.fromJsonString((String)enumEntityNumMapStr, Map.class);
            }
            Map fileSourceEnumItemMap = null;
            String enumItemMapStr = this.getPageCache().get("enumItemMap");
            if (HRStringUtils.isNotEmpty((String)enumItemMapStr)) {
                fileSourceEnumItemMap = (Map)SerializationUtils.fromJsonString((String)enumItemMapStr, Map.class);
            }
            return this.functionSubPageService.parseFunctionExpr(errorMsg, expr, fieldStr, baseDataMap, enumEntityNumMap, fileSourceEnumItemMap);
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    protected String getFunctionViewExpr() {
        String functionViewPageId = this.getPageCache().get(FUNCTION_VIEW_PAGE_ID);
        IFormView functionView = this.getView().getView(functionViewPageId);
        if (null != functionView) {
            return (String)functionView.getModel().getValue(DISPLAY_FUNCTION_TEXT);
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    protected void updateFunctionViewForFields(List<Map<String, Object>> fields) {
        String functionViewPageId = this.getPageCache().get(FUNCTION_VIEW_PAGE_ID);
        IFormView functionView = this.getView().getView(functionViewPageId);
        if (null != functionView) {
            int entryCount = functionView.getModel().getEntryRowCount(ENTRY_FIELD);
            functionView.getModel().deleteEntryRows(ENTRY_FIELD, this.getIntArray(entryCount));
            functionView.getModel().batchCreateNewEntryRow(ENTRY_FIELD, fields.size());
            HashMap fieldsMap = Maps.newHashMapWithExpectedSize((int)fields.size());
            for (int i = 0; i < fields.size(); ++i) {
                functionView.getModel().setValue(FIELD_NAME, fields.get(i).get(FIELD_NAME), i);
                functionView.getModel().setValue(FIELD_NUMBER, fields.get(i).get(FIELD_NUMBER), i);
                functionView.getModel().setValue(FIELD_TYPE, fields.get(i).get(FIELD_TYPE), i);
                fieldsMap.put((String)fields.get(i).get(FIELD_NAME), (String)fields.get(i).get(FIELD_NUMBER));
            }
            functionView.getPageCache().put(FIELDS, SerializationUtils.toJsonString((Object)fieldsMap));
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            dataMap.put(FIELDS, fieldsMap.keySet());
            dataMap.put(METHOD_KEY, METHOD_CHANGE);
            CustomControl customcontrol = (CustomControl)functionView.getControl(CONTROL_EXPRESSION);
            customcontrol.setData((Object)dataMap);
            this.getView().sendFormAction(functionView);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    protected void updateFunctionViewForExpr(String expr) {
        String functionViewPageId = this.getPageCache().get(FUNCTION_VIEW_PAGE_ID);
        IFormView functionView = this.getView().getView(functionViewPageId);
        if (null != functionView) {
            HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
            dataMap.put(UPDATE_TYPE, UPDATE_TYPE_REPLACE_ALL);
            dataMap.put(KEY_DISPLAY_EXPR, expr);
            dataMap.put("now", new Date());
            CustomControl customcontrol = (CustomControl)functionView.getControl(CONTROL_EXPRESSION);
            customcontrol.setData((Object)dataMap);
            this.getView().sendFormAction(functionView);
        }
    }

    protected Object preExecuteExpr(String expr, Map<String, Object> paramMap, StringBuilder errorMsg) {
        String functionExecuteServiceClassName = this.getPageCache().get("functionExecuteServiceClassName");
        return this.functionSubPageService.preExecuteExpr(expr, paramMap, errorMsg, functionExecuteServiceClassName);
    }

    @ExcludeFromJacocoGeneratedReport
    protected boolean isExprChanged() {
        String subPageId = this.getPageCache().get(FUNCTION_VIEW_PAGE_ID);
        IFormView functionView = this.getView().getView(subPageId);
        return functionView.getModel().getDataEntity().getDataEntityState().getDataEntityDirty();
    }

    private String replaceFieldName(String parsedExpr, List<Map<String, Object>> fields) {
        return this.functionSubPageService.replaceFieldName(parsedExpr, fields);
    }

    @ExcludeFromJacocoGeneratedReport
    private int[] getIntArray(int rowCount) {
        int[] intArray = new int[rowCount];
        for (int rowI = 0; rowI < intArray.length; ++rowI) {
            intArray[rowI] = rowI;
        }
        return intArray;
    }
}

