/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.formplugin.web.imp.BasedataQueryDesc;
import kd.hr.hbp.formplugin.web.multisheet.helper.MultiSheetHelper;
import org.apache.commons.lang3.StringUtils;

public class BasedataContianer {
    private static final Log LOG = LogFactory.getLog(BasedataContianer.class);
    private Table<String, String, List<DynamicObject>> basedataTable = HashBasedTable.create();
    private Table<String, String, Set<Long>> hasPermBasedataTable = HashBasedTable.create();
    private Table<String, String, List<Long>> hasStrategyPermBasedataTable = HashBasedTable.create();
    private List<BasedataQueryDesc> basedataList = Lists.newArrayList();
    private Table<String, String, List<Long>> orgPermScope = HashBasedTable.create();

    public void queryBaseDataRef() {
        for (BasedataQueryDesc query : this.basedataList) {
            String mainOrg;
            QFilter[] concatQfilter;
            DynamicObject[] ids;
            MainEntityType mainEntityType;
            String parentEntityNumber;
            IDataEntityType parent;
            String fieldName = query.getProp().getName();
            String baseEntityId = query.getProp().getBaseEntityId();
            IDataEntityType iDataEntityType = parent = query.getProp() instanceof MulBasedataProp ? ((MulBasedataProp)query.getProp()).getParent() : ((BasedataProp)query.getProp()).getParent();
            if (parent instanceof EntryType) {
                parentEntityNumber = parent.getParent().getName();
                mainEntityType = (MainEntityType)parent.getParent();
            } else {
                parentEntityNumber = parent.getName();
                mainEntityType = (MainEntityType)parent;
            }
            String importValue = query.getImportValue();
            String useOrgValue = query.getUseOrg();
            if (CollectionUtils.isEmpty(this.getBasedata(baseEntityId, importValue))) {
                Object[] basedataArr;
                Set<String> selectProp = query.getSelectProp();
                if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{useOrgValue})) {
                    selectProp.add(query.getUseOrgJson().getString("useorgfieldkey"));
                }
                if ((basedataArr = BusinessDataServiceHelper.load((String)baseEntityId, (String)String.join((CharSequence)",", selectProp), (QFilter[])query.getHisQFiltrs())).length > 0) {
                    this.basedataTable.put((Object)query.getProp().getBaseEntityId(), (Object)importValue, (Object)Lists.newArrayList((Object[])basedataArr));
                }
            }
            if ((ids = BusinessDataServiceHelper.load((String)baseEntityId, (String)"id", (QFilter[])(concatQfilter = (QFilter[])ObjectArrays.concat((Object[])query.getHisQFiltrs(), (Object[])new QFilter[]{MultiSheetHelper.handlePermBaseDataReference(parentEntityNumber, fieldName)}, QFilter.class)))).length > 0) {
                Set tempIds = (Set)this.hasPermBasedataTable.get((Object)parentEntityNumber, (Object)baseEntityId);
                if (Objects.isNull(tempIds)) {
                    tempIds = Arrays.stream(ids).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
                } else {
                    tempIds.add(ids[0].getLong("id"));
                }
                this.hasPermBasedataTable.put((Object)parentEntityNumber, (Object)baseEntityId, tempIds);
            }
            if (!fieldName.equals(mainOrg = mainEntityType.getMainOrg()) || !Objects.isNull(this.orgPermScope.get((Object)parentEntityNumber, (Object)mainOrg))) continue;
            String appId = AppMetadataCache.getAppInfo((String)mainEntityType.getAppId()).getId();
            String orgViewType = PermCommonUtil.getPermOrgViewScheme((String)parentEntityNumber);
            LOG.info("BasedataContianer--queryBaseDataRef(),orgViewType:{},appId:{},parentEntityNumber:{}", new Object[]{orgViewType, appId, parentEntityNumber});
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)orgViewType, (String)appId, (String)parentEntityNumber, (String)"47150e89000000ac");
            if (result.hasAllOrgPerm()) {
                this.orgPermScope.put((Object)parentEntityNumber, (Object)mainOrg, (Object)OrgUnitServiceHelper.getAllOrg((String)"11"));
                continue;
            }
            this.orgPermScope.put((Object)parentEntityNumber, (Object)mainOrg, Objects.isNull(result.getHasPermOrgs()) || result.getHasPermOrgs().size() == 0 ? Collections.singletonList(-1L) : result.getHasPermOrgs());
        }
        for (BasedataQueryDesc query : this.basedataList) {
            String baseEntityId = query.getProp().getBaseEntityId();
            String useOrgValue = query.getUseOrg();
            if (!StringUtils.isNotEmpty((CharSequence)useOrgValue)) continue;
            this.queryStrategyPerm(query, baseEntityId, useOrgValue);
        }
        LOG.info("BasedataContianer--queryBaseDataRef(),hasPermBasedataTable:{},hasStrategyPermBasedataTable:{},orgPermScope:{}", new Object[]{this.hasPermBasedataTable.toString(), this.hasStrategyPermBasedataTable.toString(), this.orgPermScope.toString()});
    }

    private void queryStrategyPerm(BasedataQueryDesc query, String baseEntityId, String useOrgValue) {
        if (CollectionUtils.isEmpty((Collection)((Collection)this.hasStrategyPermBasedataTable.get((Object)baseEntityId, (Object)useOrgValue)))) {
            String useOrgEntityNum = query.getUseOrgJson().getString("useorgentitynum");
            if (this.getBasedata(useOrgEntityNum, useOrgValue).size() == 0) {
                LOG.info("BasedataContianer--queryStrategyPerm(),useOrgEntityNum:{},useOrgValue:{} is not exists", (Object)useOrgEntityNum, (Object)useOrgValue);
                return;
            }
            QFilter baseDataQFilter = (QFilter)DispatchServiceHelper.invokeBOSService((String)"bos", (String)"IBaseDataService", (String)"getBaseDataFilter", (Object[])new Object[]{baseEntityId, this.getBasedata(useOrgEntityNum, useOrgValue).get(0).getLong("id")});
            DynamicObject[] ids1 = BusinessDataServiceHelper.load((String)baseEntityId, (String)"id", (QFilter[])new QFilter[]{baseDataQFilter});
            this.hasStrategyPermBasedataTable.put((Object)baseEntityId, (Object)useOrgValue, Arrays.stream(ids1).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
        }
    }

    public void queryBasedataFromStore() {
        this.basedataList.forEach(query -> {
            Object[] basedataArr;
            List<DynamicObject> basedataCol = this.getBasedata(query.getProp().getBaseEntityId(), query.getImportValue());
            if (CollectionUtils.isEmpty(basedataCol) && (basedataArr = BusinessDataServiceHelper.load((String)query.getProp().getBaseEntityId(), (String)String.join((CharSequence)",", query.getSelectProp()), (QFilter[])query.getQFiltrs())).length > 0) {
                this.basedataTable.put((Object)query.getProp().getBaseEntityId(), (Object)query.getImportValue(), (Object)Lists.newArrayList((Object[])basedataArr));
            }
        });
    }

    public void addBasedataQuery(BasedataQueryDesc query) {
        Optional<BasedataQueryDesc> any = this.basedataList.stream().filter(basedata -> basedata.getProp().getName().equals(query.getProp().getName()) && basedata.getParentEntity().equals(query.getParentEntity()) && basedata.getImportKey().equals(query.getImportKey()) && basedata.getImportValue().equals(query.getImportValue()) && basedata.getUseOrg().equals(query.getUseOrg())).findAny();
        if (!any.isPresent()) {
            this.basedataList.add(query);
        }
    }

    public List<DynamicObject> getBasedata(String baseEntityId, String importValue) {
        List dynamicObjectList = (List)this.basedataTable.get((Object)baseEntityId, (Object)importValue);
        if (Objects.nonNull(dynamicObjectList)) {
            return dynamicObjectList;
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    public Set<Long> getPermBasedata(String parentEntityNum, String baseEntityId) {
        Set dynamicObjectList = (Set)this.hasPermBasedataTable.get((Object)parentEntityNum, (Object)baseEntityId);
        if (Objects.nonNull(dynamicObjectList)) {
            return dynamicObjectList;
        }
        return Sets.newHashSetWithExpectedSize((int)0);
    }

    public List<Long> getPermScopeBasedata(String parentEntityNum, String fieldKey) {
        List dynamicObjectList = (List)this.orgPermScope.get((Object)parentEntityNum, (Object)fieldKey);
        if (Objects.nonNull(dynamicObjectList)) {
            return dynamicObjectList;
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    public List<Long> getStrategyPermBasedata(String baseEntityId, String useOrgValue) {
        List dynamicObjectList = (List)this.hasStrategyPermBasedataTable.get((Object)baseEntityId, (Object)useOrgValue);
        if (Objects.nonNull(dynamicObjectList)) {
            return dynamicObjectList;
        }
        return Lists.newArrayListWithExpectedSize((int)0);
    }

    public BasedataQueryDesc getBasedataProperty(String fieldKey) {
        Optional<BasedataQueryDesc> mulbasedatafield = this.basedataList.stream().filter(field -> field.getProp().getName().equals(fieldKey)).findAny();
        return mulbasedatafield.orElse(null);
    }

    public BasedataQueryDesc getBasedataProperty(String fieldKey, String useOrgValue) {
        Optional<BasedataQueryDesc> mulbasedatafield = this.basedataList.stream().filter(field -> field.getProp().getName().equals(fieldKey) && field.getUseOrg().equals(useOrgValue)).findAny();
        return mulbasedatafield.orElse(null);
    }
}

