/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ORMUtil;
import kd.bos.entity.property.AdminDivisionProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.impt.SheetHandler;

public class ImportEntityMapping {
    private static final String HRMP_HBP_FORMPLUGIN = "hrmp-hbp-formplugin";
    private Set<String> TRUE = Sets.newHashSet((Object[])new String[]{ResManager.loadKDString((String)"\u662f", (String)"ImportEntityMapping_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u771f", (String)"ImportEntityMapping_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u52fe\u9009", (String)"ImportEntityMapping_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5bf9", (String)"ImportEntityMapping_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "true", "yes", "ok"});
    private DynamicObjectType entityType;
    private Map<String, ColInfo> cols = new HashMap<String, ColInfo>();
    private Map<String, ImportEntityMapping> entries = new HashMap<String, ImportEntityMapping>();

    public static ImportEntityMapping create(DynamicObjectType entityType, Map<Integer, String> nameRow, Map<Integer, String> titleRow) {
        Map<String, ColInfo> names = ImportEntityMapping.getEntityPropertyNames(nameRow, titleRow);
        return ImportEntityMapping.createMapping(entityType, names);
    }

    private static ImportEntityMapping createMapping(DynamicObjectType entityType, Map<String, ColInfo> names) {
        ImportEntityMapping mapping = new ImportEntityMapping();
        mapping.entityType = entityType;
        for (IDataEntityProperty prop : entityType.getProperties()) {
            ColInfo colInfo;
            boolean isEntryId;
            String propName = prop.getName();
            if (prop instanceof EntryProp) {
                ImportEntityMapping entry = ImportEntityMapping.createMapping(((EntryProp)prop).getDynamicCollectionItemPropertyType(), names);
                if (entry.cols.isEmpty()) continue;
                mapping.entries.put(propName, entry);
                continue;
            }
            boolean bl = isEntryId = entityType instanceof EntryType && "id".equalsIgnoreCase(propName);
            if (isEntryId) {
                propName = entityType.getName() + "_" + propName;
            }
            if ((colInfo = names.get(propName)) == null) continue;
            if (prop instanceof FlexProp) {
                String displayName = colInfo.getDisplayName();
                colInfo.getFlexColIndex().put(colInfo.getIndex(), new String[]{colInfo.getBasedataProp(), displayName});
            }
            colInfo.setProperty(prop);
            mapping.cols.put(isEntryId ? entityType.getName() + "." + "id" : propName, colInfo);
        }
        return mapping;
    }

    private static Map<String, ColInfo> getEntityPropertyNames(Map<Integer, String> nameRow, Map<Integer, String> titleRow) {
        HashMap<String, ColInfo> names = new HashMap<String, ColInfo>();
        for (Map.Entry<Integer, String> entry : nameRow.entrySet()) {
            Integer integer = entry.getKey();
            String fullName = entry.getValue();
            String fullTitle = titleRow.get(integer);
            if (!StringUtils.isNotBlank((CharSequence)fullName)) continue;
            String[] tempNameSplit = fullName.split("\\.");
            String propertyDisplayName = fullTitle.replace("*", "");
            String propertyName = tempNameSplit[0];
            String endFix = tempNameSplit.length > 1 ? ImportEntityMapping.getMultiSelectField(tempNameSplit) : "";
            ColInfo colInfo = (ColInfo)names.get(propertyName);
            if (colInfo != null) {
                Map<Integer, String[]> idx = colInfo.getFlexColIndex();
                idx.put(integer, new String[]{endFix, propertyDisplayName});
                continue;
            }
            names.put(propertyName, new ColInfo(integer, StringUtils.isNotBlank((CharSequence)propertyDisplayName) ? propertyDisplayName : propertyName, fullTitle.startsWith("*"), endFix));
        }
        return names;
    }

    public static ImportEntityMapping create(DynamicObjectType entityType, Map<Integer, String> nameRow) {
        HashMap<String, ColInfo> names = new HashMap<String, ColInfo>();
        for (Map.Entry<Integer, String> entry : nameRow.entrySet()) {
            String fullName = entry.getValue();
            ImportEntityMapping.putPropertyName(names, entry, fullName);
        }
        ImportEntityMapping mapping = new ImportEntityMapping();
        mapping.entityType = entityType;
        for (IDataEntityProperty prop : entityType.getProperties()) {
            String propName = prop.getName();
            if (prop instanceof EntryProp) {
                ImportEntityMapping entry = ImportEntityMapping.create(((EntryProp)prop).getDynamicCollectionItemPropertyType(), nameRow);
                if (entry.cols.isEmpty()) continue;
                mapping.entries.put(propName, entry);
                continue;
            }
            if (names.get(propName) == null) continue;
            if (prop instanceof FlexProp) {
                ColInfo colInfo = (ColInfo)names.get(propName);
                String displayName = nameRow.get(colInfo.getIndex()).split(" # ")[0].replace("*", "");
                colInfo.getFlexColIndex().put(colInfo.getIndex(), new String[]{colInfo.getBasedataProp(), displayName});
            }
            ((ColInfo)names.get(propName)).setProperty(prop);
            mapping.cols.put(propName, (ColInfo)names.get(propName));
        }
        return mapping;
    }

    private static void putPropertyName(Map<String, ColInfo> names, Map.Entry<Integer, String> entry, String fullName) {
        if (StringUtils.isNotBlank((CharSequence)fullName) && fullName.contains(" # ")) {
            String[] propertyName = fullName.split(" # ");
            String[] propertyNameSplit = propertyName[1].split("\\.");
            if (names.get(propertyNameSplit[0]) != null) {
                ColInfo colInfo = names.get(propertyNameSplit[0]);
                Map<Integer, String[]> idx = colInfo.getFlexColIndex();
                idx.put(entry.getKey(), new String[]{propertyNameSplit.length > 1 ? propertyNameSplit[1] : "", propertyName[0].replace("*", "")});
            } else {
                names.put(propertyNameSplit[0], new ColInfo(entry.getKey(), fullName.startsWith("*"), propertyNameSplit.length > 1 ? propertyNameSplit[1] : ""));
            }
        }
    }

    public Map<String, ColInfo> getCols() {
        return this.cols;
    }

    public Map<String, ImportEntityMapping> getEntries() {
        return this.entries;
    }

    public String getEntityTypeId() {
        return this.entityType.getName();
    }

    public List<String> push(Map<Integer, String> row, JSONObject data) {
        ArrayList<String> logs = new ArrayList<String>();
        this.pushData(row, data, logs);
        for (Map.Entry<String, ImportEntityMapping> entry : this.entries.entrySet()) {
            JSONArray entryRows = this.getEntryRows(data, entry.getKey());
            JSONObject entryRow = new JSONObject();
            ImportEntityMapping entryMapping = entry.getValue();
            boolean entryRowEmpty = entryMapping.pushData(row, entryRow, logs);
            if (entryRowEmpty) continue;
            entryRows.add((Object)entryRow);
            data.put(entry.getKey(), (Object)entryRows);
        }
        return logs;
    }

    private JSONArray getEntryRows(JSONObject data, String key) {
        JSONArray entry;
        if (data.containsKey((Object)key)) {
            entry = data.getJSONArray(key);
        } else {
            entry = new JSONArray();
            data.put(key, (Object)entry);
        }
        return entry;
    }

    private boolean pushData(Map<Integer, String> row, JSONObject data, List<String> logs) throws KDBizException {
        boolean rowEmpty = true;
        boolean needInput = false;
        boolean hasval = false;
        boolean isEntryEntity = this.isEntryEntity(row);
        if (isEntryEntity) {
            return true;
        }
        Map<Object, Object> colname = Maps.newHashMapWithExpectedSize((int)0);
        ArrayList mustErrorLogs = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList valErrorLogs = Lists.newArrayListWithExpectedSize((int)10);
        for (Map.Entry<String, ColInfo> col : this.cols.entrySet()) {
            IDataEntityProperty prop;
            boolean isFlexProp;
            ColInfo colInfo = col.getValue();
            this.setErrorMsg(mustErrorLogs, Objects.nonNull(row.get(colInfo.index)), colInfo.isMustInput(), colInfo.getDisplayName());
            int index = -1;
            if (colInfo.getBasedataProp().length() > 1) {
                Optional<Integer> indexopt = colInfo.getFlexColIndex().keySet().stream().filter(key -> StringUtils.isNotBlank((CharSequence)((CharSequence)row.get(key)))).findAny();
                index = indexopt.orElse(index);
                colname = colInfo.getFlexColIndex();
            }
            if (!(isFlexProp = (prop = colInfo.getProperty()) instanceof FlexProp) && StringUtils.isBlank((CharSequence)row.get(colInfo.getIndex()))) {
                boolean bl = needInput = needInput || colInfo.isMustInput();
                if (index == -1 || index > -1 && StringUtils.isBlank((CharSequence)row.get(index))) continue;
            }
            Object val = null;
            HashMap<String, Object> flexVal = null;
            if (isFlexProp) {
                flexVal = new HashMap<String, Object>();
                Map<Integer, String[]> colIndex = colInfo.getFlexColIndex();
                this.putFlexValItem(row, flexVal, colIndex);
                if (!flexVal.isEmpty()) {
                    val = flexVal;
                }
            } else {
                val = row.get(colInfo.getIndex());
                if (StringUtils.isBlank((CharSequence)val)) {
                    hasval = true;
                    val = row.get(index);
                }
            }
            if (StringUtils.isNotBlank((Object)val)) {
                val = this.getVal(row, valErrorLogs, hasval, colname, colInfo, index, prop, isFlexProp, val);
                data.put(col.getKey(), val);
                if (rowEmpty) {
                    // empty if block
                }
                rowEmpty = false;
                hasval = false;
                continue;
            }
            if (!colInfo.isMustInput()) continue;
            if (!needInput) {
                // empty if block
            }
            needInput = true;
        }
        if (!mustErrorLogs.isEmpty()) {
            logs.add(String.join((CharSequence)",", mustErrorLogs));
        }
        if (!valErrorLogs.isEmpty()) {
            logs.add(String.join((CharSequence)",", valErrorLogs));
        }
        return rowEmpty;
    }

    private boolean isEntryEntity(Map<Integer, String> row) {
        Set<Integer> integers = row.keySet();
        for (Map.Entry<String, ColInfo> col : this.cols.entrySet()) {
            ColInfo colInfo = col.getValue();
            Set<Integer> flexColIndexSet = colInfo.getFlexColIndex().keySet();
            if (integers.contains(colInfo.getIndex())) {
                return false;
            }
            for (Integer flexColIndex : flexColIndexSet) {
                if (!integers.contains(flexColIndex)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isEntryRow(SheetHandler.ParsedRow prevRow, SheetHandler.ParsedRow currRow) {
        if (prevRow != null && currRow != null) {
            return currRow.getRowNum() - prevRow.getRowNum() == 1 ? this.isSameEntryOne(prevRow, currRow) : false;
        }
        return false;
    }

    public boolean isSameEntryOne(SheetHandler.ParsedRow prevRow, SheetHandler.ParsedRow currRow) {
        if (prevRow != null && !this.entries.isEmpty()) {
            boolean entityEmpty = true;
            boolean sameOne = true;
            for (Map.Entry<String, ColInfo> entry : this.cols.entrySet()) {
                Integer index = entry.getValue().getIndex();
                if (entityEmpty && StringUtils.isNotBlank((CharSequence)currRow.get(index))) {
                    entityEmpty = false;
                }
                if (sameOne && !this.equalsString(prevRow.get(index), currRow.get(index))) {
                    sameOne = false;
                    continue;
                }
                if (entityEmpty || sameOne) continue;
                break;
            }
            return entityEmpty || sameOne && this.hasEntryData(currRow.getData());
        }
        return false;
    }

    private boolean hasEntryData(Map<Integer, String> data) {
        Map.Entry<String, ImportEntityMapping> entry;
        ImportEntityMapping entryMapping;
        Iterator<Map.Entry<String, ImportEntityMapping>> iterator = this.entries.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while ((entryMapping = (entry = iterator.next()).getValue()).isEntityEmpty(data));
        return true;
    }

    private void setErrorMsg(List<String> logs, boolean rowEmpty, boolean needInput, String fieldName) {
        if (!rowEmpty && needInput) {
            if (logs.size() == 0) {
                logs.add(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199:%s", (String)"ImportEntityMapping_8", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[]{fieldName}));
            } else if (StringUtils.isNotBlank((CharSequence)fieldName)) {
                logs.add(fieldName);
            }
        }
    }

    private Object getVal(Map<Integer, String> row, List<String> logs, boolean hasval, Map<Integer, String[]> colname, ColInfo colInfo, int index, IDataEntityProperty prop, boolean isFlexProp, Object val) {
        if (!isFlexProp) {
            if (prop instanceof AdminDivisionProp) {
                val = this.getAdminId(logs, val);
            } else if (prop instanceof BasedataProp || prop instanceof MulBasedataProp) {
                JSONObject jsonData = new JSONObject();
                String key = index > -1 && hasval ? colname.get(index)[0] : colInfo.getBasedataProp();
                jsonData.put("importprop", (Object)key);
                jsonData.put(key, val);
                this.putJsondata(row, colInfo, jsonData);
                val = jsonData;
            } else if (prop instanceof ComboProp) {
                val = this.getComboProp(logs, prop, val);
            } else if (prop instanceof DecimalProp) {
                val = this.getDecimalProp(logs, prop, val);
            } else if (prop instanceof BooleanProp) {
                if (val != null) {
                    val = this.TRUE.contains(((String)val).toLowerCase());
                }
            } else if (prop instanceof MuliLangTextProp) {
                HashMap mulValue = Maps.newHashMapWithExpectedSize((int)16);
                mulValue.put(colInfo.getBasedataProp(), val);
                colInfo.getFlexColIndex().entrySet().forEach(mulCol -> {
                    if (row.containsKey(mulCol.getKey())) {
                        mulValue.put(((String[])mulCol.getValue())[0], row.get(mulCol.getKey()));
                    }
                });
                val = mulValue;
            }
        }
        return val;
    }

    private Object getDecimalProp(List<String> logs, IDataEntityProperty prop, Object val) {
        try {
            if (val == null) {
                return null;
            }
            val = prop instanceof BigIntProp ? (Number)Long.parseLong((String)val) : (Number)(prop instanceof IntegerProp ? (Number)Integer.parseInt((String)val) : (Number)Double.parseDouble((String)val));
        }
        catch (NumberFormatException e) {
            String msgFld = String.format(ResManager.loadKDString((String)"\u6570\u503c\u5b57\u6bb5 %s", (String)"ImportEntityMapping_6", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]), prop.getDisplayName());
            String msgFmt = String.format(ResManager.loadKDString((String)"\u683c\u5f0f\u5f02\u5e38\uff1a%s", (String)"ImportEntityMapping_7", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]), val);
            logs.add(msgFld + msgFmt);
        }
        return val;
    }

    private Object getComboProp(List<String> logs, IDataEntityProperty prop, Object val) {
        List items = ((ComboProp)prop).getComboItems();
        if (items != null && !items.isEmpty() && val != null) {
            val = this.setObjectValue(logs, prop, val, items);
        }
        return val;
    }

    private Object setObjectValue(List<String> logs, IDataEntityProperty prop, Object val, List<ValueMapItem> items) {
        List<String> cellValueSplit = Arrays.asList(((String)val).split(","));
        ArrayList<String> values = new ArrayList<String>();
        boolean isMulCombo = prop instanceof MulComboProp;
        for (ValueMapItem item : items) {
            if (!(isMulCombo ? cellValueSplit.contains(item.getName().toString()) : item.getName().toString().equals(val))) continue;
            values.add(item.getValue());
            if (isMulCombo) continue;
            break;
        }
        if (StringUtils.isNotBlank((Object)val) && values.isEmpty()) {
            String msg = ResManager.loadKDString((String)"\u5339\u914d\u4e0d\u5230\u4e0b\u62c9\u9009\u9879\uff1a", (String)"ImportEntityMapping_9", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]);
            logs.add(prop.getDisplayName() + msg + val);
            val = null;
        }
        val = String.join((CharSequence)",", values);
        return val;
    }

    private void putJsondata(Map<Integer, String> row, ColInfo colInfo, JSONObject jsonData) {
        for (Map.Entry<Integer, String[]> splitCol : colInfo.getFlexColIndex().entrySet()) {
            String splitVal = row.get(splitCol.getKey());
            if (!StringUtils.isNotBlank((Object)splitVal)) continue;
            jsonData.put(splitCol.getValue()[0], (Object)splitVal);
        }
    }

    private Object getAdminId(List<String> logs, Object val) {
        Object adminId = null;
        if (val != null) {
            adminId = ORMUtil.getAdminDivisionByName((String)((String)val).replace('/', '_'));
        }
        if (StringUtils.isNotBlank(adminId)) {
            val = adminId;
        } else {
            String msgF = ResManager.loadKDString((String)"\u884c\u653f\u533a\u5212\u201c", (String)"ImportEntityMapping_4", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]);
            String msgD = ResManager.loadKDString((String)"\u201d\u4e0d\u5b58\u5728", (String)"ImportEntityMapping_5", (String)HRMP_HBP_FORMPLUGIN, (Object[])new Object[0]);
            logs.add(msgF + val + msgD);
        }
        return val;
    }

    private void putFlexValItem(Map<Integer, String> row, Map<String, Object> flexVal, Map<Integer, String[]> colIndex) {
        for (Map.Entry<Integer, String[]> entry : colIndex.entrySet()) {
            String object = row.get(entry.getKey());
            if (!StringUtils.isNotBlank((Object)object)) continue;
            String[] columnInfoArray = entry.getValue();
            String flexColName = "";
            String importProp = "";
            if (columnInfoArray != null && columnInfoArray.length > 1) {
                String[] columnArray = columnInfoArray[1].split("\\.");
                if (columnArray.length > 0) {
                    flexColName = columnArray[1];
                }
                importProp = columnInfoArray[0];
            }
            if (StringUtils.isNotBlank((CharSequence)importProp)) {
                HashMap<String, String> item = (HashMap<String, String>)flexVal.get(flexColName);
                if (item == null) {
                    item = new HashMap<String, String>();
                    item.put("importprop", importProp);
                    flexVal.put(flexColName, item);
                }
                item.put(entry.getValue()[0], object);
                continue;
            }
            flexVal.put(flexColName, object);
        }
    }

    public boolean isEntityEmpty(Map<Integer, String> row) {
        boolean isEmpty = true;
        block0: for (Map.Entry<String, ColInfo> entry : this.cols.entrySet()) {
            Map<Integer, String[]> flexColIndexMap = entry.getValue().getFlexColIndex();
            if (StringUtils.isNotBlank((CharSequence)row.get(entry.getValue().getIndex()))) {
                isEmpty = false;
                break;
            }
            for (Integer flexColIndex : flexColIndexMap.keySet()) {
                if (!StringUtils.isNotBlank((CharSequence)row.get(flexColIndex))) continue;
                isEmpty = false;
                continue block0;
            }
        }
        return isEmpty;
    }

    public boolean isSameData(SheetHandler.ParsedRow prevRow, SheetHandler.ParsedRow currRow) {
        if (prevRow != null && currRow != null) {
            boolean isNearRow;
            boolean sameOne = true;
            boolean bl = isNearRow = currRow.getRowNum() - prevRow.getRowNum() == 1;
            if (isNearRow && !this.entries.isEmpty()) {
                for (Map.Entry<String, ColInfo> next : this.cols.entrySet()) {
                    int index = next.getValue().getIndex();
                    if (!sameOne || this.equalsString(prevRow.get(Integer.valueOf(index)), currRow.get(Integer.valueOf(index)))) continue;
                    sameOne = false;
                    break;
                }
                return sameOne;
            }
            return false;
        }
        return false;
    }

    private boolean equalsString(String v1, String v2) {
        if (v1 != null && !(v1 = v1.trim()).isEmpty()) {
            return v2 != null && v1.equals(v2.trim());
        }
        return v2 == null || v2.trim().isEmpty();
    }

    private static String getMultiSelectField(String[] tempNameSplit) {
        ArrayList names = Lists.newArrayListWithExpectedSize((int)tempNameSplit.length);
        names.addAll(Arrays.asList(tempNameSplit).subList(1, tempNameSplit.length));
        return String.join((CharSequence)".", names);
    }

    public static class ColInfo {
        private int index;
        private String displayName;
        private boolean mustInput;
        private String basedataProp;
        private IDataEntityProperty property;
        private Map<Integer, String[]> flexColIndex = new HashMap<Integer, String[]>();

        @Deprecated
        public ColInfo(int index, boolean mustInput, String basedataProp) {
            this.index = index;
            this.mustInput = mustInput;
            this.basedataProp = basedataProp;
        }

        public ColInfo(int index, String displayName, boolean mustInput, String basedataProp) {
            this.index = index;
            this.displayName = displayName;
            this.mustInput = mustInput;
            this.basedataProp = basedataProp;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean isMustInput() {
            return this.mustInput;
        }

        public void setMustInput(boolean mustInput) {
            this.mustInput = mustInput;
        }

        public String getBasedataProp() {
            return this.basedataProp;
        }

        public void setBasedataProp(String basedataProp) {
            this.basedataProp = basedataProp;
        }

        public IDataEntityProperty getProperty() {
            return this.property;
        }

        public void setProperty(IDataEntityProperty property) {
            this.property = property;
        }

        public Map<Integer, String[]> getFlexColIndex() {
            return this.flexColIndex;
        }

        public void setFlexColIndex(Map<Integer, String[]> flexColIndex) {
            this.flexColIndex = flexColIndex;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }
}

