/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.imp;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class MultiEntityQueryConfig {
    private QueryEntityType query;
    private String queryFileds;
    private Map<String, String> entityPKProMap = Maps.newHashMapWithExpectedSize((int)16);

    public MultiEntityQueryConfig(QueryEntityType query, List<String> customSelectProps) {
        this.query = query;
        this.init(customSelectProps);
    }

    private void init(List<String> customSelectProps) {
        List joinEntitys = this.getQuery().getJoinEntitys();
        List fieldList = this.query.getSelectFields().stream().map(select -> select.getAlias()).filter(field -> !field.contains("leadername")).collect(Collectors.toList());
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)this.getQuery().getEntityName());
        if (!fieldList.stream().allMatch(field -> HRStringUtils.equals((String)field, (String)mainType.getPrimaryKey().getName()))) {
            fieldList.add(mainType.getPrimaryKey().getName());
        }
        this.entityPKProMap.put(this.getQuery().getEntityName(), mainType.getPrimaryKey().getName());
        joinEntitys.stream().forEach(joinEntity -> {
            MainEntityType subType = MetadataServiceHelper.getDataEntityType((String)joinEntity.getEntityName());
            String pk = this.getDataSetIdKey(joinEntity.getEntityName(), subType.getPrimaryKey().getName());
            if (!fieldList.stream().allMatch(field -> HRStringUtils.equals((String)field, (String)pk))) {
                fieldList.add(pk);
            }
            this.entityPKProMap.put(joinEntity.getEntityName(), subType.getPrimaryKey().getName());
        });
        if (!CollectionUtils.isEmpty(customSelectProps)) {
            fieldList.addAll(customSelectProps);
        }
        this.queryFileds = String.join((CharSequence)",", Sets.newHashSet(fieldList));
    }

    public String getDataSetIdKey(String entityName, String idProp) {
        return entityName + "." + idProp;
    }

    public String getIdProp(String entityName) {
        return this.entityPKProMap.get(entityName);
    }

    public QueryEntityType getQuery() {
        return this.query;
    }

    public void setQuery(QueryEntityType query) {
        this.query = query;
    }

    public String getQueryFileds() {
        return this.queryFileds;
    }

    public void setQueryFileds(String queryFileds) {
        this.queryFileds = queryFileds;
    }
}

