/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.labelandreport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.service.labelandreport.SelectEntityFieldUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.model.complexobj.SelectFieldTreeNode;
import kd.hr.hbp.common.model.complexobj.labelandreport.EntityRelationCommonBo;
import kd.hr.hbp.common.model.complexobj.labelandreport.JoinConditionBo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.CloseCheckFormPlugin;

public class SetEntityRelationPlugin
extends CloseCheckFormPlugin {
    private static final String ENTRY = "relationconditions";
    private static final String LEFT_JOIN_FLEX = "leftjoinflex";
    private static final String INNER_JOIN_FLEX = "innerjoinflex";
    private static final String RIGHT_JOIN_FLEX = "rightjoinflex";
    private static final String PAGE_SELECT_ENTITY_FIELDS = "hbp_selectentityfields";
    private static final String LEFT_VAL_TYPE = "leftvaluetype";
    private static final String LEFT_ALIAS = "leftalias";
    private static final String RIGHT_TYPE = "righttype";
    private static final String RIGHT_VAL_TYPE = "rightvaluetype";
    private static final String RIGHT_ALIAS = "rightalias";
    private static final String RIGHT_BASE_DATA_ID = "rightbasedataid";
    private static final String RIGHT_ENUM_ID = "rightenumid";
    private static final String LEFT = "left";
    private static final String INNER = "inner";
    private static final String RIGHT = "right";
    private static final String RIGHT_PARENT_ALIAS = "rightparentalias";
    private static final String LEFT_PARENT_ALIAS = "leftparentalias";
    private static final String CONDITION = "condition";
    private static final String JOIN_TYPE = "jointype";

    @ExcludeFromJacocoGeneratedReport
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String hideJoinType = (String)this.getView().getFormShowParameter().getCustomParam("hideJoinType");
        if (HRStringUtils.isNotEmpty((String)hideJoinType)) {
            String[] hideJoinTypes;
            for (String joinType : hideJoinTypes = hideJoinType.split(",")) {
                if (HRStringUtils.equals((String)joinType, (String)LEFT)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{LEFT_JOIN_FLEX});
                    continue;
                }
                if (HRStringUtils.equals((String)joinType, (String)INNER)) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{INNER_JOIN_FLEX});
                    continue;
                }
                if (!HRStringUtils.equals((String)joinType, (String)RIGHT)) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{RIGHT_JOIN_FLEX});
            }
        }
        String joinType = "";
        EntityRelationCommonBo entityRelationBo = this.getEntityRelationBo();
        if (entityRelationBo != null) {
            joinType = entityRelationBo.getJoinType();
        }
        this.getModel().setValue(JOIN_TYPE, (Object)joinType);
        if (HRStringUtils.equals((String)joinType, (String)"LeftJoin")) {
            this.setChooseStyle(LEFT_JOIN_FLEX);
        } else if (HRStringUtils.equals((String)joinType, (String)"RightJoin")) {
            this.setChooseStyle(RIGHT_JOIN_FLEX);
        } else if (HRStringUtils.equals((String)joinType, (String)"InnerJoin")) {
            this.setChooseStyle(INNER_JOIN_FLEX);
        } else {
            this.setChooseStyle(LEFT_JOIN_FLEX);
            this.getModel().setValue(JOIN_TYPE, (Object)"LeftJoin");
        }
        this.setEntryData(entityRelationBo);
        HashMap map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("columnResizeMode", "preset");
        this.getView().updateControlMetadata(ENTRY, (Map)map);
        this.getModel().setDataChanged(false);
    }

    private void setEntryData(EntityRelationCommonBo entityRelationBo) {
        if (entityRelationBo != null && entityRelationBo.getConditions().size() > 0) {
            List conditions = entityRelationBo.getConditions();
            int createRows = conditions.size() - 1;
            if (createRows > 0) {
                this.getModel().batchCreateNewEntryRow(ENTRY, createRows);
            }
            String mainEntityAlias = (String)this.getView().getFormShowParameter().getCustomParam("mainEntityAlias");
            SelectFieldTreeNode entityNode = SelectEntityFieldUtil.getEntityFields((String)entityRelationBo.getEntityNumber(), (String)entityRelationBo.getEntityAlias(), (mainEntityAlias == null || mainEntityAlias.equals(entityRelationBo.getEntityAlias()) ? 1 : 0) != 0);
            SelectFieldTreeNode joinEntityNode = SelectEntityFieldUtil.getEntityFields((String)entityRelationBo.getJoinEntityNumber(), (String)entityRelationBo.getJoinEntityAlias(), (boolean)false);
            MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
            int rowIndex = 0;
            for (JoinConditionBo conditionBo : conditions) {
                StringBuilder parentType = new StringBuilder();
                SelectFieldTreeNode leftNode = this.getFieldNode(conditionBo.getLeftProp(), entityNode, joinEntityNode, parentType);
                if (leftNode == null) continue;
                if (HRStringUtils.equals((String)parentType.toString(), (String)"main")) {
                    this.getModel().setValue(LEFT_PARENT_ALIAS, (Object)entityRelationBo.getEntityAlias(), rowIndex);
                } else {
                    this.getModel().setValue(LEFT_PARENT_ALIAS, (Object)entityRelationBo.getJoinEntityAlias(), rowIndex);
                }
                String leftDisplayName = leftNode.getLongName() + " | " + leftNode.getFieldAlias();
                this.getModel().setValue(LEFT, (Object)leftDisplayName, rowIndex);
                this.getModel().setValue(LEFT_ALIAS, (Object)conditionBo.getLeftProp(), rowIndex);
                this.getModel().setValue(LEFT_VAL_TYPE, (Object)leftNode.getValueType(), rowIndex);
                this.getModel().setValue(CONDITION, (Object)conditionBo.getCompareType(), rowIndex);
                String rightType = conditionBo.getRightPropType();
                this.getModel().setValue(RIGHT_TYPE, (Object)rightType, rowIndex);
                if (HRStringUtils.equals((String)rightType, (String)"field")) {
                    this.setRightField(conditionBo, entityRelationBo, entityNode, joinEntityNode, rowIndex);
                } else {
                    this.setRightValue(conditionBo, parentType.toString(), entityRelationBo, mainEntityTypeUtil, rowIndex);
                }
                ++rowIndex;
            }
        }
    }

    private void setRightField(JoinConditionBo conditionBo, EntityRelationCommonBo entityRelationBo, SelectFieldTreeNode entityNode, SelectFieldTreeNode joinEntityNode, int rowIndex) {
        StringBuilder parentType = new StringBuilder();
        SelectFieldTreeNode rightNode = this.getFieldNode(conditionBo.getRightProp(), entityNode, joinEntityNode, parentType);
        if (rightNode == null) {
            return;
        }
        String rightDisplayName = rightNode.getLongName() + " | " + rightNode.getFieldAlias();
        this.getModel().setValue(RIGHT, (Object)rightDisplayName, rowIndex);
        this.getModel().setValue(RIGHT_VAL_TYPE, (Object)rightNode.getValueType(), rowIndex);
        this.getModel().setValue(RIGHT_ALIAS, (Object)conditionBo.getRightProp(), rowIndex);
        if (HRStringUtils.equals((String)parentType.toString(), (String)"main")) {
            this.getModel().setValue(RIGHT_PARENT_ALIAS, (Object)entityRelationBo.getEntityAlias(), rowIndex);
        } else {
            this.getModel().setValue(RIGHT_PARENT_ALIAS, (Object)entityRelationBo.getJoinEntityAlias(), rowIndex);
        }
    }

    private void setRightValue(JoinConditionBo conditionBo, String parentType, EntityRelationCommonBo entityRelationBo, MainEntityTypeUtil mainEntityTypeUtil, int rowIndex) {
        String entityNum = HRStringUtils.equals((String)parentType, (String)"main") ? entityRelationBo.getEntityNumber() : entityRelationBo.getJoinEntityNumber();
        if (conditionBo.getLeftProp().endsWith(".id")) {
            Map baseDataMap = AnalyseObjectUtil.parseFieldAliasGetBaseDataNumAndPkType((String)entityNum, (String)conditionBo.getLeftProp(), (MainEntityTypeUtil)mainEntityTypeUtil);
            this.getModel().setValue(RIGHT, (Object)this.queryBaseDataName(conditionBo.getRightPropVal(), (String)baseDataMap.get("baseDataNum"), (String)baseDataMap.get("pkType")), rowIndex);
            this.getModel().setValue(RIGHT_BASE_DATA_ID, (Object)conditionBo.getRightPropVal(), rowIndex);
        } else {
            IDataEntityProperty property = AnalyseObjectUtil.parseFieldAliasGetProperty((String)entityNum, (String)conditionBo.getLeftProp(), (MainEntityTypeUtil)mainEntityTypeUtil);
            if (property instanceof ComboProp) {
                String rightPropVal = conditionBo.getRightPropVal();
                ArrayList rightValues = Lists.newArrayListWithCapacity((int)10);
                rightValues.addAll(Arrays.stream(rightPropVal.split(",")).filter(HRStringUtils::isNotEmpty).map(val -> val.substring(1, val.length() - 1)).collect(Collectors.toList()));
                List comboItems = ((ComboProp)property).getComboItems();
                StringBuilder nameSb = new StringBuilder();
                for (String rightValue : rightValues) {
                    Optional<ValueMapItem> itemOp = comboItems.stream().filter(item -> HRStringUtils.equals((String)item.getValue(), (String)rightValue)).findAny();
                    itemOp.ifPresent(valueMapItem -> nameSb.append(valueMapItem.getName().getLocaleValue()).append(","));
                }
                if (nameSb.length() > 0) {
                    this.getModel().setValue(RIGHT, (Object)nameSb.substring(0, nameSb.length() - 1), rowIndex);
                    this.getModel().setValue(RIGHT_ENUM_ID, (Object)rightPropVal, rowIndex);
                }
            } else {
                this.getModel().setValue(RIGHT, (Object)conditionBo.getRightPropVal(), rowIndex);
            }
        }
    }

    private String queryBaseDataName(String baseDataId, String baseDataNum, String baseDataPkType) {
        if (HRStringUtils.isEmpty((String)baseDataId)) {
            return "";
        }
        StringBuilder baseDataName = new StringBuilder();
        List ids = Arrays.stream(baseDataId.split(",")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", ids);
        if (HRStringUtils.equals((String)baseDataPkType, (String)"long")) {
            List longIds = ids.stream().map(Long::parseLong).collect(Collectors.toList());
            qFilter = new QFilter("id", "in", longIds);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(baseDataNum);
        DynamicObjectCollection dys = helper.queryOriginalCollection("id, name", new QFilter[]{qFilter});
        Map<String, String> idToName = dys.stream().collect(Collectors.toMap(dy -> dy.getString("id"), dy -> dy.getString("name")));
        for (String id : ids) {
            String name = idToName.get(id);
            baseDataName.append(name).append(",");
        }
        if (baseDataName.length() > 0) {
            return baseDataName.substring(0, baseDataName.length() - 1);
        }
        return baseDataName.toString();
    }

    @ExcludeFromJacocoGeneratedReport
    private SelectFieldTreeNode getFieldNode(String fieldAlias, SelectFieldTreeNode entityNode, SelectFieldTreeNode joinEntityNode, StringBuilder parentType) {
        ArrayList result = Lists.newArrayListWithCapacity((int)10);
        SelectEntityFieldUtil.findNode((String)fieldAlias, (SelectFieldTreeNode)entityNode, (List)result);
        if (result.isEmpty()) {
            parentType.append("sub");
            SelectEntityFieldUtil.findNode((String)fieldAlias, (SelectFieldTreeNode)joinEntityNode, (List)result);
        } else {
            parentType.append("main");
        }
        if (result.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6761\u4ef6\u6570\u636e\u4e2d\u5305\u542b\u57fa\u7840\u8d44\u6599\u5c5e\u6027\uff08%s\uff09\u65e7\u6570\u636e\uff0c\u8bf7\u79fb\u9664\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"SetEntityRelationPlugin_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), fieldAlias));
            return null;
        }
        return (SelectFieldTreeNode)result.get(0);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container leftFlex = (Container)this.getControl(LEFT_JOIN_FLEX);
        leftFlex.addClickListener((ClickListener)this);
        Container innerFlex = (Container)this.getControl(INNER_JOIN_FLEX);
        innerFlex.addClickListener((ClickListener)this);
        Container rightFlex = (Container)this.getControl(RIGHT_JOIN_FLEX);
        rightFlex.addClickListener((ClickListener)this);
        TextEdit entityEdit = (TextEdit)this.getControl(LEFT);
        entityEdit.addClickListener((ClickListener)this);
        TextEdit joinEntityEdit = (TextEdit)this.getControl(RIGHT);
        joinEntityEdit.addClickListener((ClickListener)this);
    }

    @ExcludeFromJacocoGeneratedReport
    public void propertyChanged(PropertyChangedArgs args) {
        ChangeData[] changeSet;
        String newValue;
        if (HRStringUtils.equals((String)args.getProperty().getName(), (String)LEFT)) {
            String rightType;
            ChangeData[] changeSet2 = args.getChangeSet();
            String newValue2 = (String)changeSet2[0].getNewValue();
            int rowIndex = changeSet2[0].getRowIndex();
            if (HRStringUtils.isEmpty((String)newValue2)) {
                this.getModel().setValue(LEFT_ALIAS, null, rowIndex);
                this.getModel().setValue(LEFT_VAL_TYPE, null, rowIndex);
                this.getModel().setValue(LEFT_PARENT_ALIAS, null, rowIndex);
            }
            if (HRStringUtils.equals((String)"value", (String)(rightType = (String)this.getModel().getValue(RIGHT_TYPE, rowIndex)))) {
                this.getModel().setValue(RIGHT, null, rowIndex);
            }
        } else if (HRStringUtils.equals((String)args.getProperty().getName(), (String)CONDITION)) {
            int rowIndex = args.getChangeSet()[0].getRowIndex();
            String rightType = (String)this.getModel().getValue(RIGHT_TYPE, rowIndex);
            if (HRStringUtils.equals((String)"value", (String)rightType)) {
                this.getModel().setValue(RIGHT, null, rowIndex);
            }
        } else if (HRStringUtils.equals((String)args.getProperty().getName(), (String)RIGHT) && HRStringUtils.isEmpty((String)(newValue = (String)(changeSet = args.getChangeSet())[0].getNewValue()))) {
            int rowIndex = changeSet[0].getRowIndex();
            this.getModel().setValue(RIGHT_ALIAS, null, rowIndex);
            this.getModel().setValue(RIGHT_VAL_TYPE, null, rowIndex);
            this.getModel().setValue(RIGHT_TYPE, null, rowIndex);
            this.getModel().setValue(RIGHT_PARENT_ALIAS, null, rowIndex);
            this.getModel().setValue(RIGHT_BASE_DATA_ID, null, rowIndex);
            this.getModel().setValue(RIGHT_ENUM_ID, null, rowIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Container) {
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.VIEW) {
                return;
            }
            String key = ((Container)evt.getSource()).getKey();
            String joinType = "none";
            this.setChooseStyle(key);
            if (HRStringUtils.equals((String)key, (String)LEFT_JOIN_FLEX)) {
                joinType = "LeftJoin";
                this.setUnChooseStyle(RIGHT_JOIN_FLEX);
                this.setUnChooseStyle(INNER_JOIN_FLEX);
            } else if (HRStringUtils.equals((String)key, (String)RIGHT_JOIN_FLEX)) {
                joinType = "RightJoin";
                this.setUnChooseStyle(LEFT_JOIN_FLEX);
                this.setUnChooseStyle(INNER_JOIN_FLEX);
            } else if (HRStringUtils.equals((String)key, (String)INNER_JOIN_FLEX)) {
                joinType = "InnerJoin";
                this.setUnChooseStyle(LEFT_JOIN_FLEX);
                this.setUnChooseStyle(RIGHT_JOIN_FLEX);
            }
            this.getModel().setValue(JOIN_TYPE, (Object)joinType);
        } else if (evt.getSource() instanceof TextEdit) {
            String leftOrRight;
            String otherParentAlias;
            String otherFieldType;
            String key = ((TextEdit)evt.getSource()).getKey();
            this.getPageCache().put("entryFieldKey", key);
            int index = this.getModel().getEntryCurrentRowIndex(ENTRY);
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId(PAGE_SELECT_ENTITY_FIELDS);
            EntityRelationCommonBo entityRelationBo = this.getEntityRelationBo();
            if (entityRelationBo == null) {
                return;
            }
            DynamicObject currentRow = (DynamicObject)this.getModel().getEntryEntity(ENTRY).get(index);
            if (HRStringUtils.equals((String)key, (String)LEFT)) {
                otherFieldType = currentRow.getString(RIGHT_VAL_TYPE);
                otherParentAlias = currentRow.getString(RIGHT_PARENT_ALIAS);
                leftOrRight = LEFT;
            } else {
                otherFieldType = currentRow.getString(LEFT_VAL_TYPE);
                parameter.setCustomParam("rightType", (Object)currentRow.getString(RIGHT_TYPE));
                otherParentAlias = currentRow.getString(LEFT_PARENT_ALIAS);
                String leftAlias = currentRow.getString(LEFT_ALIAS);
                parameter.setCustomParam(CONDITION, (Object)currentRow.getString(CONDITION));
                parameter.setCustomParam("rightVal", (Object)currentRow.getString(RIGHT));
                String entityNum = HRStringUtils.equals((String)entityRelationBo.getEntityAlias(), (String)otherParentAlias) ? entityRelationBo.getEntityNumber() : entityRelationBo.getJoinEntityNumber();
                if (leftAlias.endsWith(".id")) {
                    parameter.setCustomParam("rightBaseDataId", (Object)currentRow.getString(RIGHT_BASE_DATA_ID));
                    String baseDataNum = AnalyseObjectUtil.parseFieldAliasGetBaseDataNum((String)entityNum, (String)leftAlias, (MainEntityTypeUtil)new MainEntityTypeUtil());
                    parameter.setCustomParam("baseDataNum", (Object)baseDataNum);
                } else {
                    IDataEntityProperty property = AnalyseObjectUtil.parseFieldAliasGetProperty((String)entityNum, (String)leftAlias, (MainEntityTypeUtil)new MainEntityTypeUtil());
                    if (property instanceof ComboProp) {
                        List comboItems = ((ComboProp)property).getComboItems();
                        parameter.setCustomParam("comboItems", (Object)SerializationUtils.toJsonString((Object)comboItems));
                        parameter.setCustomParam("enums", (Object)currentRow.getString(RIGHT_ENUM_ID));
                    }
                }
                leftOrRight = RIGHT;
            }
            parameter.setCustomParam("entityNum", (Object)entityRelationBo.getEntityNumber());
            parameter.setCustomParam("entityAlias", (Object)entityRelationBo.getEntityAlias());
            String mainEntityAlias = (String)this.getView().getFormShowParameter().getCustomParam("mainEntityAlias");
            parameter.setCustomParam("entityType", (Object)(mainEntityAlias == null || mainEntityAlias.equals(entityRelationBo.getEntityAlias()) ? "main" : "sub"));
            parameter.setCustomParam("joinEntityNum", (Object)entityRelationBo.getJoinEntityNumber());
            parameter.setCustomParam("joinEntityAlias", (Object)entityRelationBo.getJoinEntityAlias());
            parameter.setCustomParam("joinEntityType", (Object)"sub");
            parameter.setCustomParam("otherParentAlias", (Object)otherParentAlias);
            parameter.setCustomParam("otherFieldType", (Object)otherFieldType);
            parameter.setCustomParam("leftOrRight", (Object)leftOrRight);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectFields"));
            this.getView().showForm(parameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"ok")) {
            for (DynamicObject row : this.getModel().getEntryEntity(ENTRY)) {
                String left = row.getString(LEFT);
                String right = row.getString(RIGHT);
                if (!HRStringUtils.isEmpty((String)left) && !HRStringUtils.isEmpty((String)right)) continue;
                return;
            }
            if (!this.validateData()) {
                args.setCancel(true);
                return;
            }
            EntityRelationCommonBo entityRelationBo = this.getEntityRelationBo();
            if (entityRelationBo == null) {
                entityRelationBo = new EntityRelationCommonBo();
            }
            String joinType = (String)this.getModel().getValue(JOIN_TYPE);
            entityRelationBo.setJoinType(joinType);
            ArrayList conditions = Lists.newArrayListWithCapacity((int)10);
            DynamicObjectCollection conditionEntry = this.getModel().getEntryEntity(ENTRY);
            for (DynamicObject conditionDy : conditionEntry) {
                JoinConditionBo row = new JoinConditionBo();
                row.setLeftDisplayName(conditionDy.getString(LEFT));
                String leftAlias = conditionDy.getString(LEFT_ALIAS);
                row.setLeftProp(leftAlias);
                String condition = conditionDy.getString(CONDITION);
                row.setCompareType(condition);
                String rightType = conditionDy.getString(RIGHT_TYPE);
                row.setRightPropType(rightType);
                row.setRightDisplayName(conditionDy.getString(RIGHT));
                if (HRStringUtils.equals((String)rightType, (String)"field")) {
                    row.setRightProp(conditionDy.getString(RIGHT_ALIAS));
                } else if (leftAlias.endsWith(".id")) {
                    row.setRightPropVal(conditionDy.getString(RIGHT_BASE_DATA_ID));
                } else if (HRStringUtils.isNotEmpty((String)conditionDy.getString(RIGHT_ENUM_ID))) {
                    row.setRightPropVal(conditionDy.getString(RIGHT_ENUM_ID));
                } else {
                    row.setRightPropVal(conditionDy.getString(RIGHT));
                }
                conditions.add(row);
            }
            entityRelationBo.setConditions((List)conditions);
            String boStr = SerializationUtils.toJsonString((Object)entityRelationBo);
            this.getView().returnDataToParent((Object)boStr);
            this.getView().getFormShowParameter().setCustomParam("relation", (Object)boStr);
            this.closeConfirmStatus = true;
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        super.closedCallBack(evt);
        if (HRStringUtils.equals((String)evt.getActionId(), (String)"selectFields") && (returnData = evt.getReturnData()) != null) {
            Map returnDataMap = (Map)returnData;
            int currentRow = this.getModel().getEntryCurrentRowIndex(ENTRY);
            String entryFieldKey = this.getPageCache().get("entryFieldKey");
            if (HRStringUtils.equals((String)entryFieldKey, (String)LEFT)) {
                this.getModel().setValue(entryFieldKey, returnDataMap.get("displayName"), currentRow);
                this.getModel().setValue(LEFT_VAL_TYPE, returnDataMap.get("valueType"), currentRow);
                this.getModel().setValue(LEFT_ALIAS, returnDataMap.get("fieldAlias"), currentRow);
                this.getModel().setValue(LEFT_PARENT_ALIAS, returnDataMap.get("entityAlias"), currentRow);
            } else {
                this.getModel().setValue(RIGHT, returnDataMap.get("displayName"), currentRow);
                this.getModel().setValue(RIGHT_BASE_DATA_ID, returnDataMap.get("baseDataIds"), currentRow);
                this.getModel().setValue(RIGHT_ENUM_ID, returnDataMap.get("enums"), currentRow);
                String rightType = (String)returnDataMap.get("rightType");
                if (HRStringUtils.equals((String)rightType, (String)"field")) {
                    this.getModel().setValue(RIGHT_VAL_TYPE, returnDataMap.get("valueType"), currentRow);
                    this.getModel().setValue(RIGHT_ALIAS, returnDataMap.get("fieldAlias"), currentRow);
                    this.getModel().setValue(RIGHT_PARENT_ALIAS, returnDataMap.get("entityAlias"), currentRow);
                } else {
                    this.getModel().setValue(RIGHT_PARENT_ALIAS, null, currentRow);
                }
                this.getModel().setValue(RIGHT_TYPE, (Object)rightType, currentRow);
            }
        }
    }

    private boolean validateData() {
        DynamicObjectCollection conditionEntry = this.getModel().getEntryEntity(ENTRY);
        if (conditionEntry.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5173\u8054\u6761\u4ef6\u3002", (String)"SetEntityRelationPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean noneMatchFieldEqualField = conditionEntry.stream().noneMatch(cdt -> HRStringUtils.equals((String)cdt.getString(CONDITION), (String)"=") && HRStringUtils.equals((String)"field", (String)cdt.getString(RIGHT_TYPE)));
        if (noneMatchFieldEqualField) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5173\u8054\u6761\u4ef6\u4e2d\uff0c\u5fc5\u987b\u6709\u5b57\u6bb5\u7b49\u4e8e\u5b57\u6bb5\u3002", (String)"SetEntityRelationPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean hasFieldInOrNotIn = conditionEntry.stream().anyMatch(cdt -> (HRStringUtils.equals((String)cdt.getString(CONDITION), (String)"in") || HRStringUtils.equals((String)cdt.getString(CONDITION), (String)"not in")) && HRStringUtils.equals((String)"field", (String)cdt.getString(RIGHT_TYPE)));
        if (hasFieldInOrNotIn) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0e\u5b57\u6bb5\u4e4b\u95f4\u4e0d\u80fd\u4f7f\u7528\u5728...\u4e2d\u6216\u4e0d\u5728...\u4e2d\u7684\u6761\u4ef6\u3002", (String)"SetEntityRelationPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean hasFieldNotEqualField = conditionEntry.stream().anyMatch(cdt -> HRStringUtils.equals((String)cdt.getString(CONDITION), (String)"!=") && HRStringUtils.equals((String)"field", (String)cdt.getString(RIGHT_TYPE)));
        if (hasFieldNotEqualField) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u4e0e\u5b57\u6bb5\u4e4b\u95f4\u4e0d\u80fd\u4f7f\u7528\u4e0d\u7b49\u4e8e\u6761\u4ef6\u3002", (String)"SetEntityRelationPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private EntityRelationCommonBo getEntityRelationBo() {
        String relationStr = (String)this.getView().getFormShowParameter().getCustomParam("relation");
        EntityRelationCommonBo entityRelationBo = null;
        if (HRStringUtils.isNotEmpty((String)relationStr)) {
            entityRelationBo = (EntityRelationCommonBo)SerializationUtils.fromJsonString((String)relationStr, EntityRelationCommonBo.class);
        }
        return entityRelationBo;
    }

    private void setUnChooseStyle(String flexNum) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        HashMap s = Maps.newHashMapWithExpectedSize((int)1);
        HashMap b = Maps.newHashMapWithExpectedSize((int)4);
        b.put("r", "1px_solid_#e5e5e5");
        b.put("l", "1px_solid_#e5e5e5");
        b.put("t", "1px_solid_#e5e5e5");
        b.put("b", "1px_solid_#e5e5e5");
        s.put("b", b);
        map.put("s", s);
        this.getView().updateControlMetadata(flexNum, (Map)map);
    }

    private void setChooseStyle(String flexNum) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        HashMap s = Maps.newHashMapWithExpectedSize((int)1);
        HashMap b = Maps.newHashMapWithExpectedSize((int)4);
        String color = "themeColor";
        b.put("r", "1px_solid_" + color);
        b.put("l", "1px_solid_" + color);
        b.put("t", "1px_solid_" + color);
        b.put("b", "1px_solid_" + color);
        s.put("b", b);
        map.put("s", s);
        this.getView().updateControlMetadata(flexNum, (Map)map);
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    protected List<String> getUnCheckFields() {
        List<String> unCheckFields = super.getUnCheckFields();
        unCheckFields.add(LEFT_ALIAS);
        unCheckFields.add(LEFT_VAL_TYPE);
        unCheckFields.add(RIGHT_TYPE);
        unCheckFields.add(RIGHT_ALIAS);
        unCheckFields.add(RIGHT_VAL_TYPE);
        return unCheckFields;
    }
}

