/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multiexpt;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.hr.form.operate.helper.MultiSheetOperateHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.dto.ImportPermissionParam;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.mservice.ImportPermissionService;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;

public class MultiSheetSelectExportTempPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final String HR_HBP_FORMPLUGIN = "hrmp-hbp-formplugin";
    private ImportPermissionService importPermissionService = new ImportPermissionService();

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "newtemplate"});
        BillList list = (BillList)this.getControl("billlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        String billFormId;
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parent = this.getView().getViewNoPlugin(parentPageId);
        if (parent instanceof IListView && !StringUtils.isBlank((CharSequence)(billFormId = ((IListView)parent).getListModel().getDataEntityType().getName()))) {
            BillList list = (BillList)this.getControl("billlistap");
            if (MetadataServiceHelper.getDataEntityType((String)billFormId) instanceof QueryEntityType) {
                billFormId = ((QueryEntityType)MetadataServiceHelper.getDataEntityType((String)billFormId)).getEntityName();
            }
            FilterParameter filterParameter = new FilterParameter();
            QFilter qfilter = MultiSheetOperateHelper.constructTemplateQfilter((String)((String)this.getView().getFormShowParameter().getCustomParam("TemplateType")), (String)billFormId);
            filterParameter.setFilter(qfilter);
            list.setQueryFilterParameter(filterParameter);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String operateKey = ((Control)evt.getSource()).getKey();
        if ("btnok".equalsIgnoreCase(operateKey)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            Object[] templates = billList.getSelectedRows().getPrimaryKeyValues();
            if (templates.length == 0) {
                return;
            }
            String errMsg = "";
            if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                this.getView().showErrorNotification(errMsg);
                evt.setCancel(true);
            }
        }
    }

    public void click(EventObject evt) {
        String operateKey;
        FormShowParameter currShowParameter = this.getView().getFormShowParameter();
        OperationResult result = new OperationResult();
        String orgIdsStr = (String)currShowParameter.getCustomParam("MainOrgIds");
        ImportPermissionParam.Buidler importPermissionParamBuidler = new ImportPermissionParam.Buidler().setBizAppId((String)currShowParameter.getCustomParam("CheckRightAppId")).setMainOrgIds(StringUtils.isNotBlank((CharSequence)orgIdsStr) ? JSONObject.parseArray((String)orgIdsStr, Long.class) : new ArrayList(0)).setRealEntityId((String)currShowParameter.getCustomParam("RealPermissionEntityId")).setCurrentEntityId((String)currShowParameter.getCustomParam("BillFormId")).setOperateName((String)currShowParameter.getCustomParam("OperateName")).setPermissionItemId((String)currShowParameter.getCustomParam("PermissionItemId")).setResult(result);
        switch (operateKey = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                if (!this.importPermissionService.validatePermission(importPermissionParamBuidler.build())) {
                    this.importPermissionService.doFailCheckRight(this.getView(), result);
                    return;
                }
                String parentPageId = this.getView().getFormShowParameter().getParentPageId();
                IFormView parent = this.getView().getViewNoPlugin(parentPageId);
                if (!(parent instanceof IListView)) break;
                BillList billList = (BillList)this.getView().getControl("billlistap");
                Object[] templates = billList.getSelectedRows().getPrimaryKeyValues();
                if (templates != null && templates.length != 0) {
                    this.getView().returnDataToParent((Object)templates);
                    this.getView().close();
                    break;
                }
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"MultiSheetSelectExportTempPlugin_0", (String)HR_HBP_FORMPLUGIN, (Object[])new Object[0]));
                break;
            }
            case "newtemplate": {
                if (!this.importPermissionService.validatePermission(importPermissionParamBuidler.build())) {
                    this.importPermissionService.doFailCheckRight(this.getView(), result);
                    return;
                }
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("hrcs_multientityimptmpl");
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("bindEntityId", (Object)this.getPageCache().get("bindEntityId"));
                parameter.setCustomParam("templatetype", this.getView().getFormShowParameter().getCustomParam("TemplateType"));
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newtemplate"));
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if ("name".equals(hyperLinkClickEvent.getFieldName())) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(billList.getEntityId());
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setPkId(billList.getFocusRowPkId());
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "multisheetviewtemplate"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList list = (BillList)this.getControl("billlistap");
        list.refreshData();
    }
}

