/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multimport;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;

public class HRMultiEntityCallOp {
    private static final Log LOG = LogFactory.getLog(HRMultiEntityCallOp.class);

    public static void callOpSave(Map<String, ImportLogger> importLoggerMap, Function<OperationServiceImpl, List<OperationResult>> func, List<MultiEntityRowData> rowDataList) {
        DynamicObject[] opEntityArr = HRMultiEntityCallOp.convertDy(rowDataList);
        if (opEntityArr.length == 0) {
            return;
        }
        OperationResult localOperationResult = new OperationResult();
        ArrayList pkList = Lists.newArrayList();
        try {
            OperationServiceImpl opImpl = new OperationServiceImpl();
            List<OperationResult> operationResultList = func.apply(opImpl);
            LOG.info("callOpSave--OperationResult:{}", (Object)operationResultList.toString());
            operationResultList.stream().forEach(operationResult -> {
                pkList.addAll(operationResult.getSuccessPkIds());
                HRMultiEntityCallOp.logOpFaileInfo(operationResult, importLoggerMap, rowDataList);
            });
            HRMultiEntityCallOp.logOpSuccessInfo(pkList, importLoggerMap, rowDataList);
        }
        catch (Exception runtimeException) {
            LOG.error((Throwable)runtimeException);
            HRMultiEntityCallOp.logOpFaileInfo(runtimeException.getMessage(), importLoggerMap, rowDataList);
            localOperationResult.setSuccess(false);
            rowDataList.clear();
        }
    }

    private static DynamicObject[] convertDy(List<MultiEntityRowData> rowDataList) {
        return (DynamicObject[])rowDataList.stream().filter(rowData -> Objects.nonNull(rowData.getOpEntity())).map(MultiEntityRowData::getOpEntity).toArray(DynamicObject[]::new);
    }

    private static void logOpFaileInfo(OperationResult op, Map<String, ImportLogger> importLoggerMap, List<MultiEntityRowData> rowDataList) {
        List operateInfos = op.getAllErrorOrValidateInfo();
        for (IOperateInfo info : operateInfos) {
            String pkId = String.valueOf(info.getPkValue());
            MultiEntityRowData mulRowData = rowDataList.stream().filter(rowData -> HRStringUtils.equals((String)rowData.getOpEntity().getString("id"), (String)pkId)).findFirst().orElse(null);
            ImportLogger importLogger = importLoggerMap.get(mulRowData.getMainEntity());
            importLogger.log(mulRowData.getRownum(), String.join((CharSequence)",", info.getMessage()));
        }
    }

    private static void logOpSuccessInfo(List<Object> pkList, Map<String, ImportLogger> importLoggerMap, List<MultiEntityRowData> rowDataList) {
        if (CollectionUtil.isNotEmpty(pkList)) {
            int size = pkList.size();
            for (int i = 0; i < size; ++i) {
                long pkId = (Long)pkList.get(i);
                rowDataList.stream().filter(rowData -> HRStringUtils.equals((String)rowData.getOpEntity().getString("id"), (String)String.valueOf(pkId))).findAny().ifPresent(rowData -> {
                    ImportBillData row = rowData.getBillData();
                    int startindex = row.getStartIndex();
                    int endindex = row.getEndIndex();
                    ImportLogger importLogger = (ImportLogger)importLoggerMap.get(rowData.getMainEntity());
                    long count = importLogger.getDelRows().stream().filter(ints -> ints[0] == startindex && ints[1] == endindex).count();
                    if (count == 0L) {
                        importLogger.getDelRows().add(new int[]{endindex, endindex});
                    }
                });
            }
        }
    }

    private static void logOpFaileInfo(String message, Map<String, ImportLogger> importLoggerMap, List<MultiEntityRowData> rowDataList) {
        rowDataList.forEach(rowData -> {
            ImportLogger importLogger = (ImportLogger)importLoggerMap.get(rowData.getMainEntity());
            importLogger.log(rowData.getRownum(), ResManager.loadKDString((String)"\u6570\u636e\u5e93\u4fdd\u5b58\u6570\u636e\u5f02\u5e38\u3002", (String)"HRBatchImportPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        });
        if (LOG.isInfoEnabled()) {
            LOG.info(message);
        }
    }
}

