/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multimport;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class HRMultiEntityFeedBackProgress {
    private static final Log LOG = LogFactory.getLog(HRMultiEntityFeedBackProgress.class);

    public static void feedbackProgressError(ImportContext conf, Map<String, ImportLogger> importLoggerMap, List<ImportBillData> rowdatas) {
        for (ImportBillData bill : rowdatas) {
            if (bill.getData().containsKey((Object)"errCode")) continue;
            String entityName = (String)((JSONObject)bill.getData().get((Object)"data")).keySet().iterator().next();
            ImportLogger importLogger = importLoggerMap.get(entityName);
            Integer rownum = bill.getStartRowIndex();
            importLogger.log(rownum, ResManager.loadKDString((String)"\u6a21\u677f\u6570\u636e\u6821\u9a8c\u5f02\u5e38", (String)"HRBatchImportPlugin_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
        HRMultiEntityFeedBackProgress.feedbackProgressDealWith(conf, importLoggerMap);
    }

    private static int generateRandom(int maximumValue) {
        SecureRandom ranGen = new SecureRandom();
        return ranGen.nextInt(maximumValue);
    }

    public static void feedbackProgressDealWith(ImportContext conf, Map<String, ImportLogger> importLoggerMap) {
        int failNum = 0;
        int total = 0;
        HashMap logCache = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry<String, ImportLogger> entry : importLoggerMap.entrySet()) {
            ImportLogger logger = entry.getValue();
            failNum += logger.getLogCache().size();
            logCache.putAll(logger.getLogCache());
            if (!LOG.isInfoEnabled()) continue;
            LOG.info(String.format(Locale.ROOT, "----import %s --batch", logger.getSrcFile()));
        }
        for (String url : conf.getAllUrls()) {
            ImportLogger logger = conf.getLogger(url);
            total += logger.getTotal();
            logger.setFailed(failNum);
            logger.getLogCache().putAll(logCache);
        }
        conf.feedbackProgress(HRMultiEntityFeedBackProgress.generateRandom(100), total, failNum);
        LOG.info(String.format(Locale.ROOT, "--batch--succeed=%d--failed=%d", total - failNum, total));
    }
}

