/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multimport;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.formplugin.web.imp.BasedataContianer;
import kd.hr.hbp.formplugin.web.imp.MultiEntityRowData;
import kd.hr.hbp.formplugin.web.multimport.HRMultiEntityCallOp;
import kd.hr.hbp.formplugin.web.multimport.HRMultiEntityConvertToDy;
import kd.hr.hbp.formplugin.web.multimport.HRMultiEntityFeedBackProgress;
import kd.hr.hbp.formplugin.web.multimport.HRMultiEntityFileParse;
import kd.hr.hbp.formplugin.web.multimport.HRMultiEntityQueryBaseData;
import kd.hr.hbp.formplugin.web.multimport.HRMultiEntityResolveData;
import kd.hr.hbp.formplugin.web.multimport.HRMultiEntityUpdate;
import kd.hr.hbp.formplugin.web.multimport.MultiEntityImportFailedSheetHandler;
import kd.hr.hbp.formplugin.web.multimpt.wrapper.ImportBillDataWrapper;
import kd.hr.hbp.formplugin.web.multisheet.helper.MultiSheetInvoker;
import org.apache.commons.lang3.StringUtils;

public class HRMultipleEntitiesImportPlugin
extends BatchImportPlugin {
    private static final Log LOG = LogFactory.getLog(HRMultipleEntitiesImportPlugin.class);
    private static final String DEFAULT_SAVE = "save";
    private static final int BATCH_POLL_SIZE = 1000;
    private static final int BATCH_POLL_QUEUE_TIMEOUT = 20;
    private List<MultiEntityRowData> rowDataList = Lists.newArrayListWithExpectedSize((int)16);
    private List<MultiEntityRowData> rowErrDataList = Lists.newArrayListWithExpectedSize((int)16);
    private List<MultiEntityRowData> rowOpErrDataList = Lists.newArrayListWithExpectedSize((int)16);
    private BasedataContianer contianer = new BasedataContianer();
    private Map<String, ImportLogger> importLoggerMap = Maps.newHashMap();
    private Map<String, Set<String>> entityUniqueMap = Maps.newHashMap();
    private Map<String, String> entityQueryFieldMap = Maps.newHashMap();
    private HashMap<String, String> sheetNameMap = Maps.newHashMap();

    protected static boolean validateBaseDataRef(Map<String, Object> map) {
        return true;
    }

    protected void resolveExcel() {
        LOG.info("HRMultipleEntitiesImportPlugin--begin to resolveExcel");
        String maxCount = System.getProperty("hr.hrmp.hbp.multisheetexport");
        if (StringUtils.isNotBlank((CharSequence)maxCount)) {
            this.ctx.setBatchEntryRowSize(Integer.parseInt(maxCount));
        }
        HRMultiEntityFileParse.resolveExcel(this.ctx, this.importLoggerMap);
    }

    protected void importData() throws Throwable {
        LOG.info("HRMultipleEntitiesImportPlugin--begin to importData");
        this.importData(this.ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importData(ImportContext conf) {
        try {
            for (String url : conf.getAllUrls()) {
                LinkedBlockingQueue dataQ = conf.getDataQueue(url);
                ArrayList delRows = new ArrayList();
                ImportLogger importLogger = conf.getLogger(url);
                importLogger.setDelRows(delRows);
                this.fecthBacthQueenData(conf, url, dataQ);
            }
        }
        finally {
            HashMap<String, Object> retdata = new HashMap<String, Object>();
            retdata.put("complete", Boolean.TRUE);
            retdata.put("info", this.ctx.getUrlLoggers());
            int total = 0;
            int failed = 0;
            for (String url : this.ctx.getAllUrls()) {
                ImportLogger logger = this.ctx.getLogger(url);
                total += logger.getTotal();
                failed += logger.getFailed();
                if (logger.getFailed() <= 0 && logger.getRowIndex() >= logger.getLastRowIndex() - 1) continue;
                this.outputFailedForData(url, logger);
            }
            ImportLogHelper.logAll((Object)this.ctx.getLogId(), (String)JSON.toJSONString(retdata), (int)total, (int)failed);
            this.ctx.feedbackProgress(100, null, null);
        }
    }

    private void fecthBacthQueenData(ImportContext conf, String url, LinkedBlockingQueue<ImportBillData> dataQ) {
        int timeout = 0;
        while (!conf.isResolveComplete(url) || !dataQ.isEmpty()) {
            if (timeout > 5) {
                LOG.info("fecthBacthQueenData--dataQ.poll more than 5 times");
                break;
            }
            ArrayList<ImportBillData> rowDatas = new ArrayList<ImportBillData>();
            try {
                int pollSize = dataQ.size() > 1000 ? 1000 : dataQ.size();
                Queues.drain(dataQ, rowDatas, (int)pollSize, (long)20L, (TimeUnit)TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                LOG.info("{}...read from queue null,count:{}", (Object)conf.getBillFormId(), (Object)(++timeout));
                continue;
            }
            rowDatas.removeAll(Collections.singleton(null));
            timeout = 0;
            if (rowDatas.size() <= 0) continue;
            LOG.info("fecthBacthQueenData--dataQ.poll,size:{}", (Object)rowDatas.size());
            this.importBatchData(rowDatas, conf.getOption());
        }
    }

    private void outputFailedForData(String url, ImportLogger importLogger) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        try {
            new ExcelReader().read(service.getInputStream(url), (SheetHandler)new MultiEntityImportFailedSheetHandler(this.ctx, importLogger, service, this.importLoggerMap, this.isDistributeFullData()));
        }
        catch (Exception e) {
            LOG.error("HRMultipleEntitiesImportPlugin--outputFailedForData error,", (Throwable)e);
            importLogger.log(Integer.valueOf(0), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importBatchData(List<ImportBillData> rowDatas, Map<String, Object> option) {
        try {
            JSONObject lastData = rowDatas.get(rowDatas.size() - 1).getData();
            if (lastData.containsKey((Object)"errCode")) {
                LOG.error("HRMultipleEntitiesImportPlugin--importBatchData error:{}", (Object)lastData.toJSONString());
                throw new KDBizException((String)lastData.get((Object)"errCode"));
            }
            String optionCode = (String)option.get("importtype");
            this.wrapOriginalJson(rowDatas, this.importLoggerMap, optionCode);
            switch (optionCode) {
                case "new": {
                    this.addBatchQueenData(rowDatas, optionCode);
                    return;
                }
                case "override": 
                case "overridenew": {
                    this.updateBatchQueenData(rowDatas, optionCode);
                    return;
                }
            }
            return;
        }
        catch (RuntimeException kdBizException) {
            HRMultiEntityFeedBackProgress.feedbackProgressError(this.ctx, this.importLoggerMap, rowDatas);
            LOG.error("HRMultipleEntitiesImportPlugin--importBatchData error:", (Throwable)kdBizException);
            return;
        }
        finally {
            HRMultiEntityFeedBackProgress.feedbackProgressDealWith(this.ctx, this.importLoggerMap);
            this.dealImportLog(rowDatas);
        }
    }

    private void dealImportLog(List<ImportBillData> rowdatas) {
        for (ImportBillData bill : rowdatas) {
            if (bill.getData().containsKey((Object)"errCode")) continue;
            this.sheetNameMap.put((String)((JSONObject)bill.getData().get((Object)"data")).keySet().iterator().next(), bill.getData().get((Object)"sheetName").toString());
        }
        ArrayList logCache = Lists.newArrayListWithCapacity((int)this.importLoggerMap.size());
        StringBuilder logMsg = new StringBuilder();
        this.importLoggerMap.forEach((key, value) -> {
            if (StringUtils.isNotBlank((CharSequence)this.sheetNameMap.get(key))) {
                logMsg.append("[").append(this.sheetNameMap.get(key)).append("] ").append(System.lineSeparator()).append(value.toString().replace(System.lineSeparator() + "\t", "")).append(System.lineSeparator());
            }
        });
        logCache.add(new ImportLogger.ImportLog(logMsg.toString()));
        for (String url : this.ctx.getAllUrls()) {
            ImportLogger logger = this.ctx.getLogger(url);
            logger.getLogCache().clear();
            logger.getLogCache().put(-1, logCache);
        }
    }

    private void addBatchQueenData(List<ImportBillData> rowData, String optionCode) {
        LOG.info("addBatchQueenData--rowData size:{}", (Object)rowData.size());
        HRMultiEntityResolveData.resolveRowData(rowData, this.importLoggerMap, optionCode, this.contianer, this.rowDataList, this.entityUniqueMap, this.entityQueryFieldMap);
        this.rowErrDataList.clear();
        this.rowErrDataList.addAll(this.rowDataList);
        HRMultiEntityConvertToDy.convertExcelRowDataToDynamicObjs(this.importLoggerMap, this.rowDataList);
        HRMultiEntityQueryBaseData.queryBaseDataRef(this.contianer);
        HRMultiEntityQueryBaseData.setDynamicObjValues(this.importLoggerMap, this.rowDataList, this.contianer, HRMultipleEntitiesImportPlugin::validateBaseDataRef);
        this.extendProcessRowData(this.importLoggerMap, optionCode, this.rowDataList);
        this.removeCheckErrorDynamicObjs(this.importLoggerMap);
        this.rowErrDataList.removeAll(this.rowDataList);
        this.getValidateErrDataList();
        this.removeCheckErrorDynamicObjs(this.importLoggerMap);
        this.rowOpErrDataList.clear();
        this.rowOpErrDataList.addAll(this.rowDataList);
        this.invalidBillBeforeSave(this.rowDataList, this.importLoggerMap);
        HRMultiEntityCallOp.callOpSave(this.importLoggerMap, opService -> {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("import", "1");
            Map<String, List<DynamicObject>> callOpSaveMap = this.callOpSave(this.rowDataList);
            Map<String, String> opNameMap = this.initOpName(callOpSaveMap);
            return callOpSaveMap.entrySet().stream().filter(entry -> !CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))).map(entry -> OperationServiceHelper.executeOperate((String)((String)opNameMap.get(entry.getKey())), (String)((String)entry.getKey()), (DynamicObject[])((List)entry.getValue()).toArray(new DynamicObject[0]), (OperateOption)operateOption)).collect(Collectors.toList());
        }, this.rowDataList);
        this.rowOpErrDataList.removeAll(this.rowDataList);
        this.getOpErrDataList();
    }

    private void invalidBillBeforeSave(List<MultiEntityRowData> rowDataList, Map<String, ImportLogger> importLoggerMap) {
        ArrayList errRowDataList = Lists.newArrayListWithCapacity((int)rowDataList.size());
        Map<String, List<MultiEntityRowData>> groupData = rowDataList.stream().collect(Collectors.groupingBy(MultiEntityRowData::getMainEntity));
        for (Map.Entry<String, List<MultiEntityRowData>> entry : groupData.entrySet()) {
            MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)entry.getKey());
            List mustInputFields = mainEntity.getProperties().stream().filter(object -> {
                if (object instanceof FieldProp && !object.getName().equals("ctrlstrategy")) {
                    return ((FieldProp)object).isMustInput();
                }
                if (object instanceof BasedataProp) {
                    return ((BasedataProp)object).isMustInput();
                }
                if (object instanceof EntryProp) {
                    return ((EntryProp)object).isEntryMustInput();
                }
                return false;
            }).collect(Collectors.toList());
            ImportLogger importLogger = importLoggerMap.get(entry.getKey());
            List<MultiEntityRowData> rowDataListTemp = entry.getValue();
            rowDataListTemp.forEach(rowData -> {
                StringBuilder errRowDisplayNames = new StringBuilder();
                mustInputFields.forEach(object -> {
                    if (!rowData.getEntityJson().get(entry.getKey()).containsKey((Object)object.getName())) {
                        errRowDisplayNames.append(object.getDisplayName().getLocaleValue()).append(',');
                        errRowDataList.add(rowData);
                    }
                });
                if (errRowDisplayNames.length() != 0) {
                    String errMsg = errRowDisplayNames.toString();
                    if (errMsg.endsWith(",")) {
                        errMsg = errRowDisplayNames.substring(0, errRowDisplayNames.length() - 1);
                    }
                    importLogger.log(rowData.getRownum(), String.format(ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a%s\u3002", (String)"HRMultipleEntitiesImportPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), errMsg));
                }
            });
            rowDataList.removeAll(errRowDataList);
        }
    }

    private void updateBatchQueenData(List<ImportBillData> rowData, String optionCode) throws KDBizException {
        LOG.info("updateBatchQueenData--rowData size:{}", (Object)rowData.size());
        HRMultiEntityResolveData.resolveRowData(rowData, this.importLoggerMap, optionCode, this.contianer, this.rowDataList, this.entityUniqueMap, this.entityQueryFieldMap);
        this.rowErrDataList.clear();
        this.rowErrDataList.addAll(this.rowDataList);
        HRMultiEntityConvertToDy.convertExcelRowDataToDynamicObjs(this.importLoggerMap, this.rowDataList);
        List<MultiEntityRowData> duplicateErrorData = this.removeDuplicateUpdateData();
        HashSet<Object> updateIds = new HashSet<Object>();
        HRMultiEntityUpdate.queryBatchExistsRowDynamicObj(this.rowDataList, this.entityQueryFieldMap, optionCode, updateIds);
        HRMultiEntityQueryBaseData.queryBaseDataRef(this.contianer);
        HRMultiEntityQueryBaseData.setDynamicObjValues(this.importLoggerMap, this.rowDataList, this.contianer, HRMultipleEntitiesImportPlugin::validateBaseDataRef);
        this.extendProcessRowData(this.importLoggerMap, optionCode, this.rowDataList);
        this.removeCheckErrorDynamicObjs(this.importLoggerMap);
        this.rowErrDataList.removeAll(this.rowDataList);
        this.rowErrDataList.addAll(duplicateErrorData);
        this.getValidateErrDataList();
        this.removeCheckErrorDynamicObjs(this.importLoggerMap);
        this.rowOpErrDataList.clear();
        this.rowOpErrDataList.addAll(this.rowDataList);
        HRMultiEntityCallOp.callOpSave(this.importLoggerMap, opService -> {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("import", "1");
            Map<String, List<DynamicObject>> callOpSaveMap = this.callOpSave(this.rowDataList);
            Map<String, String> opNameMap = this.initOpName(callOpSaveMap);
            return callOpSaveMap.entrySet().stream().filter(entry -> !CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))).map(entry -> {
                OperationResult operationResult = opService.localInvokeOperation((String)opNameMap.get(entry.getKey()), (DynamicObject[])((List)entry.getValue()).stream().filter(dy -> updateIds.contains(dy.getPkValue())).toArray(DynamicObject[]::new), operateOption);
                if (operationResult.isSuccess()) {
                    operationResult = opService.localInvokeOperation((String)opNameMap.get(entry.getKey()), (DynamicObject[])((List)entry.getValue()).stream().filter(dy -> !updateIds.contains(dy.getPkValue())).toArray(DynamicObject[]::new), operateOption);
                }
                return operationResult;
            }).collect(Collectors.toList());
        }, this.rowDataList);
        this.rowOpErrDataList.removeAll(this.rowDataList);
        this.getOpErrDataList();
    }

    private void removeCheckErrorDynamicObjs(Map<String, ImportLogger> importLoggerMap) {
        Iterator<MultiEntityRowData> iterator = this.rowDataList.iterator();
        while (iterator.hasNext()) {
            MultiEntityRowData rowData = iterator.next();
            ImportLogger importLogger = importLoggerMap.get(rowData.getMainEntity());
            Set checkFaileRows = importLogger.getLogCache().keySet();
            if (!checkFaileRows.contains(rowData.getRownum())) continue;
            iterator.remove();
        }
    }

    private Map<String, List<DynamicObject>> callOpSave(List<MultiEntityRowData> rowDataList) {
        HashMap callOpSaveMap = Maps.newHashMapWithExpectedSize((int)rowDataList.size());
        rowDataList.forEach(rowData -> {
            String entityName = rowData.getMainEntity();
            if (callOpSaveMap.containsKey(entityName)) {
                ArrayList<DynamicObject> tempEntities = new ArrayList<DynamicObject>();
                tempEntities.addAll((Collection)callOpSaveMap.get(entityName));
                tempEntities.add(rowData.getOpEntity());
                callOpSaveMap.put(entityName, tempEntities);
            } else {
                callOpSaveMap.put(entityName, Collections.singletonList(rowData.getOpEntity()));
            }
        });
        return callOpSaveMap;
    }

    private Map<String, String> initOpName(Map<String, List<DynamicObject>> callOpSaveMap) {
        HashMap opNameMap = Maps.newHashMapWithExpectedSize((int)callOpSaveMap.size());
        callOpSaveMap.keySet().forEach(entityName -> opNameMap.put(entityName, DEFAULT_SAVE));
        this.customOpName(opNameMap);
        return opNameMap;
    }

    public void customOpName(Map<String, String> opNameMap) {
        MultiSheetInvoker.invoker(this.ctx.getAppId(), this.ctx.getBillFormId(), "customOpName", opNameMap);
    }

    public void wrapOriginalJson(List<ImportBillData> rowdatas, Map<String, ImportLogger> importLoggerMap, String optionCode) {
        ArrayList importBillDataWrapperList = Lists.newArrayListWithExpectedSize((int)rowdatas.size());
        rowdatas.forEach(importBillData -> {
            ImportBillDataWrapper importBillDataWrapper = new ImportBillDataWrapper(importBillData.getData(), importBillData.getStartIndex(), importBillData.getEndIndex(), importBillData.getEntityMapping());
            importBillDataWrapper.setEmptyRowNum(importBillData.getEmptyRowNum());
            importBillDataWrapper.setDataIndex(importBillData.getDataIndex());
            importBillDataWrapper.setStartRowIndex(importBillData.getStartRowIndex());
            importBillDataWrapperList.add(importBillDataWrapper);
        });
        MultiSheetInvoker.invoker(this.ctx.getAppId(), this.ctx.getBillFormId(), "wrapOriginalJson", importBillDataWrapperList, importLoggerMap, optionCode);
        rowdatas.clear();
        importBillDataWrapperList.forEach(importBillDataWrapper -> {
            ImportBillData importBillData = new ImportBillData(importBillDataWrapper.getData(), importBillDataWrapper.getStartIndex(), importBillDataWrapper.getEndIndex(), importBillDataWrapper.getEntityMapping());
            importBillData.setEmptyRowNum(importBillDataWrapper.getEmptyRowNum());
            importBillData.setDataIndex(importBillDataWrapper.getDataIndex());
            importBillData.setStartRowIndex(importBillDataWrapper.getStartRowIndex());
            rowdatas.add(importBillData);
        });
    }

    public void extendProcessRowData(Map<String, ImportLogger> importLoggerMap, String optionCode, List<MultiEntityRowData> rowDataList) {
        MultiSheetInvoker.invoker(this.ctx.getAppId(), this.ctx.getBillFormId(), "extendProcessRowData", importLoggerMap, optionCode, rowDataList);
    }

    public List<MultiEntityRowData> getValidateErrDataList() {
        MultiSheetInvoker.invoker(this.ctx.getAppId(), this.ctx.getBillFormId(), "getValidateErrDataList", this.rowErrDataList);
        return this.rowErrDataList;
    }

    public List<MultiEntityRowData> getOpErrDataList() {
        MultiSheetInvoker.invoker(this.ctx.getAppId(), this.ctx.getBillFormId(), "getOpErrDataList", this.rowOpErrDataList);
        return this.rowOpErrDataList;
    }

    public boolean isDistributeFullData() {
        Object isDistributeFullData = MultiSheetInvoker.invoker(this.ctx.getAppId(), this.ctx.getBillFormId(), "isDistributeFullData", new Object[0]);
        if (Objects.nonNull(isDistributeFullData)) {
            return (Boolean)isDistributeFullData;
        }
        return false;
    }

    private List<MultiEntityRowData> removeDuplicateUpdateData() {
        ArrayList rowErrorData = Lists.newArrayListWithExpectedSize((int)16);
        Map option = this.ctx.getOption();
        Map sheetDataKeyMap = (Map)option.get("sheetDataUniqueKey");
        if (Objects.isNull(sheetDataKeyMap)) {
            sheetDataKeyMap = Maps.newHashMapWithExpectedSize((int)this.rowDataList.size());
            this.ctx.addOption("sheetDataUniqueKey", (Object)sheetDataKeyMap);
        }
        Iterator<MultiEntityRowData> iterator = this.rowDataList.iterator();
        while (iterator.hasNext()) {
            MultiEntityRowData rowData = iterator.next();
            StringBuilder key = new StringBuilder();
            ArrayList disPlayNames = Lists.newArrayListWithExpectedSize((int)rowData.getKeyfields().size());
            Set dataKeySet = (Set)sheetDataKeyMap.get(rowData.getMainEntity());
            if (Objects.isNull(dataKeySet)) {
                dataKeySet = Sets.newHashSetWithExpectedSize((int)this.rowDataList.size());
                sheetDataKeyMap.put(rowData.getMainEntity(), dataKeySet);
            }
            for (String keyField : rowData.getKeyfields()) {
                DynamicProperty property = ((DynamicObjectType)rowData.getMainEntityDy().getDataEntityType()).getProperty(keyField);
                String disPlayName = Objects.nonNull(property.getDisplayName()) ? property.getDisplayName().getLocaleValue() : property.getName();
                String value = Objects.nonNull(rowData.getEntityJson().get(rowData.getMainEntity()).get((Object)keyField)) ? rowData.getEntityJson().get(rowData.getMainEntity()).get((Object)keyField) : "";
                key.append(disPlayName).append("=").append((Object)value).append(",");
                disPlayNames.add(disPlayName);
            }
            if (dataKeySet.contains(key.toString())) {
                rowErrorData.add(rowData);
                iterator.remove();
                ImportLogger importLogger = this.importLoggerMap.get(rowData.getMainEntity());
                importLogger.log(rowData.getRownum(), MessageFormat.format(ResManager.loadKDString((String)"\u6839\u636e\u6570\u636e\u66ff\u6362\u552f\u4e00\u503c\u5b57\u6bb5\u201c{0}\u201d\uff0cExcel\u4e2d\u5b58\u5728\u591a\u6761\u66f4\u65b0\u6570\u636e\u3002", (String)"HRMultipleEntitiesImportPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), String.join((CharSequence)"+", disPlayNames)));
                continue;
            }
            dataKeySet.add(key.toString());
        }
        return rowErrorData;
    }

    protected void setErrorImportMsg(String sheetName, int rowNum, String errorMsg) {
        ImportLogger importLogger = this.importLoggerMap.get(sheetName);
        if (Objects.nonNull(importLogger)) {
            List importLogs = (List)importLogger.getLogCache().get(rowNum);
            if (Objects.nonNull(importLogs)) {
                for (ImportLogger.ImportLog log : importLogs) {
                    if (!log.msg.equals(errorMsg)) continue;
                    return;
                }
            }
            importLogger.log(Integer.valueOf(rowNum), errorMsg);
        }
    }
}

