/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multimpt;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.LocalDate;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.ext.hr.form.operate.helper.MultiSheetOperateHelper;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.url.UrlService;
import kd.hr.hbp.business.multimpt.MultiSheetListDataExporter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hbp.formplugin.web.multimpt.MultiEntityImportDataPlugin;
import kd.hr.hbp.formplugin.web.multisheet.helper.MultiSheetHelper;
import kd.hr.hbp.formplugin.web.multisheet.helper.MultiSheetInvoker;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;

public class MultiEntityDlImptTmplPlugin
extends HRDynamicFormBasePlugin
implements HyperLinkClickListener {
    private static final Log LOGGER = LogFactory.getLog(MultiEntityImportDataPlugin.class);
    private static final String BILLLISTAP = "billlistap";
    private static final String FIELD_NAME = "name";
    private static final String BTN_OK = "btnok";
    private static final String BTN_NEWTEMPLATE = "newtemplate";
    private static final String PARAM_BINDENTITYID = "BillFormId";
    private static final String FIELD_ATTACHMENTFIELD = "attachmentfield";
    private static final String FIELD_TEMPORARYFIELD = "temporaryfield";
    private static final String FIELD_BASEDATA_ID = "fbasedataid";
    private static final String FIELD_URL = "url";
    private static final String URL_PATH = "path=";
    private static final int NUMBER_SEVEN = 7;
    private final String RES_TEMPLATE_PREFIX = ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f_", (String)"MultiEntityDlImptTmplPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
    private final String RES_TYPE_NOT_SUPPORT = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"MultiEntityDlImptTmplPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
    private final String RES_FULL_TEMPLATE_NOT_EDITABLE = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7f16\u8f91", (String)"MultiEntityDlImptTmplPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
    private final String RES_TEMPLATE_NOT_SELECT = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bfc\u5165\u6a21\u677f", (String)"MultiEntityDlImptTmplPlugin_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
    private final String RES_SAMPLE = ResManager.loadKDString((String)"\u793a\u4f8b", (String)"MultiEntityDlImptTmplPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
    private final String RES_MAX_TEMPLATE = ResManager.loadKDString((String)"\u6bcf\u6b21\u53ea\u80fd\u4e0b\u8f7d%s\u4e2a\u6a21\u677f\u3002", (String)"MultiEntityDlImptTmplPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject evt) {
        this.addClickListeners(new String[]{BTN_OK, BTN_NEWTEMPLATE});
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        super.initialize();
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.addPackageDataListener(pkg -> {
            if (FIELD_TEMPORARYFIELD.equalsIgnoreCase(((AbstractColumnDesc)pkg.getSource()).getKey()) && !pkg.getRowData().getDynamicObjectCollection(FIELD_ATTACHMENTFIELD).isEmpty()) {
                pkg.setFormatValue((Object)this.RES_SAMPLE);
            }
        });
    }

    public void afterCreateNewData(EventObject evt) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BINDENTITYID);
        if (HRStringUtils.isNotEmpty((String)billFormId)) {
            if (MetadataServiceHelper.getDataEntityType((String)billFormId) instanceof QueryEntityType) {
                billFormId = ((QueryEntityType)MetadataServiceHelper.getDataEntityType((String)billFormId)).getEntityName();
            }
            FilterParameter filterParameter = new FilterParameter();
            QFilter qfilter = MultiSheetOperateHelper.constructTemplateQfilter((String)((String)this.getView().getFormShowParameter().getCustomParam("TemplateType")), (String)billFormId);
            filterParameter.setFilter(qfilter);
            list.setQueryFilterParameter(filterParameter);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.downloadTemplate();
                break;
            }
            case "newtemplate": {
                BillList list = (BillList)this.getControl(BILLLISTAP);
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId(list.getEntityId());
                parameter.setCustomParam("bindEntityId", this.getView().getFormShowParameter().getCustomParam(PARAM_BINDENTITYID));
                parameter.setStatus(OperationStatus.ADDNEW);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BTN_NEWTEMPLATE));
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
        }
    }

    private List<ExportWriterFormat> loadExportFormat(String entityNumber, long templateId) {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter(entityNumber, templateId, null, null);
        List formats = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
        return formats;
    }

    private void downloadTemplate() {
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam(PARAM_BINDENTITYID);
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Object[] templates = billList.getSelectedRows().getPrimaryKeyValues();
        int maxDownloadTemplateCount = this.getMaxDownloadTemplateCountProperty();
        if (templates == null || templates.length == 0) {
            this.getView().showTipNotification(this.RES_TEMPLATE_NOT_SELECT);
            return;
        }
        if (templates.length > maxDownloadTemplateCount) {
            this.getView().showMessage(String.format(this.RES_MAX_TEMPLATE, maxDownloadTemplateCount));
            return;
        }
        LocalDate now = LocalDate.now();
        if (HRStringUtils.isNotEmpty((String)billFormId)) {
            for (Object temp : templates) {
                DynamicObject templateData = BusinessDataServiceHelper.loadSingle((Object)temp, (String)"hrcs_multientityimptmpl");
                String fileName = MultiSheetHelper.getExportFileName(now, templateData);
                assert (templateData != null);
                String url = this.uploadImptTmpl(templateData, fileName);
                this.getView().download(url);
            }
        } else {
            this.getView().showMessage(this.RES_TYPE_NOT_SUPPORT);
        }
    }

    private int getMaxDownloadTemplateCountProperty() {
        try {
            return Integer.parseInt(System.getProperty("max.download.template.count", "20"));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn((Throwable)numberFormatException);
            return 20;
        }
    }

    private String uploadImptTmpl(DynamicObject templateData, String fileName) {
        HashMap entityToSheetName = Maps.newHashMapWithExpectedSize((int)16);
        HashMap entityToFieldCol = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject mainEntityTmplDyo = templateData.getDynamicObject("mainentitytmpl");
        String mainBizObjNum = mainEntityTmplDyo.getString("bizobject.number");
        MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)mainBizObjNum);
        List<ExportWriterFormat> formats = this.loadExportFormat(mainBizObjNum, (Long)mainEntityTmplDyo.getPkValue());
        String mainEntitySheetName = mainEntity.getDisplayName().getLocaleValue();
        entityToSheetName.put(mainBizObjNum, mainEntitySheetName);
        MultiSheetListDataExporter exporter = new MultiSheetListDataExporter();
        String tempCode = mainEntityTmplDyo.getString("number") + "#" + templateData.getString("number");
        exporter.addSheet(mainEntitySheetName, formats, false, true, tempCode);
        this.setEntityToFieldCol(entityToFieldCol, exporter, mainBizObjNum, mainEntitySheetName);
        DynamicObjectCollection assocEntityTmplDyoColl = templateData.getDynamicObjectCollection("assocentitytmplentry");
        for (DynamicObject dynamicObject : assocEntityTmplDyoColl) {
            DynamicObject assocEntityTmplDyo = dynamicObject.getDynamicObject("assocentitytmpl");
            Long tmplId = (Long)assocEntityTmplDyo.getPkValue();
            String assocBizObjNum = assocEntityTmplDyo.getString("bizobject.number");
            MainEntityType assocEntityType = EntityMetadataCache.getDataEntityType((String)assocBizObjNum);
            List<ExportWriterFormat> entryFormat = this.loadExportFormat(assocBizObjNum, tmplId);
            String entitySheetName = assocEntityType.getDisplayName().getLocaleValue();
            entityToSheetName.put(assocBizObjNum, entitySheetName);
            exporter.addSheet(entitySheetName, entryFormat, false, false, assocEntityTmplDyo.getString("number"));
            this.setEntityToFieldCol(entityToFieldCol, exporter, assocBizObjNum, entitySheetName);
        }
        try {
            Table result;
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            String appId = (String)MultiSheetInvoker.getDistributeSessionlessCache().get("MulSheet_" + formShowParameter.getCustomParam(PARAM_BINDENTITYID) + RequestContext.get().getCurrUserId());
            if (StringUtils.isBlank((CharSequence)appId)) {
                appId = formShowParameter.getAppId();
            }
            LOGGER.info("MultiSheetInvoker--uploadImptTmpl-appId:{}", (Object)appId);
            String cloudNmuByAppNum = MultiSheetInvoker.getCloudNmuByAppNum(appId);
            if (!this.isKingdeeIsv(appId)) {
                LOGGER.info("MultiSheetInvoker--uploadImptTmpl-2k");
                result = (Table)HRMServiceHelper.invokeService((String)cloudNmuByAppNum, (String)appId, (String)((String)formShowParameter.getCustomParam(PARAM_BINDENTITYID)), (String)"beforeUploadImptTmpl", (Object[])new Object[]{templateData, entityToFieldCol});
            } else {
                result = (Table)HRMServiceHelper.invokeBizService((String)cloudNmuByAppNum, (String)appId, (String)((String)formShowParameter.getCustomParam(PARAM_BINDENTITYID)), (String)"beforeUploadImptTmpl", (Object[])new Object[]{templateData, entityToFieldCol});
            }
            if (result != null && result.size() > 0) {
                for (Map.Entry stringMapEntry : result.rowMap().entrySet()) {
                    String entityKey = (String)stringMapEntry.getKey();
                    Map value = (Map)stringMapEntry.getValue();
                    String dropDownSheetName = MultiSheetListDataExporter.getDropDownSheetName((String)entityKey);
                    SXSSFSheet dropDownSheet = exporter.getSheet(dropDownSheetName);
                    if (value == null) continue;
                    for (Map.Entry integerListEntry : value.entrySet()) {
                        List value1 = (List)integerListEntry.getValue();
                        for (int rowIndex = 0; rowIndex < value1.size(); ++rowIndex) {
                            if (dropDownSheet.getRow(rowIndex) == null) {
                                dropDownSheet.createRow(rowIndex).createCell(((Integer)integerListEntry.getKey()).intValue()).setCellValue((String)((List)integerListEntry.getValue()).get(rowIndex));
                                continue;
                            }
                            dropDownSheet.getRow(rowIndex).createCell(((Integer)integerListEntry.getKey()).intValue()).setCellValue((String)((List)integerListEntry.getValue()).get(rowIndex));
                        }
                        SXSSFSheet sheetTemp = exporter.getSheet((String)entityToSheetName.get(entityKey));
                        MultiSheetListDataExporter.createDropdownList((SXSSFSheet)sheetTemp, (int)((Integer)integerListEntry.getKey()), (List)value1, (String)dropDownSheetName);
                    }
                }
            }
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warn("MultiSheetInvoker--error:{}", (Object)runtimeException.getMessage());
        }
        return exporter.flush(fileName, 60);
    }

    private void setEntityToFieldCol(Map<String, Map<String, Integer>> entityToFieldCol, MultiSheetListDataExporter exporter, String entityNumber, String entitySheetName) {
        SXSSFRow rowTemp = exporter.getSheet(entitySheetName).getRow(2);
        Iterator cellIteratorTemp = rowTemp.cellIterator();
        HashMap fieldColMapTemp = Maps.newHashMapWithExpectedSize((int)rowTemp.getLastCellNum());
        while (cellIteratorTemp.hasNext()) {
            Cell next = (Cell)cellIteratorTemp.next();
            fieldColMapTemp.put(next.getStringCellValue(), next.getColumnIndex());
        }
        entityToFieldCol.put(entityNumber, fieldColMapTemp);
    }

    private boolean isKingdeeIsv(String bizAppId) {
        DynamicObject bizAppDy = new HRBaseServiceHelper("bos_devportal_bizapp").queryOriginalOne("isv", new QFilter[]{new QFilter("number", "=", (Object)bizAppId)});
        return bizAppDy == null || "kingdee".equalsIgnoreCase(bizAppDy.getString("isv"));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        BillList list = (BillList)this.getControl(BILLLISTAP);
        list.refreshData();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        Long pkId = (Long)billList.getFocusRowPkId();
        if (HRStringUtils.equals((String)evt.getFieldName(), (String)FIELD_NAME)) {
            if (pkId == 0L) {
                this.getView().showTipNotification(this.RES_FULL_TEMPLATE_NOT_EDITABLE);
                return;
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(billList.getEntityId());
            parameter.setStatus(OperationStatus.EDIT);
            parameter.setPkId((Object)pkId);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "viewtemplate"));
            this.getView().showForm((FormShowParameter)parameter);
        } else if (HRStringUtils.equals((String)evt.getFieldName(), (String)FIELD_TEMPORARYFIELD)) {
            BillList billlist = (BillList)evt.getSource();
            DynamicObject row = BusinessDataServiceHelper.loadSingle((Object)billlist.getCurrentSelectedRowInfo().getPrimaryKeyValue(), (DynamicObjectType)billlist.getEntityType());
            DynamicObjectCollection attachments = row.getDynamicObjectCollection(FIELD_ATTACHMENTFIELD);
            attachments.forEach(attach -> {
                DynamicObject attachment = attach.getDynamicObject(FIELD_BASEDATA_ID);
                String url = attachment.getString(FIELD_URL);
                if (HRStringUtils.isNotEmpty((String)(url = this.getDecodeUrl(url)))) {
                    this.getView().download(UrlService.getAttachmentFullUrl((String)url));
                }
            });
        }
    }

    private String getDecodeUrl(String url) {
        if (HRStringUtils.isNotEmpty((String)url) && url.contains(URL_PATH)) {
            try {
                url = URLDecoder.decode(url, "UTF-8");
                url = url.substring(url.indexOf("path=/") + 7);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.error("downLoad url decode error");
            }
        }
        return url;
    }
}

