/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multimpt;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormController;
import kd.bos.mvc.list.ListController;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class MultiEntityImportDataPlugin
extends HRDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(MultiEntityImportDataPlugin.class);
    private String cacheItemKey = "itemKey";
    private Map<String, Boolean> buttonVisible = new HashMap<String, Boolean>(){
        private static final long serialVersionUID = -4260471679603671323L;
        {
            this.put("radiofield1", Boolean.TRUE);
            this.put("radiofield2", Boolean.TRUE);
            this.put("keyfields", Boolean.TRUE);
        }
    };

    public void initialize() {
        this.addItemClickListeners(new String[]{"msimportdata"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        this.getPageCache().put(this.cacheItemKey, itemKey);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String itemKey = this.getPageCache().get(this.cacheItemKey);
        if (HRStringUtils.equals((String)itemKey, (String)"msimportdata")) {
            args.setCancel(true);
            FormShowParameter showParameter = this.createShowParameter();
            this.getView().showForm(showParameter);
        }
        this.getPageCache().remove(this.cacheItemKey);
    }

    private FormShowParameter createShowParameter() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_multientityimptstart");
        String billFormId = null;
        String listName = null;
        String entityId = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (view instanceof IListView) {
            IListView listview = (IListView)view;
            FormConfig config = FormMetadataCache.getFormConfig((String)listview.getBillFormId());
            billFormId = config.getEntityTypeId();
            entityId = config.getEntityTypeId();
            listName = config.getCaption().toString();
            showParameter.setCustomParam("BillTypeId", (Object)((ListShowParameter)formShowParameter).getBillTypeId());
        } else if (view instanceof IBillView) {
            billFormId = view.getEntityId();
            String caption = formShowParameter.getCaption();
            listName = StringUtils.isNotBlank((CharSequence)caption) ? caption : (formShowParameter.getFormConfig() != null ? formShowParameter.getFormConfig().getCaption().toString() : "");
        }
        showParameter.setCustomParam("oppluginPath", (Object)this.getImportOpPlugin());
        showParameter.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
        showParameter.setCustomParam("CheckRightAppId", (Object)formShowParameter.getCheckRightAppId());
        showParameter.setCustomParam("BillFormId", (Object)Optional.ofNullable(this.getCustomEntityId()).orElse(billFormId));
        showParameter.setCustomParam("ListName", (Object)listName);
        showParameter.setCustomParam("entityid", (Object)Optional.ofNullable(this.getCustomEntityId()).orElse(entityId));
        this.setButtonVisible(this.buttonVisible);
        this.setVisibleFormShowParameter(showParameter, this.buttonVisible);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("before-show-multi-sheet-import-data------billformid=" + billFormId + ", appid=" + formShowParameter.getAppId() + ", service_appid=" + formShowParameter.getServiceAppId());
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack(((Object)((Object)this)).getClass().getName(), "listoperation");
        showParameter.setCloseCallBack(closeCallBack);
        return showParameter;
    }

    public void closedCallBack(ClosedCallBackEvent closedcallbackevent) {
        Object controller = closedcallbackevent.getSource();
        if (controller instanceof ListController) {
            ((IListView)((ListController)closedcallbackevent.getSource()).getView()).refresh();
        } else if (controller instanceof FormController) {
            ((FormController)controller).getView().updateView();
        } else if (controller instanceof ListViewPluginProxy) {
            ((AbstractFormPlugin)((ListViewPluginProxy)controller).getPlugIns().get(0)).getView().invokeOperation("refresh");
        }
    }

    public String getCustomEntityId() {
        return null;
    }

    private void setVisibleFormShowParameter(FormShowParameter parameter, Map<String, Boolean> radioMap) {
        for (Map.Entry<String, Boolean> entry : radioMap.entrySet()) {
            parameter.setCustomParam(entry.getKey(), (Object)entry.getValue());
        }
    }

    public void setButtonVisible(Map<String, Boolean> radioMap) {
        radioMap.put("keyfields", Boolean.FALSE);
    }

    public String getImportOpPlugin() {
        return "kd.hr.hbp.formplugin.web.multimport.HRMultipleEntitiesImportPlugin";
    }
}

