/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multimpt;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import org.xml.sax.SAXException;

public class MultiEntityImportStartPlugin
extends HRDynamicFormBasePlugin
implements UploadListener {
    private static final Log log = LogFactory.getLog(MultiEntityImportStartPlugin.class);
    private String templateNumber = "";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Boolean overrideField = (Boolean)this.getView().getFormShowParameter().getCustomParam("radiofield1");
        Boolean overrideandnewField = (Boolean)this.getView().getFormShowParameter().getCustomParam("radiofield2");
        if (overrideField != null && !overrideField.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"radiofield1"});
        }
        if (overrideandnewField != null && !overrideandnewField.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"radiofield2"});
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String appId = (String)showParam.getCustomParam("ServiceAppId");
        String checkRightAppId = (String)showParam.getCustomParam("CheckRightAppId");
        String billFormId = (String)showParam.getCustomParam("BillFormId");
        String listName = (String)showParam.getCustomParam("ListName");
        Label title = (Label)this.getControl("title");
        if (Lang.en_US == RequestContext.get().getLang()) {
            title.setText("&nbsp;&nbsp;" + listName);
        } else {
            title.setText(listName);
        }
        String pluginName = this.getImportPlugin(showParam);
        this.init(appId, checkRightAppId, listName, billFormId, pluginName);
    }

    private void init(String appId, String checkRightAppId, String listName, String billFormId, String pluginName) {
        List<String> lockKeys = new ArrayList<String>(0);
        String importType = "new";
        if (HRStringUtils.isNotEmpty((String)pluginName)) {
            try {
                IImportDataPlugin plugin = (IImportDataPlugin)Class.forName(pluginName).newInstance();
                if (plugin instanceof BatchImportPlugin) {
                    ((BatchImportPlugin)plugin).setContext(RequestContext.get(), new ImportContext(this.getView(), null, appId, checkRightAppId, listName, billFormId, null, null), null);
                    lockKeys = ((BatchImportPlugin)plugin).getDefaultLockUIs();
                    String pluginImportType = ((BatchImportPlugin)plugin).getDefaultImportType();
                    if (HRStringUtils.isNotEmpty((String)pluginImportType)) {
                        importType = pluginImportType;
                    }
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                throw new KDBizException(ex.getMessage());
            }
        }
        if ("new".equals(importType) && !lockKeys.contains("keyfields")) {
            lockKeys.add("keyfields");
        }
        this.getView().setEnable(Boolean.valueOf(false), lockKeys.toArray(new String[0]));
        this.getModel().setValue("importtype", (Object)importType);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyName = propertyChangedArgs.getProperty().getName();
        if ("importtype".equalsIgnoreCase(propertyName)) {
            this.getView().setEnable(Boolean.valueOf(!"new".equalsIgnoreCase((String)propertyChangedArgs.getChangeSet()[0].getNewValue())), new String[]{"keyfields"});
            String importtype = (String)this.getModel().getValue(propertyName);
            if (StringUtils.equals((CharSequence)"new", (CharSequence)importtype)) {
                this.getModel().setValue("keyfields", null);
            }
        }
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                FormShowParameter currShowParameter = this.getView().getFormShowParameter();
                String billFormId = (String)currShowParameter.getCustomParam("BillFormId");
                String importPlugin = this.getImportPlugin(currShowParameter);
                if (StringUtils.isBlank((CharSequence)billFormId)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"MultiEntityImportStartPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("hrcs_dlmultientitytmpl");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("BillFormId", (Object)billFormId);
                showParameter.setCustomParam("BillTypeId", currShowParameter.getCustomParam("BillTypeId"));
                showParameter.setCustomParam("ImportPlugin", (Object)importPlugin);
                showParameter.setCustomParam("TemplateType", (Object)"IMPT");
                this.getView().showForm(showParameter);
                break;
            }
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue("filepath", (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
            }
        }
    }

    private void importData() {
        String url = (String)this.getModel().getValue("filepath");
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"MultiEntityImportStartPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return;
        }
        this.importData(url);
    }

    private void importData(String url) {
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        String billFormId = (String)showParam.getCustomParam("BillFormId");
        String listName = (String)showParam.getCustomParam("ListName");
        String serviceAppId = view.getFormShowParameter().getServiceAppId();
        String checkRightAppId = (String)showParam.getCustomParam("CheckRightAppId");
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrcs_multientityimporting");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        HashMap<String, Object> params = new HashMap<String, Object>();
        String importType = (String)this.getModel().getValue("importtype");
        params.put("Type", importType);
        params.put("oppluginPath", this.getView().getFormShowParameter().getCustomParam("oppluginPath"));
        params.put("ServiceAppId", serviceAppId);
        params.put("CheckRightAppId", checkRightAppId);
        params.put("BillFormId", billFormId);
        params.put("ListName", listName);
        params.put("OpSave", ops.getSave());
        params.put("Url", url);
        params.put("ImportPlugin", this.getImportPlugin(showParam));
        params.put("OperateKey", showParam.getCustomParam("OperateKey"));
        params.put("radiofield", showParam.getCustomParam("radiofield"));
        params.put("radiofield1", showParam.getCustomParam("radiofield1"));
        params.put("radiofield2", showParam.getCustomParam("radiofield2"));
        params.put("customParams", showParam.getCustomParam("customParams"));
        showParameter.setCustomParams(params);
        showParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
        showParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
        view.showForm(showParameter);
    }

    private String getImportPlugin(FormShowParameter showParam) {
        List plugins;
        String pluginName = (String)showParam.getCustomParam("ImportPlugin");
        if (StringUtils.isBlank((CharSequence)pluginName) && (plugins = (List)showParam.getCustomParam("plugins")) != null) {
            for (Map plugin : plugins) {
                if (!Boolean.TRUE.equals(plugin.get("Enabled"))) continue;
                return (String)plugin.get("ClassName");
            }
        }
        return pluginName;
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length == 0) {
            return;
        }
        IFormView view = this.getView();
        String url = (String)urls[0];
        FileService service = FileServiceFactory.getAttachmentFileService();
        try (InputStream in = service.getInputStream(url);){
            ArrayList<Integer> dataIndexes = new ArrayList<Integer>();
            this.checkExcel(in, dataIndexes);
            int validRowCount = dataIndexes.size();
            if (validRowCount <= 0) {
                view.showMessage(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6709\u6548\u6570\u636e\u3002", (String)"MultiEntityImportStartPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u6570\u636e\u540e\u518d\u8bd5\u3002", (String)"MultiEntityImportStartPlugin_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), MessageTypes.Default);
                return;
            }
        }
        catch (KDBizException kdBizException) {
            view.showErrorNotification(kdBizException.getMessage());
            return;
        }
        catch (Throwable throwable) {
            log.error(throwable);
            view.showMessage(this.getExcelTempErr(), ResManager.loadKDString((String)"\u8be6\u60c5\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"MultiEntityImportStartPlugin_7", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), MessageTypes.Default);
            return;
        }
        view.setVisible(Boolean.TRUE, new String[]{"filepanel"});
        view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
        IDataModel model = this.getModel();
        model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
        model.setValue("filepath", (Object)url);
    }

    private void checkExcel(InputStream in, final List<Integer> dataIndexes) throws Exception {
        new ExcelReader().read(in, new SheetHandler(){

            public void handleRow(SheetHandler.ParsedRow row) {
                if (row.getSheetName().contains("DDM_") || row.getRowNum() > 20) {
                    return;
                }
                if (row.getRowNum() == 0) {
                    MultiEntityImportStartPlugin.this.checkSubEntityName(row);
                    MultiEntityImportStartPlugin.this.checkEntitySpecificPerm(row);
                } else if (row.getRowNum() == 2) {
                    MultiEntityImportStartPlugin.this.checkImportField(row);
                } else if (row.getRowNum() > 3 && !row.isEmpty()) {
                    dataIndexes.add(row.getRowNum());
                }
            }

            public void endDocument() throws SAXException {
                super.endDocument();
                this.setInterrupt(false);
            }
        });
    }

    private void checkEntitySpecificPerm(SheetHandler.ParsedRow row) {
        String entityName = StringUtils.isEmpty((CharSequence)row.get(Integer.valueOf(0))) ? row.get(Integer.valueOf(1)) : row.get(Integer.valueOf(0));
        String[] split = entityName.split("#");
        if (split.length < 2 || !split[0].contains(row.getSheetName())) {
            throw new KDBizException(this.getExcelTempErr());
        }
        if (split.length > 2) {
            String entityNumber = split[1];
            MainEntityType mainEntity = EntityMetadataCache.getDataEntityType((String)entityNumber);
            if (!PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)mainEntity.getAppId(), (String)entityNumber, (String)"4715a0df000000ac")) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u4fee\u6539\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"MultiEntityImportStartPlugin_10", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), row.getSheetName()));
            }
        }
    }

    private void checkSubEntityName(SheetHandler.ParsedRow row) {
        String multiTemplateNumber;
        DynamicObject templateData;
        String entityName = StringUtils.isEmpty((CharSequence)row.get(Integer.valueOf(0))) ? row.get(Integer.valueOf(1)) : row.get(Integer.valueOf(0));
        String[] split = entityName.split("#");
        if (split.length < 2 || !split[0].contains(row.getSheetName())) {
            throw new KDBizException(this.getExcelTempErr());
        }
        this.templateNumber = split[2];
        if (split.length > 3 && (templateData = new HRBaseServiceHelper("hrcs_multientityimptmpl").queryOne("mainentitytmpl,id,assocentitytmplentry.assocentitytmpl,assocentitytmplentry.entityuniqueval,mainentityuniqueval", new QFilter[]{new QFilter("number", "=", (Object)(multiTemplateNumber = split[3]))})) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u6a21\u677f\u7f16\u7801\u672a\u627e\u5230\u5bfc\u5165\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5Excel\u4e2d\u7b2c\u4e00\u884c\u7684\u6a21\u677f\u7f16\u7801\u5728\u7cfb\u7edf\u4e2d\u662f\u5426\u5b58\u5728\u3002", (String)"MultiEntityImportStartPlugin_9", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
    }

    private String getExcelTempErr() {
        return ResManager.loadKDString((String)"\u6570\u636e\u6a21\u677f\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"MultiEntityImportStartPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
    }

    private void checkImportField(SheetHandler.ParsedRow row) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bos_importtemplate", (String)"treeentryentity,treeentryentity.entitynumber,treeentryentity.ismustinput,treeentryentity.importprop", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)this.templateNumber)});
        if (!Objects.nonNull(dynamicObject)) {
            throw new KDBizException(this.getExcelTempErr());
        }
        dynamicObject.getDynamicObjectCollection("treeentryentity").stream().filter(object -> object.getBoolean("ismustinput")).forEach(mustInputField -> {
            String entitynumber;
            Map data = row.getData();
            if (!(data.containsValue(entitynumber = mustInputField.getString("entitynumber")) || data.containsValue(entitynumber + "." + mustInputField.getString("importprop")) || data.containsValue(entitynumber + "." + Lang.get().toString()) || data.containsValue(entitynumber + "." + "person" + "." + mustInputField.getString("importprop")) || data.containsValue(entitynumber.replaceFirst("\\.", "_")))) {
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6a21\u677f\u4e2d\u672a\u627e\u5230\u5fc5\u5f55\u5b57\u6bb5\uff1a%s\uff0c\u8bf7\u4e0a\u4f20\u6b63\u786e\u683c\u5f0f\u7684\u6570\u636e\u6a21\u677f\u3002", (String)"MultiEntityImportStartPlugin_8", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), mustInputField.getString("entitynumber")));
            }
        });
    }
}

