/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.multimpt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.data.ImportLogHelper;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.form.plugin.impt.ImportDataTask;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;

public class MultiEntityImportingPlugin
extends HRDynamicFormBasePlugin
implements ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(MultiEntityImportingPlugin.class);
    private static final int THREAD_COUNT = 6;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"MultiEntityImportThreadPool", (int)6);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndetails", "btnsuspend"});
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
    }

    public void afterCreateNewData(EventObject eventObject) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"failpanel", "successpanel", "btnclose", "btnok", "buttonap"});
        FormShowParameter params = this.getView().getFormShowParameter();
        String appid = (String)params.getCustomParam("ServiceAppId");
        String checkRightAppId = (String)params.getCustomParam("CheckRightAppId");
        String billFormId = (String)params.getCustomParam("BillFormId");
        String listName = (String)params.getCustomParam("ListName");
        String url = (String)params.getCustomParam("Url");
        String opSaveKey = (String)params.getCustomParam("OpSave");
        String importType = (String)params.getCustomParam("Type");
        String keyfields = (String)params.getCustomParam("KeyFields");
        ((Label)this.getView().getControl("title")).setText(listName);
        ProgressBar progress = (ProgressBar)this.getControl("progressbarap");
        Object logId = ImportLogHelper.create((String)ImportDataTask.getCacheKey((String)billFormId, (String)this.getView().getPageId()), (String)listName);
        try {
            String oppluginPath = (String)this.getView().getFormShowParameter().getCustomParam("oppluginPath");
            BatchImportPlugin importPlugin = (BatchImportPlugin)Class.forName(oppluginPath).newInstance();
            ImportContext ctx = new ImportContext(this.getView(), logId, appid, checkRightAppId, listName, billFormId, opSaveKey, url).addOption("importtype", (Object)importType).addOption("KeyFields", (Object)keyfields).addOption("customParams", this.getView().getFormShowParameter().getCustomParam("customParams"));
            ctx.setFromTask(Boolean.valueOf(false));
            importPlugin.setContext(RequestContext.get(), ctx, Arrays.asList("resolveExcel", "importData"));
            threadPool.submit((Callable)importPlugin);
            threadPool.submit((Callable)importPlugin);
            progress.start();
        }
        catch (ClassNotFoundException | KDBizException exp) {
            progress.setPercent(100, ResManager.loadKDString((String)"\u5f02\u5e38\u4e2d\u65ad", (String)"MultiEntityImportingPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            LOGGER.error("MultiEntityImportingPlugin======================afterCreateNewData==KDBizException", exp);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u8bf7\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"MultiEntityImportingPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
        catch (IllegalAccessException exception) {
            LOGGER.error("MultiEntityImportingPlugin======================afterCreateNewData==IllegalAccessException", (Throwable)exception);
        }
        catch (InstantiationException exception) {
            LOGGER.error("MultiEntityImportingPlugin======================afterCreateNewData==InstantiationException", (Throwable)exception);
        }
    }

    public void onProgress(ProgressEvent evt) {
        JSONObject info;
        int importProgress = 0;
        String cacheLogStr = this.getPageCache().get("Cached_Import_Logger");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Cached_Import_Logger<----" + cacheLogStr);
        }
        if ((info = JSON.parseObject((String)cacheLogStr)) != null) {
            importProgress = info.getIntValue("progress");
            if (importProgress < 0) {
                this.importProgressError(info);
                return;
            }
            IFormView view = this.getView();
            view.setVisible(Boolean.TRUE, new String[]{"btnsuspend"});
            Label currRow = (Label)this.getControl("currentrow");
            Label rowCount = (Label)this.getControl("rowcount");
            Label handleCount = (Label)this.getControl("handlecount");
            int row = info.getIntValue("curRowNum");
            int lastRow = info.getIntValue("totalRowNum");
            int total = info.getIntValue("total");
            int succeed = info.getIntValue("succeed");
            if (row >= 0) {
                currRow.setText("" + row);
                rowCount.setText("" + lastRow);
            }
            handleCount.setText("" + total);
            if (importProgress >= 100) {
                view.setVisible(Boolean.FALSE, new String[]{"btnsuspend"});
                this.importProgressDone(info, succeed);
            }
            if (lastRow > 0) {
                this.importProcessing();
            }
        }
        evt.setProgress(importProgress);
    }

    private void importProcessing() {
        HashMap meta = Maps.newHashMap();
        meta.put("itime", 3000);
        this.getView().updateControlMetadata("progressbarap", (Map)meta);
    }

    private void importProgressDone(JSONObject info, int succeed) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"importpanel", "btncancel"});
        int failed = info.getIntValue("failed");
        if (failed > 0) {
            Label successLabel = (Label)this.getControl("success");
            Label failLabel = (Label)this.getControl("failed");
            successLabel.setText("" + succeed);
            failLabel.setText("" + failed);
            this.getView().setVisible(Boolean.TRUE, new String[]{"failpanel", "btnok"});
            HashMap notHidden = Maps.newHashMap();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata("failpanel", (Map)notHidden);
        } else {
            Label successLabel = (Label)this.getControl("successall");
            successLabel.setText("" + succeed);
            this.getView().setVisible(Boolean.TRUE, new String[]{"successpanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonap"});
            HashMap notHidden = Maps.newHashMap();
            notHidden.put("gr", 1);
            this.getView().updateControlMetadata("successpanel", (Map)notHidden);
        }
    }

    private void importProgressError(JSONObject info) {
        String err = info.containsKey((Object)"err") ? (String)info.get((Object)"err") : ResManager.loadKDString((String)"\u5bfc\u5165\u8fc7\u7a0b\u9047\u5230\u672a\u77e5\u9519\u8bef\u3002", (String)"MultiEntityImportingPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]);
        this.getView().showErrorNotification(err);
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.stop();
    }

    public void click(EventObject evt) {
        String controlKey;
        switch (controlKey = ((Control)evt.getSource()).getKey()) {
            case "btndetails": {
                this.detailClick();
                break;
            }
            case "btnok": {
                IFormView view = this.getView();
                FormShowParameter importShowParameter = new FormShowParameter();
                importShowParameter.setFormId("hrcs_multientityimptstart");
                importShowParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
                importShowParameter.setCustomParam("ServiceAppId", (Object)view.getFormShowParameter().getServiceAppId());
                importShowParameter.setCustomParam("CheckRightAppId", (Object)view.getFormShowParameter().getCheckRightAppId());
                importShowParameter.setCustomParam("BillFormId", view.getFormShowParameter().getCustomParam("BillFormId"));
                importShowParameter.setCustomParam("OperateKey", view.getFormShowParameter().getCustomParam("OperateKey"));
                importShowParameter.setCustomParam("templateCode", view.getFormShowParameter().getCustomParam("templateCode"));
                importShowParameter.setCustomParam("entityid", view.getFormShowParameter().getCustomParam("entityid"));
                importShowParameter.setCustomParam("BillFormId", view.getFormShowParameter().getCustomParam("BillFormId"));
                importShowParameter.setCustomParam("oppluginPath", view.getFormShowParameter().getCustomParam("oppluginPath"));
                importShowParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
                importShowParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
                importShowParameter.setCustomParam("KeyFields", view.getFormShowParameter().getCustomParam("KeyFields"));
                importShowParameter.setCustomParam("radiofield", view.getFormShowParameter().getCustomParam("radiofield"));
                importShowParameter.setCustomParam("radiofield1", view.getFormShowParameter().getCustomParam("radiofield1"));
                importShowParameter.setCustomParam("radiofield2", view.getFormShowParameter().getCustomParam("radiofield2"));
                importShowParameter.setCustomParam("ListName", view.getFormShowParameter().getCustomParam("ListName"));
                importShowParameter.setCustomParam("customParams", view.getFormShowParameter().getCustomParam("customParams"));
                view.showForm(importShowParameter);
                break;
            }
            case "btnsuspend": {
                IFormView view = this.getView();
                IFormView parentView = this.getView().getParentView();
                if (parentView != null) {
                    parentView.showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6570\u636e\u5df2\u88ab\u7ec8\u6b62\u3002", (String)"MultiEntityImportingPlugin_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                    this.getView().sendFormAction(parentView);
                }
                this.getAppCache(view).put(this.getSuspendKey(view), (Object)this.getSuspendKey(view));
                this.getView().close();
                break;
            }
        }
    }

    private IAppCache getAppCache(IFormView view) {
        String billFormId = (String)view.getFormShowParameter().getCustomParam("BillFormId");
        String appId = EntityMetadataCache.getDataEntityType((String)billFormId).getAppId();
        return AppCache.get((String)appId);
    }

    private String getSuspendKey(IFormView view) {
        String logId = this.getPageCache().get("IMPORT_PROGRESS_ID");
        String billFormId = (String)view.getFormShowParameter().getCustomParam("BillFormId");
        return "IMPT_SUSPEND_" + billFormId + "_" + logId;
    }

    private void detailClick() {
        String jsonData;
        String billFormId = (String)this.getView().getFormShowParameter().getCustomParam("BillFormId");
        DynamicObject taskData = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"data", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)ImportDataTask.getCacheKey((String)billFormId, (String)this.getView().getPageId()))});
        if (taskData != null && !StringUtils.isBlank((CharSequence)(jsonData = taskData.getString("data")))) {
            JSONObject data = JSON.parseObject((String)jsonData);
            try {
                JSONObject info = data.getJSONObject("info");
                for (Object obj : info.values()) {
                    this.downloadDetail(obj);
                }
            }
            catch (Exception var8) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u4ece\u65e5\u5fd7\u4e2d\u63d0\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff0c\u53ef\u80fd\u65e5\u5fd7\u683c\u5f0f\u5316\u592a\u65e7\uff0c\u8bf7\u5c1d\u8bd5\u4ece\u65e5\u5fd7\u4e2d\u624b\u52a8\u63d0\u53d6\u5230\u5730\u5740\u680f\u4e0b\u8f7d\u3002", (String)"MultiEntityImportingPlugin_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"MultiEntityImportingPlugin_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        }
    }

    private void downloadDetail(Object obj) {
        ImportLogger logger = (ImportLogger)JSONObject.parseObject((String)((JSONObject)obj).toJSONString(), ImportLogger.class);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        if (StringUtils.isNotBlank((CharSequence)logger.getErrFile())) {
            proxy.addAction("download", (Object)(logger.getErrFile() + "&a=t"));
        } else {
            this.detailClickErrorShow(logger);
        }
    }

    private void detailClickErrorShow(ImportLogger logger) {
        if (logger.getFailed() > 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"MultiEntityImportingPlugin_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        } else {
            String msg = logger.toString().trim();
            if (!msg.isEmpty()) {
                this.getView().showErrorNotification(msg);
            }
        }
    }
}

