/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.AbstractBasedataController;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.ext.hr.metadata.edit.HisModelBasedataEdit;
import kd.bos.ext.hr.metadata.edit.MulHisModelBasedataEdit;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisLineF7FilterHandler;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelListCommonTool;

public class HisBaseDataF7FastFilter
extends AbstractBasedataController
implements HisLineTimeTplConstants,
HisFieldNameConstants {
    private static final long serialVersionUID = -458562815556354429L;

    public void buildBaseDataCoreFilter(BaseDataCustomControllerEvent event) {
        super.buildBaseDataCoreFilter(event);
        List parameterQFilters = event.getListShowParameter().getListFilterParameter().getQFilters();
        List qfilters = event.getQfilters();
        ListShowParameter listShowParameter = event.getListShowParameter();
        Object source = event.getSource();
        ArrayList qFilters = Lists.newArrayListWithCapacity((int)16);
        if (source instanceof HisModelBasedataEdit) {
            HisModelBasedataEdit edit = (HisModelBasedataEdit)source;
            String selData = edit.getSelData();
            String billFormId = this.getBillFormId(((HisModelBasedataEdit)source).getProperty());
            this.changeBdQFilter(selData, billFormId, parameterQFilters);
            this.changeBdQFilter(selData, billFormId, qfilters);
            qFilters.add(this.getVersionQFilter(selData, billFormId, listShowParameter, parameterQFilters));
        } else if (source instanceof MulHisModelBasedataEdit) {
            MulHisModelBasedataEdit edit = (MulHisModelBasedataEdit)source;
            String selData = edit.getSelData();
            String billFormId = this.getBillFormId(((MulHisModelBasedataEdit)source).getProperty());
            this.changeBdQFilter(selData, billFormId, parameterQFilters);
            this.changeBdQFilter(selData, billFormId, qfilters);
            qFilters.add(this.getVersionQFilter(selData, billFormId, listShowParameter, parameterQFilters));
        } else if (source instanceof BasedataEdit) {
            String billFormId = this.getBillFormId(((BasedataEdit)source).getProperty());
            qFilters.add(this.getVersionQFilter("bd", billFormId, listShowParameter, parameterQFilters));
        } else if (source instanceof CommonBaseDataFilterColumn) {
            for (QFilter qFilter : parameterQFilters) {
                if (qFilter == null || !HRStringUtils.equals((String)qFilter.getProperty(), (String)"iscurrentversion")) continue;
                return;
            }
            CommonBaseDataFilterColumn column = (CommonBaseDataFilterColumn)source;
            IDataEntityProperty srcFieldProp = column.getFilterField().getSrcFieldProp();
            if (srcFieldProp instanceof BasedataProp) {
                String formId = column.getEntityType().getName();
                if (column.getEntityType() instanceof QueryEntityType) {
                    formId = ((BasedataProp)srcFieldProp).getRefIdProp().getParent().getName();
                }
                qFilters.add(this.getVersionQFilter("bd", formId, listShowParameter, parameterQFilters));
            } else if (srcFieldProp instanceof MulBasedataProp) {
                String formId = column.getEntityType().getName();
                if (column.getEntityType() instanceof QueryEntityType) {
                    formId = ((MulBasedataProp)srcFieldProp).getRefIdProp().getParent().getName();
                }
                qFilters.add(this.getVersionQFilter("bd", formId, listShowParameter, parameterQFilters));
            }
        }
        event.addQFilters((List)qFilters);
    }

    private void changeBdQFilter(String selData, String entityNum, List<QFilter> parameterQFilters) {
        if (HRStringUtils.equals((String)selData, (String)"bdversion")) {
            HisModelListCommonTool.changeHisListBdQFilter(entityNum, parameterQFilters);
        }
    }

    private QFilter getVersionQFilter(String selData, String formId, ListShowParameter parameter, List<QFilter> qFilters) {
        QFilter versionFilter;
        if (selData.equals("bd")) {
            versionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
            QFilter dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TOBEEFFECT.getValue()).collect(Collectors.toSet()));
            versionFilter.and(dataStatusFilter);
            String inhRelation = HisCommonService.getInstance().entityInhRelation(formId);
            if (EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(inhRelation)) {
                HisLineF7FilterHandler handler = HisLineF7FilterHandler.getInstance();
                handler.addBdQFilter(formId, (FormShowParameter)parameter, qFilters);
            }
        } else {
            versionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
            QFilter dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TOBEEFFECT.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue()).collect(Collectors.toSet()));
            versionFilter.and(dataStatusFilter);
        }
        return versionFilter;
    }

    private String getBillFormId(IDataEntityProperty property) {
        String billFormId = null;
        if (property instanceof BasedataProp) {
            billFormId = ((BasedataProp)property).getBaseEntityId();
        } else if (property instanceof MulBasedataProp) {
            billFormId = ((MulBasedataProp)property).getBaseEntityId();
        }
        return billFormId;
    }
}

