/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.HisDisableOperateConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

@ExcludeFromJacocoGeneratedReport
public class HisDisableOpResultPlugin
extends AbstractBasePlugIn
implements HisDisableOperateConstants {
    private static final String BTN_MORE = "btnmore";
    private static final String BTN_GO_CONFIRM = "goconfirmbtn";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_MORE});
        this.addClickListeners(new String[]{BTN_GO_CONFIRM});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Label title = (Label)this.getControl("title");
        title.setText((String)parameter.getCustomParam("title"));
        int failCount = (Integer)parameter.getCustomParam("failCount");
        if (failCount == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"failpanel"});
        } else {
            Label failTitle = (Label)this.getControl("failtitle");
            failTitle.setText((String)parameter.getCustomParam("failtitle"));
            Object errObj = parameter.getCustomParam("errorMsg");
            if (errObj != null) {
                StringBuilder val = new StringBuilder();
                if (errObj instanceof List) {
                    List list = (List)errObj;
                    int index = 0;
                    for (String s : list) {
                        val.append(s).append(System.lineSeparator());
                        if (++index != 5) continue;
                        break;
                    }
                } else {
                    String errStr = (String)errObj;
                    val = new StringBuilder(this.extractMessage(errStr));
                }
                this.getModel().setValue("disablecontent", (Object)val.toString());
                if (Boolean.TRUE != parameter.getCustomParam("hasMore")) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{BTN_MORE});
                }
            }
        }
        Label confirmTitle = (Label)this.getControl("confirmtitle");
        confirmTitle.setText((String)parameter.getCustomParam("confirmtitle"));
        String disableDate = (String)this.getView().getFormShowParameter().getCustomParam("hisDisableDate");
        List notConfirmIds = (List)parameter.getCustomParam("notConfirmIds");
        String formatted2999 = HRDateTimeUtils.formatUserSettingFromString((String)"2999-12-31");
        if (HRStringUtils.isNotEmpty((String)disableDate)) {
            Map pkNumbers = (Map)parameter.getCustomParam("pkNumbers");
            List<String> confirmNumbers = pkNumbers.entrySet().stream().filter(entry -> notConfirmIds.contains(Long.parseLong((String)entry.getKey()))).map(Map.Entry::getValue).collect(Collectors.toList());
            this.getView().getPageCache().put("hisDisableDate", disableDate);
            StringBuilder confirmNumberSb = new StringBuilder();
            confirmNumbers.forEach(confirmNumber -> confirmNumberSb.append((String)confirmNumber).append("\u3001"));
            String confirmNumberStr = confirmNumberSb.substring(0, confirmNumberSb.length() - 1);
            String formattedDisableDate = HRDateTimeUtils.formatUserSettingFromString((String)disableDate);
            confirmNumberStr = confirmNumberStr + "\uff1a" + String.format(ResManager.loadKDString((String)"\u6267\u884c\u7981\u7528\u64cd\u4f5c\u540e\uff0c\u5c06\u4f1a\u5220\u9664%s~2999-12-31\u5185\u7684\u6240\u6709\u201c\u5f85\u751f\u6548\u201d\u6570\u636e\u7248\u672c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"HisDisableOpResultPlugin_01", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), formattedDisableDate, formatted2999);
            this.getModel().setValue("confirmcontent", (Object)confirmNumberStr);
            this.getView().setVisible(Boolean.TRUE, new String[]{"confirmcontent"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"confirmcontent2"});
        } else {
            String confirmNumberStr;
            ArrayList confirmNumbersForEff = Lists.newArrayListWithCapacity((int)10);
            ArrayList confirmNumbersForToBeEff = Lists.newArrayListWithCapacity((int)10);
            HRBaseServiceHelper helper = new HRBaseServiceHelper((String)this.getView().getFormShowParameter().getCustomParam("hisFormId"));
            DynamicObjectCollection dyCol = helper.queryOriginalCollection("id, number, datastatus", new QFilter[]{new QFilter("id", "in", (Object)notConfirmIds)});
            for (DynamicObject dy : dyCol) {
                String dataStatus = dy.getString("datastatus");
                if (HRStringUtils.equals((String)EnumHisDataVersionStatus.EFFECTING.getStatus(), (String)dataStatus)) {
                    confirmNumbersForEff.add(dy.getString("number"));
                    continue;
                }
                confirmNumbersForToBeEff.add(dy.getString("number"));
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"confirmcontent", "confirmcontent2"});
            StringBuilder confirmNumberSb = new StringBuilder();
            if (confirmNumbersForEff.size() > 0) {
                confirmNumbersForEff.forEach(confirmNumber -> confirmNumberSb.append((String)confirmNumber).append("\u3001"));
                confirmNumberStr = confirmNumberSb.substring(0, confirmNumberSb.length() - 1);
                String toDay = HRDateTimeUtils.getUserSettingFormat().format(new Date());
                confirmNumberStr = String.format("%s:%s", confirmNumberStr, String.format(ResManager.loadKDString((String)"\u6267\u884c\u7981\u7528\u64cd\u4f5c\u540e\uff0c\u5c06\u4f1a\u5220\u9664%s~2999-12-31\u5185\u7684\u6240\u6709\u201c\u5f85\u751f\u6548\u201d\u6570\u636e\u7248\u672c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"HisDisableOpResultPlugin_01", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), toDay, formatted2999));
                this.getModel().setValue("confirmcontent", (Object)confirmNumberStr);
                this.getView().setVisible(Boolean.TRUE, new String[]{"confirmcontent"});
            }
            if (confirmNumbersForToBeEff.size() > 0) {
                confirmNumbersForToBeEff.forEach(confirmNumber -> confirmNumberSb.append((String)confirmNumber).append("\u3001"));
                confirmNumberStr = confirmNumberSb.substring(0, confirmNumberSb.length() - 1);
                confirmNumberStr = String.format("%s:%s", confirmNumberStr, String.format(ResManager.loadKDString((String)"\u6267\u884c\u7981\u7528\u64cd\u4f5c\u540e\uff0c\u5c06\u4f1a\u65b0\u589e\u52a0\u4e00\u4e2a\u6709\u6548\u671f\u4e3a[\u6700\u65e9\u751f\u6548\u65e5\u671f~%1$s]\uff0c\u4f7f\u7528\u72b6\u6001\u8bb0\u5f55\u4e3a\u201c\u7981\u7528\u201d\u7684\u6570\u636e\u7248\u672c\uff0c\u5e76\u5220\u9664\u5176\u5728\u6b64\u671f\u95f4\u5185\u7684\u6240\u6709\u201c\u5f85\u751f\u6548\u201d\u6570\u636e\u7248\u672c\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"HisDisableOpResultPlugin_02", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), new Object[0]), formatted2999);
                this.getModel().setValue("confirmcontent2", (Object)confirmNumberStr);
                this.getView().setVisible(Boolean.TRUE, new String[]{"confirmcontent2"});
            }
        }
    }

    private String extractMessage(String errStr) {
        int index = errStr.indexOf(62);
        if (index == -1) {
            return errStr;
        }
        String[] lines = StringUtils.substring((String)errStr, (int)(errStr.indexOf(62) + 1)).split("<br/>");
        StringBuilder val = new StringBuilder();
        val.append(lines[0]);
        for (int i = 1; i < lines.length - 1; ++i) {
            val.append(System.lineSeparator());
            val.append(lines[i]);
        }
        return val.toString();
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (BTN_MORE.equals(key)) {
            FormShowParameter param = this.getView().getFormShowParameter();
            IFormView view = this.getView();
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("ide_showoperationresult");
            parameter.setCustomParam("pkNumbers", param.getCustomParam("pkNumbers"));
            parameter.setCustomParam("operateName", param.getCustomParam("operateName"));
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            this.getPageCache().put("operationresult", parentView.getPageCache().get("operationresult"));
            this.getView().showForm(parameter);
        } else if (BTN_GO_CONFIRM.equals(key)) {
            FormShowParameter currentParam = this.getView().getFormShowParameter();
            FormShowParameter parameter = new FormShowParameter();
            parameter.setFormId("hbp_hisconfirmdisable");
            parameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
            parameter.setCustomParam("hisFormId", currentParam.getCustomParam("hisFormId"));
            parameter.setCustomParam("notConfirmIds", currentParam.getCustomParam("notConfirmIds"));
            parameter.setCustomParam("showListColumns", currentParam.getCustomParam("showListColumns"));
            parameter.setCustomParam("hisDisableDate", currentParam.getCustomParam("hisDisableDate"));
            parameter.setParentPageId(this.getView().getFormShowParameter().getParentPageId());
            parameter.setCloseCallBack(this.getView().getFormShowParameter().getCloseCallBack());
            parameter.setCaption(ResManager.loadKDString((String)"\u5f85\u786e\u8ba4", (String)"HisDisableOpResultPlugin_03", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            this.getView().showForm(parameter);
        }
    }
}

