/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.service.cache.CodeRuleCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.repository.HisLineTimeDao;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentFiledService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionReviseService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EnumHisVersionSource;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hbp.formplugin.web.newhismodel.ReviseRecordEdit;
import kd.hr.hbp.formplugin.web.newhismodel.pluginservice.impl.HisCommonEditPluginService;
import kd.hr.hbp.formplugin.web.newhismodel.pluginservice.impl.HisLineTimeChangeTitleService;
import kd.hr.hbp.formplugin.web.newhismodel.pluginservice.impl.HisLineTimeTplFormEditService;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisAttachmentTool;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisDisableTool;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisLineChangeValidator;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelEditBtnGenTool;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelEditBuTool;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisNewDataPageFieldsHandler;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisShowFormHandler;
import org.apache.commons.lang3.ObjectUtils;

public class HisLineTimeTplFormEdit
extends HRDataBaseEdit
implements HisLineTimeTplConstants,
UploadListener {
    private static final Log LOGGER = LogFactory.getLog(HisLineTimeTplFormEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        HisAttachmentTool.registerAttachments(this.getView(), this);
    }

    @ExcludeFromJacocoGeneratedReport
    public void remove(UploadEvent evt) {
        HisAttachmentTool.remove(evt, this.getView(), this.getModel());
        String changeAttachmentStr = this.getPageCache().get("changeAttachments");
        if (HRStringUtils.isNotEmpty((String)changeAttachmentStr)) {
            String attachDeleteFlagStr = this.getPageCache().get("attachDeleteFlag");
            Set attachDeleteFlag = attachDeleteFlagStr != null ? (Set)SerializationUtils.fromJsonString((String)attachDeleteFlagStr, Set.class) : Sets.newHashSetWithExpectedSize((int)16);
            AttachmentPanel attachmentpanel = (AttachmentPanel)this.getControl(evt.getCallbackKey());
            attachDeleteFlag.add(attachmentpanel.getKey());
            this.getPageCache().put("attachDeleteFlag", SerializationUtils.toJsonString(attachDeleteFlag));
        }
        HisAttachmentTool.removeFromRevise(evt, this.getView(), this.getModel());
    }

    public void afterCreateNewData(EventObject event) {
        super.afterCreateNewData(event);
        this.setNewData();
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        String fromPage = this.getFromPage();
        if (HRStringUtils.equals((String)"openVersionPage", (String)fromPage)) {
            return;
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        ReviseRecordEdit.setSlideBill(proxy);
    }

    public void afterLoadData(EventObject event) {
        String dataStatus;
        boolean isTemp;
        super.afterLoadData(event);
        String fromPage = this.getFromPage();
        if (fromPage == null) {
            String statusField;
            boolean needEdit = HisLineTimeTplFormEditService.getInstance().needEdit(this.getView().getPageCache(), this.getModel());
            if (!needEdit && HRStringUtils.isNotEmpty((String)(statusField = ((BasedataEntityType)this.getModel().getDataEntityType()).getBillStatus())) && this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT) {
                ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.AUDIT);
            }
        } else if (HRStringUtils.equals((String)"fromHisAction", (String)fromPage) && !(isTemp = HRStringUtils.equals((String)(dataStatus = (String)this.getModel().getValue("datastatus")), (String)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue()))) {
            ((BillShowParameter)this.getView().getFormShowParameter()).setBillStatus(BillOperationStatus.AUDIT);
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setNumberField();
        HisAttachmentTool.newPageProcessAttachments(this.getView());
        this.handlePageStatus();
        HisModelEditBuTool.setBuFieldsEnable(this.getView(), this.getModel());
        HisModelEditBuTool.setReviseFieldsEnable(this.getView(), this.getModel());
        this.putCustomParamsToPageCache();
        HisLineTimeChangeTitleService.getInstance().setHisModelTitle(this.getView(), null, this.getModel(), false);
        this.getModel().setDataChanged(false);
    }

    @ExcludeFromJacocoGeneratedReport
    private void setNumberField() {
        String entityId;
        List allCodeRule;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String action = (String)customParams.get("his_action");
        if ((HRStringUtils.equals((String)action, (String)"open_insert_data_page") || HRStringUtils.equals((String)action, (String)"open_insert_new_data_page") || HRStringUtils.equals((String)action, (String)"open_copy_his_data_page")) && (allCodeRule = CodeRuleCache.getAllCodeRuleByEntity((String)(entityId = this.getModel().getDataEntityType().getName()))) != null && !allCodeRule.isEmpty()) {
            String codeField = ((BasedataEntityType)this.getModel().getDataEntityType()).getNumberProperty();
            Long boId = HRLongValueParseService.getInstance().getLongValueFromMap(customParams, "boid");
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
            DynamicObject currentBo = helper.queryOriginalOne(codeField, new QFilter("id", "=", (Object)boId));
            String currentNumber = currentBo.getString(codeField);
            Boolean isModifiable = ((CodeRuleInfo)allCodeRule.get(0)).getIsModifiable();
            if (isModifiable == null || !((CodeRuleInfo)allCodeRule.get(0)).getIsModifiable().booleanValue()) {
                this.getPageCache().put("hisCurrentNumberCode", currentNumber);
            }
            if (StringUtils.isNotEmpty((String)codeField)) {
                this.getModel().setValue(codeField, (Object)currentNumber);
            }
        }
    }

    private void setNewData() {
        Long boId;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String action = (String)customParams.get("his_action");
        if (HRStringUtils.equals((String)action, (String)"open_insert_data_page") || HRStringUtils.equals((String)action, (String)"open_copy_his_data_page")) {
            Object currentDataId = customParams.get("currentDataId");
            DynamicObject dataDy = HisCommonEntityRepository.queryHisLineDy((String)this.getModel().getDataEntity().getDataEntityType().getName(), currentDataId);
            if (dataDy != null) {
                Set ignoreFields = Collections.emptySet();
                String ignoreFieldStr = (String)customParams.get("fromCopyHis");
                if (HRStringUtils.isNotEmpty((String)ignoreFieldStr)) {
                    ignoreFields = (Set)SerializationUtils.fromJsonString((String)ignoreFieldStr, Set.class);
                }
                this.setAllField(dataDy, ignoreFields);
                this.getModel().setValue("iscurrentversion", (Object)Boolean.FALSE);
                Date effStartDate = dataDy.getDate("bsed");
                if (effStartDate != null) {
                    String date = HRDateTimeUtils.format((Date)effStartDate, (String)"yyyy-MM-dd");
                    this.getPageCache().put("currentDataEffDate", date);
                }
                this.getPageCache().put("his_action", action);
                if (this.getModel().getDataEntityType().getProperty("enable") != null) {
                    this.getPageCache().put("hisPageEnable", dataDy.getString("enable"));
                }
            }
        }
        if (HRStringUtils.equals((String)action, (String)"open_insert_new_data_page")) {
            boId = HRLongValueParseService.getInstance().getLongValueFromMap(customParams, "boid");
            this.getModel().setValue("boid", (Object)boId);
            if (this.getModel().getDataEntityType().getProperty("enable") != null) {
                this.getPageCache().put("hisPageEnable", (String)customParams.get("hisPageEnable"));
            }
            if (this.getModel().getDataEntityType().getProperty("issyspreset") != null) {
                this.getModel().setValue("issyspreset", HisLineTimeDao.getInstance().queryCurrentDataIsSysPreset(this.getModel().getDataEntityType().getName(), (Object)boId));
            }
            HisNewDataPageFieldsHandler.getInstance().handleInsertNewDataPageFields(this.getModel(), this.getView());
        } else if (HRStringUtils.equals((String)action, (String)"open_copy_his_data_page")) {
            boId = HRLongValueParseService.getInstance().getLongValueFromMap(this.getView().getFormShowParameter().getCustomParams(), "boid");
            this.getModel().setValue("boid", (Object)boId);
            this.getPageCache().put("open_copy_his_data_page", "1");
            HisNewDataPageFieldsHandler.getInstance().handleInsertNewDataPageFields(this.getModel(), this.getView());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (HRStringUtils.equals((String)"save", (String)evt.getOperationKey())) {
            this.setPermItemForHisPage(evt);
        }
    }

    private void setConfirmCallBack(BeforeDoOperationEventArgs evt) {
        String fromPage = this.getFromPage();
        if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
            String hisReviseConfirm = this.getPageCache().get("hisReviseConfirm");
            if (HRStringUtils.equals((String)hisReviseConfirm, (String)"1")) {
                this.getPageCache().remove("hisReviseConfirm");
                boolean hasPerm = this.validRevisePerm(evt);
                if (!hasPerm) {
                    return;
                }
                if (this.getModel().getDataEntityType().getAllFields().containsKey("status")) {
                    this.getModel().setValue("status", (Object)"C");
                    List iDataEntityProperties = this.getModel().getDataEntity().getDataEntityState().GetDirtyProperties();
                    for (IDataEntityProperty property : iDataEntityProperties) {
                        if (!HRStringUtils.equals((String)property.getName(), (String)"status")) continue;
                        int ordinal = property.getOrdinal();
                        this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
                        break;
                    }
                }
                return;
            }
            Boolean skipHisVersionChangeTips = (Boolean)this.getView().getFormShowParameter().getCustomParam("skipHisVersionChangeTips");
            if (skipHisVersionChangeTips != null && skipHisVersionChangeTips.booleanValue()) {
                this.getView().getPageCache().put("hisReviseConfirm", "1");
                this.getView().invokeOperation("save");
            } else {
                ConfirmCallBackListener confirmListener = new ConfirmCallBackListener("saveConfirm", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u540e\uff0c\u5c06\u66f4\u65b0\u5f53\u524d\u7248\u672c\u6570\u636e\u3002\u786e\u5b9a\u4fdd\u5b58\u5417\uff1f", (String)"HisLineTimeTplFormEdit_13", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirmListener);
            }
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String actionId = event.getCallBackId();
        if (actionId.equals("saveConfirm") && event.getResult() == MessageBoxResult.Yes) {
            this.getView().getPageCache().put("hisReviseConfirm", "1");
            this.getView().invokeOperation("save");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        this.dataDeleteValidate();
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        HisLineChangeValidator validator = new HisLineChangeValidator(this.getView(), this.getModel(), (IFormPlugin)this);
        String fromPage = this.getFromPage();
        switch (operateKey) {
            case "save": {
                if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
                    this.setConfirmCallBack(args);
                    if (args.isCancel()) {
                        return;
                    }
                    ((AbstractOperate)args.getSource()).getOption().setVariableValue("fromPage", "revise");
                    if (this.getView().getFormShowParameter().getCustomParams().containsKey("preAttachments")) {
                        ((AbstractOperate)args.getSource()).getOption().setVariableValue("preAttachments", JSONObject.toJSONString((Object)this.getView().getFormShowParameter().getCustomParam("preAttachments")));
                    }
                    return;
                }
                this.beforeSaveDo(op, args, validator);
                break;
            }
            case "confirmchange": 
            case "confirmchangenoaudit": {
                this.beforeConfirmDo(op, args, validator);
                break;
            }
            case "audit": {
                FormOperate operate = (FormOperate)args.getSource();
                operate.getOption().setVariableValue("opFromFormEdit", "true");
                break;
            }
            case "his_disable": {
                this.getModel().setValue("id", this.getModel().getValue("boid"));
                HisDisableTool.resetEnableField(this.getModel());
                HisDisableTool.showSetDisableDatePage(args, this.getModel().getDataEntityType().getName(), this.getView(), (IFormPlugin)this);
                break;
            }
            case "enable": {
                this.getModel().setValue("id", this.getModel().getValue("boid"));
                break;
            }
            case "reviserecord": {
                String pkId = (Boolean)this.getModel().getValue("iscurrentversion") != false ? String.valueOf(this.getModel().getValue("sourcevid")) : String.valueOf(this.getModel().getValue("id"));
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                HashMap<String, Object> o = new HashMap<String, Object>(8);
                o.put("formId", "hbp_revisepage");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("entity", this.getView().getModel().getDataEntityType().getName());
                params.put("boid", String.valueOf(this.getModel().getValue("boid")));
                params.put("pkId", pkId);
                o.put("params", params);
                proxy.addAction("showSlideBill", o);
                return;
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean validateBeforeChangeData() {
        String action = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        if (HRStringUtils.equals((String)action, (String)"open_insert_data_page") || HRStringUtils.equals((String)action, (String)"open_data_page") || HRStringUtils.equals((String)action, (String)"modify_data_page")) {
            Long id = (Long)this.getModel().getValue("id");
            if (id == null || id == 0L) {
                return true;
            }
            HRBaseServiceHelper helper = new HRBaseServiceHelper(this.getModel().getDataEntityType().getName());
            DynamicObject dy = helper.queryOriginalOne("datastatus, hisversion", (Object)id);
            if (dy != null && !HRStringUtils.equals((String)EnumHisDataVersionStatus.TEMP.getStatus(), (String)dy.getString("datastatus"))) {
                String version = dy.getString("hisversion");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u6570\u636e\u5df2\u88ab\u4ed6\u4eba\u786e\u8ba4\u53d8\u66f4\uff0c\u751f\u6210%s\u7248\u672c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"HisLineTimeTplFormEdit_14", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), version));
                return false;
            }
        }
        return true;
    }

    private void beforeSaveDo(AbstractOperate op, BeforeDoOperationEventArgs args, HisLineChangeValidator validator) {
        String operateKey = op.getOperateKey();
        OperateOption option = op.getOption();
        if (!args.isCancel() && this.newHisDataPageSaveValidatePerm() && this.validateBeforeChangeData() && validator.validateVersionChange(operateKey)) {
            long boId = this.getModel().getDataEntity().getLong("boid");
            if (boId == 0L) {
                this.getModel().setValue("boid", (Object)HRLongValueParseService.getInstance().getLongValueFromMap(this.getView().getFormShowParameter().getCustomParams(), "boid"));
            }
            option.setVariableValue("opFromFormEdit", "true");
            if (ObjectUtils.isNotEmpty((Object)this.getPageCache().get("hasRight"))) {
                option.setVariableValue("hasRight", this.getPageCache().get("hasRight"));
            }
            option.setVariableValue("his_action", (String)this.getView().getFormShowParameter().getCustomParam("his_action"));
            String currentNumberCode = this.getPageCache().get("hisCurrentNumberCode");
            IDataEntityType dataEntityType = this.getModel().getDataEntity().getDataEntityType();
            String numberField = ((BillEntityType)dataEntityType).getBillNo();
            if (StringUtils.isNotEmpty((String)numberField)) {
                if (HRStringUtils.isNotEmpty((String)currentNumberCode)) {
                    option.setVariableValue("hisCurrentNumberCode", currentNumberCode);
                } else {
                    option.setVariableValue("hisCurrentNumberCode", String.valueOf(this.getModel().getValue(numberField)));
                }
            }
            boolean numberFieldChanged = false;
            for (IDataEntityProperty bizChangedProperty : this.getModel().getDataEntity().getDataEntityState().getBizChangedProperties()) {
                if (!HRStringUtils.equals((String)bizChangedProperty.getName(), (String)numberField)) continue;
                numberFieldChanged = true;
                break;
            }
            option.setVariableValue("hisCurrentNumberCodeIsChanged", String.valueOf(numberFieldChanged));
            String action = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
            String currentEffDate = this.getPageCache().get("currentDataEffDate");
            option.setVariableValue("his_action", action);
            option.setVariableValue("currentDataEffDate", currentEffDate);
            HisAttachmentTool.saveAttachmentInfoToOp(args, this.getView());
            this.setEnable(option);
        } else {
            args.setCancel(true);
        }
    }

    private boolean newHisDataPageSaveValidatePerm() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String action = (String)customParams.get("his_action");
        if (HRStringUtils.equals((String)action, (String)"open_insert_new_data_page")) {
            Long boId = HRLongValueParseService.getInstance().getLongValueFromMap(customParams, "boid");
            boolean hasDataRuleRight = HisCommonService.getInstance().hasDataRuleRight((Object)boId, this.getView().getEntityId());
            if (hasDataRuleRight) {
                return true;
            }
            String entityName = EntityMetadataCache.getDataEntityType((String)this.getView().getEntityId()).getDisplayName().getLocaleValue();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HisLineTimeTplFormEdit_15", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), entityName));
            return false;
        }
        return true;
    }

    private void setPermItemForHisPage(BeforeItemClickEvent evt) {
        String action = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityName = this.getModel().getDataEntityType().getName();
        String caption = FormMetadataCache.getFormConfig((String)entityName).getCaption().getLocaleValue();
        if (HRStringUtils.equals((String)action, (String)"open_insert_data_page") || HRStringUtils.equals((String)action, (String)"open_copy_his_data_page") || HRStringUtils.equals((String)action, (String)"open_insert_new_data_page") || HRStringUtils.equals((String)action, (String)"open_data_page") || HRStringUtils.equals((String)action, (String)"modify_data_page")) {
            boolean hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityName, (String)"4715a0df000000ac");
            if (!hasPermission) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u4fee\u6539\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HisLineTimeTplFormEdit_12", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption));
                evt.setCancel(true);
            }
            this.getView().getPageCache().put("hasRight", "true");
        }
    }

    private boolean validRevisePerm(BeforeDoOperationEventArgs args) {
        long userId = RequestContext.get().getCurrUserId();
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityName = this.getModel().getDataEntityType().getName();
        String caption = FormMetadataCache.getFormConfig((String)entityName).getCaption().getLocaleValue();
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)userId, (String)appId, (String)entityName, (String)"2OPEM0HF65UC");
        if (!hasPermission) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u7248\u672c\u4fee\u8ba2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HisLineTimeTplFormEdit_11", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption));
            args.setCancel(true);
        }
        return hasPermission;
    }

    private void beforeConfirmDo(AbstractOperate op, BeforeDoOperationEventArgs args, HisLineChangeValidator validator) {
        String operateKey = op.getOperateKey();
        OperateOption option = op.getOption();
        if (!args.isCancel() && this.newHisDataPageSaveValidatePerm() && this.validateBeforeChangeData() && validator.validateVersionChange(operateKey)) {
            this.setCurrentBoId();
            option.setVariableValue("opFromFormEdit", "true");
            String action = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
            String currentEffDate = this.getPageCache().get("currentDataEffDate");
            option.setVariableValue("his_action", action);
            option.setVariableValue("currentDataEffDate", currentEffDate);
            HisAttachmentTool.saveAttachmentInfoToOp(args, this.getView());
            this.processAttachmentFields(op.getOption());
            this.setEnable(option);
            this.getView().getModel().clearNoDataRow();
        } else {
            args.setCancel(true);
        }
    }

    private void setEnable(OperateOption option) {
        String fromPage = this.getFromPage();
        if (HRStringUtils.equals((String)"fromHisAction", (String)fromPage) && this.getModel().getDataEntityType().getAllFields().containsKey("enable")) {
            String enable = this.getPageCache().get("hisPageEnable");
            if (HRStringUtils.equals((String)enable, (String)"0")) {
                option.setVariableValue("hisPageEnable", "1");
            } else {
                option.setVariableValue("hisPageEnable", enable);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        String needAudit = this.getView().getPageCache().get("needAudit");
        OperationResult operationResult = args.getOperationResult();
        boolean isSuccess = false;
        if (operationResult != null) {
            isSuccess = operationResult.isSuccess();
        }
        boolean needDisabledAttach = false;
        switch (operateKey) {
            case "insertdata_his": {
                if (!isSuccess) break;
                this.beforeChangeDataDo();
                break;
            }
            case "showhisversion": {
                if (!isSuccess) break;
                HisShowFormHandler.getInstance().showHisVersionPageForHisLineEdit(this.getView());
                needDisabledAttach = true;
                break;
            }
            case "confirmchange": 
            case "confirmchangenoaudit": {
                this.afterConfirmChange(isSuccess);
                needDisabledAttach = true;
                break;
            }
            case "revise": {
                if (!isSuccess) {
                    String fromPage = this.getFromPage();
                    if (!HRStringUtils.equals((String)fromPage, (String)"fromHisAction")) break;
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable"});
                    break;
                }
                HisShowFormHandler.getInstance().editTimeLineRevisePage((FormView)this.getView(), (IFormPlugin)this, this.getModel());
                break;
            }
            case "reviserecord": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable"});
                break;
            }
            case "his_disable": {
                this.getView().getFormShowParameter().setCustomParam("his_is_disable", (Object)"true");
                HisAttachmentTool.reloadAttachments(this.getView(), this.getModel().getValue("id"));
                this.getView().getFormShowParameter().setCustomParam("fromPage", null);
                this.getPageCache().put("pageStatus", "view");
                HisDisableTool.showDisableResultForEdit(args, this.getView(), (IFormPlugin)this);
                break;
            }
            case "enable": {
                if (isSuccess) {
                    this.getPageCache().put("pageStatus", "view");
                    this.showBtnForEnabledData();
                }
                this.getView().getFormShowParameter().setCustomParam("his_is_disable", (Object)"true");
                HisAttachmentTool.reloadAttachments(this.getView(), this.getModel().getValue("id"));
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_disable"});
                break;
            }
            case "audit": {
                String enableRevise;
                if (!isSuccess) break;
                if (this.isFromListView()) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"hisversionbtn", "insertdatabtn"});
                }
                if (HRStringUtils.equals((String)(enableRevise = this.getPageCache().get("openrevise")), (String)"1")) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"bar_revise"});
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
                }
                HisLineTimeTplFormEditService.getInstance().hideBtnForEnablingData(this.getView(), this.getModel());
                needDisabledAttach = true;
                break;
            }
            case "save": {
                if (!isSuccess) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable"});
                    break;
                }
                this.processCommonSaveOp(isSuccess, this.getView().getEntityId(), needAudit, this.getModel());
                String action = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
                if (!"open_revise_page".equals(action) && "true".equals(needAudit)) break;
                needDisabledAttach = true;
                break;
            }
            case "refresh": {
                if (this.getRefreshReadOnly()) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                }
                HisAttachmentTool.reloadAttachments(this.getView(), this.getModel().getValue("id"));
                break;
            }
            case "submit": {
                if (!isSuccess) break;
                needDisabledAttach = false;
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_audit"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                break;
            }
            case "unsubmit": {
                if (!isSuccess) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_audit"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_save"});
                break;
            }
        }
        if (isSuccess) {
            if ("insertdata_his".equalsIgnoreCase(operateKey)) {
                return;
            }
            boolean isSaveAndNew = false;
            if (op instanceof SaveAndNew) {
                isSaveAndNew = true;
            }
            HisLineTimeChangeTitleService.getInstance().setHisModelTitle(this.getView(), operateKey, this.getModel(), isSaveAndNew);
            if (!"his_disable".equals(operateKey) && !"enable".equals(operateKey)) {
                HisAttachmentTool.removeRepeatAttachments(this.getView(), needDisabledAttach);
                this.getView().getFormShowParameter().getCustomParams().remove("load_attachment_from_db");
                this.getView().getFormShowParameter().getCustomParams().remove("his_is_disable");
            }
        }
    }

    private void afterConfirmChange(boolean isSuccess) {
        if (!isSuccess) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable"});
            return;
        }
        String pageStatus = this.getPageCache().get("pageStatus");
        if ("addnew".equals(pageStatus) || "modify".equals(pageStatus)) {
            HisModelEditBtnGenTool.displayAfterNewVersionSave(this.getView());
            this.getView().getFormShowParameter().setCustomParam("his_action", (Object)"modify_data_page");
            this.getView().getFormShowParameter().setCustomParam("fromPage", (Object)"fromHisAction");
        } else {
            HisModelEditBtnGenTool.afterConfirmChangeHisBtnBar(this.getView());
            this.getView().getFormShowParameter().setCustomParam("fromPage", null);
        }
        this.getPageCache().put("closeNoCheck", "1");
        IDataEntityProperty statusProp = this.getModel().getProperty("status");
        if (statusProp != null) {
            this.getModel().setValue("status", (Object)"C");
        }
        this.getPageCache().put("pageStatus", "view");
        this.getView().setStatus(OperationStatus.EDIT);
        HisLineTimeTplFormEditService.getInstance().setBillStatusViewOrAudit(this.getView(), this.getModel());
    }

    private void processCommonSaveOp(boolean isSuccess, String entityNumber, String needAudit, IDataModel dataModel) {
        String currentNumberCode;
        String fromPage;
        String inheritPath = this.getModel().getDataEntityType().getInheritPath();
        boolean isOriTimeSeqTpl = HisCommonEditPluginService.getInstance().isOriTimeSeqTpl(entityNumber, inheritPath);
        if (isOriTimeSeqTpl) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        if (HRStringUtils.equals((String)(fromPage = this.getFromPage()), (String)"revise")) {
            if (isSuccess) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                if (this.getView().getFormShowParameter().getCustomParams().containsKey("isVersionDataPage")) {
                    HisModelEditBtnGenTool.displayReviseVersionSave(this.getView());
                } else {
                    HisModelEditBtnGenTool.hideAfterReviseSave(this.getView());
                }
            }
            return;
        }
        if (isOriTimeSeqTpl) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_modify", "bar_reviserecord"});
        }
        if (HRStringUtils.isNotEmpty((String)(currentNumberCode = this.getPageCache().get("hisCurrentNumberCode")))) {
            boolean dataChanged = this.getModel().getDataChanged();
            this.getModel().setValue("number", (Object)currentNumberCode);
            this.getModel().setDataChanged(dataChanged);
        }
        if (!"true".equals(needAudit)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"hisversionbtn", "insertdatabtn"});
        }
        HisLineTimeTplFormEditService.getInstance().hideBtnForEnablingData(this.getView(), this.getModel());
    }

    @ExcludeFromJacocoGeneratedReport
    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId;
        super.closedCallBack(event);
        switch (actionId = event.getActionId()) {
            case "setDisableDate": {
                Object returnDate = event.getReturnData();
                if (returnDate == null) {
                    return;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                this.getPageCache().put("hisSetDisableDate", sdf.format(returnDate));
                this.getView().invokeOperation("his_disable");
                break;
            }
            case "ConfirmDisable": {
                String result = this.getPageCache().get("hisDisableResult");
                if (HRStringUtils.equals((String)"1", (String)result)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"HisLineTimeTplFormEdit_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                    this.getPageCache().remove("hisDisableResult");
                }
                this.getView().invokeOperation("refresh");
                break;
            }
            case "hbp_hischangestyle": {
                Object returnDate = event.getReturnData();
                if (returnDate == null) {
                    HisLineTimeTplFormEditService.getInstance().setBillStatusViewOrAudit(this.getView(), this.getModel());
                    return;
                }
                if (returnDate instanceof Map) {
                    Object tempVersionId = ((Map)returnDate).get("tempVersionId");
                    HisShowFormHandler.getInstance().openTempVersionDataEditPage(this.getView(), this.getView().getEntityId(), this.getModel().getDataEntity().getPkValue(), tempVersionId);
                    break;
                }
                HisShowFormHandler.getInstance().changeData(this.getView(), (IFormPlugin)this);
                break;
            }
            case "save": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                Object returnDate = event.getReturnData();
                if (!Objects.equals(returnDate, MessageBoxOptions.OK.getValue())) {
                    this.getPageCache().remove("confirmShow");
                    return;
                }
                this.setCurrentBoId();
                OperationResult operationResult = this.getView().invokeOperation(actionId);
                if (!operationResult.isSuccess()) {
                    String fromPage = this.getFromPage();
                    if (HRStringUtils.equals((String)"fromHisAction", (String)fromPage)) break;
                    this.getModel().setValue("bsled", null);
                    break;
                }
                this.getView().returnDataToParent((Object)actionId);
                this.getModel().setDataChanged(false);
                break;
            }
            case "hisDataChange": {
                Object returnDate = event.getReturnData();
                if (Objects.equals(returnDate, "save")) {
                    this.getView().invokeOperation("save");
                    break;
                }
                if (Objects.equals(returnDate, "confirmchange")) {
                    this.getView().invokeOperation("confirmchange");
                    break;
                }
                if (!Objects.equals(returnDate, "confirmchangenoaudit")) break;
                this.getView().invokeOperation("confirmchangenoaudit");
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent event) {
        super.beforeClosed(event);
        if (HRStringUtils.equals((String)"1", (String)this.getPageCache().get("closeNoCheck"))) {
            event.setCheckDataChange(false);
        }
    }

    private void handlePageStatus() {
        String fromPage = this.getFromPage();
        this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
        if (this.getModel().getValue("id") != null && HRStringUtils.equals((String)"fromHisAction", (String)fromPage)) {
            HisVersionReviseService service = new HisVersionReviseService();
            boolean existReviseRecord = service.isExistReviseRecord(this.getModel().getDataEntityType().getName(), String.valueOf(this.getModel().getValue("id")));
            this.getView().getFormShowParameter().setCustomParam("existReviseRecord", (Object)existReviseRecord);
        }
        Map status = HRBaseDataConfigUtil.getStatus((String)this.getView().getModel().getDataEntityType().getName());
        boolean needAudit = (Boolean)status.get("auditcheck");
        String enableStatus = (String)status.get("enablestatus");
        this.getView().getPageCache().put("needAudit", String.valueOf(needAudit));
        if (HRStringUtils.equals((String)"revise", (String)fromPage)) {
            HisModelEditBtnGenTool.displayReviseBtnBar(this.getView());
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise", "bar_reviserecord"});
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            this.getPageCache().put("pageStatus", "edit");
            if (this.getView().getFormShowParameter().getCustomParams().containsKey("isVersionDataPage")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"hisversion"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"hisversion"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"hisversion"});
            }
            if (this.getModel().getDataEntityType().getAllFields().containsKey("status")) {
                this.getModel().setValue("status", (Object)"A");
                this.getModel().setDataChanged(false);
            }
            return;
        }
        if (HRStringUtils.equals((String)"openVersionPage", (String)fromPage)) {
            HisModelEditBtnGenTool.createBillEditReviseBtnBar(this.getView(), fromPage);
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            this.getPageCache().put("pageStatus", "view");
            return;
        }
        if (HRStringUtils.equals((String)"fromHisAction", (String)fromPage)) {
            HisModelEditBtnGenTool.createBillEditHisBtnBar(this.getView(), needAudit);
            String dataStatus = (String)this.getModel().getValue("datastatus");
            boolean isTemp = HRStringUtils.equals((String)dataStatus, (String)EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue());
            String action = this.getAction();
            this.setBillStatusForHisPage(isTemp, action);
            boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
            Boolean isCurrentVersion = (Boolean)this.getModel().getValue("iscurrentversion");
            if (fromDatabase && !isCurrentVersion.booleanValue() && !HRStringUtils.equals((String)dataStatus, (String)EnumHisDataVersionStatus.TEMP.getStatus())) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"hisversion"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"hisversion"});
            }
        } else if (HRStringUtils.equals((String)"fromHisViewWindow", (String)fromPage)) {
            HisModelEditBtnGenTool.onlyCloseBtnBar(this.getView());
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            this.getView().setStatus(OperationStatus.VIEW);
        } else {
            if (HRStringUtils.equals((String)"page_custom_param", (String)fromPage)) {
                return;
            }
            String entityNumber = this.getView().getEntityId();
            String inheritPath = this.getModel().getDataEntityType().getInheritPath();
            boolean isOriTimeSeqTpl = HisCommonEditPluginService.getInstance().isOriTimeSeqTpl(entityNumber, inheritPath);
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            if (isOriTimeSeqTpl && showParameter.getStatus() == OperationStatus.ADDNEW) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bsled", "hisversion"});
            } else {
                HisLineTimeTplFormEditService.getInstance().setStatusForDetailPage(this.getView(), this.getPageCache(), this.getModel(), needAudit, enableStatus);
                this.getView().setVisible(Boolean.FALSE, new String[]{"bsled", "hisversion"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"pagepanel"});
            }
        }
        Map hisEntityEventMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSHismodelService", (String)"getHisEntityEventBo", (Object[])new Object[]{this.getModel().getDataEntityType().getName()});
        if (hisEntityEventMap.isEmpty()) {
            this.getPageCache().put("openrevise", "1");
        } else if (HRStringUtils.equals((String)((String)hisEntityEventMap.get("openrevise")), (String)"0")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
        } else {
            this.getPageCache().put("openrevise", "1");
        }
    }

    private void beforeChangeDataDo() {
        String flag = (String)this.getView().getFormShowParameter().getCustomParam("fromTreeOpTips");
        if (HRStringUtils.equals((String)flag, (String)"1")) {
            HisShowFormHandler.getInstance().changeData(this.getView(), (IFormPlugin)this);
            return;
        }
        Object pkValue = this.getModel().getValue("boid");
        boolean isModify = HisLineTimeDao.getInstance().hasTempVersion(this.getModel().getDataEntityType().getName(), pkValue);
        if (isModify) {
            HisShowFormHandler.getInstance().openChooseChangeStylePage(this.getView(), pkValue, (IFormPlugin)this);
        } else {
            HisShowFormHandler.getInstance().changeData(this.getView(), (IFormPlugin)this);
        }
    }

    private void putCustomParamsToPageCache() {
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        HashMap customParamMap = (HashMap)pageCache.get("customParamMap", Map.class);
        if (customParamMap == null) {
            customParamMap = new HashMap(16);
        }
        customParamMap.putAll(this.getView().getFormShowParameter().getCustomParams());
        pageCache.put("customParamMap", customParamMap);
    }

    private void setAllField(DynamicObject dataDy, Set<String> ignoreFields) {
        if (ignoreFields == null) {
            ignoreFields = Collections.emptySet();
        }
        DataEntityPropertyCollection collection = this.getModel().getDataEntityType().getProperties();
        ArrayList entryPropList = Lists.newArrayListWithCapacity((int)16);
        for (IDataEntityProperty property : collection) {
            String propertyName = property.getName();
            if (HRStringUtils.equals((String)propertyName, (String)"id") || HRStringUtils.equals((String)propertyName, (String)"masterid") || HRStringUtils.equals((String)propertyName, (String)"versionsource") || HRStringUtils.equals((String)propertyName, (String)"datastatus") || HRStringUtils.equals((String)propertyName, (String)"changedescription") || HRStringUtils.equals((String)propertyName, (String)"createtime") || HRStringUtils.equals((String)propertyName, (String)"creator") || HRStringUtils.equals((String)propertyName, (String)"modifier") || HRStringUtils.equals((String)propertyName, (String)"modifytime") || HRStringUtils.equals((String)propertyName, (String)"status") || HRStringUtils.equals((String)propertyName, (String)"multilanguagetext") || propertyName.endsWith("_id") || ignoreFields.contains(propertyName)) continue;
            if (property instanceof EntryProp) {
                entryPropList.add((EntryProp)property);
                continue;
            }
            Object propVal = dataDy.get(propertyName);
            if (propVal instanceof MulBasedataDynamicObjectCollection) {
                MulBasedataDynamicObjectCollection newMulBaseData = HisAttachmentFiledService.getInstance().copyNewMulBaseData((MulBasedataDynamicObjectCollection)propVal, this.getView().getPageId());
                this.getModel().getDataEntity().set(propertyName, (Object)newMulBaseData);
                continue;
            }
            this.getModel().setValue(propertyName, propVal);
        }
        this.setValueForEntry(dataDy, entryPropList);
    }

    private void setValueForEntry(DynamicObject dataDy, List<EntryProp> entryPropList) {
        entryPropList.forEach(entry -> {
            String entryNum = entry.getName();
            DataEntityPropertyCollection entryFields = entry.getDynamicCollectionItemPropertyType().getProperties();
            DynamicObjectCollection currentEntryCol = dataDy.getDynamicObjectCollection((IDataEntityProperty)entry);
            int createRowCount = currentEntryCol.size() - entry.getDefaultRows();
            if (createRowCount > 0) {
                this.getModel().batchCreateNewEntryRow(entryNum, createRowCount);
            }
            DynamicObjectCollection newDynamicObjectCollection = (DynamicObjectCollection)this.getModel().getValue(entryNum);
            for (int i = 0; i < currentEntryCol.size(); ++i) {
                DynamicObject dyRow = (DynamicObject)currentEntryCol.get(i);
                DynamicObject dyNewRow = (DynamicObject)newDynamicObjectCollection.get(i);
                if (dyRow == null || dyNewRow == null) continue;
                for (IDataEntityProperty entryField : entryFields) {
                    Object value;
                    String entryFieldNum = entryField.getName();
                    if (HRStringUtils.equals((String)"id", (String)entryFieldNum) || HRStringUtils.equals((String)"seq", (String)entryFieldNum) || HRStringUtils.equals((String)"masterid", (String)entryFieldNum) || HRStringUtils.equals((String)"multilanguagetext", (String)entryFieldNum) || (value = dyRow.get(entryField)) == null) continue;
                    if (value instanceof MulBasedataDynamicObjectCollection) {
                        MulBasedataDynamicObjectCollection newMulBaseData = HisAttachmentFiledService.getInstance().copyNewMulBaseData((MulBasedataDynamicObjectCollection)value, this.getView().getPageId());
                        dyNewRow.set(entryFieldNum, (Object)newMulBaseData);
                        continue;
                    }
                    if (entryField instanceof SubEntryProp) {
                        this.setValueForSubEntry(currentEntryCol, entryField, i, dyNewRow);
                        continue;
                    }
                    dyNewRow.set(entryFieldNum, dyRow.get(entryFieldNum));
                }
                ((DynamicObject)this.getModel().getEntryEntity(entryNum).get(i)).getDataEntityState().setBizChanged(true);
                ((DynamicObject)this.getModel().getEntryEntity(entryNum).get(i)).getDataEntityState().setBizChangeFlags(new long[]{1L});
            }
            this.getModel().setValue(entryNum, (Object)newDynamicObjectCollection);
        });
    }

    @ExcludeFromJacocoGeneratedReport
    private void setValueForSubEntry(DynamicObjectCollection currentEntryCol, IDataEntityProperty entryField, int index, DynamicObject dyNewRow) {
        String entryFieldNum = entryField.getName();
        DynamicObjectCollection subCol = (DynamicObjectCollection)this.getModel().getValue(entryFieldNum, index);
        subCol.clear();
        ((DynamicObject)currentEntryCol.get(index)).getDynamicObjectCollection(entryFieldNum).forEach(dy -> {
            DataEntityPropertyCollection properties = dy.getDynamicObjectType().getProperties();
            DynamicObject subEntryObj = subCol.addNew();
            subEntryObj.getDataEntityState().setBizChanged(true);
            subEntryObj.getDataEntityState().setBizChangeFlags(new long[]{1L});
            properties.forEach(prop -> {
                if (HRStringUtils.equals((String)"id", (String)prop.getName()) || HRStringUtils.equals((String)"seq", (String)prop.getName()) || HRStringUtils.equals((String)"masterid", (String)prop.getName()) || HRStringUtils.equals((String)"multilanguagetext", (String)prop.getName())) {
                    return;
                }
                Object value = dy.get(prop.getName());
                if (value == null) {
                    return;
                }
                if (value instanceof MulBasedataDynamicObjectCollection) {
                    MulBasedataDynamicObjectCollection newMulBaseData = HisAttachmentFiledService.getInstance().copyNewMulBaseData((MulBasedataDynamicObjectCollection)value, this.getView().getPageId());
                    subEntryObj.set(prop.getName(), (Object)newMulBaseData);
                } else {
                    subEntryObj.set(prop.getName(), value);
                }
            });
        });
        dyNewRow.set(entryField.getName(), (Object)subCol);
    }

    @ExcludeFromJacocoGeneratedReport
    private void setBillStatusForHisPage(boolean isTemp, String action) {
        if (HRStringUtils.equals((String)action, (String)"open_data_page")) {
            this.getView().setVisible(Boolean.valueOf(isTemp), new String[]{"confirmchange", "bar_save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable"});
        }
        if (HRStringUtils.equals((String)action, (String)"open_insert_new_data_page") || HRStringUtils.equals((String)action, (String)"open_copy_his_data_page")) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.ADDNEW);
            this.getPageCache().put("pageStatus", "addnew");
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise", "bar_reviserecord"});
        } else if (HRStringUtils.equals((String)action, (String)"open_insert_data_page")) {
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
            this.getPageCache().put("pageStatus", "edit");
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise", "bar_reviserecord"});
        } else if (HRStringUtils.equals((String)action, (String)"modify_data_page")) {
            this.getView().setVisible(Boolean.valueOf(isTemp), new String[]{"confirmchange", "bar_save"});
            if (isTemp) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_reviserecord"});
            } else {
                HisLineTimeTplFormEditService.getInstance().setBillStatusViewOrAudit(this.getView(), this.getModel());
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_revise"});
                this.setReviseRecord();
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_disable"});
            this.getPageCache().put("pageStatus", "modify");
            this.getView().getFormShowParameter().setCustomParam("isVersionDataPage", (Object)"1");
        } else {
            Object tempPageStatusView = this.getView().getFormShowParameter().getCustomParam("tempPageStatusView");
            if (!isTemp || Objects.equals(tempPageStatusView, "1")) {
                HisLineTimeTplFormEditService.getInstance().setBillStatusViewOrAudit(this.getView(), this.getModel());
                this.getPageCache().put("pageStatus", "view");
                HisAttachmentTool.hideAttachmentsBtn(this.getView());
                this.setReviseRecord();
                if (this.getModel().getDataEntityType().getProperties().containsKey((Object)"versionsource")) {
                    String versionSource = (String)this.getModel().getValue("versionsource");
                    if (EnumHisVersionSource.ORIGIN_DATA_SINK.getType().equals(versionSource)) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
                    } else {
                        String enableRevise = this.getPageCache().get("openrevise");
                        if (HRStringUtils.equals((String)enableRevise, (String)"1")) {
                            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_revise"});
                        } else {
                            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
                        }
                    }
                }
                if (Objects.equals(tempPageStatusView, "1")) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"confirmchange", "bar_save", "bar_revise"});
                }
            } else {
                ((IBillView)this.getView()).setBillStatus(BillOperationStatus.EDIT);
                this.getPageCache().put("pageStatus", "edit");
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise", "bar_reviserecord"});
            }
            this.getView().getFormShowParameter().setCustomParam("isVersionDataPage", (Object)"1");
        }
    }

    private void setCurrentBoId() {
        Long boid = (Long)this.getModel().getValue("boid");
        if (boid == null || boid == 0L) {
            this.getModel().setValue("boid", (Object)HRLongValueParseService.getInstance().getLongValueFromMap(this.getView().getFormShowParameter().getCustomParams(), "boid"));
        }
    }

    private void showBtnForEnabledData() {
        if (this.isFromListView() && this.getModel().getDataEntityType().getProperties().containsKey((Object)"status") && HRStringUtils.equals((String)this.getModel().getDataEntity().getString("status"), (String)"C")) {
            String enableRevise = this.getPageCache().get("openrevise");
            if (HRStringUtils.equals((String)enableRevise, (String)"1")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"insertdatabtn", "hisversionbtn", "bar_revise"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"insertdatabtn", "hisversionbtn"});
            }
        }
        this.getView().invokeOperation("refresh");
    }

    private boolean isFromListView() {
        String notFromListView = this.getPageCache().get("notFromListView");
        return !HRStringUtils.equals((String)notFromListView, (String)"1");
    }

    private void dataDeleteValidate() {
        Object boIdValue = this.getModel().getValue("boid");
        if (ObjectUtils.isEmpty((Object)boIdValue)) {
            return;
        }
        boolean isNotEqualsZero = false;
        if (boIdValue instanceof Long) {
            isNotEqualsZero = (Long)boIdValue != 0L;
        } else if (boIdValue instanceof Integer) {
            isNotEqualsZero = (Integer)boIdValue != 0;
            LOGGER.info("boIdValue:{} is Integer", boIdValue);
        }
        if (isNotEqualsZero && !ORM.create().exists(this.getModel().getDataEntityType().getName(), boIdValue)) {
            throw new KDBizException(BosErrorCode.operationFailed, new Object[]{ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"HisLineTimeTplFormEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])});
        }
    }

    private String getFromPage() {
        String fromPage = (String)this.getView().getFormShowParameter().getCustomParam("fromPage");
        return fromPage;
    }

    private boolean getRefreshReadOnly() {
        return "open_data_page".equals(this.getAction());
    }

    private String getAction() {
        String action = (String)this.getView().getFormShowParameter().getCustomParam("his_action");
        return action;
    }

    private void setReviseRecord() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("existReviseRecord")) {
            boolean existReviseRecord = (Boolean)this.getView().getFormShowParameter().getCustomParam("existReviseRecord");
            if (!existReviseRecord) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_reviserecord"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_reviserecord"});
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        HisLineTimeChangeTitleService.getInstance().setCaptionForPreOpenForm(e.getFormShowParameter());
    }

    private void processAttachmentFields(OperateOption operateOption) {
        String pageId;
        if (operateOption == null) {
            return;
        }
        String entityNumber = this.getView().getEntityId();
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        IDataEntityType dataEntityType = this.getModel().getDataEntity().getDataEntityType();
        if (dataEntityType == null) {
            return;
        }
        String billNo = "";
        String numberFiled = ((BillEntityType)dataEntityType).getBillNo();
        if (dataEntityType instanceof BillEntityType && HRStringUtils.isNotEmpty((String)numberFiled)) {
            billNo = this.getModel().getDataEntity().getString(numberFiled);
        }
        if (HRStringUtils.isEmpty((String)(pageId = this.getView().getPageId()))) {
            return;
        }
        HisAttachmentFiledService.getInstance().persistAttachments(operateOption, entityNumber, billNo, pageId, null, new DynamicObject[]{this.getModel().getDataEntity()});
    }
}

