/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.DynamicTextColumnDesc;
import kd.bos.entity.property.ComboProp;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hbp.formplugin.web.newhismodel.pluginservice.HisModelF7TplListServise;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisLineF7FilterHandler;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelListCommonTool;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisShowFormHandler;

public class HisModelF7TplListPlugin
extends HRDataBaseList
implements HisLineTimeTplConstants,
HisFieldNameConstants {
    private static final Log LOGGER = LogFactory.getLog(HisModelF7TplListPlugin.class);
    private final Map<String, Date> changeDateMap = Maps.newHashMapWithExpectedSize((int)5);
    private Map<Object, DynamicObject> currentDataMap;
    private final HisModelF7TplListServise hisModelF7TplListServise = HisModelF7TplListServise.getInstance();
    private boolean boolFilterStyle = false;
    private boolean isHisFieldF7;
    private static final String BTN_BUSINESS_EXAMPLE = "businessexample";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_BUSINESS_EXAMPLE});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)BTN_BUSINESS_EXAMPLE)) {
            HisShowFormHandler.getInstance().openF7BsExample(this.getView());
        }
    }

    public void initialize() {
        super.initialize();
        this.isHisFieldF7 = this.isHisFieldF7();
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        this.isHisFieldF7 = this.isHisFieldF7();
        if (this.isHisFieldF7) {
            String filterStyle = this.hisModelF7TplListServise.getFilterStyle(this.getView());
            this.boolFilterStyle = HRStringUtils.equals((String)filterStyle, (String)"2");
            if (this.boolFilterStyle) {
                this.handleBeforePackageData(event);
            }
            return;
        }
        if (!this.hisModelF7TplListServise.isLookup(this.getView()) || HisLineF7FilterHandler.getInstance().isBusinessF7(this.getView())) {
            return;
        }
        this.handleBeforePackageData(event);
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        if (this.isHisFieldF7 && this.boolFilterStyle) {
            this.handlePackageData(e);
            return;
        }
        if (!this.hisModelF7TplListServise.isLookup(this.getView()) || HisLineF7FilterHandler.getInstance().isBusinessF7(this.getView())) {
            return;
        }
        this.handlePackageData(e);
    }

    public void beforeBindData(EventObject e) {
        ListShowParameter listParameter;
        Object isShowDisableData;
        Boolean showDisableData;
        super.beforeBindData(e);
        if (!this.hisModelF7TplListServise.isLookup(this.getView())) {
            return;
        }
        if (this.isHisFieldF7) {
            String filterStyle = this.hisModelF7TplListServise.getFilterStyle(this.getView());
            this.getModel().setValue("versiondatafilter", (Object)(!HRStringUtils.equals((String)filterStyle, (String)"1") ? 1 : 0));
        }
        if ((showDisableData = (Boolean)Optional.ofNullable(isShowDisableData = (listParameter = (ListShowParameter)this.getView().getFormShowParameter()).getCustomParam("isShowDisableData")).orElse(Boolean.FALSE)).booleanValue() && this.isPageStart()) {
            this.getModel().setValue("isshowdisabled", (Object)Boolean.TRUE);
        }
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        if (!this.hisModelF7TplListServise.isLookup(this.getView())) {
            return;
        }
        if (this.isHisFieldF7) {
            String filterStyle = this.hisModelF7TplListServise.getFilterStyle(this.getView());
            this.hisModelF7TplListServise.showDateField(filterStyle, this.getView(), this.getModel(), true);
            this.getView().setVisible(Boolean.FALSE, new String[]{"effectdate_flex"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"filterstyletip"});
            return;
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"filterstyletip", "filterstyleflexap"});
        HisLineF7FilterHandler handler = HisLineF7FilterHandler.getInstance();
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (handler.isBusinessF7(this.getView())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"effectdate", "effectdaterange"});
        } else {
            Object isShowEffDateControl = listParameter.getCustomParam("isShowEffDateControl");
            if (((Boolean)Optional.ofNullable(isShowEffDateControl).orElse(true)).booleanValue()) {
                String effDateFieldType = (String)listParameter.getCustomParam("effDateFieldType");
                if (HRStringUtils.equals((String)effDateFieldType, (String)"effDateRange")) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"effectdate"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"effectdaterange"});
                    this.getView().updateView("effectdaterange");
                    Date dateStart = handler.transDate(listParameter.getCustomParam("effdatestart"));
                    Date dateEnd = handler.transDate(listParameter.getCustomParam("effdateend"));
                    if (dateStart != null && dateEnd != null) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"effectdaterange"});
                    }
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{"effectdaterange"});
                    this.getView().setVisible(Boolean.TRUE, new String[]{"effectdate"});
                    this.getView().updateView("effectdate");
                    Date customEffDate = handler.transDate(listParameter.getCustomParam("effectdate"));
                    if (customEffDate != null) {
                        this.getView().setEnable(Boolean.FALSE, new String[]{"effectdate"});
                    }
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"effectdate", "effectdaterange"});
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("columnResizeMode", "fit");
            this.getView().updateControlMetadata("gridview", map);
        }
    }

    private boolean isPageStart() {
        String isPageStart = this.getPageCache().get("isPageStart");
        return !"0".equals(isPageStart);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        if (!this.hisModelF7TplListServise.isLookup(this.getView())) {
            return;
        }
        List filterColumns = args.getCommonFilterColumns();
        CommonFilterColumn filterColumn = new CommonFilterColumn();
        filterColumn.setFieldName("datastatus");
        filterColumn.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7248\u672c\u72b6\u6001", (String)"HisLineTimeTplListPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        String billFormId = ((ListView)this.getView()).getListModel().getDataEntityType().getName();
        ArrayList combos = new ArrayList();
        List valueMapItemList = ((ComboProp)EntityMetadataCache.getDataEntityType((String)billFormId).getFields().get("datastatus")).getComboItems();
        valueMapItemList.removeIf(item -> EnumHisDataVersionStatus.REVISED.getStatus().equals(item.getValue()));
        valueMapItemList.forEach(valueMapItem -> {
            ComboItem item = new ComboItem();
            item.setCaption(valueMapItem.getName());
            item.setValue(valueMapItem.getValue());
            combos.add(item);
        });
        filterColumn.setComboItems(combos);
        ArrayList defaultValues = Lists.newArrayListWithCapacity((int)16);
        defaultValues.add(EventOperateEnums.CHANGE_BEFORE_STATUS_TEMP.getValue());
        defaultValues.add(EventOperateEnums.CHANGE_BEFORE_STATUS_TOBEEFFECT.getValue());
        defaultValues.add(EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue());
        defaultValues.add(EventOperateEnums.CHANGE_BEFORE_STATUS_INVALIDED.getValue());
        filterColumn.setDefaultValues((List)defaultValues);
        filterColumn.setMulti(true);
        filterColumn.setMustInput(false);
        filterColumn.setCustom(true);
        filterColumns.add(filterColumn);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        if (this.isHisFieldF7) {
            String filterStyle = this.hisModelF7TplListServise.getFilterStyle(this.getView());
            if (HRStringUtils.equals((String)filterStyle, (String)"1")) {
                this.hisModelF7TplListServise.createBusF7ListColumn(args);
            } else {
                this.hisModelF7TplListServise.createVerF7ListColumn(args, this.getView());
            }
            return;
        }
        if (this.hisModelF7TplListServise.isLookup(this.getView())) {
            String isPageStart = this.getPageCache().get("isPageStart");
            if (isPageStart == null) {
                this.getPageCache().put("isPageStart", "1");
            } else {
                this.getPageCache().put("isPageStart", "0");
            }
            this.hisModelF7TplListServise.createF7ListColumn(args, this.getView());
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        if (!this.hisModelF7TplListServise.isLookup(this.getView())) {
            return;
        }
        List basedataCoreQFilters = event.getBasedataCoreQFilters();
        basedataCoreQFilters.removeIf(filter -> HRStringUtils.equals((String)filter.getProperty(), (String)"datastatus") || HRStringUtils.equals((String)filter.getProperty(), (String)"iscurrentversion"));
        List qFilters = event.getQFilters();
        if (this.isHisFieldF7) {
            String filterStyle = this.hisModelF7TplListServise.getFilterStyle(this.getView());
            if (HRStringUtils.equals((String)filterStyle, (String)"1")) {
                this.hisModelF7TplListServise.buildBusFilter(qFilters);
            } else {
                this.hisModelF7TplListServise.buildVerFilter(qFilters, this.getModel(), this.getView().getPageCache());
            }
            return;
        }
        if (!HisLineF7FilterHandler.getInstance().isBusinessF7(this.getView())) {
            List<QFilter> currentQFilters;
            String formId = ((IListView)this.getView()).getListModel().getDataEntityType().getName();
            HisModelListCommonTool.changeHisListBdQFilter(formId, event.getQFilters());
            HisModelListCommonTool.changeHisListBdQFilter(formId, event.getBasedataCoreQFilters());
            Boolean isShowCurrentNumAndName = (Boolean)this.getView().getFormShowParameter().getCustomParam("isShowCurrentNumAndName");
            if (isShowCurrentNumAndName != null && isShowCurrentNumAndName.booleanValue() && (currentQFilters = event.getQFilters().stream().filter(qFilter -> qFilter != null && "ftlike".equals(qFilter.getCP())).collect(Collectors.toList())).size() > 0) {
                IListView view = (IListView)this.getView();
                HRBaseServiceHelper helper = new HRBaseServiceHelper(view.getListModel().getDataEntityType().getName());
                QFilter versionQFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
                currentQFilters.add(versionQFilter);
                DynamicObjectCollection boCol = helper.queryOriginalCollection("id", currentQFilters.toArray(new QFilter[0]));
                QFilter newSearchFilter = new QFilter("boid", "in", boCol.stream().map(bo -> bo.get("id")).collect(Collectors.toSet()));
                currentQFilters.forEach(qFilter -> qFilter.or(newSearchFilter));
            }
        }
        ListShowParameter listParameter = (ListShowParameter)this.getView().getFormShowParameter();
        this.hisModelF7TplListServise.initParams(listParameter, event, this.getView(), this.getModel(), this.getPageCache(), this.changeDateMap);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        ListView listView;
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String fieldKey = propertyChangedArgs.getProperty().getName();
        ChangeData[] changeSet = propertyChangedArgs.getChangeSet();
        ChangeData changeData = changeSet[0];
        if (HRStringUtils.equals((String)"effectdate", (String)fieldKey) && this.hisModelF7TplListServise.isLookup(this.getView())) {
            this.changeDateMap.put("changeDate", (Date)changeSet[0].getNewValue());
            listView = (ListView)this.getView();
            listView.refresh();
            listView.clearSelection();
        } else if (HRStringUtils.equals((String)"effdatestart", (String)fieldKey) && this.hisModelF7TplListServise.isLookup(this.getView())) {
            this.changeDateMap.put("changeDateStart", (Date)changeSet[0].getNewValue());
            listView = (ListView)this.getView();
            listView.refresh();
            listView.clearSelection();
        } else if (HRStringUtils.equals((String)"effdateend", (String)fieldKey) && this.hisModelF7TplListServise.isLookup(this.getView())) {
            this.changeDateMap.put("changeDateEnd", (Date)changeSet[0].getNewValue());
            listView = (ListView)this.getView();
            listView.refresh();
            listView.clearSelection();
        } else if (HRStringUtils.equals((String)"f7effdatestart", (String)fieldKey) && this.hisModelF7TplListServise.isLookup(this.getView())) {
            this.changeDateMap.put("f7effdatestart", (Date)changeSet[0].getNewValue());
            if (changeSet[0].getNewValue() == null) {
                this.getPageCache().put("f7effdatestart", "null");
            } else {
                this.getPageCache().put("f7effdatestart", DateUtils.dateToString((Date)((Date)changeSet[0].getNewValue()), (DatePattern)DatePattern.YYYY_MM_DD));
            }
            listView = (ListView)this.getView();
            listView.refresh();
        } else if (HRStringUtils.equals((String)"f7effdateend", (String)fieldKey) && this.hisModelF7TplListServise.isLookup(this.getView())) {
            this.changeDateMap.put("f7effdateend", (Date)changeSet[0].getNewValue());
            if (changeSet[0].getNewValue() == null) {
                this.getPageCache().put("f7effdateend", "null");
            } else {
                this.getPageCache().put("f7effdateend", DateUtils.dateToString((Date)((Date)changeSet[0].getNewValue()), (DatePattern)DatePattern.YYYY_MM_DD));
            }
            listView = (ListView)this.getView();
            listView.refresh();
        }
        if (HRStringUtils.equals((String)fieldKey, (String)"versiondatafilter")) {
            String filterStyleStr;
            boolean filterStyle = changeData.getNewValue() != null && (Boolean)changeData.getNewValue() != false;
            String string = filterStyleStr = filterStyle ? "2" : "1";
            if (customParams.containsKey("fieldName")) {
                String fieldName = (String)customParams.get("fieldName");
                IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
                if (customParams.containsKey("fromFilterGridView")) {
                    parentView.getPageCache().put(fieldName + "_fromFilterGridView", filterStyleStr);
                } else if (customParams.containsKey("fromSchemeFilterView")) {
                    parentView.getPageCache().put(fieldName + "_fromSchemeFilterView", filterStyleStr);
                }
            }
            this.hisModelF7TplListServise.showDateField(filterStyleStr, this.getView(), this.getModel(), false);
            F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
            f7SelectedList.removeAllItems();
            BillList billList = (BillList)this.getControl("billlistap");
            billList.clearSelection();
            this.getView().updateView("billlistap");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"showallversion")) {
            ListSelectedRow row = args.getListSelectedData().get(0);
            Object primaryKey = row.getPrimaryKeyValue();
            String billFormId = ((ListView)this.getView()).getBillFormId();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("hbp_showallversion");
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCaption(ResManager.loadKDString((String)"\u67e5\u770b\u6240\u6709\u7248\u672c", (String)"HisModelF7TplListPlugin_10", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            showParameter.setCustomParam("billFormId", (Object)billFormId);
            showParameter.setCustomParam("primaryKey", primaryKey);
            this.getView().showForm(showParameter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"showallversion")) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void handleBeforePackageData(BeforePackageDataEvent event) {
        Set boIds = event.getPageData().stream().map(data -> data.get("boid")).collect(Collectors.toSet());
        LOGGER.info("handleBeforePackageData.boids = {}", (Object)boIds.toString());
        String formId = ((IListView)this.getView()).getListModel().getDataEntityType().getName();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(formId);
        DynamicObjectCollection currentData = helper.queryOriginalCollection("id, number, name", new QFilter[]{new QFilter("id", "in", boIds)});
        this.currentDataMap = currentData.stream().collect(Collectors.toMap(data -> data.get("id"), data -> data, (oldValue, newValue) -> oldValue));
    }

    private void handlePackageData(PackageDataEvent e) {
        if (e.getSource() instanceof DynamicTextColumnDesc) {
            DynamicTextColumnDesc col = (DynamicTextColumnDesc)e.getSource();
            Object boId = e.getRowData().get("boid");
            if ("currentnumforhis".equals(col.getKey())) {
                if (this.currentDataMap.get(boId) != null) {
                    e.setFormatValue(this.currentDataMap.get(boId).get("number"));
                }
            } else if ("currentnameforhis".equals(col.getKey()) && this.currentDataMap.get(boId) != null) {
                e.setFormatValue(this.currentDataMap.get(boId).get("name"));
            }
        }
    }

    private boolean isHisFieldF7() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        LOGGER.info("HisModelF7TplListPlugin.hisFieldFilterFlag excute info : customParams = {}", (Object)customParams.toString());
        return (customParams.containsKey("isFromCommonFilterColumn") || customParams.containsKey("isFromSchemeFilterColumn")) && customParams.containsKey("isHisVersionField") && this.getView().getControl("versiondatafilter") != null;
    }
}

