/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel.bd;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.bdctrl.BaseDataListPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.mvc.list.AbstractListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.domain.util.HisHandleBuUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.constants.newhismodel.HisSysConstants;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisBaseDataListPlugin
extends BaseDataListPlugin
implements HisLineTimeTplConstants,
HisSysConstants {
    private static final String CREATEORG = "createorg";
    private static final String USEORGID = "useorgId";
    private static final String ISPERSONALIZEDATA = "isPersonalizeData";
    private static final String TBLUNASSIGN_SEARCH = "tblunassign_search_his";
    private static final String ASSIGN_QUERY_CALLBACK = "assignQueryCallBack";
    private static final String PAGE_HIS_BD_UNASSIGN_QUERY = "his_bd_unassign_query";
    private final Set<String> hisLineOpKeys = Stream.of("his_modify", "his_copy", "his_delete", "confirmchange", "confirmchangenoaudit").collect(Collectors.toSet());
    private final Set<String> hisNoneLineOpKeys = Stream.of("deletehis", "audithisconfirmchange").collect(Collectors.toSet());

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        String option = (String)this.getView().getFormShowParameter().getCustomParam("option");
        if (!HRStringUtils.equals((String)option, (String)"showhisversion")) {
            super.filterContainerSearchClick(args);
            return;
        }
        this.getPageCache().put("isSwitchedMultiOrg", "1");
        super.filterContainerSearchClick(args);
    }

    public void afterBindData(EventObject e) {
        String hisInfoList;
        String option;
        super.afterBindData(e);
        if (this.isHisLine() ? !HRStringUtils.equals((String)(option = (String)this.getView().getFormShowParameter().getCustomParam("option")), (String)"showhisversion") : !HRStringUtils.equals((String)(hisInfoList = (String)this.getView().getFormShowParameter().getCustomParam("hisinfolist")), (String)"hisinfolist")) {
            return;
        }
        Object isPersonalizeData = this.getView().getFormShowParameter().getCustomParam(ISPERSONALIZEDATA);
        String useOrgID = (String)this.getView().getFormShowParameter().getCustomParam(USEORGID);
        HRPageCache pageCache = new HRPageCache(this.getPageCache());
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap == null) {
            customParamMap = Maps.newHashMapWithExpectedSize((int)16);
        }
        customParamMap.put(ISPERSONALIZEDATA, isPersonalizeData);
        customParamMap.put(USEORGID, useOrgID);
        pageCache.put("customParamMap", (Object)customParamMap);
        String createOrg = (String)this.getView().getFormShowParameter().getCustomParam(CREATEORG);
        if (HRStringUtils.isNotEmpty((String)createOrg)) {
            pageCache.put("createOrg", (Object)Long.valueOf(createOrg));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String option;
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        this.getPageCache().put("itemKey", itemKey);
        Long orgId = null;
        if (HRStringUtils.isNotEmpty((String)this.getPageCache().get("createOrg"))) {
            orgId = Long.valueOf(this.getPageCache().get("createOrg"));
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        String entityName = this.getEntityNumber();
        if (HRStringUtils.equals((String)itemKey, (String)TBLUNASSIGN_SEARCH)) {
            this.beforeItemClickUNAssignSearch(evt, orgId, appId, entityName);
        }
        if (!HRStringUtils.equals((String)(option = (String)this.getView().getFormShowParameter().getCustomParam("option")), (String)"showhisversion")) {
            return;
        }
        if (this.isHisLine() && "insertdatabtn".equals(itemKey) && this.stopOp()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53d8\u66f4\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"HisBaseDataListPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (HRStringUtils.equals((String)evt.getItemKey(), (String)TBLUNASSIGN_SEARCH)) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            this.showAssignForm(rows, PAGE_HIS_BD_UNASSIGN_QUERY);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (this.isHisLine()) {
            String option;
            if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"his_disable")) {
                String useOrgID = this.getPageCache().get("createOrg");
                operate.getOption().setVariableValue("createOrg", useOrgID);
            }
            if (!HRStringUtils.equals((String)(option = (String)this.getView().getFormShowParameter().getCustomParam("option")), (String)"showhisversion")) {
                return;
            }
            if (this.hisLineOpKeys.contains(operate.getOperateKey()) && this.stopOp()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53d8\u66f4\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"HisBaseDataListPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else {
            String hisInfoList = (String)this.getView().getFormShowParameter().getCustomParam("hisinfolist");
            if (!HRStringUtils.equals((String)hisInfoList, (String)"hisinfolist")) {
                return;
            }
            if (this.hisNoneLineOpKeys.contains(operate.getOperateKey()) && this.stopOp()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u53d8\u66f4\u975e\u672c\u7ec4\u7ec7\u521b\u5efa\u7684\u6570\u636e\u3002", (String)"HisBaseDataListPlugin_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String callBackId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (("permChangeCallBack".equals(callBackId) || ASSIGN_QUERY_CALLBACK.equals(callBackId)) && null != returnData || "personalizeData".equals(callBackId)) {
            String entity = ((AbstractListView)this.getView()).getBillFormId();
            entity = FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
            if ("permChangeCallBack".equals(callBackId)) {
                Set ids = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
                HRBaseServiceHelper helper = new HRBaseServiceHelper(entity);
                DynamicObject[] dataCol = helper.query("id, org, createorg, ctrlstrategy", new QFilter[]{new QFilter("id", "in", ids)});
                String itemKey = this.getPageCache().get("itemKey");
                if (HRStringUtils.equals((String)itemKey, (String)"bdctrlchange")) {
                    HisHandleBuUtil.modifyCtrlStrategyForAllVersion((DynamicObject[])dataCol);
                } else if (HRStringUtils.equals((String)itemKey, (String)"orgpermchange")) {
                    HisHandleBuUtil.modifyCreateBuForAllVersion((DynamicObject[])dataCol);
                }
            }
            BillList billList = (BillList)this.getControl("billlistap");
            billList.clearSelection();
            ((IListView)this.getView()).refresh();
            if (!BaseDataCommonService.isNewModel((String)entity)) {
                billList.refresh();
            }
        }
    }

    private boolean isHisLine() {
        return EntityMetadataCache.getDataEntityType((String)((ListView)this.getView()).getBillFormId()).getAllFields().containsKey("bsed");
    }

    @ExcludeFromJacocoGeneratedReport
    private void beforeItemClickUNAssignSearch(BeforeItemClickEvent evt, Long orgid, String appId, String entityName) {
        int permRes = PermissionServiceHelper.checkPermission((long)RequestContext.get().getCurrUserId(), (String)"DIM_ORG", (long)orgid, (String)appId, (String)entityName, (String)"80513208000000ac");
        if (0 == permRes) {
            String caption = FormMetadataCache.getFormConfig((String)entityName).getCaption().getLocaleValue();
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c%s\u201d\u7684\u201c\u672a\u5206\u914d\u67e5\u8be2\u201d\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"HisBaseDataListPlugin_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), caption));
            evt.setCancel(true);
            return;
        }
        if (!this.checkCtrlStrategy()) {
            evt.setCancel(true);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void showAssignForm(ListSelectedRowCollection rows, String fromId) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        ArrayList ids = new ArrayList(rows.size());
        rows.forEach(row -> ids.add((Long)row.getPrimaryKeyValue()));
        params.put("ids", ids);
        params.put("useOrgId", Long.valueOf(this.getPageCache().get("createOrg")));
        params.put("entityNumber", this.getEntityNumber());
        String appId = this.getView().getFormShowParameter().getAppId();
        params.put("appId", appId);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, ASSIGN_QUERY_CALLBACK);
        this.showForm(fromId, params, callBack, ShowType.Modal);
    }

    @ExcludeFromJacocoGeneratedReport
    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    @ExcludeFromJacocoGeneratedReport
    private boolean checkCtrlStrategy() {
        DynamicObject view = BaseDataServiceHelper.getCtrlview((String)this.getEntityNumber());
        if (view == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u63a7\u5236\u7b56\u7565\u7684\u7ba1\u63a7\u89c6\u56fe\u5931\u8d25\uff0c \u8bf7\u5728\u201c\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u201d\u4e2d\u5148\u914d\u7f6e\u65b0\u589e\u3002", (String)"BaseDataListPlugin_24", (String)"bos-bd-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private String getEntityNumber() {
        String entity = ((AbstractListView)this.getView()).getBillFormId();
        entity = FormMetadataCache.getFormConfig((String)entity).getEntityTypeId();
        return entity;
    }

    private boolean stopOp() {
        String useOrgID = (String)this.getView().getFormShowParameter().getCustomParam(USEORGID);
        String createOrgId = (String)this.getView().getFormShowParameter().getCustomParam(CREATEORG);
        if (HRStringUtils.isNotEmpty((String)createOrgId) && HRStringUtils.isNotEmpty((String)useOrgID)) {
            return !createOrgId.equals(useOrgID);
        }
        return false;
    }
}

