/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel.pluginservice;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.SortType;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.list.BillList;
import kd.bos.list.DynamicTextListColumn;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListColumn;
import kd.bos.list.ListColumnGroup;
import kd.bos.list.ListOperationColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.domain.service.impl.newhismodel.hisversion.HisVersionReviseService;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EventOperateEnums;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisLineF7FilterHandler;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisModelListCommonTool;

public class HisModelF7TplListServise
implements HisLineTimeTplConstants,
HisFieldNameConstants {
    public static final String SHOW_DISABLE = "isshowdisabled";
    public static final String HIS_BUS_FIELD_GRP = "hisBusinessFieldsGroup";
    public static final String CUR_FIELD_GRP = "currentFieldsGroup";
    public static final String GRID_VIEW = "gridview";
    public static final String FSEQ = "fseq";
    public static final String F7_EFFDATE_START = "f7effdatestart";
    public static final String F7_EFFDATE_END = "f7effdateend";
    public static final String KEY = "key";
    public static final String CAPTION = "caption";
    public static final String FIELD_NAME = "fieldName";
    public static final String F7_EFFDATE_RANGE = "f7effectdaterange";
    public static final String IS_SHOW_CUR_NUM_AND_NAME = "isShowCurrentNumAndName";
    public static final String VERSION_DATA_FILTER = "versiondatafilter";
    public static final String IS_PAGE_START = "isPageStart";
    private static volatile HisModelF7TplListServise hisModelF7TplListServise = null;
    private static final Log LOGGER = LogFactory.getLog(HisModelF7TplListServise.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisModelF7TplListServise getInstance() {
        if (hisModelF7TplListServise != null) return hisModelF7TplListServise;
        Class<HisVersionReviseService> clazz = HisVersionReviseService.class;
        synchronized (HisVersionReviseService.class) {
            if (hisModelF7TplListServise != null) return hisModelF7TplListServise;
            hisModelF7TplListServise = new HisModelF7TplListServise();
            // ** MonitorExit[var0] (shouldn't be in output)
            return hisModelF7TplListServise;
        }
    }

    public void createVerF7ListColumn(BeforeCreateListColumnsArgs args, IFormView view) {
        List columnList = args.getListColumns();
        if (args.getListGroupColumns().stream().anyMatch(group -> HRStringUtils.equals((String)HIS_BUS_FIELD_GRP, (String)group.getKey()) || HRStringUtils.equals((String)CUR_FIELD_GRP, (String)group.getKey()))) {
            return;
        }
        Set keySet = Stream.of("issyspreset", "firstbsed", "ismodify").collect(Collectors.toSet());
        args.getListColumns().removeIf(column -> keySet.contains(column.getListFieldKey()));
        ArrayList businessColumns = Lists.newArrayListWithCapacity((int)args.getListColumns().size());
        for (IListColumn col2 : args.getListColumns()) {
            col2.setFixed(false);
            if (!HRStringUtils.equals((String)GRID_VIEW, (String)col2.getParentViewKey()) || col2.getVisible() == 0 || HRStringUtils.equals((String)FSEQ, (String)col2.getFieldName())) continue;
            HashMap<String, String> map2 = new HashMap<String, String>(16);
            map2.put(KEY, col2.getListFieldKey());
            map2.put(CAPTION, col2.getCaption().getLocaleValue());
            businessColumns.add(map2);
        }
        args.getListColumns().removeIf(col -> !HRStringUtils.equals((String)FSEQ, (String)col.getFieldName()) && HRStringUtils.equals((String)GRID_VIEW, (String)col.getParentViewKey()) && col.getVisible() != 0);
        this.addVersionNumAndBoIdCol(columnList, view, false);
        businessColumns.forEach(map -> {
            ListColumn col = HisModelListCommonTool.createListColumn((String)map.get(KEY), (String)map.get(CAPTION), (Container)view.getControl(GRID_VIEW));
            columnList.add(col);
        });
        this.addVersionF7Col(columnList, view);
        this.addHisGroup(args, view);
        this.addCurrentGroup(args, view);
    }

    public void createBusF7ListColumn(BeforeCreateListColumnsArgs args) {
        List columnList = args.getListColumns();
        this.addOperationCol(columnList);
    }

    private void addOperationCol(List<IListColumn> columnList) {
        ListOperationColumn colOperate = new ListOperationColumn();
        ArrayList items = Lists.newArrayListWithCapacity((int)16);
        OperationColItem operationColItem = new OperationColItem();
        operationColItem.setOperationName(new LocaleString(ResManager.loadKDString((String)"\u67e5\u770b\u6240\u6709\u7248\u672c", (String)"HisModelF7TplListService_8", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        operationColItem.setOperationKey("showallversion");
        operationColItem.setVisible(true);
        items.add(operationColItem);
        colOperate.setOperationColItems((List)items);
        colOperate.setVisible(63);
        colOperate.setName(new LocaleString(ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"HisModelF7TplListService_9", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        colOperate.setCaption(new LocaleString(ResManager.loadKDString((String)"\u64cd\u4f5c", (String)"HisModelF7TplListService_9", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        colOperate.setKey("listoperatecol");
        colOperate.setSeq(2);
        columnList.add((IListColumn)colOperate);
    }

    public void addVersionNumAndBoIdCol(List<IListColumn> columnList, IFormView view, boolean showVersionNum) {
        columnList.forEach(column -> column.setOrder(SortType.NotOrder.name()));
        ListColumn colBoId = HisModelListCommonTool.createListColumn("boid", ResManager.loadKDString((String)"\u4e1a\u52a1ID", (String)"HisModelF7TplListService_10", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)view.getControl(GRID_VIEW));
        colBoId.setVisible(0);
        colBoId.setOrder(SortType.ASC.name());
        columnList.add((IListColumn)colBoId);
        ListColumn colVersion = HisModelListCommonTool.createListColumn("hisversion", ResManager.loadKDString((String)"\u7248\u672c\u53f7", (String)"HisModelF7TplListService_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)view.getControl(GRID_VIEW));
        if (!showVersionNum) {
            colVersion.setVisible(0);
        }
        columnList.add(0, (IListColumn)colVersion);
    }

    public void addVersionF7Col(List<IListColumn> columnList, IFormView view) {
        if (columnList.stream().noneMatch(column -> HRStringUtils.equals((String)column.getListFieldKey(), (String)"bsed"))) {
            ListColumn colBsed = HisModelListCommonTool.createListColumn("bsed", ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"HisModelF7TplListService_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)view.getControl(GRID_VIEW));
            columnList.add((IListColumn)colBsed);
        }
        if (columnList.stream().noneMatch(column -> HRStringUtils.equals((String)column.getListFieldKey(), (String)"bsled"))) {
            ListColumn colBsled = HisModelListCommonTool.createListColumn("bsled", ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f", (String)"HisModelF7TplListService_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)view.getControl(GRID_VIEW));
            columnList.add((IListColumn)colBsled);
        }
        if (columnList.stream().noneMatch(column -> HRStringUtils.equals((String)column.getListFieldKey(), (String)"datastatus"))) {
            ListColumn colDataStatus = HisModelListCommonTool.createListColumn("datastatus", ResManager.loadKDString((String)"\u7248\u672c\u72b6\u6001", (String)"HisModelF7TplListService_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), (Container)view.getControl(GRID_VIEW));
            columnList.add((IListColumn)colDataStatus);
        }
    }

    private void addHisGroup(BeforeCreateListColumnsArgs args, IFormView view) {
        LocaleString displayName = ((IListView)view).getListModel().getDataEntityType().getDisplayName();
        ListColumnGroup hisGroup = new ListColumnGroup();
        hisGroup.setKey(HIS_BUS_FIELD_GRP);
        hisGroup.setName(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u7248\u672c", (String)"HisModelF7TplListService_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), displayName.getLocaleValue())));
        hisGroup.setParentViewKey(GRID_VIEW);
        hisGroup.setVisible(11);
        args.getListColumns().forEach(col -> {
            if (HRStringUtils.equals((String)FSEQ, (String)col.getFieldName()) || HRStringUtils.equals((String)"boid", (String)col.getFieldName())) {
                return;
            }
            col.setParentViewKey(HIS_BUS_FIELD_GRP);
            col.setParent((Container)hisGroup);
            if (col instanceof ListColumn) {
                hisGroup.getItems().add((ListColumn)col);
            }
        });
        args.addListColumnGroup(hisGroup);
    }

    private void addCurrentGroup(BeforeCreateListColumnsArgs args, IFormView view) {
        LocaleString displayName = ((IListView)view).getListModel().getDataEntityType().getDisplayName();
        ListColumnGroup currentGroup = new ListColumnGroup();
        currentGroup.setKey(CUR_FIELD_GRP);
        currentGroup.setName(displayName);
        currentGroup.setParentViewKey(GRID_VIEW);
        currentGroup.setVisible(11);
        DynamicTextListColumn currentName = this.createDynamicListColumn("currentnameforhis", ResManager.loadKDString((String)"\u540d\u79f0", (String)"HisModelF7TplListService_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        currentName.setParent((Container)currentGroup);
        args.getListColumns().add(0, currentName);
        DynamicTextListColumn currentNum = this.createDynamicListColumn("currentnumforhis", ResManager.loadKDString((String)"\u7f16\u7801", (String)"HisModelF7TplListService_7", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        currentNum.setParent((Container)currentGroup);
        args.getListColumns().add(0, currentNum);
        currentGroup.getItems().add(currentNum);
        currentGroup.getItems().add(currentName);
        args.addListColumnGroup(currentGroup);
    }

    private DynamicTextListColumn createDynamicListColumn(String key, String caption) {
        DynamicTextListColumn dyCol = new DynamicTextListColumn();
        dyCol.setCaption(new LocaleString(caption));
        dyCol.setKey(key);
        dyCol.setListFieldKey(key);
        dyCol.setVisible(63);
        dyCol.setParentViewKey(CUR_FIELD_GRP);
        dyCol.setTextAlign("center");
        dyCol.setFixed(true);
        dyCol.setSeq(0);
        return dyCol;
    }

    public void initParams(ListShowParameter listParameter, SetFilterEvent event, IFormView view, IDataModel model, IPageCache pageCache, Map<String, Date> changeDateMap) {
        HisLineF7FilterHandler handler;
        List qFilters = event.getQFilters();
        BillList billList = (BillList)event.getSource();
        Map fields = billList.getEntityType().getFields();
        if (fields.containsKey("enable")) {
            boolean showDisable = false;
            if (view.getControl(SHOW_DISABLE) != null) {
                showDisable = (Boolean)model.getValue(SHOW_DISABLE);
            }
            Object isShowDisableData = listParameter.getCustomParam("isShowDisableData");
            Optional<QFilter> enableQFilter = qFilters.stream().filter(qFilter -> qFilter != null && "enable".equals(qFilter.getProperty())).findAny();
            if (showDisable || this.isPageStart(pageCache) && ((Boolean)Optional.ofNullable(isShowDisableData).orElse(false)).booleanValue()) {
                if (enableQFilter.isPresent()) {
                    enableQFilter.get().or(new QFilter("enable", "=", (Object)"0"));
                } else {
                    QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                    qFilters.add(enableFilter.or(new QFilter("enable", "=", (Object)"0")));
                }
            } else {
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                qFilters.add(enableFilter);
            }
        }
        if (fields.containsKey("status")) {
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            qFilters.add(statusFilter);
        }
        if ((handler = HisLineF7FilterHandler.getInstance()).isBusinessF7(view)) {
            handler.addBusinessF7QFilters(listParameter, qFilters);
        } else {
            handler.addVersionF7QFilters(listParameter, qFilters, view, changeDateMap);
        }
    }

    public void createF7ListColumn(BeforeCreateListColumnsArgs args, IFormView view) {
        if (HisLineF7FilterHandler.getInstance().isBusinessF7(view)) {
            return;
        }
        List columnList = args.getListColumns();
        if (args.getListGroupColumns().stream().anyMatch(group -> HRStringUtils.equals((String)HIS_BUS_FIELD_GRP, (String)group.getKey()) || HRStringUtils.equals((String)CUR_FIELD_GRP, (String)group.getKey()))) {
            return;
        }
        Set keySet = Stream.of("issyspreset", "firstbsed", "ismodify").collect(Collectors.toSet());
        args.getListColumns().removeIf(column -> keySet.contains(column.getListFieldKey()));
        Boolean isShowCurrentNumAndName = (Boolean)view.getFormShowParameter().getCustomParam(IS_SHOW_CUR_NUM_AND_NAME);
        if (isShowCurrentNumAndName != null && isShowCurrentNumAndName.booleanValue()) {
            ArrayList businessColumns = Lists.newArrayListWithCapacity((int)args.getListColumns().size());
            for (IListColumn col2 : args.getListColumns()) {
                col2.setFixed(false);
                if (!HRStringUtils.equals((String)GRID_VIEW, (String)col2.getParentViewKey()) || col2.getVisible() == 0 || HRStringUtils.equals((String)FSEQ, (String)col2.getFieldName())) continue;
                HashMap<String, String> map2 = new HashMap<String, String>(16);
                map2.put(KEY, col2.getListFieldKey());
                map2.put(CAPTION, col2.getCaption().getLocaleValue());
                businessColumns.add(map2);
            }
            args.getListColumns().removeIf(col -> !HRStringUtils.equals((String)FSEQ, (String)col.getFieldName()) && HRStringUtils.equals((String)GRID_VIEW, (String)col.getParentViewKey()) && col.getVisible() != 0);
            this.addVersionNumAndBoIdCol(columnList, view, true);
            businessColumns.forEach(map -> {
                ListColumn col = HisModelListCommonTool.createListColumn((String)map.get(KEY), (String)map.get(CAPTION), (Container)view.getControl(GRID_VIEW));
                columnList.add(col);
            });
            this.addVersionF7Col(columnList, view);
            this.addHisGroup(args, view);
            this.addCurrentGroup(args, view);
        } else {
            this.addVersionNumAndBoIdCol(columnList, view, true);
            this.addVersionF7Col(columnList, view);
        }
    }

    private boolean isPageStart(IPageCache pageCache) {
        String isPageStart = pageCache.get(IS_PAGE_START);
        return HRStringUtils.equals((String)isPageStart, (String)"1");
    }

    public void buildVerFilter(List<QFilter> qFilters, IDataModel model, IPageCache pageCache) {
        qFilters.removeIf(filter -> filter != null && HRStringUtils.equals((String)filter.getProperty(), (String)"datastatus"));
        qFilters.removeIf(filter -> filter != null && HRStringUtils.equals((String)filter.getProperty(), (String)"iscurrentversion"));
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        qFilters.add(currentVersionFilter);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.DELETED.getStatus(), EnumHisDataVersionStatus.DISCARDED.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toSet()));
        qFilters.add(dataStatusFilter);
        this.buildEffdateFilter(qFilters, model, pageCache);
    }

    private void buildEffdateFilter(List<QFilter> qFilters, IDataModel model, IPageCache pageCache) {
        String effDateStartCache;
        long dayTime;
        long current;
        Date effDateStart = (Date)model.getValue(F7_EFFDATE_START);
        Date effDateEnd = (Date)model.getValue(F7_EFFDATE_END);
        if (effDateStart == null) {
            current = System.currentTimeMillis();
            dayTime = current - (current + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
            effDateStart = new Date(dayTime);
        }
        if (effDateEnd == null) {
            current = System.currentTimeMillis();
            dayTime = current - (current + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
            effDateEnd = new Date(dayTime);
        }
        if (HRStringUtils.equals((String)(effDateStartCache = pageCache.get(F7_EFFDATE_START)), (String)"null")) {
            effDateStart = null;
        } else if (effDateStartCache != null) {
            effDateStart = DateUtils.stringToDate((String)effDateStartCache);
        }
        String effDateEndCache = pageCache.get(F7_EFFDATE_END);
        if (HRStringUtils.equals((String)effDateEndCache, (String)"null")) {
            effDateEnd = null;
        } else if (effDateStartCache != null) {
            effDateEnd = DateUtils.stringToDate((String)effDateEndCache);
        }
        if (effDateStart == null || effDateEnd == null) {
            return;
        }
        QFilter bsedFilter = new QFilter("bsed", "<=", (Object)effDateEnd).and("bsled", ">=", (Object)effDateStart);
        QFilter bsledFilter = new QFilter("bsled", "<=", (Object)effDateEnd).and("bsled", ">=", (Object)effDateStart);
        qFilters.add(bsedFilter.or(bsledFilter));
    }

    public void buildBusFilter(List<QFilter> qFilters) {
        qFilters.removeIf(filter -> filter != null && HRStringUtils.equals((String)filter.getProperty(), (String)"datastatus"));
        qFilters.removeIf(filter -> filter != null && HRStringUtils.equals((String)filter.getProperty(), (String)"iscurrentversion"));
        QFilter currentVersionFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
        qFilters.add(currentVersionFilter);
        QFilter dataStatusFilter = new QFilter("datastatus", "in", Stream.of(EventOperateEnums.CHANGE_BEFORE_STATUS_EFFECTING.getValue(), EventOperateEnums.CHANGE_BEFORE_STATUS_TOBEEFFECT.getValue()).collect(Collectors.toSet()));
        qFilters.add(dataStatusFilter);
    }

    public boolean isLookup(IFormView view) {
        boolean isLookup = false;
        if (view.getFormShowParameter() instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)view.getFormShowParameter();
            isLookup = listShowParameter.isLookUp();
        }
        return isLookup;
    }

    public String getFilterStyle(IFormView view) {
        String filterStyle = "";
        String fieldName = "";
        Map customParams = view.getFormShowParameter().getCustomParams();
        if (customParams.containsKey(FIELD_NAME)) {
            fieldName = (String)customParams.get(FIELD_NAME);
            if (customParams.containsKey("fromFilterGridView")) {
                fieldName = fieldName + "_fromFilterGridView";
            } else if (customParams.containsKey("fromSchemeFilterView")) {
                fieldName = fieldName + "_fromSchemeFilterView";
            }
            IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
            filterStyle = parentView.getPageCache().get(fieldName);
        } else {
            filterStyle = "1";
        }
        return filterStyle;
    }

    public void showDateField(String filterStyle, IFormView view, IDataModel model, boolean updateView) {
        if (HRStringUtils.equals((String)filterStyle, (String)"2")) {
            String effDateStartCache;
            long dayTime;
            long current;
            view.setVisible(Boolean.TRUE, new String[]{F7_EFFDATE_RANGE});
            Date effDateStart = (Date)model.getValue(F7_EFFDATE_START);
            Date effDateEnd = (Date)model.getValue(F7_EFFDATE_END);
            if (effDateStart == null) {
                current = System.currentTimeMillis();
                dayTime = current - (current + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
                effDateStart = new Date(dayTime);
            }
            if (effDateEnd == null) {
                current = System.currentTimeMillis();
                dayTime = current - (current + (long)TimeZone.getDefault().getRawOffset()) % 86400000L;
                effDateEnd = new Date(dayTime);
            }
            if (HRStringUtils.equals((String)(effDateStartCache = view.getPageCache().get(F7_EFFDATE_START)), (String)"null")) {
                effDateStart = null;
            } else if (effDateStartCache != null) {
                effDateStart = DateUtils.stringToDate((String)effDateStartCache);
            }
            String effDateEndCache = view.getPageCache().get(F7_EFFDATE_END);
            if (HRStringUtils.equals((String)effDateEndCache, (String)"null")) {
                effDateEnd = null;
            } else if (effDateStartCache != null) {
                effDateEnd = DateUtils.stringToDate((String)effDateEndCache);
            }
            model.setValue(F7_EFFDATE_START, (Object)effDateStart);
            model.setValue(F7_EFFDATE_END, (Object)effDateEnd);
            if (updateView) {
                view.updateView(F7_EFFDATE_RANGE);
            }
        } else {
            view.setVisible(Boolean.FALSE, new String[]{F7_EFFDATE_RANGE});
        }
    }
}

