/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel.pluginservice.impl;

import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisAttachmentTool;

public class HisLineTimeTplFormEditService {
    private static volatile HisLineTimeTplFormEditService service = null;

    private HisLineTimeTplFormEditService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisLineTimeTplFormEditService getInstance() {
        if (service != null) return service;
        Class<HisLineTimeTplFormEditService> clazz = HisLineTimeTplFormEditService.class;
        synchronized (HisLineTimeTplFormEditService.class) {
            if (service != null) return service;
            service = new HisLineTimeTplFormEditService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void setStatusForDetailPage(IFormView view, IPageCache pageCache, IDataModel dataModel, boolean needAudit, String enableStatus) {
        boolean needEdit = this.needEdit(pageCache, dataModel);
        if (!needEdit) {
            this.setBillStatusViewOrAudit(view, dataModel);
        }
        this.setPageAndCacheStatus(needEdit, needAudit, view, pageCache, dataModel);
        Boolean isCurrentVersion = (Boolean)dataModel.getValue("iscurrentversion");
        Long boid = (Long)dataModel.getValue("boid");
        if (isCurrentVersion.booleanValue() || boid == null || boid == 0L) {
            view.setVisible(Boolean.FALSE, new String[]{"hisversion"});
        }
        view.setVisible(Boolean.FALSE, new String[]{"bar_reviserecord", "changedescription"});
        IFormView parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId());
        if (parentView != null && !(parentView instanceof ListView)) {
            view.setVisible(Boolean.FALSE, new String[]{"hisversionbtn", "insertdatabtn", "bar_revise", "bar_reviserecord"});
            pageCache.put("notFromListView", "1");
        }
        this.hideBtnForEnablingData(view, dataModel);
        view.setVisible(Boolean.valueOf(needAudit && HRStringUtils.equals((String)enableStatus, (String)"10")), new String[]{"bar_unaudit"});
        view.setVisible(Boolean.FALSE, new String[]{"bar_new"});
        dataModel.setDataChanged(false);
    }

    private void setPageAndCacheStatus(boolean needEdit, boolean needAudit, IFormView view, IPageCache pageCache, IDataModel dataModel) {
        if (needEdit && view.getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            ((IBillView)view).setBillStatus(BillOperationStatus.ADDNEW);
            pageCache.put("pageStatus", "addnew");
            this.addBoView(view);
            return;
        }
        boolean isAuditPage = this.isAuditPage(needAudit, dataModel);
        if (isAuditPage) {
            this.showOpenHisListBtn(view, pageCache, dataModel);
            HisAttachmentTool.hideAttachmentsBtn(view);
            return;
        }
        IDataEntityProperty statusProp = dataModel.getProperty("status");
        if (statusProp != null) {
            String status = (String)dataModel.getValue("status");
            if (HRStringUtils.equals((String)status, (String)"A")) {
                pageCache.put("pageStatus", "edit");
                view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_saveandnew", "bar_submit"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_audit", "bar_revise"});
            } else if (HRStringUtils.equals((String)status, (String)"B")) {
                pageCache.put("pageStatus", "view");
                view.setVisible(Boolean.TRUE, new String[]{"bar_submit", "bar_audit", "bar_disable"});
                view.setVisible(Boolean.FALSE, new String[]{"bar_save"});
            }
        } else {
            pageCache.put("pageStatus", "edit");
            view.setVisible(Boolean.TRUE, new String[]{"bar_save"});
        }
        this.addBoView(view);
    }

    private void addBoView(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{"hisversionbtn", "insertdatabtn", "bsled", "changedescription"});
    }

    private void editBoView(IFormView view, IDataModel dataModel) {
        view.setVisible(Boolean.FALSE, new String[]{"hisversionbtn", "insertdatabtn", "bsled", "changedescription"});
        IDataEntityProperty statusProp = dataModel.getProperty("status");
        if (statusProp != null) {
            String status = (String)dataModel.getValue("status");
            if (HRStringUtils.equals((String)status, (String)"A")) {
                view.setVisible(Boolean.TRUE, new String[]{"bar_save"});
            } else if (HRStringUtils.equals((String)status, (String)"B")) {
                view.setVisible(Boolean.TRUE, new String[]{"bar_save", "bar_submit"});
                view.setVisible(Boolean.TRUE, new String[]{"bar_disable"});
            }
        }
    }

    private boolean isAuditPage(boolean needAudit, IDataModel dataModel) {
        boolean notEnabling;
        IDataEntityProperty enableProp = dataModel.getProperty("enable");
        boolean bl = notEnabling = enableProp == null || !HRStringUtils.equals((String)((String)dataModel.getValue("enable")), (String)"10");
        if (!notEnabling && !needAudit) {
            return false;
        }
        if (!needAudit) {
            return true;
        }
        IDataEntityProperty statusProp = dataModel.getProperty("status");
        if (statusProp == null) {
            return true;
        }
        return HRStringUtils.equals((String)((String)dataModel.getValue("status")), (String)"C");
    }

    private void showOpenHisListBtn(IFormView view, IPageCache pageCache, IDataModel dataModel) {
        HisLineTimeTplFormEditService.getInstance().setBillStatusViewOrAudit(view, dataModel);
        pageCache.put("pageStatus", "view");
        view.setVisible(Boolean.TRUE, new String[]{"hisversionbtn", "insertdatabtn", "bar_disable"});
        view.setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        Object isPersonalizeData = view.getFormShowParameter().getCustomParam("isPersonalizeData");
        if (Objects.nonNull(isPersonalizeData) && ((Boolean)isPersonalizeData).booleanValue()) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_save"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_save"});
        }
    }

    public boolean needEdit(IPageCache pageCache, IDataModel dataModel) {
        String pageStatus = pageCache.get("pageStatus");
        if ("addnew".equals(pageStatus) || "modify".equals(pageStatus) || "edit".equals(pageStatus)) {
            return true;
        }
        if ("view".equals(pageStatus)) {
            String status;
            IDataEntityProperty statusProp = dataModel.getProperty("status");
            if (statusProp != null && (HRStringUtils.equals((String)(status = (String)dataModel.getValue("status")), (String)"B") || HRStringUtils.equals((String)status, (String)"A"))) {
                return true;
            }
        } else if (pageStatus == null) {
            Long boid = (Long)dataModel.getValue("boid");
            String dataStatus = (String)dataModel.getValue("datastatus");
            boolean needEdit = boid == null || boid == 0L || dataStatus == null || EnumHisDataVersionStatus.TEMP.getStatus().equals(dataStatus);
            return needEdit;
        }
        return false;
    }

    public void setBillStatusViewOrAudit(IFormView view, IDataModel dataModel) {
        String statusField = ((BasedataEntityType)dataModel.getDataEntityType()).getBillStatus();
        if (HRStringUtils.isNotEmpty((String)statusField) && view.getFormShowParameter().getStatus() != OperationStatus.VIEW) {
            ((IBillView)view).setBillStatus(BillOperationStatus.AUDIT);
        } else {
            ((IBillView)view).setBillStatus(BillOperationStatus.VIEW);
            view.setStatus(OperationStatus.VIEW);
        }
    }

    public void hideBtnForEnablingData(IFormView view, IDataModel dataModel) {
        if (dataModel.getDataEntityType().getProperties().containsKey((Object)"enable") && HRStringUtils.equals((String)dataModel.getDataEntity().getString("enable"), (String)"10")) {
            view.setVisible(Boolean.FALSE, new String[]{"insertdatabtn", "hisversionbtn", "bar_revise", "bar_reviserecord"});
        } else if (dataModel.getDataEntityType().getProperties().containsKey((Object)"status") && HRStringUtils.equals((String)dataModel.getDataEntity().getString("status"), (String)"C")) {
            view.setVisible(Boolean.FALSE, new String[]{"bar_audit"});
        }
    }
}

