/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.newhismodel.tree;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.HisLineTimeTplFormEdit;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisShowFormHandler;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisTreeTplTool;

public class HisLineTimeTreeTplFormEdit
extends HisLineTimeTplFormEdit {
    private static final Log LOGGER = LogFactory.getLog(HisLineTimeTreeTplFormEdit.class);

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "save": 
            case "confirmchange": 
            case "confirmchangenoaudit": {
                if (args.isCancel()) break;
                this.showTreeTips(args, operateKey);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (!HRStringUtils.equals((String)event.getActionId(), (String)"hbp_histreeoptips")) {
            return;
        }
        String opNum = (String)event.getReturnData();
        if (HRStringUtils.isNotEmpty((String)opNum)) {
            this.getView().getPageCache().put("skipValidateVersionChange", "1");
            this.getView().invokeOperation(opNum);
            this.getView().getPageCache().remove("skipValidateVersionChange");
        }
    }

    private void showTreeTips(BeforeDoOperationEventArgs args, String operateKey) {
        List<Map<String, Object>> parents;
        StringBuilder tips = new StringBuilder();
        Date startDate = (Date)this.getModel().getValue("bsed");
        Date endDate = (Date)this.getModel().getValue("bsled");
        String parentLongNumber = null;
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        if (parent != null) {
            parentLongNumber = parent.getString("longnumber");
        }
        if ((parents = HisTreeTplTool.validateTreeSaveOrConfirmChange(this.getModel().getDataEntityType().getName(), operateKey, startDate, endDate, parentLongNumber, tips)) != null && !parents.isEmpty()) {
            args.setCancel(true);
            HisShowFormHandler.getInstance().openTreeConfirmOpTips(this.getView(), tips.toString(), SerializationUtils.toJsonString(parents), (IFormPlugin)this);
        }
    }
}

