/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.org.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.tree.TreeNodeLabel;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.events.EnableCustomSumEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.QueryEntityServiceHelper;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.constants.org.OrgTreeSearchParam;
import kd.hr.hbp.common.model.AuthorizedOrgResultWithSub;
import kd.hr.hbp.common.model.OrgSubInfo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;
import kd.hr.hbp.formplugin.web.org.structproject.imp.AdminOrgSpProcessor;
import kd.hr.hbp.formplugin.web.org.template.TreeListTemplateBase;
import kd.hr.hbp.formplugin.web.org.util.TreeNodeNameSetter;
import org.apache.commons.collections4.trie.PatriciaTrie;

@ExcludeFromJacocoGeneratedReport
public class AdminOrgTreeListTemplate
extends TreeListTemplateBase {
    private static final String CUR_TREE_ROOT_STRUCT_FIELDS = "adminorg.id id, adminorg.boid boid,adminorg.name name, structlongnumber, adminorg.enable enable,adminorg.tobedisableflag tobedisableflag,adminorg.sourcevid sourcevid,''  parentorg, parentorg.sourcevid psourcevid, adminorg.isvirtualorg isvirtualorg";
    private static final String HIS_TREE_ROOT_STRUCT_FIELDS = "adminorg.id id, adminorg.id boid,adminorg.name name, adminorg.number number,structlongnumber, adminorg.enable enable,adminorg.tobedisableflag tobedisableflag, adminorg.isvirtualorg isvirtualorg";
    private static final String CUR_SUB_TREE_STRUCT_FIELDS = "adminorg.id id, adminorg.boid boid, adminorg.name name, adminorg.sourcevid sourcevid, parentorg.sourcevid psourcevid,parentorg.id parentorg, structlongnumber, isleaf, adminorg.enable enable,adminorg.tobedisableflag tobedisableflag, adminorg.isvirtualorg isvirtualorg";
    private static final String CUR_SUB_TREE_FIELDS = " id, boid , name , parentorg,'' isleaf, structlongnumber, enable, tobedisableflag";
    public static final long NO_DATA_ROOT_ID = -1L;
    public static final long NO_PARENT_ROOT_ID = -2L;
    public static final String PARENT_ORG = "parentorg";
    public static final String SELECT_ALL_TREENODE = "select_all_treenode";
    public static final String STRUCT_LONG_NUMBER = "structlongnumber";
    private TreeNodeNameSetter treeNodeNameSetter;
    private Boolean companySuffixVisible;
    protected String isvirtualorg;

    public AdminOrgTreeListTemplate(OrgTreeModel orgTeamTreeModel) {
        super(orgTeamTreeModel, "adminOrg", PARENT_ORG, "adminorg.boid");
        this.orgStructNumberProperty = orgTeamTreeModel.isHisTree() ? "adminorg.structnumber" : "structnumber";
        this.setStructProjectCapable(new AdminOrgSpProcessor());
        this.queryHisTreeDateCount = 8;
        this.initHisSql();
        this.initTreeOrderBys();
        this.treeNodeNameSetter = new TreeNodeNameSetter();
    }

    private void initTreeOrderBys() {
        String treeOrderBys = this.getTreeOrderBys();
        if (StringUtils.isEmpty((CharSequence)treeOrderBys)) {
            this.setSubTreeOrderBys("sortcode");
        }
    }

    private void initHisSql() {
        this.hisSubFiledFromSql.append("select A.fid as id, A.fboid as boid,A.fnumber as number, AA.ftobedisableflag AS tobedisableflag,").append(" A.fisvirtualorg AS isvirtualorg, ").append(" CASE WHEN AL.fname IS NULL THEN A.fname WHEN AL.fname = '' THEN A.fname WHEN AL.fname = ' ' THEN A.fname ELSE AL.fname END as name").append(" ,B.fstructlongnumber as structlongnumber, A.fenable as enable, A1.fid as  parentorg, B.fisleaf as isleaf , S.fsortcode as sortcode").append("  FROM  T_HAOS_ADMINORG A LEFT JOIN T_HAOS_ADMINORG_A AA ON A.FID=AA.FID inner join  T_HAOS_ADMINSTRUCT B on A.fboid = B.fadminorgid ").append("  LEFT JOIN T_HAOS_ADMINORG_L AL ON (A.FId = AL.FId AND AL.FLOCALEID = ?) ").append("  LEFT JOIN T_HAOS_ADMINORG A1 on B.fparentid = A1.fboid ").append(" AND A1.fiscurrentversion = '0' AND A1.fdatastatus in ('1','2') AND A1.finitstatus = '2' AND A1.fbsed <= ? AND A1.fbsled >= ?").append("  LEFT JOIN T_HAOS_ORGSORTCODE S on S.FADMINORGID = A.fboid ").append(" AND S.fbsed <= ?  AND S.fbsled >= ?  AND S.fiscurrentversion = '0'  AND S.fdatastatus in ('1', '2') AND S.finitstatus in ('2') ");
        this.hisSubWhereCommonSql.append("  WHERE A.fiscurrentversion = '0' AND B.fiscurrentversion = '0' ").append("  AND A.fdatastatus in ('1', '2') AND A.finitstatus in ('2') ").append("  AND B.fdatastatus in ('1','2') AND B.finitstatus in ('2') ");
        this.hisSubWhereBizSql.append("  AND A.fbsed <= ?  AND A.fbsled >= ?  AND B.fbsed <= ?  AND B.fbsled >= ?");
        this.hisSubWhereBizSql.append((CharSequence)((AdminOrgSpProcessor)this.getStructProjectCapable()).getHisSubWhereStructProjectSql());
    }

    @Override
    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        IListView view = (IListView)this.getView();
        String billFormId = view.getBillFormId();
        String dataEntityNumber = QueryEntityServiceHelper.getDataEntityNumber((String)billFormId);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)dataEntityNumber);
        if (dataEntityType.getProperty("isvirtualorg") != null && this.isAdminStructProjectTree()) {
            setFilterEvent.getQFilters().add(new QFilter("isvirtualorg", "=", (Object)"0"));
        }
    }

    @Override
    protected String getOrgParentStructLongNumberQueryFields() {
        return "adminorg.id id, parentorg.id parent, structlongnumber,isroot";
    }

    @Override
    protected DynamicObject getRootDynamicObjectByCommonParentSLN(String commonParentStructLongNumber) {
        return TreeTemplateHelper.getRootDynamicObjectByCommonParentSLN((String)commonParentStructLongNumber, (String)HIS_TREE_ROOT_STRUCT_FIELDS, (String)"adminorg.id", (OrgTreeModel)this.orgTreeModel, (Date)this.getDateParam(), (QFilter)new QFilter("structproject", "=", (Object)this.getStructProjectCapable().getStructProject().getLong("id")));
    }

    @Override
    public void initializeTree(EventObject e) {
        if (this.orgTreeModel != null && this.orgTreeModel.isHisTree() && this.isCurNowDate()) {
            this.orgTreeModel.setCurNowDate(Boolean.TRUE.booleanValue());
        }
        super.initializeTree(e);
        IClientViewProxy service = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("key", "treeview");
        hashMap.put("labelShowType", 1);
        service.addAction("u", hashMap);
    }

    @Override
    public DynamicObject getCurVerTreeNodeDynInPerm(QFilter permFilter, QFilter orgTreeFilter) {
        return TreeTemplateHelper.getCurTreeRootNodeDynamicObj((String)this.orgTreeModel.getEntityName(), (String)CUR_TREE_ROOT_STRUCT_FIELDS, (QFilter)permFilter, (QFilter)orgTreeFilter, (QFilter)this.getCurTreeBizCommonQFilter());
    }

    @Override
    public DynamicObject getHisTreeRootNodeDynInPerm(QFilter structLongNumberFilter) {
        Date dateParam = this.getDateParam();
        if (dateParam == null) {
            return this.getCurDayHisDyn(structLongNumberFilter);
        }
        LocalDate localDateParam = dateParam.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (dateParam != null && localDateParam.isBefore(LocalDate.now())) {
            if (this.rootNodeDynamicObj != null) {
                return this.rootNodeDynamicObj;
            }
            if (this.isAllOrgDoNotHaveParentAtSearchDate()) {
                return this.getCustomRootDy(-2L);
            }
            if (this.getPageCache().get("all_conditional_org") == null) {
                return this.getCustomRootDy(-1L);
            }
            String commonParentStructLongNumber = this.getPageCache().get("common_prefix_struct_long_number");
            if (commonParentStructLongNumber != null) {
                if (StringUtils.equals((CharSequence)"no_common_parent", (CharSequence)commonParentStructLongNumber)) {
                    return this.getCustomRootDy(-2L);
                }
                this.rootNodeDynamicObj = this.getRootDynamicObjectByCommonParentSLN(commonParentStructLongNumber);
                if (this.rootNodeDynamicObj == null) {
                    return this.getCustomRootDy(-2L);
                }
            } else {
                return null;
            }
            return this.rootNodeDynamicObj;
        }
        return this.getCurDayHisDyn(structLongNumberFilter);
    }

    @Override
    protected AuthorizedOrgResultWithSub getPermOrgResultWithSub() {
        AuthorizedOrgResultWithSub permOrgResultWithSub = super.getPermOrgResultWithSub();
        if (!this.orgTreeModel.isHisTree() || this.orgTreeModel.isHisTree() && this.isCurNowDate()) {
            this.permOrgResultWithSub = permOrgResultWithSub;
            return this.permOrgResultWithSub;
        }
        Date dateParam = this.getDateParam();
        if (HRDateTimeUtils.truncateDate((Date)new Date()).equals(HRDateTimeUtils.truncateDate((Date)dateParam))) {
            return permOrgResultWithSub;
        }
        if (this.dateChgPermResult != null) {
            return this.dateChgPermResult;
        }
        IPageCache pageCache = this.getPageCache();
        String oldSearchDate = pageCache.get("old_searchdate");
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ROOT);
        LocalDate oldLocalDate = null;
        if (HRStringUtils.isNotEmpty((String)oldSearchDate)) {
            oldLocalDate = LocalDate.parse(oldSearchDate, dateTimeFormatter);
        }
        LocalDate curLocalDate = TreeTemplateHelper.date2LocalDate((Date)dateParam);
        if (HRStringUtils.isEmpty((String)oldSearchDate) || oldLocalDate != null && !oldLocalDate.equals(curLocalDate)) {
            this.resetPermDataSLNByDate(permOrgResultWithSub, oldLocalDate, curLocalDate);
            this.dateChgPermResult = permOrgResultWithSub;
            pageCache.put("old_searchdate", curLocalDate.toString());
        }
        return permOrgResultWithSub;
    }

    protected void resetPermDataSLNByDate(AuthorizedOrgResultWithSub permOrgResultWithSub, LocalDate defDate, LocalDate newDate) {
        if (this.getPageCache().get("CACHE_PERM_RESET_HIS_TREE_MARK") == null) {
            if (!permOrgResultWithSub.isHasAllOrgPerm() && this.orgTreeModel.isHisTree() && (defDate == null || newDate != null && defDate != null && !defDate.equals(newDate))) {
                this.resetPermOrgResultWithSubWithDate(permOrgResultWithSub);
                this.getPageCache().put("perm_org_result_withsub", SerializationUtils.toJsonString((Object)permOrgResultWithSub));
            }
            this.getPageCache().put("CACHE_PERM_RESET_HIS_TREE_MARK", "true");
        }
    }

    private void resetPermOrgResultWithSubWithDate(AuthorizedOrgResultWithSub permOrgResultWithSub) {
        HRBaseServiceHelper structHelper = new HRBaseServiceHelper("haos_adminorgstruct");
        List hasPermOrgWithSub = permOrgResultWithSub.getHasPermOrgsWithSub();
        Set orgIds = hasPermOrgWithSub.stream().map(OrgSubInfo::getOrgId).collect(Collectors.toSet());
        QFilter structProjectFilter = new QFilter("structproject", "=", (Object)this.getStructProjectCapable().getStructProject().getLong("id"));
        QFilter adminOrgFilter = new QFilter("adminorg", "in", orgIds);
        DynamicObject[] structDys = structHelper.queryOriginalArray("adminorg.id, structlongnumber", new QFilter[]{adminOrgFilter, structProjectFilter, this.getDataStatusAndBSedFilter()});
        Map<Long, DynamicObject> structInfoMap = Arrays.stream(structDys).collect(Collectors.toMap(structDy -> structDy.getLong("adminorg.id"), structDy -> structDy));
        hasPermOrgWithSub.forEach(orgSubInfo -> {
            Long orgId = orgSubInfo.getOrgId();
            DynamicObject structInfo = (DynamicObject)structInfoMap.get(orgId);
            if (structInfo != null) {
                orgSubInfo.setLongStructNumber(structInfo.getString(STRUCT_LONG_NUMBER));
            }
        });
    }

    private DynamicObject getCurDayHisDyn(QFilter structLongNumberFilter) {
        String mainEntityFields = "id, name, boid";
        return TreeTemplateHelper.getHisTreeRootDynInPerm((String)HIS_TREE_ROOT_STRUCT_FIELDS, (String)mainEntityFields, (OrgTreeModel)this.orgTreeModel, (QFilter)structLongNumberFilter, (QFilter)this.getOrgTreeFilter(), (QFilter)this.getOrgFilter());
    }

    @Override
    protected Map<Long, Supplier<TreeNode>> getDefinedDyVsCustomNode() {
        HashMap<Long, Supplier<TreeNode>> map = new HashMap<Long, Supplier<TreeNode>>();
        map.put(-1L, this::noDataVirtualNode);
        map.put(-2L, () -> {
            TreeNode treeNode = this.parentVirtualNode("");
            treeNode.setIsOpened(true);
            return treeNode;
        });
        map.put(Long.valueOf("-3"), this::noPermDataVirtualNode);
        return map;
    }

    @Override
    protected DynamicObject getRootDynByRootId() {
        if (!this.orgTreeModel.isHisTree()) {
            return HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryOriginalOne(CUR_TREE_ROOT_STRUCT_FIELDS, new QFilter("adminorg.id", "=", (Object)100000L).toArray());
        }
        DynamicObject mainEntityInfo = TreeTemplateHelper.getHisTreeRootMainDynByRootId((OrgTreeModel)this.orgTreeModel, (QFilter)this.getDataStatusAndBSedFilter());
        if (mainEntityInfo == null) {
            return null;
        }
        DynamicObject structEntityInfo = TreeTemplateHelper.getHisTreeRootStructDynByRootId((String)HIS_TREE_ROOT_STRUCT_FIELDS, (String)"adminorg.id", (OrgTreeModel)this.orgTreeModel, (String)this.getCurrentVersionVal());
        structEntityInfo.set("id", mainEntityInfo.get("id"));
        structEntityInfo.set("name", mainEntityInfo.get("name"));
        return structEntityInfo;
    }

    @Override
    protected DynamicObject getRootNodeDyn() {
        if (!this.orgTreeModel.isHisTree()) {
            return this.getCurTreeRootNodeDyn(CUR_TREE_ROOT_STRUCT_FIELDS);
        }
        return this.getHisTreeRootNodeDyn(CUR_TREE_ROOT_STRUCT_FIELDS);
    }

    protected DynamicObject getHisTreeRootNodeDyn(String curTreeRootStructFields) {
        return this.getHisTreeRootNodeDynInPerm(new QFilter("1", "=", (Object)1));
    }

    @Override
    protected void encapsulateRootNode(TreeNode rootNode, DynamicObject dynamicObject) {
        if (!this.isAdminStructProjectTree()) {
            this.treeNodeNameSetter.beforeEncapsulationNode(dynamicObject, this.getDateParam());
        }
        super.encapsulateRootNode(rootNode, dynamicObject);
    }

    @Override
    public List<Map<String, String>> encapsulationTreeMap(DynamicObjectCollection dyColl) {
        if (this.isShowCompanyName()) {
            this.treeNodeNameSetter.beforeEncapsulationTreeMap(dyColl, this.getDateParam());
        }
        return super.encapsulationTreeMap(dyColl);
    }

    @Override
    protected void resetOrgNameByEnableInfo(TreeNode node, DynamicObject dyn) {
        String companyName;
        if (node == null || dyn == null) {
            return;
        }
        String enable = dyn.getString("enable");
        node.setLabelShowType(1);
        if ("0".equals(enable)) {
            ArrayList<TreeNodeLabel> labelParaList = new ArrayList<TreeNodeLabel>(0);
            TreeNodeLabel treeNodeLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u5df2\u505c\u7528", (String)"AdminOrgTreeListTemplate_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "#999999");
            labelParaList.add(treeNodeLabel);
            node.setLabelPara(labelParaList);
        }
        if (this.isShowCompanyName() && HRStringUtils.isNotEmpty((String)(companyName = this.treeNodeNameSetter.createCompanySuffix(dyn)))) {
            node.setText(String.format("%s\uff08%s\uff09", node.getText(), companyName));
        }
    }

    @Override
    protected void resetOrgNameByEnableInfo(TreeNode node, Map<String, String> nodeMap) {
        String companyName;
        if (node == null || nodeMap == null) {
            return;
        }
        String enable = nodeMap.get("enable");
        node.setLabelShowType(1);
        if ("0".equals(enable)) {
            ArrayList<TreeNodeLabel> labelParaList = new ArrayList<TreeNodeLabel>(0);
            TreeNodeLabel treeNodeLabel = new TreeNodeLabel(ResManager.loadKDString((String)"\u5df2\u505c\u7528", (String)"AdminOrgTreeListTemplate_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), "#999999");
            labelParaList.add(treeNodeLabel);
            node.setLabelPara(labelParaList);
        }
        if (this.isShowCompanyName() && HRStringUtils.isNotEmpty((String)(companyName = this.treeNodeNameSetter.createCompanySuffix(nodeMap)))) {
            node.setText(String.format("%s\uff08%s\uff09", node.getText(), companyName));
        }
    }

    @Override
    public QFilter getSearchTreeStructFilter() {
        List<String> structLongNumbers = this.getOrgStructLongNumberByPermOrg();
        if (null == structLongNumbers || structLongNumbers.size() == 0) {
            return null;
        }
        List allSubStructNumbers = OrgTreeUtils.getAllSubStructNumbers((String)this.getRootNode().getLongNumber(), structLongNumbers, (boolean)true);
        return new QFilter("adminorg.structnumber", "in", (Object)allSubStructNumbers);
    }

    @Override
    public List<String> getSearchTreeStructNumberList() {
        List<String> structLongNumbers = this.getOrgStructLongNumberByPermOrg();
        if (null == structLongNumbers || structLongNumbers.size() == 0) {
            return null;
        }
        List allSubStructNumbers = OrgTreeUtils.getAllSubStructNumbers((String)this.getRootNode().getLongNumber(), structLongNumbers, (boolean)true);
        return allSubStructNumbers;
    }

    @Override
    public List<TreeNode> searchCurTreeNode(String searchText, QFilter structFilter) {
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)16);
        QFilter nameFilter = new QFilter("adminorg.name", "like", (Object)("%" + searchText + "%"));
        QFilter[] filters = new QFilter[]{nameFilter, structFilter, this.getOrgTreeFilter()};
        String orderBy = "adminorg." + this.subTreeOrderBys + ", adminorg.id";
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl(CUR_SUB_TREE_STRUCT_FIELDS, filters, orderBy);
        if (dynCol == null) {
            return treeNodes;
        }
        this.setOrgLeaf(dynCol, PARENT_ORG);
        dynCol.forEach(dynamicObject -> {
            String orgId = dynamicObject.getString("id");
            TreeNode treeNode = new TreeNode(dynamicObject.getString(PARENT_ORG), orgId, dynamicObject.getString("name"));
            treeNode.setLongNumber(dynamicObject.getString(STRUCT_LONG_NUMBER));
            treeNode.setData((Object)dynamicObject.getString("boid"));
            treeNodes.add(treeNode);
        });
        return treeNodes;
    }

    @Override
    @ExcludeFromJacocoGeneratedReport
    public List<TreeNode> searchHisTreeNode(String searchText) {
        DynamicObjectCollection retDynCol;
        StringBuilder sqlStr = this.getHisSubTreeQuerySql();
        sqlStr.append(" AND AL.fname like ? ");
        ArrayList structLongNumberList = new ArrayList(16);
        ArrayList orgIdWithOutSub = new ArrayList(16);
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        this.resetPermOrgResultWitchSub(permOrgResultWithSub);
        if (this.orgTreeModel.isFilterTreePerm() && !permOrgResultWithSub.isHasAllOrgPerm()) {
            TreeTemplateHelper.getHisPermStructLongNumberLikeAndOutSub((AuthorizedOrgResultWithSub)permOrgResultWithSub, orgIdWithOutSub, structLongNumberList);
            StringBuilder structLongNumberSb = new StringBuilder();
            StringBuilder orgIdWithOutSubSb = new StringBuilder();
            if (!ObjectUtils.isEmpty(structLongNumberList)) {
                structLongNumberList.forEach(s -> structLongNumberSb.append("OR B.fstructlongnumber LIKE ? "));
            }
            if (!ObjectUtils.isEmpty(orgIdWithOutSub)) {
                ArrayList placeholderList = new ArrayList(16);
                orgIdWithOutSub.forEach(orgId -> placeholderList.add("?"));
                String join = String.join((CharSequence)",", placeholderList);
                orgIdWithOutSubSb.append(join);
            }
            if (!StringUtils.isEmpty((CharSequence)structLongNumberSb) && !StringUtils.isEmpty((CharSequence)orgIdWithOutSubSb)) {
                sqlStr.append(" AND ( ");
                sqlStr.append(structLongNumberSb.substring(2)).append("  OR A.FBOID IN (").append((CharSequence)orgIdWithOutSubSb).append(")");
                sqlStr.append(")");
            } else if (!StringUtils.isEmpty((CharSequence)structLongNumberSb) && StringUtils.isEmpty((CharSequence)orgIdWithOutSubSb)) {
                sqlStr.append(" AND ( ");
                sqlStr.append(structLongNumberSb.substring(2));
                sqlStr.append(")");
            } else if (StringUtils.isEmpty((CharSequence)structLongNumberSb) && !StringUtils.isEmpty((CharSequence)orgIdWithOutSubSb)) {
                sqlStr.append(" AND A.FBOID IN ( ");
                sqlStr.append((CharSequence)orgIdWithOutSubSb).append(")");
            }
        }
        List<Object> paramList = this.getHisSubTreeQueryParamList(this.queryHisTreeDateCount);
        paramList.add("%" + searchText + "%");
        if (!ObjectUtils.isEmpty(structLongNumberList)) {
            paramList.addAll(structLongNumberList);
        }
        if (!ObjectUtils.isEmpty(orgIdWithOutSub)) {
            paramList.addAll(orgIdWithOutSub);
        }
        if (ObjectUtils.isEmpty((Object)(retDynCol = TreeTemplateHelper.getHisAdminOrgDynCol((StringBuilder)sqlStr, paramList, (String)"hbp_adminOrgHisTreeSearchByName")))) {
            new ArrayList(0);
        }
        OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)retDynCol, (String)this.subTreeOrderBys);
        this.setOrgLeaf(retDynCol, PARENT_ORG);
        return OrgTreeUtils.buildSearchTreeNodeList((DynamicObjectCollection)retDynCol, (String)PARENT_ORG);
    }

    @Override
    public List<TreeNode> getSearchNodesBySearchId(Long searchIdVal) {
        DynamicObject orgMainDyn;
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        if (null == searchIdVal) {
            return treeNodes;
        }
        QFilter dataStatusBSedFilter = this.getDataStatusAndBSedFilter();
        if (this.orgTreeModel.isHisTree()) {
            dataStatusBSedFilter = this.getHisListDataStatusBSedFilter();
        }
        if ((orgMainDyn = TreeTemplateHelper.getMainDynByVidAndCommonFilter((String)this.orgTreeModel.getMainEntityName(), (QFilter)this.getOrgEnableFilter(), (QFilter)dataStatusBSedFilter, (Long)searchIdVal)) == null) {
            return treeNodes;
        }
        QFilter orgIdFilter = new QFilter("adminorg.id", "=", (Object)orgMainDyn.getLong("boid"));
        if (this.orgTreeModel.isHisTree()) {
            return this.getHisTreeSearchDynCol(searchIdVal, PARENT_ORG, this.queryHisTreeDateCount, this.subTreeOrderBys);
        }
        QFilter[] filters = new QFilter[]{orgIdFilter, this.getDataStatusAndBSedFilter(), this.getOrgEnableFilter()};
        TreeTemplateHelper.assemblyCurTreeSearchNodes(treeNodes, (String)this.getEntityName(), (OrgTreeModel)this.orgTreeModel, (String)CUR_SUB_TREE_STRUCT_FIELDS, (String)PARENT_ORG, (QFilter[])filters, null);
        return treeNodes;
    }

    @ExcludeFromJacocoGeneratedReport
    public List<String> getParentStructNumbers(OrgTreeSearchParam searchParam, TreeNode node) {
        ArrayList structNumbers = Lists.newArrayList();
        if (searchParam.isSearchById()) {
            structNumbers.addAll(Arrays.asList(node.getLongNumber().split("!")));
            return structNumbers;
        }
        String structLongNumber = node.getLongNumber();
        if (StringUtils.isNotBlank((CharSequence)structLongNumber)) {
            String[] numbers = structLongNumber.split("!");
            if ("0".equals(node.getParentid())) {
                structNumbers.add(structLongNumber);
            } else {
                String curSearchNodeId = searchParam.getRootNode().getId();
                int length = numbers.length;
                if (length == 0) {
                    return structNumbers;
                }
                if (length == 1) {
                    structNumbers.addAll(Arrays.asList(numbers));
                    return structNumbers;
                }
                structNumbers.addAll(Arrays.asList(numbers).subList(curSearchNodeId.equals(node.getParentid()) ? 0 : 1, length - 1));
            }
        }
        return structNumbers;
    }

    @Override
    public void queryTreeNodeChildrenByStructNumbers(OrgTreeSearchParam searchParam, List<String> structNumbers, TreeNode node) {
        if (structNumbers.isEmpty()) {
            return;
        }
        if (!this.orgTreeModel.isHisTree()) {
            String selectFields = "adminorg.id, adminorg.boid boid, parentorg.id parentorg, structlongnumber, isleaf";
            QFilter numberFilter = new QFilter("adminorg.structnumber", "in", structNumbers);
            if (!this.getEntityName().equals("haos_adminorgstruct")) {
                numberFilter = new QFilter(this.orgStructNumberProperty, "in", structNumbers);
            }
            if (!this.isAdminStructProjectTree()) {
                this.orgStructNumberProperty = "adminorg.structnumber";
            }
            DynamicObjectCollection structDynCols = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl(selectFields, new QFilter[]{this.getDataStatusAndBSedFilter(), numberFilter}, null);
            OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)structDynCols, (String)STRUCT_LONG_NUMBER);
            this.setOrgLeaf(structDynCols, PARENT_ORG);
            this.getView().getPageCache().put(SELECT_ALL_TREENODE, "true");
            TreeTemplateHelper.lazyCurTreeNodeChildren((DynamicObjectCollection)structDynCols, (OrgTreeSearchParam)searchParam, (TreeNode)node, (String)"adminorg.id", (String)"parentorg.id");
            return;
        }
        StringBuilder sqlStr = this.getHisSubTreeQuerySql();
        OrgTreeUtils.assemblyStructNumberSql((StringBuilder)sqlStr, (String)"A.fstructnumber", (int)structNumbers.size());
        List<Object> paramList = this.getHisSubTreeQueryParamList(this.queryHisTreeDateCount);
        paramList.addAll(structNumbers);
        DynamicObjectCollection retDynCol = TreeTemplateHelper.getHisAdminOrgDynCol((StringBuilder)sqlStr, paramList, (String)"hbp_adminOrgHisTreeNodeChildren");
        OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)retDynCol, (String)this.subTreeOrderBys);
        this.setOrgLeaf(retDynCol, PARENT_ORG);
        TreeTemplateHelper.lazyHisTreeNodeChildren((DynamicObjectCollection)retDynCol, (OrgTreeSearchParam)searchParam, (TreeNode)node, (String)PARENT_ORG);
    }

    @Override
    public DynamicObjectCollection queryCurTreeViewDynamicCollection(QFilter[] qFilters) {
        if (this.orgTreeModel.isHisTree() || !this.isAdminStructProjectTree()) {
            Date dateParam = this.getDateParam();
            if (this.isCurNowDate() && dateParam == null) {
                dateParam = new Date();
            }
            QFilter structBSedFilter = new QFilter("bsed", "<=", (Object)dateParam).and("bsled", ">=", (Object)dateParam);
            QFilter mainBSedFilter = new QFilter("adminorg.bsed", "<=", (Object)dateParam).and("adminorg.bsled", ">=", (Object)dateParam);
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(Arrays.asList(qFilters));
            qFilterList.add(structBSedFilter);
            qFilterList.add(mainBSedFilter);
            qFilterList.add(new QFilter("structproject", "=", (Object)this.getStructProjectCapable().getStructProject().getLong("id")));
            return HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getEntityName()).queryColl(CUR_SUB_TREE_STRUCT_FIELDS, qFilterList.toArray(new QFilter[0]), "adminorg." + this.subTreeOrderBys + ", adminorg.id");
        }
        DynamicObjectCollection dynCol = HRBaseDaoFactory.getInstance((String)this.orgTreeModel.getMainEntityName()).queryColl(CUR_SUB_TREE_FIELDS, qFilters, this.subTreeOrderBys + ", id");
        return dynCol;
    }

    @Override
    public DynamicObjectCollection queryHisTreeViewDynamicCollection(List<String> treeViewStructNumberList, Date queryDate) {
        if (treeViewStructNumberList.isEmpty()) {
            return null;
        }
        StringBuilder sqlStr = this.getHisSubTreeQuerySql();
        OrgTreeUtils.assemblyStructNumberSql((StringBuilder)sqlStr, (String)"A.fstructnumber", (int)treeViewStructNumberList.size());
        List<Object> paramList = this.getHisSubTreeQueryParamList(this.queryHisTreeDateCount);
        paramList.addAll(treeViewStructNumberList);
        DynamicObjectCollection retDynCol = TreeTemplateHelper.getHisAdminOrgDynCol((StringBuilder)sqlStr, paramList, (String)"hbp_adminOrgTreeQuery");
        if (this.isAdminStructProjectTree()) {
            OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)retDynCol, (String)this.subTreeOrderBys);
        } else {
            OrgTreeUtils.sortDynColsOrderBys((DynamicObjectCollection)retDynCol, (String)"number");
        }
        return retDynCol;
    }

    private List<String> getOrgStructLongNumberByPermOrg() {
        if (!this.orgTreeModel.isFilterTreePerm()) {
            return TreeTemplateHelper.getAllPermissionStructLongNumbers((String)this.getEntityName(), (QFilter[])new QFilter[]{this.getOrgEnableFilter(), this.getDataStatusAndBSedFilter()}, null);
        }
        return TreeTemplateHelper.getOrgStructLongNumberByPermOrg((OrgTreeModel)this.orgTreeModel, (QFilter)this.getOrgTreeFilter(), (AuthorizedOrgResultWithSub)this.getPermOrgResultWithSub(), (String)"adminorg.boid", null);
    }

    @Override
    public List<String> getAllPermissionStructLongNumbers() {
        DynamicObjectCollection collection = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl(STRUCT_LONG_NUMBER, new QFilter[]{this.getOrgTreeFilter()}, null);
        return collection.stream().map(dynamicObject -> dynamicObject.getString(STRUCT_LONG_NUMBER)).collect(Collectors.toList());
    }

    @Override
    public List<Long> getAllOrgBoIdList() {
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        logger.error(String.format("AdminOrgTreeListTemplate.getCurAllOrgBoId currentNodeId=:%s", currentNodeId));
        this.orgTreeModel.setIncludeChild(this.isInCludeChild());
        return TreeTemplateHelper.getAllOrgBoId((ITreeModel)this.getTreeModel(), (OrgTreeModel)this.orgTreeModel, (AuthorizedOrgResultWithSub)this.getPermOrgResultWithSub(), this.getOrgSubStructLongNumberPermMap(), (QFilter)this.getOrgTreeFilter(), (String)"adminorg.id", (boolean)this.isDefDirectlySubOrg(), (String)this.dynParentProperty);
    }

    @Override
    public List<Object> getHisSubTreeQueryParamList(int queryDateCount) {
        List<Object> hisSubTreeQueryParamList = super.getHisSubTreeQueryParamList(queryDateCount);
        hisSubTreeQueryParamList.addAll(((AdminOrgSpProcessor)this.getStructProjectCapable()).getStructProjectSqlParamList());
        return hisSubTreeQueryParamList;
    }

    public List<Long> getAllOrgBoIdListFast() {
        Long rootOrgId;
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        logger.error(String.format("AdminOrgTreeListTemplate.getAllOrgBoIdListFast currentNodeId=:%s", currentNodeId));
        this.orgTreeModel.setIncludeChild(this.isInCludeChild());
        if (currentNodeId == null) {
            return new ArrayList<Long>(16);
        }
        String curNodeIdStr = currentNodeId.toString();
        TreeNode treeNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)curNodeIdStr);
        if (treeNode == null) {
            logger.info("TreeTemplateHelper.getAllOrgBoId, rootNode is null");
            return new ArrayList<Long>(16);
        }
        if (treeNode.getData() == null) {
            logger.info("TreeTemplateHelper.getAllOrgBoId, treeNode.getData() is null,treeNode={}", (Object)SerializationUtils.toJsonString((Object)treeNode));
            return new ArrayList<Long>(16);
        }
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        Long orgBoId = Long.parseLong(treeNode.getData().toString());
        if (!orgBoId.equals(rootOrgId = Long.valueOf(OrgUnitServiceHelper.getRootOrgId()))) {
            return TreeTemplateHelper.getAllOrgBoId((ITreeModel)this.getTreeModel(), (OrgTreeModel)this.orgTreeModel, (AuthorizedOrgResultWithSub)permOrgResultWithSub, this.getOrgSubStructLongNumberPermMap(), (QFilter)this.getOrgTreeFilter(), (String)"adminorg.id", (boolean)this.isDefDirectlySubOrg(), (String)this.dynParentProperty);
        }
        if (this.orgTreeModel.isIncludeChild()) {
            if (permOrgResultWithSub.isHasAllOrgPerm()) {
                return null;
            }
            List orgSubInfoList = permOrgResultWithSub.getHasPermOrgsWithSub();
            for (OrgSubInfo orgSubInfo : orgSubInfoList) {
                if (!orgSubInfo.getOrgId().equals(rootOrgId) || !orgSubInfo.isContainsSub()) continue;
                return null;
            }
        }
        return TreeTemplateHelper.getAllOrgBoId((ITreeModel)this.getTreeModel(), (OrgTreeModel)this.orgTreeModel, (AuthorizedOrgResultWithSub)permOrgResultWithSub, this.getOrgSubStructLongNumberPermMap(), (QFilter)this.getOrgTreeFilter(), (String)"adminorg.id", (boolean)this.isDefDirectlySubOrg(), (String)this.dynParentProperty);
    }

    @Override
    public DynamicObjectCollection getCurChildDynCol(Set<Long> orgBoIdSet) {
        if (ObjectUtils.isEmpty(orgBoIdSet)) {
            return null;
        }
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        QFilter structLongNumberAndSubFilter = null;
        if (this.orgTreeModel.isFilterTreePerm() && !permOrgResultWithSub.isHasAllOrgPerm()) {
            structLongNumberAndSubFilter = TreeTemplateHelper.getOrgAndSubInPermFilter((AuthorizedOrgResultWithSub)this.getPermOrgResultWithSub(), (String)"adminorg.boid");
        }
        QFilter parentBoIdFilter = new QFilter(PARENT_ORG, "in", orgBoIdSet);
        QFilter[] qFilters = new QFilter[]{this.getOrgTreeFilter(), parentBoIdFilter, structLongNumberAndSubFilter};
        return HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("structlongnumber, isleaf,adminorg.boid boid, parentorg.boid parentorg", qFilters, null);
    }

    @Override
    public void setOrgLeaf(DynamicObjectCollection dynObjCol, String dynParentProperty) {
        if (dynObjCol == null) {
            return;
        }
        HashMap<Long, DynamicObject> notLeafDynMap = new HashMap<Long, DynamicObject>(dynObjCol.size());
        for (DynamicObject dyn2 : dynObjCol) {
            notLeafDynMap.put(dyn2.getLong("boid"), dyn2);
        }
        Map<Long, DynamicObject> queryChildDynMap = this.getNeedQueryToSetLeafDynMap(notLeafDynMap);
        if (this.orgTreeModel.isFilterTreePerm() && !this.getPermOrgResultWithSub().isHasAllOrgPerm()) {
            Map<Long, Boolean> boIdVsIsLeaf = this.queryIsLeaf(queryChildDynMap.keySet());
            Set<Map.Entry<Long, DynamicObject>> curOrgColEntry = queryChildDynMap.entrySet();
            for (Map.Entry<Long, DynamicObject> curOrgMap : curOrgColEntry) {
                Long curOrgId = curOrgMap.getKey();
                DynamicObject curOrgDyn = curOrgMap.getValue();
                curOrgDyn.set("isleaf", (Object)boIdVsIsLeaf.getOrDefault(curOrgId, Boolean.FALSE));
            }
        } else {
            String doNotHaveParentCache = this.getPageCache().get("do_not_have_parent_org_structlongnumber");
            DynamicObjectCollection childDynCol = doNotHaveParentCache != null ? this.getHisChildDynColl(queryChildDynMap.keySet()) : this.getCurChildDynCol(queryChildDynMap.keySet());
            if (childDynCol == null) {
                for (DynamicObject dyn3 : notLeafDynMap.values()) {
                    dyn3.set("isleaf", (Object)Boolean.TRUE);
                }
            } else {
                Map<Long, List<DynamicObject>> curOrgGroupParentCol = childDynCol.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong(dynParentProperty)));
                Set<Map.Entry<Long, DynamicObject>> curOrgColEntry = queryChildDynMap.entrySet();
                for (Map.Entry<Long, DynamicObject> curOrgMap : curOrgColEntry) {
                    Long curOrgId = curOrgMap.getKey();
                    DynamicObject curOrgDyn = curOrgMap.getValue();
                    List<DynamicObject> childDynList = curOrgGroupParentCol.get(curOrgId);
                    if (ObjectUtils.isEmpty(childDynList)) {
                        curOrgDyn.set("isleaf", (Object)Boolean.TRUE);
                        continue;
                    }
                    curOrgDyn.set("isleaf", (Object)Boolean.FALSE);
                }
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private Map<Long, Boolean> queryIsLeaf(Set<Long> orgBoIdSet) {
        if (ObjectUtils.isEmpty(orgBoIdSet)) {
            return new HashMap<Long, Boolean>();
        }
        QFilter structLongNumberAndSubFilter = TreeTemplateHelper.getOrgAndSubInPermFilter((AuthorizedOrgResultWithSub)this.getPermOrgResultWithSub(), (String)"adminorg.boid");
        QFilter[] qFilters = new QFilter[]{this.getOrgTreeFilter(), structLongNumberAndSubFilter};
        DynamicObjectCollection dynamicObjectCollection = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("structlongnumber, adminorg as adminorg.id", qFilters, null);
        Map<Long, String> orgBoIdVsSLN = dynamicObjectCollection.stream().filter(dy -> orgBoIdSet.contains(dy.getLong("adminorg.id"))).collect(Collectors.toMap(dy -> dy.getLong("adminorg.id"), dy -> dy.getString(STRUCT_LONG_NUMBER)));
        Object place = new Object();
        PatriciaTrie SLNPatriciaTrie = dynamicObjectCollection.stream().collect(Collectors.toMap(dy -> dy.getString(STRUCT_LONG_NUMBER), dy -> place, (obj, obj2) -> obj, PatriciaTrie::new));
        return orgBoIdVsSLN.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            String SLN = (String)entry.getValue();
            SortedMap prefixSLNSortedMap = SLNPatriciaTrie.prefixMap((Object)(SLN + "!"));
            return prefixSLNSortedMap.size() == 0;
        }));
    }

    public final boolean isAdminStructProjectTree() {
        if (this.getStructProjectCapable().getStructProject() == null) {
            return false;
        }
        return this.getStructProjectCapable().getStructProject().getLong("id") == 1010L;
    }

    @ExcludeFromJacocoGeneratedReport
    private DynamicObjectCollection getHisChildDynColl(Set<Long> orgBoIdSet) {
        if (ObjectUtils.isEmpty(orgBoIdSet)) {
            return null;
        }
        AuthorizedOrgResultWithSub permOrgResultWithSub = this.getPermOrgResultWithSub();
        QFilter adminOrgBoIdFilter = null;
        if (this.orgTreeModel.isFilterTreePerm() && !permOrgResultWithSub.isHasAllOrgPerm() && CollectionUtils.isNotEmpty((Collection)permOrgResultWithSub.getHasPermOrgsWithSub())) {
            QFilter structLongNumberAndSubFilter = TreeTemplateHelper.getOrgAndSubInPermFilter((AuthorizedOrgResultWithSub)this.getPermOrgResultWithSub(), (String)"adminorg.boid");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(this.getEntityName());
            DynamicObjectCollection originalDynColl = serviceHelper.queryOriginalCollection("adminorg.boid", structLongNumberAndSubFilter.toArray());
            Set adminOrgBoIdSet = originalDynColl.stream().map(dyn -> dyn.getLong("adminorg.boid")).collect(Collectors.toSet());
            adminOrgBoIdFilter = new QFilter("adminorg.boid", "in", adminOrgBoIdSet);
        }
        QFilter parentBoIdFilter = new QFilter(PARENT_ORG, "in", orgBoIdSet);
        QFilter[] qFilters = new QFilter[]{this.getOrgTreeFilter(), parentBoIdFilter, adminOrgBoIdFilter};
        return HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("structlongnumber, isleaf,adminorg.boid boid, parentorg.boid parentorg", qFilters, null);
    }

    private DynamicObject getCustomRootDy(long id) {
        DynamicObjectType subDataEntityType = EntityMetadataCache.getSubDataEntityType((String)"haos_adminorgdetail", Arrays.asList("id", "boid", "name"));
        DynamicObject rootDy = new DynamicObject(subDataEntityType);
        rootDy.set("id", (Object)id);
        rootDy.set("boid", (Object)id);
        return rootDy;
    }

    @Override
    public DynamicObjectCollection getTreeViewCollection(String entityName, String currentNodeId) {
        if (this.orgTreeModel.isHisTree() || !this.isAdminStructProjectTree()) {
            this.orgStructNumberProperty = "adminorg.structnumber";
            return super.getTreeViewCollection(entityName, currentNodeId);
        }
        return this.getCurrentTreeViewCollection(currentNodeId);
    }

    public DynamicObjectCollection getCurrentTreeViewCollection(String currentNodeId) {
        TreeNode currentNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)currentNodeId);
        long startTime = System.currentTimeMillis();
        logger.info("TreeListTemplateBase.getTreeViewCollection,currentNodeId={}", (Object)currentNodeId);
        if (currentNode == null) {
            logger.info("TreeListTemplateBase.getTreeViewCollection, currentNode is null");
            return null;
        }
        String currentStructLongNumber = currentNode.getLongNumber();
        if (currentStructLongNumber == null) {
            logger.info("TreeListTemplateBase.getTreeViewCollection, currentStructLongNumber is null");
            return null;
        }
        QFilter currentChildFilter = this.getCurrentChildFilter(currentStructLongNumber, Long.valueOf(currentNodeId));
        DynamicObjectCollection treeViewDynObjColl = this.queryCurTreeViewDynamicCollection(new QFilter[]{this.getBaseAndCurrentCustomQFilter(), currentChildFilter});
        this.setOrgLeaf(treeViewDynObjColl, this.dynParentProperty);
        logger.info("TreeListTemplateBase.getTreeViewCollection,currentNodeId={},cost={}", (Object)currentNodeId, (Object)(System.currentTimeMillis() - startTime));
        return treeViewDynObjColl;
    }

    protected QFilter getCurrentCustomQFilter() {
        QFilter qFilter = null;
        String qFilterStr = (String)this.getView().getFormShowParameter().getCustomParam("bizQFilterKey");
        if (HRStringUtils.isEmpty((String)qFilterStr)) {
            return qFilter;
        }
        logger.info(String.format("TreeListTemplateBase_bizQFilterKey: param is %s", qFilterStr));
        qFilter = QFilter.fromSerializedString((String)qFilterStr);
        this.setQfProperty(qFilter);
        qFilter.getNests(true).forEach(nest -> this.setQfProperty(nest.getFilter()));
        return qFilter;
    }

    private void setQfProperty(QFilter qFilter) {
        String replaceKey = "adminorg.";
        String value = qFilter.getProperty();
        if (value != null) {
            String newValue = "adminorg".equals(value) ? "boid" : value.replace(replaceKey, "");
            qFilter.__setProperty(newValue);
        }
    }

    private QFilter getBaseAndCurrentCustomQFilter() {
        QFilter qFilter = this.getCurTreeBizCommonQFilter();
        return qFilter;
    }

    @Override
    protected QFilter getCurTreeBizCommonQFilter() {
        if (this.isAdminStructProjectTree()) {
            return this.getDataStatusAndBSedFilter().and(this.getOrgEnableFilter());
        }
        QFilter curTreeBizCommonQFilter = super.getCurTreeBizCommonQFilter();
        return curTreeBizCommonQFilter;
    }

    @Override
    protected QFilter getOrgTreeEnableFilter() {
        if (this.isAdminStructProjectTree()) {
            return super.getOrgTreeEnableFilter();
        }
        if (this.isShowDisable()) {
            return new QFilter("adminorg.enable", "in", (Object)new String[]{"1", "0"});
        }
        return new QFilter("adminorg.enable", "=", (Object)"1");
    }

    @ExcludeFromJacocoGeneratedReport
    public QFilter getCurrentChildFilter(String currentStructLongNumber, Long currentOrgId) {
        QFilter qFilter;
        String selectAll = this.getView().getPageCache().get(SELECT_ALL_TREENODE);
        this.getView().getPageCache().remove(SELECT_ALL_TREENODE);
        if (!this.isAdminStructProjectTree()) {
            this.orgStructNumberProperty = "adminorg.structnumber";
        }
        if (HRStringUtils.equals((String)selectAll, (String)"true")) {
            return super.getTreeViewStructNumberFilter(currentStructLongNumber);
        }
        if (!this.orgTreeModel.isFilterTreePerm() || this.getPermOrgResultWithSub().isHasAllOrgPerm()) {
            return new QFilter(PARENT_ORG, "=", (Object)currentOrgId);
        }
        List hasPermOrgsWithSub = this.getPermOrgResultWithSub().getHasPermOrgsWithSub();
        HashSet parentOrgSet = Sets.newHashSet();
        parentOrgSet.add(currentOrgId);
        this.getParentTreeNodeIdSet(currentOrgId, parentOrgSet);
        for (OrgSubInfo orgSubInfo : hasPermOrgsWithSub) {
            if (!parentOrgSet.contains(orgSubInfo.getOrgId()) || !orgSubInfo.isContainsSub()) continue;
            return new QFilter(PARENT_ORG, "=", (Object)currentOrgId);
        }
        ArrayList childStructNumbers = Lists.newArrayList();
        ArrayList currentChildIds = Lists.newArrayList();
        for (OrgSubInfo orgSubInfo : hasPermOrgsWithSub) {
            String structNumber = orgSubInfo.getStructNumber();
            String longStructNumber = orgSubInfo.getLongStructNumber();
            if (HRStringUtils.isEmpty((String)structNumber) || HRStringUtils.isEmpty((String)longStructNumber)) {
                currentChildIds.add(orgSubInfo.getOrgId());
                continue;
            }
            if (!longStructNumber.startsWith(currentStructLongNumber)) continue;
            if (longStructNumber.length() - currentStructLongNumber.length() == 13) {
                childStructNumbers.add(structNumber);
                continue;
            }
            if (longStructNumber.length() - currentStructLongNumber.length() > 13) {
                structNumber = longStructNumber.substring(currentStructLongNumber.length() + 1, currentStructLongNumber.length() + 13);
                childStructNumbers.add(structNumber);
                continue;
            }
            childStructNumbers.add(structNumber);
        }
        if (CollectionUtils.isNotEmpty((Collection)childStructNumbers)) {
            qFilter = new QFilter("structnumber", "in", (Object)childStructNumbers);
            return qFilter.and(new QFilter(PARENT_ORG, "=", (Object)currentOrgId));
        }
        if (CollectionUtils.isNotEmpty((Collection)currentChildIds)) {
            qFilter = new QFilter("boid", "in", (Object)currentChildIds);
            return qFilter.and(new QFilter(PARENT_ORG, "=", (Object)currentOrgId));
        }
        return new QFilter("1", "!=", (Object)1);
    }

    private void getParentTreeNodeIdSet(Long treeParentId, Set<Long> parentTreeNodeIdSet) {
        TreeNode treeNode = this.getTreeModel().getRoot().getTreeNode(String.valueOf(treeParentId), 20);
        if (HRStringUtils.isNotEmpty((String)treeNode.getParentid())) {
            parentTreeNodeIdSet.add(Long.valueOf(treeNode.getParentid()));
            this.getParentTreeNodeIdSet(Long.valueOf(treeNode.getParentid()), parentTreeNodeIdSet);
        }
    }

    private boolean isShowCompanyName() {
        if (this.companySuffixVisible == null) {
            Boolean companyNameVisibleCustomParam = this.getCompanyNameVisibleCustomParam();
            this.companySuffixVisible = companyNameVisibleCustomParam != null ? companyNameVisibleCustomParam : Boolean.valueOf(!this.isAdminStructProjectTree());
        }
        return this.companySuffixVisible;
    }

    private Boolean getCompanyNameVisibleCustomParam() {
        Boolean flag = null;
        String customParam = (String)this.getView().getFormShowParameter().getCustomParam("company_name_visible");
        if (customParam != null) {
            logger.info(String.format("getCustomStructProjectControlFilter custom param: %s", customParam));
            try {
                flag = (Boolean)SerializationUtils.fromJsonString((String)customParam, Boolean.class);
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
                logger.error(String.format("getCustomStructProjectControlFilter error with param: %s", customParam));
            }
        }
        return flag;
    }

    public void setEnableCustomSum(EnableCustomSumEvent args) {
        super.setEnableCustomSum(args);
        args.setEnableCustomSum(false);
    }
}

