/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.org.template;

import com.alibaba.fastjson.JSON;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.hr.hbp.business.servicehelper.org.TreeTemplateHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

@ExcludeFromJacocoGeneratedReport
public class OrgTreeQueryCriteriaPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(OrgTreeQueryCriteriaPlugin.class);

    public void beforeBindData(EventObject eventObject) {
        String searchDateStr;
        super.beforeBindData(eventObject);
        String chkShowDisable = (String)this.getView().getFormShowParameter().getCustomParam("chkshowdisable");
        if (!StringUtils.isEmpty((CharSequence)chkShowDisable)) {
            this.getView().getModel().setValue("chkshowdisable", (Object)chkShowDisable);
        }
        if (!StringUtils.isEmpty((CharSequence)(searchDateStr = (String)this.getView().getFormShowParameter().getCustomParam("searchdate")))) {
            try {
                Date searchDate = HRDateTimeUtils.parseDate((String)searchDateStr);
                this.getModel().setValue("searchdate", (Object)searchDate);
            }
            catch (ParseException e) {
                logger.error("AdminOrgPageRightDynamicPlugin parse date error!");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"confirm")) {
            LocalDate curSearchDate;
            String cachedSearchDateStr;
            LocalDate cachedSearchDate;
            boolean cachedShowDisable;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("chkshowdisable", this.getModel().getValue("chkshowdisable"));
            Date searchDate = (Date)this.getModel().getValue("searchdate");
            this.getView().returnDataToParent(map);
            this.getView().getPageCache().put("checkClose", "1");
            boolean curShowDisable = (Boolean)map.get("chkshowdisable");
            IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
            IPageCache pageCache = parentView.getPageCache();
            boolean treeConditionChanged = false;
            String cachedShowDisableStr = pageCache.get("chkshowdisable");
            boolean bl = cachedShowDisable = cachedShowDisableStr == null ? Boolean.FALSE : Boolean.parseBoolean(cachedShowDisableStr);
            if (cachedShowDisable != curShowDisable) {
                pageCache.put("chkshowdisable", String.valueOf(curShowDisable));
                treeConditionChanged = true;
            }
            if (!(cachedSearchDate = (cachedSearchDateStr = pageCache.get("searchdate")) == null ? TreeTemplateHelper.date2LocalDate((Date)new Date()) : (LocalDate)JSON.parseObject((String)cachedSearchDateStr, LocalDate.class)).isEqual(curSearchDate = TreeTemplateHelper.date2LocalDate((Date)searchDate))) {
                pageCache.put("searchdate", JSON.toJSONString((Object)curSearchDate));
                treeConditionChanged = true;
            }
            if (treeConditionChanged) {
                TreeTemplateHelper.removeRootAndStructLongNumberCache((IPageCache)pageCache);
                pageCache.put("treeConditionChanged", "true");
            }
            this.getView().close();
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)"close")) {
            this.getView().getPageCache().put("checkClose", "1");
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String checkClose = this.getView().getPageCache().get("checkClose");
        if (!StringUtils.equals((CharSequence)checkClose, (CharSequence)"1")) {
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"today"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"today")) {
            this.getModel().setValue("searchdate", (Object)KDDateUtils.today());
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSearchdateShowFutureDate();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equals("searchdate")) {
            this.setSearchdateShowFutureDate();
        }
    }

    private void setSearchdateShowFutureDate() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        IPageCache pageCache = parentView.getPageCache();
        if (pageCache != null && HRStringUtils.equals((String)pageCache.get("is_show_future_date"), (String)"true")) {
            DateEdit bsededit = (DateEdit)this.getView().getControl("searchdate");
            bsededit.setMaxDate(HRDateTimeUtils.getSysMaxDate());
        }
    }
}

