/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.query;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.business.service.query.HRQueryExactMatchListDataProvider;
import kd.hr.hbp.business.service.query.ksql.KsqlConfig;
import kd.hr.hbp.business.servicehelper.EntityReleaseInfoService;
import kd.hr.hbp.formplugin.web.HRAdminOrgTreeList;
import kd.hr.hbp.formplugin.web.query.QueryListDataFactory;

public class HRPersonF7AdminOrgTreeListPlugin
extends HRAdminOrgTreeList {
    private static final Log LOGGER = LogFactory.getLog(HRPersonF7AdminOrgTreeListPlugin.class);

    @Override
    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String listmodel = (String)this.getView().getFormShowParameter().getCustomParam("listmodel");
        String entityId = ((BillList)args.getSource()).getEntityId();
        if ("search".equals(listmodel)) {
            args.setListDataProvider((IListDataProvider)new HRQueryExactMatchListDataProvider());
            return;
        }
        args.setListDataProvider((IListDataProvider)this.listDataProvider(entityId));
    }

    private ListDataProvider listDataProvider(String entityNum) {
        DynamicObject entityReleaseInfo = EntityReleaseInfoService.getEntityReleaseInfoByName((String)entityNum);
        if (Objects.isNull(entityReleaseInfo)) {
            return null;
        }
        String dataSourceTypeStr = entityReleaseInfo.getString("datasourcetype");
        String ksqlQueryType = entityReleaseInfo.getString("ksqlquerytype");
        boolean ksqlUseUnion = entityReleaseInfo.getBoolean("ksqluseunion");
        LOGGER.info("HR QueryListPlugin dataSourceTypeStr:" + dataSourceTypeStr + ", ksqlQueryType:" + ksqlQueryType + ", ksqlUseUnion:" + ksqlUseUnion);
        return QueryListDataFactory.getListDataProvider(this.getView(), dataSourceTypeStr, this.setCustomKSqlConfig(), ksqlQueryType, ksqlUseUnion);
    }

    protected KsqlConfig setCustomKSqlConfig() {
        return null;
    }

    public void afterBindData(EventObject args) {
        HashMap mapBillListAp = Maps.newHashMapWithExpectedSize((int)8);
        mapBillListAp.put("enabledChangePage", Boolean.TRUE);
        mapBillListAp.put("suppressSelectAllRows", Boolean.TRUE);
        this.getView().updateControlMetadata("billlistap", (Map)mapBillListAp);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        Map parameter = operate.getParameter();
        parameter.put("byList", Boolean.TRUE);
        operate.setParameter(parameter);
    }
}

