/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.query;

import com.google.common.collect.Maps;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.exception.KDBizException;
import kd.bos.ext.hr.util.QueryEntityUtil;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.hr.hbp.business.service.query.HRQueryExactMatchListDataProvider;
import kd.hr.hbp.business.service.query.ksql.KsqlConfig;
import kd.hr.hbp.business.servicehelper.EntityReleaseInfoService;
import kd.hr.hbp.formplugin.web.query.QueryListDataFactory;
import kd.hr.hbp.formplugin.web.template.IHRF7AdminOrgTreeListPlugin;
import kd.hr.hbp.formplugin.web.template.IHRF7CloudAppTreeListPlugin;

public class HRQueryF7TreeListPlugin
extends AbstractTreeListPlugin
implements IHRF7AdminOrgTreeListPlugin,
IHRF7CloudAppTreeListPlugin {
    private static final Log LOGGER = LogFactory.getLog(HRQueryF7TreeListPlugin.class);

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        super.beforeCreateListDataProvider(args);
        String listmodel = (String)this.getView().getFormShowParameter().getCustomParam("listmodel");
        String entityId = ((BillList)args.getSource()).getEntityId();
        if ("search".equals(listmodel)) {
            args.setListDataProvider((IListDataProvider)new HRQueryExactMatchListDataProvider());
            return;
        }
        if ("tree".equals(listmodel)) {
            String treeType = (String)this.getView().getFormShowParameter().getCustomParam("treeType");
            List fieldNames = QueryEntityUtil.getFieldNames((String)entityId);
            if (treeType == null || "cloudApp".equals(treeType)) {
                if (!fieldNames.contains(this.getBizAppId())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%1$s\u4e0d\u5b58\u5728\u6216\u672a\u8bbe\u7f6e\u5b57\u6bb5:%2$s\u3002", (String)"HRQueryF7TreeListPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), entityId, this.getBizAppId()));
                }
            } else {
                if (!fieldNames.contains(this.getOrgField())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%1$s\u4e0d\u5b58\u5728\u6216\u672a\u8bbe\u7f6e\u5b57\u6bb5:%2$s\u3002", (String)"HRQueryF7TreeListPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), entityId, this.getOrgField()));
                }
                if (!fieldNames.contains(this.getParentOrgField())) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2%1$s\u4e0d\u5b58\u5728\u6216\u672a\u8bbe\u7f6e\u5b57\u6bb5:%2$s\u3002", (String)"HRQueryF7TreeListPlugin_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), entityId, this.getParentOrgField()));
                }
            }
        }
        args.setListDataProvider((IListDataProvider)this.listDataProvider(entityId));
    }

    private ListDataProvider listDataProvider(String entityNum) {
        DynamicObject entityReleaseInfo = EntityReleaseInfoService.getEntityReleaseInfoByName((String)entityNum);
        if (Objects.isNull(entityReleaseInfo)) {
            return null;
        }
        String dataSourceTypeStr = entityReleaseInfo.getString("datasourcetype");
        String ksqlQueryType = entityReleaseInfo.getString("ksqlquerytype");
        boolean ksqlUseUnion = entityReleaseInfo.getBoolean("ksqluseunion");
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("HR QueryListPlugin dataSourceTypeStr:" + dataSourceTypeStr + ", ksqlQueryType:" + ksqlQueryType + ", ksqlUseUnion:" + ksqlUseUnion);
        }
        return QueryListDataFactory.getListDataProvider(this.getView(), dataSourceTypeStr, this.setCustomKSqlConfig(), ksqlQueryType, ksqlUseUnion);
    }

    protected KsqlConfig setCustomKSqlConfig() {
        return null;
    }

    public void afterBindData(EventObject args) {
        HashMap mapBillListAp = Maps.newHashMapWithExpectedSize((int)8);
        mapBillListAp.put("enabledChangePage", Boolean.TRUE);
        mapBillListAp.put("suppressSelectAllRows", Boolean.TRUE);
        this.getView().updateControlMetadata("billlistap", (Map)mapBillListAp);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        Map parameter = operate.getParameter();
        parameter.put("byList", Boolean.TRUE);
        operate.setParameter(parameter);
    }

    @Override
    public ITreeModel getTreeModel() {
        return super.getTreeModel();
    }

    @Override
    public IDataModel getModel() {
        return super.getModel();
    }

    public void initializeTree(EventObject evt) {
        if (this.getTreeModel().getRoot() != null) {
            LOGGER.info("\u5df2\u7ecf\u521d\u59cb\u5316\u6811\uff0c\u4e0d\u518d\u521d\u59cb\u5316\uff01");
            return;
        }
        String treeType = (String)this.getView().getFormShowParameter().getCustomParam("treeType");
        if (treeType == null || "cloudApp".equals(treeType)) {
            this.initCloudAppTree();
        } else {
            this.initAdminOrgTree();
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        String treeType = (String)this.getView().getFormShowParameter().getCustomParam("treeType");
        if (treeType == null || "cloudApp".equals(treeType)) {
            this.buildCloudAppTreeListFilter(e);
        } else {
            this.buildAdminOrgTreeListFilter(e);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        this.afterFilterContainerSearchClick(args);
    }
}

