/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.query;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRStringUtils;

public class QueryF7SelectRowResetListPlugin
extends AbstractListPlugin
implements ListRowClickListener {
    private static final Log LOGGER = LogFactory.getLog(QueryF7SelectRowResetListPlugin.class);
    private static final String LIST_NAME_NUMBER_CACHE = "listnamenumberkey";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addListRowClickListener((ListRowClickListener)this);
    }

    public void listRowClick(ListRowClickEvent evt) {
        EntityType entityType = ((BillList)evt.getSource()).getEntityType();
        if (!(entityType instanceof QueryEntityType)) {
            return;
        }
        this.reloadSelectedRowsNameNumber((QueryEntityType)entityType, evt.getListSelectedRowCollection());
    }

    private void reloadSelectedRowsNameNumber(QueryEntityType queryEntityType, ListSelectedRowCollection selectedRows) {
        DynamicObject[] selRowNameNumberDyos;
        Set needLoadNameNumberPkSet = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        HRPageCache pageCache = new HRPageCache(this.getView());
        Map listNameNumberCache = (Map)pageCache.get(LIST_NAME_NUMBER_CACHE, Map.class);
        if (listNameNumberCache == null) {
            listNameNumberCache = Maps.newHashMapWithExpectedSize((int)16);
        } else {
            for (ListSelectedRow selectedRow : selectedRows) {
                Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
                if (HRStringUtils.isNotEmpty((String)selectedRow.getName()) && HRStringUtils.isNotEmpty((String)selectedRow.getNumber())) {
                    needLoadNameNumberPkSet.remove(primaryKeyValue);
                    continue;
                }
                Map nameNumberMap = (Map)listNameNumberCache.get(String.valueOf(primaryKeyValue));
                if (nameNumberMap == null) continue;
                selectedRow.setNumber((String)nameNumberMap.get("number"));
                selectedRow.setName((String)nameNumberMap.get("name"));
                needLoadNameNumberPkSet.remove(primaryKeyValue);
            }
        }
        if (needLoadNameNumberPkSet.isEmpty()) {
            return;
        }
        String nameKey = (String)this.getView().getFormShowParameter().getCustomParam("nameKey");
        String name = StringUtils.isEmpty((CharSequence)nameKey) ? queryEntityType.getNameProperty() : nameKey;
        String numberKey = (String)this.getView().getFormShowParameter().getCustomParam("numberKey");
        String number = StringUtils.isEmpty((CharSequence)numberKey) ? queryEntityType.getNumberProperty() : numberKey;
        LOGGER.error("nameKey:{}", (Object)nameKey);
        LOGGER.error("numberKey:{}", (Object)numberKey);
        String queryField = String.format("id,%s,%s", name, number);
        QFilter queryQFilter = new QFilter("id", "in", needLoadNameNumberPkSet);
        DynamicProperty nameProp = queryEntityType.getMainEntityType().getProperty(name);
        DynamicProperty numberProp = queryEntityType.getMainEntityType().getProperty(number);
        String[] nameArr = name.split("\\.");
        BasedataProp baProp = null;
        if (name.contains(".") && number.contains(".") && nameArr.length == 2) {
            baProp = (BasedataProp)queryEntityType.getMainEntityType().getProperty(nameArr[0]);
        }
        if (nameProp != null && numberProp == null || baProp != null) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(queryEntityType.getEditEntityName());
            selRowNameNumberDyos = serviceHelper.query(queryField, new QFilter[]{queryQFilter});
        } else {
            DynamicObjectCollection dyoColl = HRQueryEntityHelper.getInstance().getQueryDyoColl(queryEntityType, queryField, new QFilter[]{queryQFilter}, "");
            selRowNameNumberDyos = (DynamicObject[])dyoColl.toArray((Object[])new DynamicObject[dyoColl.size()]);
        }
        Map<Object, Map> listNameNumberDbData = Arrays.stream(selRowNameNumberDyos).collect(Collectors.toMap(dyo -> dyo.get("id"), dyo -> {
            HashMap nameNumberMap = Maps.newHashMapWithExpectedSize((int)2);
            nameNumberMap.put("name", dyo.getString(name));
            nameNumberMap.put("number", dyo.getString(number));
            return nameNumberMap;
        }, (k1, k2) -> k1));
        for (ListSelectedRow selectedRow : selectedRows) {
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            Map nameNumberDbMap = listNameNumberDbData.get(primaryKeyValue);
            if (nameNumberDbMap == null) continue;
            selectedRow.setNumber((String)nameNumberDbMap.get("number"));
            selectedRow.setName((String)nameNumberDbMap.get("name"));
            listNameNumberCache.put(String.valueOf(primaryKeyValue), nameNumberDbMap);
        }
        pageCache.put(LIST_NAME_NUMBER_CACHE, (Object)listNameNumberCache);
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        if (evt.getSource() instanceof BillList) {
            BillList billList = (BillList)evt.getSource();
            EntityType entityType = billList.getEntityType();
            if (!(entityType instanceof QueryEntityType)) {
                return;
            }
            this.reloadSelectedRowsNameNumber((QueryEntityType)entityType, billList.getSelectedRows());
        }
    }
}

