/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.template;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.bussiness.cert.HRCertCheckServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.sdk.annotation.SdkPlugin;
import org.apache.commons.lang3.StringUtils;

@SdkPlugin(name="HR\u57fa\u7840\u8d44\u6599\u6a21\u677f\u5217\u8868\u63d2\u4ef6")
public class HRBaseDataTplList
extends HRDataBaseList {
    private Map<String, Object> params;
    private static Log LOGGER = LogFactory.getLog(HRBaseDataTplList.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setButtonStatus();
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        if ("enable".equals(args.getListFieldKey()) && StringUtils.equals((CharSequence)this.getEnableStatus(), (CharSequence)"1")) {
            Iterator it = args.getComboItems().iterator();
            while (it.hasNext()) {
                ValueMapItem valueMapItem = (ValueMapItem)it.next();
                if (!valueMapItem.getValue().equals("10")) continue;
                it.remove();
            }
        }
        super.listColumnCompareTypesSet(args);
    }

    private void setDefValue() {
        String billFormId = this.getBillFormId();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billFormId);
        IDataEntityProperty statusProp = mainType.findProperty(((BasedataEntityType)mainType).getBillStatus());
        if (!(Objects.isNull(statusProp) || this.isAuditCheck() && !this.getHisModelCondition(billFormId))) {
            LOGGER.info("kd.hr.hbp.formplugin.web.template.HRBaseDataTplList.setDefValue:{}", (Object)billFormId);
            ((BillStatusProp)statusProp).setDefValue((Object)"C");
            HashMap<String, String> mapParam = new HashMap<String, String>();
            mapParam.put("formId", billFormId);
            FormShowParameter parameter = FormShowParameter.createFormShowParameter(mapParam);
            IFormView view = parameter.createViewForWebApi();
            view.initialize(parameter);
            BillEntityType dt = (BillEntityType)view.getModel().getDataEntityType();
            String billStatusKey = dt.getBillStatus();
            boolean isDefaultAudit = BillStatus.C.name().equals(((FieldProp)dt.getProperty(billStatusKey)).getDefValue());
            LOGGER.info("kd.hr.hbp.formplugin.web.template.HRBaseDataTplList.isDefaultAudit:{}", (Object)isDefaultAudit);
        }
    }

    private boolean getHisModelCondition(String billFormId) {
        String entityType = HisCommonService.getInstance().entityInhRelation(billFormId);
        return EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(entityType) || EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(entityType);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (!e.getParameter().getBillStatus().equals((Object)BillOperationStatus.ADDNEW)) {
            this.setDefValue();
        } else {
            String billFormId = this.getBillFormId();
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)billFormId);
            IDataEntityProperty statusProp = mainType.findProperty(((BasedataEntityType)mainType).getBillStatus());
            if (!(Objects.isNull(statusProp) || this.isAuditCheck() && !this.getHisModelCondition(billFormId))) {
                ((BillStatusProp)statusProp).setDefValue((Object)"A");
            }
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List schemeFilterColumns = args.getSchemeFilterColumns();
        Iterator it = schemeFilterColumns.iterator();
        while (it.hasNext()) {
            FilterColumn schemeFilterColumn = (FilterColumn)it.next();
            if (!this.isAuditCheck() && StringUtils.equals((CharSequence)schemeFilterColumn.getFieldName(), (CharSequence)"status")) {
                it.remove();
            }
            if (!StringUtils.equals((CharSequence)schemeFilterColumn.getFieldName(), (CharSequence)"enable") || StringUtils.equals((CharSequence)this.getEnableStatus(), (CharSequence)"10")) continue;
            List comboItems = ((SchemeFilterColumn)schemeFilterColumn).getComboItems();
            this.removeItr(comboItems);
        }
        List commonFilterColumns = args.getCommonFilterColumns();
        Iterator commonIt = commonFilterColumns.iterator();
        while (commonIt.hasNext()) {
            FilterColumn filterColumn = (FilterColumn)commonIt.next();
            if (!this.isAuditCheck() && StringUtils.equals((CharSequence)filterColumn.getFieldName(), (CharSequence)"status")) {
                commonIt.remove();
            }
            if (!StringUtils.equals((CharSequence)filterColumn.getFieldName(), (CharSequence)"enable") || StringUtils.equals((CharSequence)this.getEnableStatus(), (CharSequence)"10")) continue;
            List comboItems = ((CommonFilterColumn)filterColumn).getComboItems();
            this.removeItr(comboItems);
        }
    }

    private void removeItr(List<ComboItem> comboItems) {
        comboItems.removeIf(next -> HRStringUtils.equals((String)next.getValue(), (String)"10"));
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        if (!this.isAuditCheck()) {
            columns.removeIf(column -> StringUtils.equals((CharSequence)column.getListFieldKey(), (CharSequence)"status"));
        }
    }

    private void setButtonStatus() {
        if (this.isAuditCheck()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"tblaudit", "tblunaudit", "tblsubmit", "tblunsubmit"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblaudit", "tblunaudit", "tblsubmit", "tblunsubmit"});
        }
    }

    private boolean isAuditCheck() {
        this.getParams(this.getBillFormId());
        return (Boolean)this.params.get("auditcheck");
    }

    private String getEnableStatus() {
        this.getParams(this.getBillFormId());
        return (String)this.params.get("enablestatus");
    }

    private void getParams(String billFormId) {
        if (Objects.isNull(this.params) || this.params.size() == 0) {
            this.params = HRBaseDataConfigUtil.getStatus((String)billFormId);
        }
    }

    private String getBillFormId() {
        return ((BillList)this.getControl("billlistap")).getListModel().getDataEntityType().getName();
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        HRCertCheckServiceHelper.check((FormShowParameter)e.getFormShowParameter(), (PreOpenFormEventArgs)e);
    }
}

