/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.template;

import java.util.Collection;
import java.util.List;
import kd.bos.base.BasedataHelper;
import kd.bos.base.IBasedataController;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.model.OrgTreeParam;
import kd.bos.org.utils.OrgBillListCommon;
import kd.bos.org.utils.OrgTreeUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public interface IHRF7AdminOrgTreeListPlugin {
    public static final Log LOGGER = LogFactory.getLog(IHRF7AdminOrgTreeListPlugin.class);
    public static final String CONTROLLER_FILTERS = "controllerFilters";
    public static final String IS_SEARCH_CLICK = "isSearchClick";

    public IFormView getView();

    public ITreeModel getTreeModel();

    public IDataModel getModel();

    public IPageCache getPageCache();

    default public void initAdminOrgTree() {
        Object rootId = this.getView().getFormShowParameter().getCustomParam("rootId");
        long orgId = StringUtils.isNotBlank((Object)rootId) ? Long.parseLong(rootId.toString()) : 0L;
        OrgTreeParam param = this.getOrgTreeParam(orgId);
        TreeNode root = OrgUnitServiceHelper.getTreeRootNodeById((OrgTreeParam)param);
        if (root == null) {
            root = new TreeNode("", "0", ResManager.loadKDString((String)"\u5168\u90e8", (String)"OrgViewTreeListPlugin_0", (String)"bos-org-formplugin", (Object[])new Object[0]));
        }
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    default public OrgTreeParam getOrgTreeParam(long orgId) {
        boolean buildRootNodeInRange;
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        OrgTreeParam param = new OrgTreeParam();
        param.setId(orgId);
        String orgViewNumber = this.getOrgViewNumber();
        param.setOrgViewNumber(orgViewNumber);
        param.setMarkFreeze(true);
        boolean includeDisable = OrgBillListCommon.isIncludeFreeze((IDataModel)this.getModel());
        param.setIncludeFreeze(includeDisable);
        param.setIncludeDisable(includeDisable);
        this.buildBaseDataControllerTreeFilter(param.getCustomFilterList());
        boolean bl = buildRootNodeInRange = !listShowParameter.isLookUp() || 0 == listShowParameter.getF7Style() || 3 == listShowParameter.getF7Style();
        if (buildRootNodeInRange) {
            param.getCustomFilterList().addAll(listShowParameter.getListFilterParameter().getQFilters());
        }
        param.setBuildRootNodeInRange(buildRootNodeInRange);
        return param;
    }

    default public void buildBaseDataControllerTreeFilter(List<QFilter> qFilters) {
        this.buildBaseDataControllerFilter(qFilters, false);
    }

    default public void buildBaseDataControllerFilter(List<QFilter> qFilters, boolean isAddListFilter) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        EntityType dataEntityType = ((IListView)this.getView()).getListModel().getDataEntityType();
        if (StringUtils.isNotEmpty((CharSequence)this.getPageCache().get(CONTROLLER_FILTERS))) {
            List controllerFilters = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(CONTROLLER_FILTERS), QFilter.class);
            qFilters.addAll(controllerFilters);
        } else if ("t_org_structure".equalsIgnoreCase(dataEntityType.getAlias())) {
            String orgViewType = this.getOrgViewType();
            listShowParameter.setCustomParam("orgFuncId", (Object)orgViewType);
            listShowParameter.setCustomParam("orgViewSchemeNumber", (Object)this.getOrgViewNumber());
            listShowParameter.setCustomParam("isshowdisabled", (Object)OrgBillListCommon.isIncludeFreeze((IDataModel)this.getModel()));
            BaseDataCustomControllerEvent event = new BaseDataCustomControllerEvent((Object)this, listShowParameter);
            BasedataEntityType entityType = this.getBillListEntityType(orgViewType, isAddListFilter, dataEntityType);
            List controllers = BasedataHelper.createPlugin((List)entityType.getBasedataControllersProp());
            for (IBasedataController controller : controllers) {
                controller.buildBaseDataCoreFilter(event);
            }
            qFilters.addAll(event.getQfilters());
            this.getPageCache().put(CONTROLLER_FILTERS, SerializationUtils.toJsonString((Object)event.getQfilters()));
        }
    }

    default public BasedataEntityType getBillListEntityType(String orgViewType, boolean isAddListFilter, EntityType dataEntityType) {
        BasedataEntityType entityType = null;
        if (isAddListFilter && !this.isOrgF7()) {
            entityType = (BasedataEntityType)dataEntityType;
        }
        if (entityType == null) {
            entityType = "01".equals(orgViewType) ? (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_adminorg") : (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"bos_org");
        }
        return entityType;
    }

    default public boolean isOrgF7() {
        return ((ListShowParameter)this.getView().getFormShowParameter()).isLookUp();
    }

    default public String getOrgViewNumber() {
        return "01";
    }

    default public String getOrgViewType() {
        return "01";
    }

    default public void buildAdminOrgTreeListFilter(BuildTreeListFilterEvent e) {
        QFilter subOrgFilter;
        e.setCancel(true);
        if (!Boolean.parseBoolean(this.getPageCache().get(IS_SEARCH_CLICK)) && (subOrgFilter = this.getBuildTreeListFilter(e.getNodeId().toString())) != null) {
            e.addQFilter(subOrgFilter);
        }
    }

    default public QFilter getBuildTreeListFilter(String nodeId) {
        if (!StringUtils.isBlank((CharSequence)nodeId) && !"0".equals(nodeId)) {
            QFilter subOrgFilter;
            long orgId = Long.parseLong(nodeId);
            if (this.isIncludeGrand()) {
                QFilter orgFilter;
                String orgViewNumber = this.getOrgViewNumber();
                QFilter viewFilter = new QFilter("view.number", "=", (Object)orgViewNumber);
                QFilter[] filters = new QFilter[]{viewFilter, orgFilter = new QFilter(this.getOrgField(), "=", (Object)orgId)};
                DynamicObject structObj = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"longnumber", (QFilter[])filters);
                if (structObj == null) {
                    return null;
                }
                String longNumberFilter = structObj.getString("longnumber") + "!%";
                subOrgFilter = QFilter.like((String)this.getOrgLongNumber(), (String)longNumberFilter);
            } else {
                subOrgFilter = new QFilter(this.getParentOrgField(), "=", (Object)orgId);
            }
            QFilter currentOrgFilter = new QFilter(this.getOrgField(), "=", (Object)orgId);
            currentOrgFilter = currentOrgFilter.or(subOrgFilter);
            return currentOrgFilter;
        }
        return null;
    }

    default public void afterFilterContainerSearchClick(FilterContainerSearchClickArgs args) {
        if (!CollectionUtils.isEmpty((Collection)args.getFastQFilters())) {
            this.getPageCache().put(IS_SEARCH_CLICK, "true");
        }
        OrgTreeUtils.removeListRowClickCache((IPageCache)this.getPageCache());
    }

    default public boolean isIncludeGrand() {
        return false;
    }

    default public String getOrgField() {
        return "org";
    }

    default public String getParentOrgField() {
        return "parent";
    }

    default public String getOrgLongNumber() {
        return "longnumber";
    }
}

