/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.devportal.common.util.AppUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRAppServiceHelper;
import kd.hr.hbp.business.servicehelper.HRCloudServiceHelper;
import kd.hr.hbp.formplugin.web.template.IHRF7TreeFilter;

public interface IHRF7CloudAppTreeListPlugin
extends IHRF7TreeFilter {
    public static final Log LOGGER = LogFactory.getLog(IHRF7CloudAppTreeListPlugin.class);
    public static final String LEAFTYPE = "leafType";
    public static final String LEAFTYPE_APP = "app";
    public static final String LEAFTYPE_CLOUD = "cloud";

    public IFormView getView();

    public ITreeModel getTreeModel();

    default public void initCloudAppTree() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String leafType = (String)listShowParameter.getCustomParam(LEAFTYPE);
        if (StringUtils.isEmpty((CharSequence)leafType)) {
            leafType = LEAFTYPE_APP;
        }
        boolean onlyVisible = LEAFTYPE_CLOUD.equals(leafType) || !listShowParameter.isLookUp();
        List cloudIds = HRCloudServiceHelper.getAllHRCommonCloudIdsSort();
        Set appIds = HRAppServiceHelper.getAllHRAppIdsExceptExt((boolean)onlyVisible);
        Set allAppIds = HRAppServiceHelper.getAllHRAppIds((boolean)onlyVisible);
        listShowParameter.setCustomParam("hr_bizappids", (Object)SerializationUtils.toJsonString((Object)allAppIds));
        listShowParameter.setCustomParam("hr_bizappidsExceptExt", (Object)SerializationUtils.toJsonString((Object)appIds));
        if (LEAFTYPE_APP.equals(leafType)) {
            String tempIds;
            appIds = allAppIds;
            String extCloudId = (String)listShowParameter.getCustomParam("extCloudId");
            if (StringUtils.isNotEmpty((CharSequence)extCloudId)) {
                List<String> extCloudIds = Arrays.asList(extCloudId.split(","));
                cloudIds.addAll(extCloudIds);
                appIds.addAll(HRAppServiceHelper.getAPPByCloudIds(extCloudIds, (boolean)onlyVisible));
            }
            if (StringUtils.isNotEmpty((CharSequence)(tempIds = (String)listShowParameter.getCustomParam("bizappids")))) {
                appIds = (Set)SerializationUtils.fromJsonString((String)tempIds, Set.class);
            }
        } else {
            String extCloudId;
            String isShowExtApp = (String)listShowParameter.getCustomParam("isShowExtapp");
            if (StringUtils.isNotEmpty((CharSequence)isShowExtApp) && Boolean.parseBoolean(isShowExtApp)) {
                appIds = allAppIds;
            }
            if (StringUtils.isNotEmpty((CharSequence)(extCloudId = (String)listShowParameter.getCustomParam("extCloudId")))) {
                List<String> extCloudIds = Arrays.asList(extCloudId.split(","));
                cloudIds.addAll(extCloudIds);
                if (StringUtils.isNotEmpty((CharSequence)isShowExtApp) && Boolean.parseBoolean(isShowExtApp)) {
                    appIds.addAll(HRAppServiceHelper.getAPPByCloudIds(extCloudIds, (boolean)onlyVisible));
                } else {
                    appIds.addAll(HRAppServiceHelper.getAppExceptExtByCloudIds(extCloudIds, (boolean)onlyVisible));
                }
            }
        }
        String industryId = (String)listShowParameter.getCustomParam("industryid");
        TreeNode root = AppUtils.getSubsysTree((String[])cloudIds.toArray(new String[cloudIds.size()]), (String[])appIds.toArray(new String[appIds.size()]), (String)industryId, (String)leafType, (boolean)true, (boolean)false, (boolean)true);
        if (root.getChildren() != null) {
            Map<String, TreeNode> children = root.getChildren().stream().collect(Collectors.toMap(TreeNode::getId, it -> it));
            ArrayList childrenList = Lists.newArrayListWithExpectedSize((int)cloudIds.size());
            for (String cloudId : cloudIds) {
                if (null == children.get(cloudId)) continue;
                childrenList.add(children.get(cloudId));
            }
            root.setChildren((List)childrenList);
        }
        this.getTreeModel().setRoot(root);
        String rootId = root.getId();
        this.getTreeModel().setCurrentNodeId((Object)rootId);
        LOGGER.debug("\u5b50\u7cfb\u7edf\u6811\u6839\u8282\u70b9ID\u4e3a\uff1a%s", (Object)rootId);
    }

    /*
     * WARNING - void declaration
     */
    default public void buildCloudAppTreeListFilter(BuildTreeListFilterEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String type = (String)listShowParameter.getCustomParam(LEAFTYPE);
        String currentNodeId = (String)evt.getNodeId();
        TreeNode currentNode = this.getTreeModel().getRoot().getTreeNode(currentNodeId, 5);
        String leafType = (String)currentNode.getData();
        if (StringUtils.isNotEmpty((CharSequence)type) && LEAFTYPE_CLOUD.equals(type)) {
            List cloudNodeList;
            HashSet cloudList = Sets.newHashSetWithExpectedSize((int)16);
            if (LEAFTYPE_CLOUD.equals(leafType)) {
                cloudList.add(currentNodeId);
            } else if ("root".equals(leafType) && (cloudNodeList = this.getTreeModel().getRoot().getChildren()) != null && cloudNodeList.size() > 0) {
                for (TreeNode treeNode : cloudNodeList) {
                    if (null == treeNode || null == treeNode.getId()) continue;
                    cloudList.add(treeNode.getId());
                }
            }
            QFilter q1 = new QFilter(this.getCloudId(), "in", (Object)cloudList);
            evt.addQFilter(q1);
        } else {
            DynamicObject[] cloudNodeList;
            List appNodeList;
            HashSet appList = Sets.newHashSetWithExpectedSize((int)16);
            if (LEAFTYPE_CLOUD.equals(leafType)) {
                appNodeList = currentNode.getChildren();
                if (appNodeList != null && !appNodeList.isEmpty()) {
                    for (TreeNode treeNode : appNodeList) {
                        if (null == treeNode || !StringUtils.isNotEmpty((CharSequence)treeNode.getId())) continue;
                        appList.add(treeNode.getId());
                    }
                }
            } else if ("root".equals(leafType)) {
                appNodeList = Lists.newArrayListWithExpectedSize((int)16);
                cloudNodeList = this.getTreeModel().getRoot().getChildren();
                if (cloudNodeList != null && cloudNodeList.size() > 0) {
                    for (TreeNode treeNode : cloudNodeList) {
                        if (null == treeNode || null == treeNode.getChildren()) continue;
                        appNodeList.addAll(treeNode.getChildren());
                    }
                    for (TreeNode treeNode : appNodeList) {
                        if (null == treeNode || !StringUtils.isNotEmpty((CharSequence)treeNode.getId())) continue;
                        appList.add(treeNode.getId());
                    }
                }
            } else {
                appList.add(currentNodeId);
            }
            if (!appList.isEmpty()) {
                DynamicObject[] objs = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("masterid", "in", (Object)appList)});
                if (objs.length > 0) {
                    void var11_20;
                    cloudNodeList = objs;
                    int n = cloudNodeList.length;
                    boolean bl = false;
                    while (var11_20 < n) {
                        DynamicObject dynamicObject = cloudNodeList[var11_20];
                        appList.add(dynamicObject.getString("id"));
                        ++var11_20;
                    }
                }
                QFilter qFilter = new QFilter(this.getBizAppId(), "in", (Object)appList);
                evt.addQFilter(qFilter);
            }
        }
    }

    default public void addFilter(SetFilterEvent evt) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        QFilter customFilter = this.getCustomFilter(listShowParameter);
        if (null != customFilter) {
            evt.addCustomQFilter(customFilter);
            return;
        }
        String type = (String)listShowParameter.getCustomParam(LEAFTYPE);
        if (StringUtils.isNotEmpty((CharSequence)type) && LEAFTYPE_CLOUD.equals(type) && StringUtils.isEmpty((CharSequence)this.getBizAppId())) {
            return;
        }
        QFilter qFilter = this.getHRAppFilter(listShowParameter);
        if (null != qFilter) {
            evt.addCustomQFilter(qFilter);
        }
    }

    @Override
    default public String getBizAppId() {
        return "bizappid";
    }

    @Override
    default public String getCloudId() {
        return "bizcloud";
    }
}

