/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util.newhismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.repository.HisLineTimeDao;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.HRBaseDataConfigUtil;
import kd.hr.hbp.common.constants.newhismodel.HisDisableOperateConstants;
import kd.hr.hbp.common.constants.newhismodel.HisFieldNameConstants;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisDisableTool
implements HisLineTimeTplConstants,
HisFieldNameConstants,
HisDisableOperateConstants {
    private static final Log LOGGER = LogFactory.getLog(HisDisableTool.class);

    public static void showSetDisableDatePage(BeforeDoOperationEventArgs args, String formId, IFormView view, IFormPlugin plugin) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        Map hisEntityEventMap = (Map)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSHismodelService", (String)"getHisEntityEventBo", (Object[])new Object[]{formId});
        String setDisableDate = (String)hisEntityEventMap.get("setdisabledate");
        if (HRStringUtils.equals((String)setDisableDate, (String)"true")) {
            HisDisableTool.setDisablePage(args, view, plugin);
        } else {
            op.getOption().setVariableValue("isshowmessage", "false");
        }
    }

    private static void setDisablePage(BeforeDoOperationEventArgs args, IFormView view, IFormPlugin plugin) {
        String disableDateStr;
        AbstractOperate op = (AbstractOperate)args.getSource();
        boolean showTips = false;
        if (args.getListSelectedData().isEmpty()) {
            String status = (String)view.getModel().getValue("status");
            String enable = (String)view.getModel().getValue("enable");
            if (!HRStringUtils.equals((String)status, (String)"C") || HRStringUtils.equals((String)enable, (String)"10")) {
                op.getOption().setVariableValue("isshowmessage", "false");
                return;
            }
        } else {
            boolean notOpen;
            boolean needAudit = HRBaseDataConfigUtil.getAudit((String)((IListView)view).getBillFormId());
            Set pks = args.getListSelectedData().stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            Map enableMap = HisLineTimeDao.getInstance().queryEnables(((IListView)view).getBillFormId(), pks);
            boolean bl = notOpen = needAudit ? args.getListSelectedData().stream().noneMatch(data -> "C".equals(data.getBillStatus()) && !"10".equals(enableMap.get(data.getPrimaryKeyValue()))) : args.getListSelectedData().stream().allMatch(data -> "10".equals(enableMap.get(data.getPrimaryKeyValue())));
            if (notOpen) {
                op.getOption().setVariableValue("isshowmessage", "false");
                return;
            }
            showTips = needAudit ? args.getListSelectedData().stream().anyMatch(data -> !"C".equals(data.getBillStatus()) || "10".equals(enableMap.get(data.getPrimaryKeyValue()))) : args.getListSelectedData().stream().anyMatch(data -> "10".equals(enableMap.get(data.getPrimaryKeyValue())));
        }
        if (HRStringUtils.isEmpty((String)(disableDateStr = view.getPageCache().get("hisSetDisableDate")))) {
            args.setCancel(true);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hbp_hissetdisabledate");
            OpenStyle style = new OpenStyle();
            style.setShowType(ShowType.Modal);
            formShowParameter.setOpenStyle(style);
            formShowParameter.setCustomParam("showTips", (Object)showTips);
            formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "setDisableDate"));
            view.showForm(formShowParameter);
        } else {
            op.getOption().setVariableValue("isshowmessage", "false");
            op.getOption().setVariableValue("hisDisableDate", disableDateStr);
            view.getPageCache().put("hisDisableDate", disableDateStr);
            view.getPageCache().remove("hisSetDisableDate");
        }
    }

    public static void showDisableResultForEdit(AfterDoOperationEventArgs args, IFormView view, IFormPlugin plugin) {
        Set notConfirmIds = Collections.emptySet();
        String hisDisableDate = view.getPageCache().get("hisDisableDate");
        if (HRStringUtils.isNotEmpty((String)hisDisableDate)) {
            try {
                Date disableDate = HRDateTimeUtils.parseDate((String)view.getPageCache().get("hisDisableDate"));
                notConfirmIds = HisCommonEntityRepository.getAllToBeEffectBoIdByBoId((HRBaseServiceHelper)new HRBaseServiceHelper(view.getEntityId()), (Collection)Stream.of((Long)view.getModel().getValue("id")).collect(Collectors.toList()), (Date)disableDate);
            }
            catch (ParseException ex) {
                LOGGER.error((Throwable)ex);
            }
        } else {
            notConfirmIds = HisCommonEntityRepository.getAllToBeEffectBoIdByBoId((HRBaseServiceHelper)new HRBaseServiceHelper(view.getEntityId()), (DynamicObject[])new DynamicObject[]{view.getModel().getDataEntity()});
        }
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        notConfirmIds.removeIf(successPkIds::contains);
        if (notConfirmIds.isEmpty()) {
            if (args.getOperationResult().isSuccess()) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"HisDisableTool_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            } else if (!args.getOperationResult().getAllErrorOrValidateInfo().isEmpty()) {
                ValidationErrorInfo info = (ValidationErrorInfo)args.getOperationResult().getAllErrorOrValidateInfo().get(0);
                String errorLevel = info.getErrorLevel();
                if (HRStringUtils.equals((String)errorLevel, (String)ErrorLevel.FatalError.name())) {
                    view.showErrorNotification(info.getMessage());
                } else {
                    view.showTipNotification(info.getMessage());
                }
            } else {
                view.showTipNotification(args.getOperationResult().getMessage());
            }
            view.invokeOperation("refresh");
            return;
        }
        if (notConfirmIds.size() > 0) {
            HisDisableTool.showConfirmDisableResultPage(notConfirmIds, view, plugin);
        }
    }

    public static void showDisableResultForList(AfterDoOperationEventArgs args, IFormView view, IFormPlugin plugin) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        ListSelectedRowCollection selectRows = ((ListView)view).getSelectedRows();
        Set selectRowIds = selectRows.stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
        int count = selectRowIds.size();
        int successCount = args.getOperationResult().getSuccessPkIds().size();
        HashMap pkNumbers = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList errorMsgList = Lists.newArrayListWithCapacity((int)16);
        ArrayList failedIds = Lists.newArrayListWithCapacity((int)16);
        args.getOperationResult().getAllErrorOrValidateInfo().stream().limit(1000L).forEach(info -> {
            if (info.getPkValue() == null) {
                return;
            }
            pkNumbers.put(info.getPkValue().toString(), info.getMessage().split(":")[0]);
            errorMsgList.add(info.getMessage());
            failedIds.add((Long)info.getPkValue());
        });
        String sysMsg = args.getOperationResult().getMessage();
        if (errorMsgList.isEmpty() && HRStringUtils.isNotEmpty((String)sysMsg)) {
            errorMsgList.add(sysMsg);
        }
        ListShowParameter parameter = (ListShowParameter)view.getFormShowParameter();
        String hisDisableDate = view.getPageCache().get("hisDisableDate");
        Set notConfirmIds = Collections.emptySet();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(parameter.getBillFormId());
        if (HRStringUtils.isNotEmpty((String)hisDisableDate)) {
            try {
                Date disableDate = HRDateTimeUtils.parseDate((String)view.getPageCache().get("hisDisableDate"));
                notConfirmIds = HisCommonEntityRepository.getAllToBeEffectBoIdByBoId((HRBaseServiceHelper)helper, selectRowIds, (Date)disableDate);
                notConfirmIds.removeAll(failedIds);
            }
            catch (ParseException ex) {
                LOGGER.error((Throwable)ex);
            }
        } else {
            DynamicObject[] dys = HisCommonEntityRepository.queryCurrentDataForEffDate((HRBaseServiceHelper)helper, selectRowIds);
            notConfirmIds = HisCommonEntityRepository.getAllToBeEffectBoIdByBoId((HRBaseServiceHelper)helper, (DynamicObject[])dys);
            notConfirmIds.removeAll(failedIds);
        }
        List successPkIds = args.getOperationResult().getSuccessPkIds();
        notConfirmIds.removeIf(successPkIds::contains);
        if (!notConfirmIds.isEmpty()) {
            for (Long rowId : selectRowIds) {
                Optional<ListSelectedRow> selectedRow;
                if (!notConfirmIds.contains(rowId) || !(selectedRow = selectRows.stream().filter(row -> Objects.equals(row.getPrimaryKeyValue(), rowId)).findAny()).isPresent()) continue;
                String number = selectedRow.get().getNumber();
                pkNumbers.put(rowId.toString(), number);
            }
            int failCount = count - successCount - notConfirmIds.size();
            if (notConfirmIds.size() == count) {
                HisDisableTool.showConfirmDisableResultPage(notConfirmIds, view, plugin);
            } else {
                view.getPageCache().put("operationresult", DataEntitySerializer.serializerToString((Object)args.getOperationResult(), (boolean)true, (boolean)true));
                HisDisableTool.showCustomDisableOpResult(view, plugin, count, successCount, failCount, notConfirmIds.size(), pkNumbers, notConfirmIds, op.getOperateName().getLocaleValue(), errorMsgList);
            }
        } else {
            int failCount = count - successCount;
            if (errorMsgList.size() == 1 && count == failCount) {
                view.showTipNotification((String)errorMsgList.get(0));
            } else if (errorMsgList.size() > 0) {
                view.getPageCache().put("operationresult", DataEntitySerializer.serializerToString((Object)args.getOperationResult(), (boolean)true, (boolean)true));
                HisDisableTool.showDefaultDisableOpResult(view, count, successCount, failCount, pkNumbers, op.getOperateName().getLocaleValue(), errorMsgList);
            } else if (count == successCount) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"HisDisableTool_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private static void showConfirmDisableResultPage(Set<Long> notConfirmIds, IFormView view, IFormPlugin plugin) {
        String formId;
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hbp_hisconfirmdisable");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (view instanceof IListView) {
            ListShowParameter parameter = (ListShowParameter)view.getFormShowParameter();
            formId = parameter.getBillFormId();
            showParameter.setCustomParam("showListColumns", HisDisableTool.getBusinessColListMsg(view));
        } else {
            formId = view.getEntityId();
        }
        showParameter.setCustomParam("hisFormId", (Object)formId);
        showParameter.setCustomParam("notConfirmIds", notConfirmIds);
        showParameter.setCustomParam("hisDisableDate", (Object)view.getPageCache().get("hisDisableDate"));
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f85\u786e\u8ba4", (String)"HisDisableTool_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "ConfirmDisable"));
        view.showForm(showParameter);
    }

    private static void showCustomDisableOpResult(IFormView view, IFormPlugin plugin, int count, int successCount, int failCount, int notConfirmCount, Map<String, String> pkNumbers, Set<Long> notConfirmIds, String operateName, List<String> errorMsgList) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hbp_hisdisableresult");
        showParameter.setCustomParam("pkNumbers", pkNumbers);
        showParameter.setCustomParam("hasMore", (Object)(errorMsgList.size() > 5 ? 1 : 0));
        showParameter.setCustomParam("title", (Object)String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c\u7981\u7528\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761\uff0c\u5f85\u786e\u8ba4%4$s\u6761", (String)"HisDisableTool_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), count, successCount, failCount, notConfirmCount));
        showParameter.setCustomParam("failCount", (Object)failCount);
        showParameter.setCustomParam("failtitle", (Object)String.format(ResManager.loadKDString((String)"\u7981\u7528\u5931\u8d25\uff08%s\uff09", (String)"HisDisableTool_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), failCount));
        showParameter.setCustomParam("confirmtitle", (Object)String.format(ResManager.loadKDString((String)"\u5f85\u786e\u8ba4\uff08%s\uff09", (String)"HisDisableTool_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), notConfirmCount));
        showParameter.setCustomParam("operateName", (Object)operateName);
        showParameter.setCustomParam("errorMsg", errorMsgList);
        showParameter.setCustomParam("notConfirmIds", notConfirmIds);
        ListShowParameter parameter = (ListShowParameter)view.getFormShowParameter();
        showParameter.setCustomParam("hisFormId", (Object)parameter.getBillFormId());
        showParameter.setCustomParam("showListColumns", HisDisableTool.getBusinessColListMsg(view));
        showParameter.setCustomParam("hisDisableDate", (Object)view.getPageCache().get("hisDisableDate"));
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "ConfirmDisable"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u7ed3\u679c", (String)"HisDisableTool_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        view.showForm(showParameter);
    }

    private static void showDefaultDisableOpResult(IFormView view, int count, int successCount, int failCount, Map<String, String> pkNumbers, String opName, List<String> errorMsgList) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_operationresult");
        showParameter.setCustomParam("pkNumbers", pkNumbers);
        showParameter.setCustomParam("hasMore", (Object)(failCount > 5 ? 1 : 0));
        showParameter.setCustomParam("operateName", (Object)opName);
        showParameter.setCustomParam("title", (Object)String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u5355\u636e\uff0c\u7981\u7528\u6210\u529f%2$s\u6761\uff0c\u5931\u8d25%3$s\u6761", (String)"HisDisableTool_7", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), count, successCount, failCount));
        showParameter.setCustomParam("errorMsg", errorMsgList);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setShowTitle(false);
        view.showForm(showParameter);
    }

    private static List<Map<String, String>> getBusinessColListMsg(IFormView view) {
        ArrayList colMap = Lists.newArrayListWithCapacity((int)16);
        ((ListView)view).getShowListColumns().stream().filter(col -> HRStringUtils.equals((String)"gridview", (String)col.getParentViewKey())).forEach(col -> {
            HashMap<String, String> map = new HashMap<String, String>(16);
            map.put("key", col.getListFieldKey());
            map.put("caption", col.getCaption().getLocaleValue());
            colMap.add(map);
        });
        return colMap;
    }

    public static void resetEnableField(IDataModel model) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(model.getDataEntityType().getName());
        DynamicObject dy = helper.queryOriginalOne("enable,status", model.getValue("boid"));
        model.setValue("enable", (Object)dy.getBoolean("enable"));
        if (model.getDataEntityType().getProperties().containsKey((Object)"status")) {
            model.setValue("status", dy.get("status"));
        }
    }
}

