/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util.newhismodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Toolbar;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.BasedataFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.BarItemAp;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.constants.newhismodel.HisSysConstants;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisModelEditBtnGenTool
implements HisLineTimeTplConstants,
HisSysConstants {
    public static void createBdBillEditSaveBtn(IFormView view) {
        Container toolBar = (Container)view.getControl("tbmain");
        if (toolBar == null) {
            return;
        }
        toolBar.deleteControls(new String[]{"bar_save"});
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        HisModelEditBtnGenTool.genSaveHisBtn(items);
        toolBar.insertControls(0, (List)items);
    }

    public static void displayReviseBtnBar(IFormView view) {
        Set<String> btnSet = HisModelEditBtnGenTool.getAllEditBtnKeySet(view);
        HashSet<String> displaySet = new HashSet<String>(Arrays.asList("bar_save", "bar_close"));
        for (String btn : btnSet) {
            if (displaySet.contains(btn)) {
                view.setVisible(Boolean.TRUE, new String[]{btn});
                continue;
            }
            view.setVisible(Boolean.FALSE, new String[]{btn});
        }
    }

    public static void displayAfterNewVersionSave(IFormView view) {
        List<String> btnSet = HisModelEditBtnGenTool.getAllEditBtnKeyWithDefault(view);
        HashSet<String> disPlaySet = new HashSet<String>(16);
        disPlaySet.add("tblclosehis");
        String enableRevise = view.getPageCache().get("openrevise");
        if (HRStringUtils.equals((String)enableRevise, (String)"1")) {
            disPlaySet.add("bar_revise");
        }
        for (String btn : btnSet) {
            if (disPlaySet.contains(btn)) {
                view.setVisible(Boolean.TRUE, new String[]{btn});
                continue;
            }
            view.setVisible(Boolean.FALSE, new String[]{btn});
        }
    }

    public static void displayReviseVersionSave(IFormView view) {
        Set<String> btnSet = HisModelEditBtnGenTool.getAllEditBtnKeySet(view);
        btnSet.add("tblclosehis");
        HashSet<String> disPlaySet = new HashSet<String>(Arrays.asList("bar_revise", "bar_reviserecord", "bar_close"));
        for (String btn : btnSet) {
            if (disPlaySet.contains(btn)) {
                view.setVisible(Boolean.TRUE, new String[]{btn});
                continue;
            }
            view.setVisible(Boolean.FALSE, new String[]{btn});
        }
    }

    public static void hideAfterReviseSave(IFormView view) {
        Set<String> btnSet = HisModelEditBtnGenTool.getAllEditBtnKeySet(view);
        btnSet.add("tblclosehis");
        HashSet<String> hideSet = new HashSet<String>(Arrays.asList("bar_save", "bar_saveandnew", "bar_more", "bar_new", "bar_modify", "bar_delete", "bar_submit", "bar_audit", "baritemap", "bar_reviserecord"));
        for (String btn : btnSet) {
            if (hideSet.contains(btn)) {
                view.setVisible(Boolean.FALSE, new String[]{btn});
                continue;
            }
            view.setVisible(Boolean.TRUE, new String[]{btn});
        }
    }

    public static void createBillEditReviseBtnBar(IFormView view, String fromPage) {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        Container toolBar = (Container)view.getControl("tbmain");
        if (toolBar == null) {
            return;
        }
        List<String> btnList = HisModelEditBtnGenTool.getAllEditBtnKeyWithDefault(view);
        toolBar.deleteControls(btnList.toArray(new String[0]));
        if (HRStringUtils.equals((String)"revise", (String)fromPage)) {
            HisModelEditBtnGenTool.genSaveHisBtn(items);
            HisModelEditBtnGenTool.genReviseBtn(items);
        }
        HisModelEditBtnGenTool.genCloseBtn(items);
        toolBar.addControls((List)items);
    }

    public static void createBillEditHisBtnBar(IFormView view, boolean needAudit) {
        Container toolBar = (Container)view.getControl("tbmain");
        if (toolBar == null) {
            return;
        }
        List<String> btnList = HisModelEditBtnGenTool.getAllEditBtnKeyWithDefault(view);
        btnList.add("hisversionbtn");
        btnList.add("tblclosehis");
        btnList.add("bar_close");
        HashSet<String> remainedBtn = new HashSet<String>(1);
        remainedBtn.add("bar_disable");
        remainedBtn.add("bar_delete");
        remainedBtn.add("bar_saveandnew");
        remainedBtn.add("bar_submit");
        remainedBtn.add("bar_audit");
        for (String btn : btnList) {
            if (remainedBtn.contains(btn)) continue;
            toolBar.deleteControls(new String[]{btn});
        }
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        HisModelEditBtnGenTool.genChangeBtn(items);
        view.setVisible(Boolean.FALSE, new String[]{"insertdatabtn"});
        if (needAudit) {
            HisModelEditBtnGenTool.genSaveHisBtn(items);
            HisModelEditBtnGenTool.genConfirmChangeBtn(items);
        } else {
            HisModelEditBtnGenTool.genConfirmChangeBtnNoAudit(items);
        }
        HisModelEditBtnGenTool.genReviseBtn(items);
        HisModelEditBtnGenTool.genHisInfoBtn(items);
        view.setVisible(Boolean.FALSE, new String[]{"hisversionbtn", "bar_delete", "bar_saveandnew", "bar_submit", "bar_audit"});
        HisModelEditBtnGenTool.genCloseBtn(items);
        toolBar.addControls((List)items);
    }

    public static void onlyCloseBtnBar(IFormView view) {
        Container toolBar = (Container)view.getControl("tbmain");
        if (toolBar == null) {
            return;
        }
        List<String> btnList = HisModelEditBtnGenTool.getAllEditBtnKeyWithDefault(view);
        for (String btn : btnList) {
            toolBar.deleteControls(new String[]{btn});
        }
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        HisModelEditBtnGenTool.genCloseBtn(items);
        toolBar.addControls((List)items);
        view.setVisible(Boolean.FALSE, new String[]{"pagepanel"});
    }

    public static void afterConfirmChangeHisBtnBar(IFormView view) {
        String enableRevise = view.getPageCache().get("openrevise");
        Set<String> btnSet = HisModelEditBtnGenTool.getAllEditBtnKeySet(view);
        btnSet.add("confirmchange");
        btnSet.add("tblclosehis");
        btnSet.add("hisversionbtn");
        HashSet<String> hideSet = new HashSet<String>(Arrays.asList("bar_save", "bar_saveandnew", "bar_more", "bar_new", "bar_modify", "bar_submit", "bar_audit", "baritemap", "confirmchange", "bar_reviserecord", "bar_close"));
        for (String btn : btnSet) {
            if (hideSet.contains(btn)) {
                view.setVisible(Boolean.FALSE, new String[]{btn});
                continue;
            }
            view.setVisible(Boolean.TRUE, new String[]{btn});
        }
        if (HRStringUtils.equals((String)enableRevise, (String)"1")) {
            view.setVisible(Boolean.TRUE, new String[]{"bar_revise"});
        } else {
            view.setVisible(Boolean.FALSE, new String[]{"bar_revise"});
        }
        view.setVisible(Boolean.FALSE, new String[]{"changedescription"});
    }

    private static void genReviseBtn(List<Map<String, Object>> items) {
        BarItemAp reviseBtn = new BarItemAp();
        reviseBtn.setKey("bar_revise");
        reviseBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u4fee\u8ba2", (String)"HisModelEditBtnGenTool_7", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        reviseBtn.setOperationKey("revise");
        reviseBtn.setCommitValidate(true);
        items.add(reviseBtn.createControl());
        BarItemAp reviseRecordBtn = new BarItemAp();
        reviseRecordBtn.setKey("bar_reviserecord");
        reviseRecordBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u7248\u672c\u4fee\u8ba2\u5386\u53f2", (String)"HisModelEditBtnGenTool_8", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        reviseRecordBtn.setOperationKey("reviserecord");
        reviseRecordBtn.setCommitValidate(true);
        items.add(reviseRecordBtn.createControl());
    }

    public static void createBillListHisBtnBar(IFormView view, boolean needAudit) {
        Container toolBar = (Container)view.getControl("toolbarap");
        if (toolBar == null) {
            return;
        }
        List<String> btnList = HisModelEditBtnGenTool.getAllListBtnKey(view);
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        toolBar.deleteControls(btnList.toArray(new String[0]));
        toolBar.deleteControls(new String[]{"insertdatabtn", "confirmchange", "versionchangecomparebtn", "deletehisbtn", "tblrefreshhis", "tblclosehis"});
        HisModelEditBtnGenTool.genNewHisVersionBtn(items);
        if (needAudit) {
            HisModelEditBtnGenTool.genConfirmChangeBtn(items);
            HisModelEditBtnGenTool.genDeleteHisBtn(items);
        }
        HisModelEditBtnGenTool.genVersionChangeCompareBtn(items);
        HisModelEditBtnGenTool.genRefreshBtn(items);
        HisModelEditBtnGenTool.genCloseBtn(items);
        toolBar.addControls((List)items);
    }

    public static void createNonHisListBtnBar(IFormView view, boolean needAudit) {
        Toolbar toolbar = (Toolbar)view.getControl("toolbarap");
        if (toolbar == null) {
            return;
        }
        List<String> btnList = HisModelEditBtnGenTool.getAllListBtnKey(view);
        toolbar.deleteControls(new String[]{"tbl_auditconfirmchange", "tbl_deletehis", "versionchangecomparebtn", "tblrefreshhis", "tblclosehis"});
        toolbar.deleteControls(btnList.toArray(new String[0]));
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        Container toolBar = (Container)view.getControl("toolbarap");
        if (needAudit) {
            BarItemAp confirmChangeBtn = new BarItemAp();
            confirmChangeBtn.setKey("tbl_auditconfirmchange");
            confirmChangeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4", (String)"HisModelEditBtnGenTool_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
            confirmChangeBtn.setOperationKey("audithisconfirmchange");
            items.add(confirmChangeBtn.createControl());
            BarItemAp deleteBtn = new BarItemAp();
            deleteBtn.setKey("tbl_deletehis");
            deleteBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u5220\u9664", (String)"HisModelEditBtnGenTool_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
            deleteBtn.setOperationKey("deletehis");
            items.add(deleteBtn.createControl());
        }
        HisModelEditBtnGenTool.genVersionChangeCompareBtn(items);
        HisModelEditBtnGenTool.genRefreshBtn(items);
        HisModelEditBtnGenTool.genCloseBtn(items);
        toolBar.addControls((List)items);
    }

    public static void createBillEditNonHisBtnBar(IFormView view, boolean needAudit) {
        Container toolBar = (Container)view.getControl("tbmain");
        if (toolBar == null) {
            return;
        }
        List<String> btnList = HisModelEditBtnGenTool.getAllEditBtnKey(view);
        btnList.add("tblclosehis");
        toolBar.deleteControls(btnList.toArray(new String[0]));
        toolBar.deleteControls(new String[]{"bar_save", "tblclosehis", "bar_revise", "bar_reviserecord"});
        ArrayList items = Lists.newArrayListWithExpectedSize((int)16);
        Map customParams = view.getFormShowParameter().getCustomParams();
        String fromPage = (String)customParams.get("fromPage");
        if (HRStringUtils.equals((String)fromPage, (String)"revise")) {
            HisModelEditBtnGenTool.genSaveHisBtn(items);
            HisModelEditBtnGenTool.genReviseBtn(items);
            HisModelEditBtnGenTool.genCloseBtn(items);
            toolBar.addControls((List)items);
            return;
        }
        if (needAudit) {
            HisModelEditBtnGenTool.genNonChangeSaveBtn(items);
            HisModelEditBtnGenTool.genNonAuditConfirmChange(items);
        } else {
            HisModelEditBtnGenTool.genNonConfirmChange(items);
        }
        HisModelEditBtnGenTool.genReviseBtn(items);
        HisModelEditBtnGenTool.genCloseBtn(items);
        toolBar.addControls((List)items);
    }

    public static void createBillEditNonHisBtnBarForRevise(IFormView view, boolean needAudit) {
        Container toolBar = (Container)view.getControl("tbmain");
        if (toolBar == null) {
            return;
        }
        Set<String> btnSet = HisModelEditBtnGenTool.getAllEditBtnKeySet(view);
        HashSet<String> hisBtnReviseSet = new HashSet<String>(Arrays.asList("bar_save", "bar_close"));
        for (String btn : btnSet) {
            if (hisBtnReviseSet.contains(btn)) {
                view.setVisible(Boolean.TRUE, new String[]{btn});
                continue;
            }
            view.setVisible(Boolean.FALSE, new String[]{btn});
        }
    }

    private static Set<String> getAllEditBtnKeySet(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        String id = MetadataDao.getIdByNumber((String)parameter.getFormId(), (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List allItems = formMeta.getItems();
        HashSet<String> btnSet = new HashSet<String>(16);
        Optional<ControlAp> tbMain = allItems.stream().filter(item -> HRStringUtils.equals((String)item.getKey(), (String)"tbmain")).findFirst();
        tbMain.ifPresent(mainAp -> {
            String mainId = mainAp.getId();
            btnSet.addAll(allItems.stream().filter(item -> HRStringUtils.equals((String)mainId, (String)item.getParentId())).map(AbstractElement::getKey).collect(Collectors.toSet()));
        });
        return btnSet;
    }

    private static List<String> getAllEditBtnKey(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        String id = MetadataDao.getIdByNumber((String)parameter.getFormId(), (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List allItems = formMeta.getItems();
        ArrayList btnList = Lists.newArrayListWithCapacity((int)16);
        Optional<ControlAp> tbMain = allItems.stream().filter(item -> HRStringUtils.equals((String)item.getKey(), (String)"tbmain")).findFirst();
        tbMain.ifPresent(mainAp -> {
            String mainId = mainAp.getId();
            btnList.addAll(allItems.stream().filter(item -> HRStringUtils.equals((String)mainId, (String)item.getParentId())).map(AbstractElement::getKey).collect(Collectors.toSet()));
        });
        return btnList;
    }

    private static List<String> getAllEditBtnKeyWithDefault(IFormView view) {
        List<String> btnList = HisModelEditBtnGenTool.getAllEditBtnKey(view);
        btnList.add("bar_disable");
        btnList.add("bar_save");
        btnList.add("tblclosehis");
        btnList.add("bar_revise");
        btnList.add("bar_reviserecord");
        btnList.add("insertdatabtn");
        btnList.add("bar_close");
        btnList.add("confirmchange");
        return btnList;
    }

    private static List<String> getAllListBtnKey(IFormView view) {
        ListShowParameter parameter = (ListShowParameter)view.getFormShowParameter();
        String id = MetadataDao.getIdByNumber((String)parameter.getBillFormId(), (MetaCategory)MetaCategory.Form);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        List allItems = formMeta.getItems();
        ArrayList btnList = Lists.newArrayListWithCapacity((int)16);
        allItems.stream().filter(controlAp -> controlAp instanceof BasedataFormAp).findFirst().ifPresent(listAp -> {
            List allListItems = ((BasedataFormAp)listAp).getListMeta().getItems();
            allListItems.stream().filter(controlAp -> HRStringUtils.equals((String)controlAp.getKey(), (String)"_toolbar_")).findFirst().ifPresent(toolBar -> {
                String toolBarId = toolBar.getId();
                btnList.addAll(allListItems.stream().filter(control -> HRStringUtils.equals((String)control.getParentId(), (String)toolBarId)).map(AbstractElement::getKey).collect(Collectors.toList()));
            });
        });
        return btnList;
    }

    private static void genNonConfirmChange(List<Map<String, Object>> items) {
        BarItemAp confirmChangeBtn = new BarItemAp();
        confirmChangeBtn.setKey("bar_confirmchange");
        confirmChangeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4", (String)"HisModelEditBtnGenTool_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        confirmChangeBtn.setOperationKey("confirmchange");
        confirmChangeBtn.setCommitValidate(true);
        items.add(confirmChangeBtn.createControl());
    }

    private static void genNonAuditConfirmChange(List<Map<String, Object>> items) {
        BarItemAp confirmChangeBtn = new BarItemAp();
        confirmChangeBtn.setKey("bar_auditconfirmchange");
        confirmChangeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4", (String)"HisModelEditBtnGenTool_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        confirmChangeBtn.setOperationKey("auditconfirmchange");
        confirmChangeBtn.setCommitValidate(true);
        items.add(confirmChangeBtn.createControl());
    }

    private static void genNewHisVersionBtn(List<Map<String, Object>> items) {
        BarItemAp insertDataBtn = new BarItemAp();
        insertDataBtn.setKey("insertdatabtn");
        insertDataBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u65b0\u589e\u6570\u636e\u7248\u672c", (String)"HisModelEditBtnGenTool_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        insertDataBtn.setOperationKey("newhisversion");
        items.add(insertDataBtn.createControl());
    }

    private static void genChangeBtn(List<Map<String, Object>> items) {
        BarItemAp insertDataBtn = new BarItemAp();
        insertDataBtn.setKey("insertdatabtn");
        insertDataBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u53d8\u66f4", (String)"HisModelEditBtnGenTool_10", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        insertDataBtn.setOperationKey("insertdata_his");
        items.add(insertDataBtn.createControl());
    }

    private static void genSaveHisBtn(List<Map<String, Object>> items) {
        BarItemAp saveBtn = new BarItemAp();
        saveBtn.setKey("bar_save");
        saveBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"HisModelEditBtnGenTool_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        saveBtn.setOperationKey("save");
        saveBtn.setCommitValidate(true);
        items.add(saveBtn.createControl());
    }

    private static void genVersionChangeCompareBtn(List<Map<String, Object>> items) {
        BarItemAp confirmChangeBtn = new BarItemAp();
        confirmChangeBtn.setKey("versionchangecomparebtn");
        confirmChangeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u7248\u672c\u5bf9\u6bd4", (String)"HisModelEditBtnGenTool_6", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        confirmChangeBtn.setOperationKey("versionchangecompare");
        confirmChangeBtn.setCommitValidate(true);
        items.add(confirmChangeBtn.createControl());
    }

    private static void genConfirmChangeBtn(List<Map<String, Object>> items) {
        BarItemAp confirmChangeBtn = new BarItemAp();
        confirmChangeBtn.setKey("confirmchange");
        confirmChangeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4", (String)"HisModelEditBtnGenTool_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        confirmChangeBtn.setOperationKey("confirmchange");
        confirmChangeBtn.setCommitValidate(true);
        items.add(confirmChangeBtn.createControl());
    }

    private static void genConfirmChangeBtnNoAudit(List<Map<String, Object>> items) {
        BarItemAp confirmChangeBtn = new BarItemAp();
        confirmChangeBtn.setKey("confirmchange");
        confirmChangeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4", (String)"HisModelEditBtnGenTool_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        confirmChangeBtn.setOperationKey("confirmchangenoaudit");
        confirmChangeBtn.setCommitValidate(true);
        items.add(confirmChangeBtn.createControl());
    }

    private static void genDeleteHisBtn(List<Map<String, Object>> items) {
        BarItemAp deleteHisBtn = new BarItemAp();
        deleteHisBtn.setKey("deletehisbtn");
        deleteHisBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u5220\u9664", (String)"HisModelEditBtnGenTool_3", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        deleteHisBtn.setOperationKey("his_delete");
        items.add(deleteHisBtn.createControl());
    }

    private static void genRefreshBtn(List<Map<String, Object>> items) {
        BarItemAp refreshBtn = new BarItemAp();
        refreshBtn.setKey("tblrefreshhis");
        refreshBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u5237\u65b0", (String)"HisModelEditBtnGenTool_4", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        refreshBtn.setOperationKey("refresh");
        items.add(refreshBtn.createControl());
    }

    private static void genCloseBtn(List<Map<String, Object>> items) {
        BarItemAp closeBtn = new BarItemAp();
        closeBtn.setKey("tblclosehis");
        closeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u9000\u51fa", (String)"HisModelEditBtnGenTool_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        closeBtn.setOperationKey("close");
        items.add(closeBtn.createControl());
    }

    private static void genCloseBtnWithDelete(List<Map<String, Object>> items, Container toolBar) {
        toolBar.deleteControls(new String[]{"tblclosehis", "bar_close"});
        BarItemAp closeBtn = new BarItemAp();
        closeBtn.setKey("tblclosehis");
        closeBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u9000\u51fa", (String)"HisModelEditBtnGenTool_5", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        closeBtn.setOperationKey("close");
        items.add(closeBtn.createControl());
    }

    private static void genNonChangeSaveBtn(List<Map<String, Object>> items) {
        BarItemAp saveBtn = new BarItemAp();
        saveBtn.setKey("bar_changesave");
        saveBtn.setName(new LocaleString(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"HisModelEditBtnGenTool_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        saveBtn.setOperationKey("changesave");
        saveBtn.setCommitValidate(true);
        items.add(saveBtn.createControl());
    }

    private static void genHisInfoBtn(List<Map<String, Object>> items) {
        BarItemAp btn = new BarItemAp();
        btn.setKey("hisversionbtn");
        btn.setName(new LocaleString(ResManager.loadKDString((String)"\u5386\u53f2\u7248\u672c\u4fe1\u606f", (String)"HisModelEditBtnGenTool_9", (String)"hrmp-hbp-formplugin", (Object[])new Object[0])));
        btn.setOperationKey("showhisversion");
        btn.setCommitValidate(true);
        items.add(btn.createControl());
    }
}

