/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util.newhismodel;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.business.domain.repository.HisPersonalDataRepository;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisReviseValidateService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisModelEditBuTool {
    public static void setBuFieldsEnable(IFormView view, IDataModel model) {
        String fromPage = (String)view.getFormShowParameter().getCustomParam("fromPage");
        Long boId = HRLongValueParseService.getInstance().getLongValueFromMap(view.getFormShowParameter().getCustomParams(), "boid");
        String tempPageStatusViewFlag = (String)view.getFormShowParameter().getCustomParam("tempPageStatusView");
        if (HRStringUtils.equals((String)"fromHisAction", (String)fromPage) && HisModelEditBuTool.isCtrlBaseData(model.getDataEntityType()) && !HRStringUtils.equals((String)tempPageStatusViewFlag, (String)"1")) {
            HisModelEditBuTool.setBuFields(boId, view, model);
            model.setDataChanged(false);
            view.setEnable(Boolean.FALSE, new String[]{"createorg", "ctrlstrategy"});
        }
        if (HRStringUtils.equals((String)"revise", (String)fromPage) && HisModelEditBuTool.isCtrlBaseData(model.getDataEntityType())) {
            view.setEnable(Boolean.FALSE, new String[]{"createorg", "ctrlstrategy"});
        }
    }

    private static boolean isCtrlBaseData(MainEntityType entityType) {
        return entityType.getAllFields().keySet().containsAll(Stream.of("createorg", "org", "useorg", "ctrlstrategy").collect(Collectors.toSet()));
    }

    private static void setBuFields(Object boId, IFormView view, IDataModel model) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(model.getDataEntityType().getName());
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "=", boId)};
        DynamicObject currentObj = helper.queryOriginalOne("createorg, org, useorg, ctrlstrategy", qFilters);
        if (currentObj == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"HisModelEditBuTool_01", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            return;
        }
        model.setValue("createorg", currentObj.get("createorg"));
        model.setValue("org", currentObj.get("org"));
        model.setValue("useorg", currentObj.get("useorg"));
        model.setValue("ctrlstrategy", currentObj.get("ctrlstrategy"));
    }

    public static void setReviseFieldsEnable(IFormView view, IDataModel model) {
        boolean isPersionalData = false;
        if (view.getFormShowParameter().getCustomParams().containsKey("isPersonalizeSaveData")) {
            Object isPersionalDataObj = view.getFormShowParameter().getCustomParam("isPersonalizeSaveData");
            if (isPersionalDataObj instanceof String) {
                isPersionalData = HRStringUtils.equals((String)((String)isPersionalDataObj), (String)"true");
            } else if (isPersionalDataObj instanceof Boolean) {
                isPersionalData = (Boolean)isPersionalDataObj;
            }
        }
        String inhRelation = HisCommonService.getInstance().entityInhRelation(model.getDataEntityType().getName());
        String fromPage = (String)view.getFormShowParameter().getCustomParam("fromPage");
        if (HRStringUtils.equals((String)"revise", (String)fromPage) && inhRelation.equals(EnumEntityTpl.LINETIMESEQ_TPL.getNumber())) {
            boolean treeModel = HisReviseValidateService.getInstance().isTreeModel(model.getDataEntityType().getName());
            boolean hasOnlyOneVersion = HisReviseValidateService.getInstance().hasOnlyOneVersion(model.getDataEntityType().getName(), model.getValue("boid"));
            if (treeModel || isPersionalData || !hasOnlyOneVersion) {
                view.setEnable(Boolean.FALSE, new String[]{"bsed"});
            }
            view.setEnable(Boolean.FALSE, new String[]{"bsled"});
        }
    }

    public static boolean exitsOriginSyncData(String entityNumber, Long boid) {
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityNumber);
        if (!isBaseDataCtrl.booleanValue()) {
            return false;
        }
        return HisPersonalDataRepository.exitsOriginSyncData((HRBaseServiceHelper)new HRBaseServiceHelper(entityNumber), (Long)boid);
    }
}

