/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util.newhismodel;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.FieldControlRules;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.application.impl.common.DynamicObjectCommonService;
import kd.hr.hbp.business.application.impl.common.HRLongValueParseService;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentFiledService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.constants.newhismodel.EnumHisVersionSource;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisAttachmentTool;

public class HisNewDataPageFieldsHandler {
    private static volatile HisNewDataPageFieldsHandler handler = null;
    private static final String MODIFY_LOCK_NUMS = "modifyLockNums";
    private static final String MODIFY_NOT_VISIBLE_NUMS = "modifyNotVisibleNums";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisNewDataPageFieldsHandler getInstance() {
        if (handler != null) return handler;
        Class<DynamicObjectCommonService> clazz = DynamicObjectCommonService.class;
        synchronized (DynamicObjectCommonService.class) {
            if (handler != null) return handler;
            handler = new HisNewDataPageFieldsHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public void handlePersonalizedFieldsForChangeBsed(IDataModel model, IFormView view, Date effStartDate, Map<String, Boolean> mapUpdate) {
        QFilter dataStatusQFilter;
        QFilter dateQFilter;
        QFilter versionQFilter;
        Long currentDataId;
        QFilter boIdQFilter;
        HRBaseServiceHelper helper = new HRBaseServiceHelper(model.getDataEntityType().getName());
        DynamicObject versionDy = helper.loadDynamicObject(new QFilter[]{boIdQFilter = new QFilter("boid", "=", (Object)(currentDataId = HRLongValueParseService.getInstance().getLongValueFromMap(view.getFormShowParameter().getCustomParams(), "boid"))), versionQFilter = new QFilter("iscurrentversion", "=", (Object)false), dateQFilter = new QFilter("bsed", "<=", (Object)effStartDate).and(new QFilter("bsled", ">=", (Object)effStartDate)), dataStatusQFilter = new QFilter("datastatus", "in", Stream.of(EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()).collect(Collectors.toSet()))});
        if (versionDy == null) {
            return;
        }
        String versionSource = versionDy.getString("versionsource");
        if (versionSource != null && versionSource.equals(EnumHisVersionSource.ORIGIN_DATA_SINK.getType())) {
            return;
        }
        this.setNewData(model, mapUpdate, versionDy, view);
    }

    public void handlePersonalizedFields(IDataModel model, IFormView view, Map<String, Boolean> mapShare, Map<String, Boolean> mapUpdate) {
        MainEntityType mainType = model.getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap entryMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap attachmentMap = Maps.newHashMapWithExpectedSize((int)16);
        formMeta.getItems().forEach(item -> {
            Boolean allowToShare;
            if (!(item instanceof FieldAp || item instanceof EntryAp || item instanceof AttachmentPanelAp)) {
                return;
            }
            String propKey = item.getKey();
            String lock = "";
            String visible = "edit";
            Boolean allowToUpdate = (Boolean)mapUpdate.get(propKey);
            if (allowToUpdate == null || !allowToUpdate.booleanValue()) {
                lock = "edit";
            }
            if ((allowToShare = (Boolean)mapShare.get(propKey)) != null && !allowToShare.booleanValue()) {
                visible = "";
            }
            if (item instanceof EntryFieldAp) {
                return;
            }
            if (item instanceof FieldAp) {
                this.collectLockAndVisibleNums(fieldMap, visible, lock, propKey);
            } else if (item instanceof AttachmentPanelAp) {
                this.collectLockAndVisibleNums(attachmentMap, visible, "", propKey);
            } else {
                this.collectLockAndVisibleNums(entryMap, visible, lock, propKey);
            }
        });
        Map allFields = model.getDataEntityType().getAllFields();
        Set modifyLockNums = (Set)fieldMap.get(MODIFY_LOCK_NUMS);
        if (modifyLockNums != null) {
            modifyLockNums.removeIf(num -> !allFields.containsKey(num));
        }
        this.setVisibleOrLock(model, view, fieldMap, entryMap, Collections.emptyMap(), attachmentMap);
        view.setEnable(Boolean.TRUE, new String[]{"bsed", "bsled", "changedescription"});
    }

    public void handleInsertNewDataPageFields(IDataModel model, IFormView view) {
        MainEntityType mainType = model.getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        HashMap entryFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap attachmentMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap entryMap = Maps.newHashMapWithExpectedSize((int)16);
        formMeta.getItems().forEach(item -> {
            String propKey = item.getKey();
            String visible = item.getVisible();
            String lock = item.getLock();
            if (item instanceof EntryFieldAp) {
                this.collectLockAndVisibleNums(entryFieldMap, visible, lock, propKey);
            } else if (item instanceof FieldAp) {
                this.collectLockAndVisibleNums(fieldMap, visible, lock, propKey);
            } else if (item instanceof AttachmentPanelAp) {
                this.collectLockAndVisibleNums(attachmentMap, visible, lock, propKey);
            } else if (item instanceof EntryAp) {
                this.collectLockAndVisibleNums(entryMap, visible, lock, propKey);
            }
        });
        this.handleFieldPermission(model, fieldMap, entryFieldMap);
        this.setVisibleOrLock(model, view, fieldMap, entryMap, entryFieldMap, attachmentMap);
    }

    private void setNewData(IDataModel model, Map<String, Boolean> mapUpdate, DynamicObject versionDy, IFormView view) {
        MainEntityType mainType = model.getDataEntityType();
        Map allFields = model.getDataEntityType().getAllFields();
        Map allEntities = mainType.getAllEntities();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        formMeta.getItems().forEach(item -> {
            if (!(item instanceof FieldAp) && !(item instanceof EntryAp)) {
                return;
            }
            String propKey = item.getKey();
            Boolean allowToUpdate = (Boolean)mapUpdate.get(propKey);
            if (allowToUpdate != null && allowToUpdate.booleanValue()) {
                return;
            }
            if (item instanceof EntryFieldAp) {
                return;
            }
            if (item instanceof FieldAp) {
                if (!allFields.containsKey(propKey) || HRStringUtils.equals((String)propKey, (String)"bsed") || HRStringUtils.equals((String)propKey, (String)"bsled")) {
                    return;
                }
                if (versionDy != null) {
                    this.setValue(model, propKey, versionDy.get(propKey));
                } else {
                    this.setValue(model, propKey, null);
                }
            } else {
                if (versionDy != null) {
                    if (allEntities.get(propKey) instanceof SubEntryType) {
                        this.setSubEntryFieldValue(model, allEntities, versionDy, propKey);
                    } else {
                        Map entryFields = ((EntityType)model.getDataEntityType().getAllEntities().get(propKey)).getFields();
                        this.setEntryValue(model, propKey, versionDy.getDynamicObjectCollection(propKey), entryFields.keySet(), view.getPageId());
                    }
                } else {
                    model.getEntryEntity(propKey).clear();
                }
                view.updateView(propKey);
            }
        });
    }

    private void setVisibleOrLock(IDataModel model, IFormView view, Map<String, Set<String>> fieldMap, Map<String, Set<String>> entryMap, Map<String, Set<String>> entryFieldMap, Map<String, Set<String>> attachmentMap) {
        Long currentDataId = HRLongValueParseService.getInstance().getLongValueFromMap(view.getFormShowParameter().getCustomParams(), "boid");
        this.setAttachmentPanelAp(model, view, currentDataId, attachmentMap);
        DynamicObject currentDy = null;
        String copyHisPage = view.getPageCache().get("open_copy_his_data_page");
        if (!HRStringUtils.equals((String)copyHisPage, (String)"1")) {
            String selectedProp = this.getAllSelectedProp(model, entryFieldMap, fieldMap, entryMap);
            if (HRStringUtils.isNotEmpty((String)selectedProp)) {
                currentDy = HisCommonEntityRepository.queryHisLineDy((String)model.getDataEntity().getDataEntityType().getName(), (Object)currentDataId, (String)selectedProp);
            } else {
                return;
            }
        }
        this.setFieldAp(model, view, currentDy, fieldMap);
        Map<String, Set<String>> subEntryMap = this.apartEntryAndSubEntry(model, entryMap);
        Map<String, Set<String>> subEntryFieldMap = this.apartEntryAndSubEntryFields(model, entryFieldMap);
        this.setEntryAp(model, view, currentDy, entryMap);
        this.setEntryFieldAp(model, view, currentDy, entryFieldMap);
        this.setSubEntryAp(model, view, currentDy, subEntryMap);
        this.setSubEntryFieldMap(model, view, currentDy, subEntryFieldMap);
    }

    private void handleFieldPermission(IDataModel model, Map<String, Set<String>> fieldMap, Map<String, Set<String>> entryFieldMap) {
        String entityNum = model.getDataEntityType().getName();
        String appNum = model.getDataEntityType().getAppId();
        String appId = EntityMetadataCache.getAppInfo((String)appNum).getId();
        FieldControlRules fieldControlRules = (FieldControlRules)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSDataPermissionService", (String)"getFieldControlRules", (Object[])new Object[]{RequestContext.get().getCurrUserId(), appId, entityNum, Collections.emptyMap()});
        List fieldControlRuleDtos = fieldControlRules.getFieldControlRuleDtos();
        Map allFields = model.getDataEntityType().getAllFields();
        fieldControlRuleDtos.forEach(rule -> {
            String mainOrg = model.getDataEntityType().getMainOrg();
            if (HRStringUtils.isNotEmpty((String)mainOrg)) {
                long createOrg = 0L;
                Object createOrgObj = model.getDataEntity().get(mainOrg);
                if (createOrgObj instanceof DynamicObject) {
                    createOrg = ((DynamicObject)createOrgObj).getLong("id");
                } else if (createOrgObj instanceof Long) {
                    createOrg = (Long)createOrgObj;
                }
                HashSet orgs = Sets.newHashSetWithExpectedSize((int)16);
                Long mainOrgId = rule.getMainOrgId();
                orgs.add(mainOrgId);
                if (rule.getIncludeSubOrg()) {
                    orgs.addAll(rule.getSubOrgId());
                }
                if (!orgs.contains(createOrg)) {
                    return;
                }
            }
            Set canNotReadFields = rule.getFieldControlRule().getCanNotReadFields();
            this.collectFieldPermissionFieldNums(MODIFY_NOT_VISIBLE_NUMS, allFields, canNotReadFields, fieldMap, entryFieldMap);
            Set canNotWriteFields = rule.getFieldControlRule().getCanNotWriteFields();
            this.collectFieldPermissionFieldNums(MODIFY_LOCK_NUMS, allFields, canNotWriteFields, fieldMap, entryFieldMap);
        });
    }

    private void collectFieldPermissionFieldNums(String mapKey, Map<String, IDataEntityProperty> allFields, Set<String> notPermFields, Map<String, Set<String>> fieldMap, Map<String, Set<String>> entryFieldMap) {
        for (String notPermField : notPermFields) {
            Set<String> notVisibleNums;
            IDataEntityProperty property = allFields.get(notPermField);
            if (property == null) continue;
            if (property.getParent() instanceof EntryType) {
                notVisibleNums = entryFieldMap.getOrDefault(mapKey, Sets.newHashSetWithExpectedSize((int)16));
                notVisibleNums.add(notPermField);
                entryFieldMap.put(mapKey, notVisibleNums);
                continue;
            }
            notVisibleNums = fieldMap.getOrDefault(mapKey, Sets.newHashSetWithExpectedSize((int)16));
            notVisibleNums.add(notPermField);
            fieldMap.put(mapKey, notVisibleNums);
        }
    }

    private String getAllSelectedProp(IDataModel model, Map<String, Set<String>> entryFieldMap, Map<String, Set<String>> fieldMap, Map<String, Set<String>> entryMap) {
        StringBuilder allSelectedProps = new StringBuilder();
        HashSet allFieldNums = Sets.newHashSetWithExpectedSize((int)16);
        allFieldNums.addAll(fieldMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        allFieldNums.forEach(fieldNum -> allSelectedProps.append((String)fieldNum).append(','));
        Set<String> allEntryNums = entryMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        this.getEntryQueryFieldNums(allEntryNums, model, allSelectedProps);
        Set entryFields = entryFieldMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map allFields = model.getDataEntityType().getAllFields();
        for (String entryField : entryFields) {
            String entryNum = ((IDataEntityProperty)allFields.get(entryField)).getParent().getName();
            if (allEntryNums.contains(entryNum)) continue;
            allSelectedProps.append(entryNum).append('.').append(entryField).append(',');
        }
        if (allSelectedProps.length() > 1) {
            return allSelectedProps.substring(0, allSelectedProps.length() - 1);
        }
        return "";
    }

    private void collectLockAndVisibleNums(Map<String, Set<String>> collectMap, String visible, String lock, String propKey) {
        if (lock != null && lock.contains("edit")) {
            Set<String> modifyLockNums = collectMap.getOrDefault(MODIFY_LOCK_NUMS, Sets.newHashSetWithExpectedSize((int)16));
            modifyLockNums.add(propKey);
            collectMap.putIfAbsent(MODIFY_LOCK_NUMS, modifyLockNums);
        }
        if (visible != null && !visible.contains("edit")) {
            Set<String> modifyNotVisibleNums = collectMap.getOrDefault(MODIFY_NOT_VISIBLE_NUMS, Sets.newHashSetWithExpectedSize((int)16));
            modifyNotVisibleNums.add(propKey);
            collectMap.putIfAbsent(MODIFY_NOT_VISIBLE_NUMS, modifyNotVisibleNums);
        }
    }

    private Map<String, Set<String>> apartEntryAndSubEntry(IDataModel model, Map<String, Set<String>> entryMap) {
        Set<String> modifyLockEntryNums = entryMap.getOrDefault(MODIFY_LOCK_NUMS, Collections.emptySet());
        Set<String> modifyNotVisibleEntryNums = entryMap.getOrDefault(MODIFY_NOT_VISIBLE_NUMS, Collections.emptySet());
        Map allEntities = model.getDataEntityType().getAllEntities();
        HashMap subEntryMap = Maps.newHashMapWithExpectedSize((int)2);
        this.pickSubEntry(MODIFY_LOCK_NUMS, modifyLockEntryNums, allEntities, subEntryMap);
        this.pickSubEntry(MODIFY_NOT_VISIBLE_NUMS, modifyNotVisibleEntryNums, allEntities, subEntryMap);
        return subEntryMap;
    }

    private Map<String, Set<String>> apartEntryAndSubEntryFields(IDataModel model, Map<String, Set<String>> entryFieldMap) {
        HashMap subEntryFieldMap = Maps.newHashMapWithExpectedSize((int)2);
        Set<String> modifyLockEntryFieldNums = entryFieldMap.getOrDefault(MODIFY_LOCK_NUMS, Collections.emptySet());
        Set<String> modifyNotVisibleEntryFieldNums = entryFieldMap.getOrDefault(MODIFY_NOT_VISIBLE_NUMS, Collections.emptySet());
        Map allFields = model.getDataEntityType().getAllFields();
        this.pickSubEntryFields(MODIFY_LOCK_NUMS, modifyLockEntryFieldNums, allFields, subEntryFieldMap);
        this.pickSubEntryFields(MODIFY_NOT_VISIBLE_NUMS, modifyNotVisibleEntryFieldNums, allFields, subEntryFieldMap);
        return subEntryFieldMap;
    }

    private void pickSubEntry(String key, Set<String> entryNums, Map<String, EntityType> allEntities, Map<String, Set<String>> subEntryMap) {
        Iterator<String> iterator = entryNums.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (!(allEntities.get(next) instanceof SubEntryType)) continue;
            Set<String> subEntryNumSet = subEntryMap.getOrDefault(key, Sets.newHashSetWithExpectedSize((int)16));
            subEntryNumSet.add(next);
            subEntryMap.putIfAbsent(key, subEntryNumSet);
            iterator.remove();
        }
    }

    private void pickSubEntryFields(String key, Set<String> entryFieldNums, Map<String, IDataEntityProperty> allFields, Map<String, Set<String>> subEntryFieldMap) {
        Iterator<String> iterator = entryFieldNums.iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            IDataEntityProperty property = allFields.get(next);
            if (!(property.getParent() instanceof SubEntryType)) continue;
            Set<String> subEntryNumSet = subEntryFieldMap.getOrDefault(key, Sets.newHashSetWithExpectedSize((int)16));
            subEntryNumSet.add(next);
            subEntryFieldMap.putIfAbsent(key, subEntryNumSet);
            iterator.remove();
        }
    }

    private void setFieldAp(IDataModel model, IFormView view, DynamicObject currentDy, Map<String, Set<String>> fieldMap) {
        Set modifyLockFields = fieldMap.getOrDefault(MODIFY_LOCK_NUMS, Collections.emptySet());
        Set modifyNotVisibleFields = fieldMap.getOrDefault(MODIFY_NOT_VISIBLE_NUMS, Collections.emptySet());
        if (modifyLockFields.size() > 0) {
            for (String fieldNum : modifyLockFields) {
                view.setEnable(Boolean.FALSE, new String[]{fieldNum});
                if (currentDy == null) continue;
                this.setValue(model, fieldNum, currentDy.get(fieldNum));
            }
        }
        if (modifyNotVisibleFields.size() > 0) {
            for (String fieldNum : modifyNotVisibleFields) {
                view.setVisible(Boolean.FALSE, new String[]{fieldNum});
                if (currentDy == null) continue;
                this.setValue(model, fieldNum, currentDy.get(fieldNum));
            }
        }
    }

    private void setAttachmentPanelAp(IDataModel model, IFormView view, Object currentDataId, Map<String, Set<String>> fieldMap) {
        List attachments;
        HashMap attachmentMap;
        Set modifyLockAttachments = fieldMap.getOrDefault(MODIFY_LOCK_NUMS, Collections.emptySet());
        Set modifyNotVisibleAttachments = fieldMap.getOrDefault(MODIFY_NOT_VISIBLE_NUMS, Collections.emptySet());
        String entityId = model.getDataEntityType().getName();
        if (modifyLockAttachments.size() > 0) {
            attachmentMap = Maps.newHashMapWithExpectedSize((int)modifyLockAttachments.size());
            for (String fieldNum : modifyLockAttachments) {
                attachments = AttachmentServiceHelper.getAttachments((String)entityId, (Object)currentDataId, (String)fieldNum);
                attachmentMap.put(fieldNum, attachments);
                view.setEnable(Boolean.FALSE, new String[]{fieldNum});
            }
            HisAttachmentTool.setAttachments(view, attachmentMap);
        }
        if (modifyNotVisibleAttachments.size() > 0) {
            attachmentMap = Maps.newHashMapWithExpectedSize((int)modifyNotVisibleAttachments.size());
            for (String fieldNum : modifyNotVisibleAttachments) {
                if (!modifyLockAttachments.contains(fieldNum)) {
                    attachments = AttachmentServiceHelper.getAttachments((String)entityId, (Object)currentDataId, (String)fieldNum);
                    attachmentMap.put(fieldNum, attachments);
                }
                view.setVisible(Boolean.FALSE, new String[]{fieldNum});
            }
            HisAttachmentTool.setAttachments(view, attachmentMap);
        }
    }

    private void setEntryAp(IDataModel model, IFormView view, DynamicObject currentDy, Map<String, Set<String>> fieldMap) {
        Set modifyLockEntryNums = fieldMap.getOrDefault(MODIFY_LOCK_NUMS, Collections.emptySet());
        Set modifyNotVisibleEntryNums = fieldMap.getOrDefault(MODIFY_NOT_VISIBLE_NUMS, Collections.emptySet());
        Set<String> allEntryNums = fieldMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map<String, Set<String>> allEntryFieldNumMap = this.getEntryQueryFieldNums(allEntryNums, model, new StringBuilder());
        if (modifyLockEntryNums.size() > 0) {
            for (String fieldNum : modifyLockEntryNums) {
                view.setEnable(Boolean.FALSE, new String[]{fieldNum});
                if (currentDy == null) continue;
                this.setEntryFieldsValue(model, allEntryFieldNumMap, currentDy, view.getPageId());
            }
        }
        if (modifyNotVisibleEntryNums.size() > 0) {
            for (String fieldNum : modifyNotVisibleEntryNums) {
                view.setVisible(Boolean.FALSE, new String[]{fieldNum});
                if (currentDy == null) continue;
                this.setEntryFieldsValue(model, allEntryFieldNumMap, currentDy, view.getPageId());
            }
        }
    }

    private void setSubEntryAp(IDataModel model, IFormView view, DynamicObject currentDy, Map<String, Set<String>> fieldMap) {
        Set modifyLockSubEntryNums = fieldMap.getOrDefault(MODIFY_LOCK_NUMS, Collections.emptySet());
        Set modifyNotVisibleSubEntryNums = fieldMap.getOrDefault(MODIFY_NOT_VISIBLE_NUMS, Collections.emptySet());
        Map allEntities = model.getDataEntityType().getAllEntities();
        if (modifyLockSubEntryNums.size() > 0) {
            for (String fieldNum : modifyLockSubEntryNums) {
                view.setEnable(Boolean.FALSE, new String[]{fieldNum});
                if (currentDy == null) continue;
                this.setSubEntryFieldValue(model, allEntities, currentDy, fieldNum);
            }
        }
        if (modifyNotVisibleSubEntryNums.size() > 0) {
            for (String fieldNum : modifyNotVisibleSubEntryNums) {
                view.setVisible(Boolean.FALSE, new String[]{fieldNum});
                if (currentDy == null) continue;
                this.setSubEntryFieldValue(model, allEntities, currentDy, fieldNum);
            }
        }
    }

    private void setEntryFieldAp(IDataModel model, IFormView view, DynamicObject currentDy, Map<String, Set<String>> fieldMap) {
        Set modifyLockEntryFieldNums = fieldMap.getOrDefault(MODIFY_LOCK_NUMS, Collections.emptySet());
        Set modifyNotVisibleEntryFieldNums = fieldMap.getOrDefault(MODIFY_NOT_VISIBLE_NUMS, Collections.emptySet());
        Set<String> allEntryFieldNums = fieldMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map allFields = model.getDataEntityType().getAllFields();
        HashMap entryNumMap = Maps.newHashMapWithExpectedSize((int)16);
        allEntryFieldNums.forEach(entryField -> {
            String entryNum = ((IDataEntityProperty)allFields.get(entryField)).getParent().getName();
            Set entryFields = entryNumMap.getOrDefault(entryNum, Sets.newHashSetWithExpectedSize((int)16));
            entryFields.add(entryField);
            entryNumMap.putIfAbsent(entryNum, entryFields);
        });
        if (currentDy != null) {
            this.setEntryFieldsValue(model, entryNumMap, currentDy, view.getPageId());
        }
        entryNumMap.forEach((entryNum, entryFieldNums) -> {
            DynamicObjectCollection entryEntity = model.getEntryEntity(entryNum);
            for (int i = 0; i < entryEntity.size(); ++i) {
                for (String entryFieldNum : entryFieldNums) {
                    if (modifyLockEntryFieldNums.contains(entryFieldNum)) {
                        view.setEnable(Boolean.FALSE, i, new String[]{entryFieldNum});
                    }
                    if (!modifyNotVisibleEntryFieldNums.contains(entryFieldNum)) continue;
                    view.setVisible(Boolean.FALSE, new String[]{entryFieldNum});
                }
            }
        });
    }

    private Map<String, Set<String>> getEntryQueryFieldNums(Set<String> allEntryNums, IDataModel model, StringBuilder selectedProps) {
        HashMap allEntryFieldNumMap = Maps.newHashMapWithExpectedSize((int)16);
        for (String entryNum : allEntryNums) {
            Map entryFields = ((EntityType)model.getDataEntityType().getAllEntities().get(entryNum)).getFields();
            entryFields.forEach((num, prop) -> selectedProps.append(entryNum).append('.').append((String)num).append(','));
            allEntryFieldNumMap.put(entryNum, entryFields.keySet());
        }
        return allEntryFieldNumMap;
    }

    private void setEntryFieldsValue(IDataModel model, Map<String, Set<String>> allEntryFieldNumMap, DynamicObject currentDy, String pageId) {
        allEntryFieldNumMap.forEach((entryNum, entryFields) -> {
            DynamicObjectCollection entry = currentDy.getDynamicObjectCollection(entryNum);
            this.setEntryValue(model, (String)entryNum, entry, (Set<String>)entryFields, pageId);
        });
    }

    private void setSubEntryFieldMap(IDataModel model, IFormView view, DynamicObject currentDy, Map<String, Set<String>> fieldMap) {
        Set modifyLockSubEntryFieldNums = fieldMap.getOrDefault(MODIFY_LOCK_NUMS, Collections.emptySet());
        Set modifyNotVisibleSubEntryFieldNums = fieldMap.getOrDefault(MODIFY_NOT_VISIBLE_NUMS, Collections.emptySet());
        Set<String> allSubEntryFieldNums = fieldMap.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        Map allFields = model.getDataEntityType().getAllFields();
        Map allEntities = model.getDataEntityType().getAllEntities();
        HashMap subEntryNumMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap entryNumMap = Maps.newHashMapWithExpectedSize((int)16);
        allSubEntryFieldNums.forEach(entryField -> {
            String subEntryNum = ((IDataEntityProperty)allFields.get(entryField)).getParent().getName();
            Set entryFields = subEntryNumMap.getOrDefault(subEntryNum, Sets.newHashSetWithExpectedSize((int)16));
            entryFields.add(entryField);
            subEntryNumMap.putIfAbsent(subEntryNum, entryFields);
        });
        subEntryNumMap.forEach((subEntryNum, entryFields) -> {
            String entryNum = ((EntityType)allEntities.get(subEntryNum)).getParent().getName();
            Map subEntryNumMap1 = entryNumMap.getOrDefault(entryNum, Maps.newHashMapWithExpectedSize((int)16));
            Set subEntryFields = subEntryNumMap1.getOrDefault(subEntryNum, Sets.newHashSetWithExpectedSize((int)16));
            subEntryFields.addAll(entryFields);
            subEntryNumMap1.putIfAbsent(subEntryNum, subEntryFields);
            entryNumMap.putIfAbsent(entryNum, subEntryNumMap1);
        });
        if (currentDy != null) {
            this.setSubEntryFieldsValue(model, entryNumMap, currentDy);
        }
        entryNumMap.forEach((entryNum, subEntryNumsMap) -> {
            DynamicObjectCollection entryEntity = model.getEntryEntity(entryNum);
            for (DynamicObject dynamicObject : entryEntity) {
                for (Map.Entry subEntryNumsEntry : subEntryNumsMap.entrySet()) {
                    DynamicObjectCollection subEntry = dynamicObject.getDynamicObjectCollection((String)subEntryNumsEntry.getKey());
                    Set subEntryFields = (Set)subEntryNumsEntry.getValue();
                    for (String subEntryField : subEntryFields) {
                        for (int j = 0; j < subEntry.size(); ++j) {
                            if (modifyLockSubEntryFieldNums.contains(subEntryField)) {
                                view.setEnable(Boolean.FALSE, j, new String[]{subEntryField});
                            }
                            if (!modifyNotVisibleSubEntryFieldNums.contains(subEntryField)) continue;
                            view.setVisible(Boolean.FALSE, new String[]{subEntryField});
                        }
                    }
                }
            }
        });
    }

    private void setSubEntryFieldsValue(IDataModel model, Map<String, Map<String, Set<String>>> entryNumMap, DynamicObject currentDy) {
        entryNumMap.forEach((entryNum, subEntryNumMap) -> {
            DynamicObjectCollection entry = currentDy.getDynamicObjectCollection(entryNum);
            int index = 0;
            for (DynamicObject entryDy : entry) {
                for (Map.Entry subEntryNumEntry : subEntryNumMap.entrySet()) {
                    DynamicObjectCollection subEntry = entryDy.getDynamicObjectCollection((String)subEntryNumEntry.getKey());
                    for (DynamicObject subEntryDy : subEntry) {
                        DataEntityPropertyCollection properties = subEntryDy.getDynamicObjectType().getProperties();
                        DynamicObjectCollection subCol = (DynamicObjectCollection)model.getValue((String)subEntryNumEntry.getKey(), index);
                        if (subCol == null) continue;
                        subCol.clear();
                        DynamicObject subEntryObj = subCol.addNew();
                        properties.forEach(prop -> {
                            if (((Set)subEntryNumEntry.getValue()).contains(prop.getName())) {
                                subEntryObj.set(prop.getName(), subEntryDy.get(prop.getName()));
                            }
                        });
                    }
                }
                ++index;
            }
        });
    }

    private void setSubEntryFieldValue(IDataModel model, Map<String, EntityType> allEntities, DynamicObject currentDy, String subEntryNum) {
        SubEntryType subEntryType = (SubEntryType)allEntities.get(subEntryNum);
        String entryNum = subEntryType.getParent().getName();
        DynamicObjectCollection currentEntry = currentDy.getDynamicObjectCollection(entryNum);
        int i = 0;
        for (DynamicObject currentEntryDy : currentEntry) {
            DynamicObjectCollection currentSubEntry = currentEntryDy.getDynamicObjectCollection(subEntryNum);
            for (DynamicObject currentSubEntryDy : currentSubEntry) {
                DataEntityPropertyCollection properties = currentSubEntry.getDynamicObjectType().getProperties();
                DynamicObjectCollection subCol = (DynamicObjectCollection)model.getValue(subEntryNum, i);
                if (subCol == null) continue;
                subCol.clear();
                DynamicObject subEntryObj = subCol.addNew();
                properties.forEach(prop -> {
                    if (HRStringUtils.equals((String)"id", (String)prop.getName()) || HRStringUtils.equals((String)"seq", (String)prop.getName()) || HRStringUtils.equals((String)"masterid", (String)prop.getName()) || HRStringUtils.equals((String)"multilanguagetext", (String)prop.getName())) {
                        return;
                    }
                    subEntryObj.set(prop.getName(), currentSubEntryDy.get(prop.getName()));
                });
                ++i;
            }
        }
    }

    private void setValue(IDataModel model, String propertyName, Object propVal) {
        if (propVal instanceof MulBasedataDynamicObjectCollection) {
            model.setValue(propertyName, (Object)((MulBasedataDynamicObjectCollection)propVal).stream().filter(data -> data != null && data.getDynamicObject("fbasedataid") != null).map(data -> data.getDynamicObject("fbasedataid").getPkValue()).toArray());
        } else {
            if (HRStringUtils.equals((String)propertyName, (String)"id") || HRStringUtils.equals((String)propertyName, (String)"masterid") || HRStringUtils.equals((String)propertyName, (String)"datastatus") || HRStringUtils.equals((String)propertyName, (String)"versionsource") || HRStringUtils.equals((String)propertyName, (String)"modifier") || HRStringUtils.equals((String)propertyName, (String)"modifytime") || HRStringUtils.equals((String)propertyName, (String)"status") || HRStringUtils.equals((String)propertyName, (String)"boid") || HRStringUtils.equals((String)propertyName, (String)"iscurrentversion") || HRStringUtils.equals((String)propertyName, (String)"ismodify") || HRStringUtils.equals((String)propertyName, (String)"changebsed") || HRStringUtils.equals((String)propertyName, (String)"hisversion") || HRStringUtils.equals((String)propertyName, (String)"firstbsed")) {
                return;
            }
            model.setValue(propertyName, propVal);
        }
    }

    private void setEntryValue(IDataModel model, String entryNum, DynamicObjectCollection entry, Set<String> entryFields, String pageId) {
        int defaultRows = ((EntryProp)model.getDataEntityType().getProperty(entryNum)).getDefaultRows();
        int createRowCount = 0;
        int entryCount = model.getEntryEntity(entryNum).size() - defaultRows;
        if (entryCount == 0) {
            createRowCount = entry.size() - defaultRows;
        }
        if (createRowCount > 0) {
            model.batchCreateNewEntryRow(entryNum, createRowCount);
        }
        int i = 0;
        DynamicObjectCollection newDynamicObjectCollection = (DynamicObjectCollection)model.getValue(entryNum);
        for (DynamicObject entryDy : entry) {
            DynamicObject dyNewRow = (DynamicObject)newDynamicObjectCollection.get(i);
            if (entryDy == null || dyNewRow == null) continue;
            for (String entryField : entryFields) {
                Object value;
                if (model.getEntryEntity(entryNum).size() <= i || (value = entryDy.get(entryField)) == null) continue;
                if (value instanceof MulBasedataDynamicObjectCollection) {
                    MulBasedataDynamicObjectCollection newMulBaseData = HisAttachmentFiledService.getInstance().copyNewMulBaseData((MulBasedataDynamicObjectCollection)value, pageId);
                    dyNewRow.set(entryField, (Object)newMulBaseData);
                    continue;
                }
                dyNewRow.set(entryField, entryDy.get(entryField));
            }
            ++i;
        }
        model.setValue(entryNum, (Object)newDynamicObjectCollection);
    }
}

