/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util.newhismodel;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.calc.HisVersionCalcTipsVo;
import kd.hr.hbp.business.domain.repository.HisCommonEntityRepository;
import kd.hr.hbp.business.domain.service.attachment.HisAttachmentService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.constants.newhismodel.HisLineTimeTplConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.newhismodel.pluginservice.impl.HisLineTimeChangeTitleService;
import kd.hr.hbp.formplugin.web.util.newhismodel.HisAttachmentTool;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.DigestUtils;

public class HisShowFormHandler
implements HisLineTimeTplConstants {
    private static final Log LOGGER = LogFactory.getLog(HisShowFormHandler.class);
    private static volatile HisShowFormHandler handler = null;

    private HisShowFormHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisShowFormHandler getInstance() {
        if (handler != null) return handler;
        Class<HisShowFormHandler> clazz = HisShowFormHandler.class;
        synchronized (HisShowFormHandler.class) {
            if (handler != null) return handler;
            handler = new HisShowFormHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public void showVersionChangeCompareList(ListView view, Set<Object> selectedRowIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hbp_hisversioncompare");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        view.getPageCache().put("formId", view.getBillFormId());
        view.getPageCache().put("boid", view.getFormShowParameter().getCustomParam("boid").toString());
        view.getPageCache().put("selectedIds", SerializationUtils.toJsonString(selectedRowIds));
        List colMapList = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSHismodelService", (String)"getEntityVerCpColCfg", (Object[])new Object[]{view.getBillFormId()});
        LinkedHashMap hisColMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
        view.getShowListColumns().stream().filter(col -> HRStringUtils.equals((String)"gridview", (String)col.getParentViewKey())).forEach(col -> {
            String listFieldKey = col.getListFieldKey();
            if (listFieldKey == null || col.getCaption() == null) {
                return;
            }
            if (HRStringUtils.equals((String)"fseq", (String)listFieldKey) || HRStringUtils.equals((String)"index", (String)listFieldKey)) {
                return;
            }
            hisColMap.put(listFieldKey, col.getCaption().getLocaleValue());
        });
        view.getPageCache().put("showListColumnForVersionCompare", SerializationUtils.toJsonString((Object)colMapList));
        view.getPageCache().put("showListHisColumnForVersionCompare", SerializationUtils.toJsonString((Object)hisColMap));
        view.showForm(formShowParameter);
    }

    public void showHisVersionPageForHisLineEdit(IFormView view) {
        IDataModel model = view.getModel();
        ListShowParameter showParameter = this.buildHisLineHisListParameter(model.getDataEntity().getDataEntityType().getName(), view.getPageId(), view.getPageCache(), model);
        view.showForm((FormShowParameter)showParameter);
    }

    private ListShowParameter buildHisLineHisListParameter(String formId, String parentPageId, IPageCache cache, IDataModel model) {
        DynamicObject dy = model.getDataEntity();
        ListShowParameter showParameter = new ListShowParameter();
        Object boId = dy.get("boid");
        Object id = dy.get("id");
        showParameter.setBillFormId(formId);
        showParameter.setFormId("bos_list");
        showParameter.setHasRight(true);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HRPageCache pageCache = new HRPageCache(cache);
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap != null) {
            showParameter.setCustomParams(customParamMap);
        }
        if (dy.getDataEntityType().getProperties().containsKey((Object)"enable")) {
            String enable = dy.getString("enable");
            showParameter.setCustomParam("hisPageEnable", (Object)enable);
        }
        showParameter.setCustomParam("option", (Object)"showhisversion");
        showParameter.setCustomParam("boid", boId);
        HisLineTimeChangeTitleService.getInstance().setHisInfoCaption(showParameter, model);
        String pageId = parentPageId + "_" + formId + "_" + id + "_" + RequestContext.get().getLocalSessionId() + "_showHisVersion";
        showParameter.setPageId(pageId);
        QFilter qFilter1 = new QFilter("boid", "=", boId);
        QFilter qFilter2 = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        showParameter.getListFilterParameter().getQFilters().add(qFilter1);
        showParameter.getListFilterParameter().getQFilters().add(qFilter2);
        boolean hasInitStatus = HisCommonService.getInstance().hasInitStatusFiled((IDataEntityType)model.getDataEntityType(), formId);
        if (hasInitStatus) {
            QFilter qFilter3 = new QFilter("initstatus", "not in", Arrays.asList("0", "1"));
            showParameter.getListFilterParameter().getQFilters().add(qFilter3);
        }
        return showParameter;
    }

    public void insertDataForHisLineList(ListView view, IFormPlugin plugin) {
        ListShowParameter parameter = (ListShowParameter)view.getFormShowParameter();
        BillShowParameter showParameter = this.newBillShowParameter(parameter.getBillFormId());
        showParameter.setFormId(parameter.getBillFormId());
        showParameter.setBillStatus(BillOperationStatus.ADDNEW);
        showParameter.setCustomParams(view.getFormShowParameter().getCustomParams());
        HRPageCache pageCache = new HRPageCache(view.getPageCache());
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap != null) {
            showParameter.getCustomParams().putAll(customParamMap);
        }
        showParameter.setCustomParam("fromPage", (Object)"fromHisAction");
        showParameter.setCustomParam("option", (Object)"insertdata_his");
        showParameter.setCustomParam("his_action", (Object)"open_insert_new_data_page");
        showParameter.setCustomParam("boid", view.getFormShowParameter().getCustomParam("boid"));
        showParameter.setCustomParam("hisPageEnable", view.getFormShowParameter().getCustomParam("hisPageEnable"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "closeForInsertData"));
        view.showForm((FormShowParameter)showParameter);
    }

    public void openHisImportStartPage(ListView view, IFormPlugin plugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hbp_hisimportstart");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("ServiceAppId", (Object)view.getFormShowParameter().getAppId());
        parameter.setCustomParam("CheckRightAppId", (Object)view.getFormShowParameter().getCheckRightAppId());
        parameter.setCustomParam("BillFormId", (Object)view.getBillFormId());
        parameter.setCustomParam("RealPermissionEntityId", (Object)view.getBillFormId());
        parameter.setCustomParam("ListName", (Object)view.getFormShowParameter().getFormName());
        parameter.setCustomParam("PermissionItemId", (Object)view.getFormShowParameter().getPermissionItemId());
        parameter.setCustomParam("ListName", (Object)view.getFormShowParameter().getFormName());
        Map opMap = EntityMetadataCache.getDataEntityOperate((String)view.getBillFormId(), (String)"importdata");
        Map opParameter = (Map)opMap.get("parameter");
        parameter.setCustomParam("plugins", opParameter.get("plugins"));
        parameter.setCloseCallBack(new CloseCallBack(plugin, "closeForHisImport"));
        view.showForm(parameter);
    }

    public void modifyData(boolean fromLink, ListView view, Object focusRowPkId, IFormPlugin plugin) {
        ListShowParameter parameter = (ListShowParameter)view.getFormShowParameter();
        BillShowParameter showParameter = this.newBillShowParameter(parameter.getBillFormId());
        showParameter.setFormId(parameter.getBillFormId());
        String billStatus = view.getCurrentSelectedRowInfo().getBillStatus();
        showParameter.setStatus(OperationStatus.EDIT);
        if (HRStringUtils.equals((String)billStatus, (String)"C")) {
            showParameter.setBillStatus(BillOperationStatus.AUDIT);
        } else {
            showParameter.setBillStatus(BillOperationStatus.EDIT);
        }
        showParameter.setPkId(focusRowPkId);
        HRPageCache pageCache = new HRPageCache(view.getPageCache());
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap != null) {
            showParameter.getCustomParams().putAll(customParamMap);
            String caption = (String)customParamMap.get("caption");
            if (HRStringUtils.isNotEmpty((String)caption)) {
                showParameter.setCaption(caption);
            }
        }
        showParameter.setCustomParam("fromPage", (Object)"fromHisAction");
        showParameter.setCustomParam("his_action", (Object)"modify_data_page");
        showParameter.setCustomParam("his_modify_from_Link", (Object)fromLink);
        showParameter.setCustomParam("boid", view.getFormShowParameter().getCustomParam("boid"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "closeForModify"));
        showParameter.setPageId("HISDATA_" + focusRowPkId + RequestContext.get().getGlobalSessionId());
        view.showForm((FormShowParameter)showParameter);
    }

    public void openChangeBedPage(ListView view, Object focusRowPkId, IFormPlugin plugin) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hbp_hischangedate");
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Date effEndDate = HisCommonEntityRepository.getCurrentRowBsled((String)view.getBillFormId(), (Object)focusRowPkId);
        showParameter.setCustomParam("bsled", (Object)effEndDate);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "hbp_hischangedate"));
        view.showForm(showParameter);
    }

    public void openCopyHisPage(ListView view, Object focusRowPkId, IFormPlugin plugin) {
        BillShowParameter showParameter = this.newBillShowParameter(view.getBillFormId());
        showParameter.setFormId(view.getBillFormId());
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParams(view.getFormShowParameter().getCustomParams());
        HRPageCache pageCache = new HRPageCache(view.getPageCache());
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap != null) {
            showParameter.getCustomParams().putAll(customParamMap);
        }
        Set ignoreFields = Stream.of("boid", "versionsource", "changedescription", "hisversion", "creator", "createtime", "modifier", "modifytime", "creator_id", "modifier_id").collect(Collectors.toSet());
        showParameter.setCustomParam("fromCopyHis", (Object)SerializationUtils.toJsonString(ignoreFields));
        HashSet attachment = Sets.newHashSetWithExpectedSize((int)16);
        HisCommonService.getInstance().findAttachments((Control)FormMetadataCache.getRootControl((String)view.getBillFormId()), (Set)attachment);
        if (!attachment.isEmpty()) {
            ArrayList attachmentMapList = Lists.newArrayListWithCapacity((int)10);
            for (String fieldNum : attachment) {
                List attachments = AttachmentServiceHelper.getAttachments((String)view.getBillFormId(), (Object)focusRowPkId, (String)fieldNum);
                attachmentMapList.addAll(attachments);
            }
            showParameter.setCustomParam("attachments", (Object)attachmentMapList);
        }
        showParameter.setCustomParam("fromPage", (Object)"fromHisAction");
        showParameter.setCustomParam("currentDataId", focusRowPkId);
        showParameter.setCustomParam("his_action", (Object)"open_copy_his_data_page");
        showParameter.setCustomParam("boid", view.getFormShowParameter().getCustomParam("boid"));
        showParameter.setCustomParam("hisPageEnable", view.getFormShowParameter().getCustomParam("hisPageEnable"));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "closeForCopyHisData"));
        view.showForm((FormShowParameter)showParameter);
    }

    public void newTimeLineRevisePage(FormView view, Object focusRowPkId, IFormPlugin plugin) {
        String billFormId = view instanceof ListView ? ((ListView)view).getBillFormId() : view.getModel().getDataEntityType().getName();
        BillShowParameter showParameter = this.newBillShowParameter(billFormId);
        showParameter.setFormId(billFormId);
        showParameter.setPkId(focusRowPkId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        HRPageCache pageCache = new HRPageCache(view.getPageCache());
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap != null) {
            showParameter.setCustomParams(customParamMap);
        }
        showParameter.setCustomParam("isVersionDataPage", (Object)"1");
        Set ids = Stream.of(String.valueOf(focusRowPkId)).collect(Collectors.toSet());
        List attachmentMapList = HisAttachmentService.generateAttachmentMapById(ids, (String)billFormId);
        showParameter.setCustomParam("preAttachments", (Object)attachmentMapList);
        showParameter.setCustomParam("fromPage", (Object)"revise");
        showParameter.setCustomParam("his_action", (Object)"open_revise_page");
        showParameter.setCustomParam("currentDataId", focusRowPkId);
        showParameter.setCustomParam("boid", view.getFormShowParameter().getCustomParam("boid"));
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "closeForRevise"));
        view.showForm((FormShowParameter)showParameter);
    }

    public void editTimeLineRevisePage(FormView view, IFormPlugin plugin, IDataModel model) {
        HRBaseServiceHelper serviceHelper;
        DynamicObject dynamicObject;
        Object focusRowPkId = model.getValue("id");
        String billFormId = view instanceof ListView ? ((ListView)view).getBillFormId() : view.getModel().getDataEntityType().getName();
        BillShowParameter showParameter = this.newBillShowParameter(billFormId);
        showParameter.setFormId(billFormId);
        showParameter.setPkId(focusRowPkId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        HRPageCache pageCache = new HRPageCache(view.getPageCache());
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap != null) {
            showParameter.setCustomParams(customParamMap);
        }
        Object interId = (dynamicObject = (serviceHelper = new HRBaseServiceHelper(billFormId)).queryOriginalOne("sourcevid", focusRowPkId)) != null ? ((Boolean)model.getValue("iscurrentversion") != false ? dynamicObject.get("sourcevid") : focusRowPkId) : ((Boolean)model.getValue("iscurrentversion") != false ? model.getValue("sourcevid") : focusRowPkId);
        Set ids = Stream.of(String.valueOf(interId)).collect(Collectors.toSet());
        List attachmentMapList = HisAttachmentService.generateAttachmentMapById(ids, (String)billFormId);
        showParameter.setCustomParam("preAttachments", (Object)attachmentMapList);
        if (view.getFormShowParameter().getCustomParams().containsKey("fromPage") && !view.getFormShowParameter().getCustomParams().containsKey("isVersionDataPage")) {
            if (view.getFormShowParameter().getCustomParams().containsKey("his_action")) {
                String action = (String)view.getFormShowParameter().getCustomParams().get("his_action");
                if ("modify_data_page".equals(action)) {
                    showParameter.setCustomParam("isVersionDataPage", (Object)"1");
                }
            } else if (ObjectUtils.isNotEmpty((Object)model.getValue("hisversion"))) {
                showParameter.setCustomParam("isVersionDataPage", (Object)"1");
            }
        }
        showParameter.setCustomParam("fromPage", (Object)"revise");
        showParameter.setCustomParam("his_action", (Object)"open_revise_page");
        showParameter.setCustomParam("currentDataId", focusRowPkId);
        showParameter.setCustomParam("boid", view.getFormShowParameter().getCustomParam("boid"));
        showParameter.setHasRight(true);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "closeForRevise"));
        view.showForm((FormShowParameter)showParameter);
    }

    public void newNoTimeLineRevisePage(FormView view, Object focusRowPkId, IFormPlugin plugin, IDataModel model) {
        String billFormId = view instanceof ListView ? ((ListView)view).getBillFormId() : view.getModel().getDataEntityType().getName();
        BillShowParameter showParameter = this.newBillShowParameter(billFormId);
        showParameter.setFormId(billFormId);
        showParameter.setPkId(focusRowPkId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "closeForRevise"));
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("pkId", focusRowPkId);
        customParams.put("boid", view.getFormShowParameter().getCustomParam("boid"));
        customParams.put("fromPage", "revise");
        customParams.put("useorgId", view.getFormShowParameter().getCustomParam("useorgId"));
        this.setPersonalCustomParams(customParams, billFormId);
        showParameter.setCustomParams(customParams);
        showParameter.setCustomParam("isVersionDataPage", (Object)"1");
        Set ids = Stream.of(String.valueOf(focusRowPkId)).collect(Collectors.toSet());
        List attachmentMapList = HisAttachmentService.generateAttachmentMapById(ids, (String)billFormId);
        showParameter.setCustomParam("preAttachments", (Object)attachmentMapList);
        showParameter.setHasRight(true);
        String pageId = view.getPageId() + "_revise";
        pageId = DigestUtils.md5DigestAsHex((byte[])pageId.getBytes());
        showParameter.setPageId(pageId);
        view.showForm((FormShowParameter)showParameter);
    }

    public void editNoTimeLineRevisePage(FormView view, Object focusRowPkId, IFormPlugin plugin, IDataModel model) {
        String billFormId = view instanceof ListView ? ((ListView)view).getBillFormId() : view.getModel().getDataEntityType().getName();
        BillShowParameter showParameter = this.newBillShowParameter(billFormId);
        showParameter.setFormId(billFormId);
        showParameter.setPkId(focusRowPkId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "closeForRevise"));
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("pkId", focusRowPkId);
        customParams.put("disable_control_title", "true");
        customParams.put("boid", view.getFormShowParameter().getCustomParam("boid"));
        customParams.put("fromPage", "revise");
        this.setPersonalCustomParams(customParams, billFormId);
        showParameter.setCustomParams(customParams);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(billFormId);
        DynamicObject dynamicObject = serviceHelper.queryOriginalOne("sourcevid", focusRowPkId);
        Object interId = dynamicObject != null ? ((Boolean)model.getValue("iscurrentversion") != false ? dynamicObject.get("sourcevid") : focusRowPkId) : ((Boolean)model.getValue("iscurrentversion") != false ? model.getValue("sourcevid") : focusRowPkId);
        Set ids = Stream.of(String.valueOf(interId)).collect(Collectors.toSet());
        List attachmentMapList = HisAttachmentService.generateAttachmentMapById(ids, (String)billFormId);
        showParameter.setCustomParam("preAttachments", (Object)attachmentMapList);
        if (view.getFormShowParameter().getCustomParams().containsKey("fromPage") && ObjectUtils.isNotEmpty((Object)model.getValue("hisversion"))) {
            showParameter.setCustomParam("isVersionDataPage", (Object)"1");
        }
        showParameter.setHasRight(true);
        String pageId = view.getPageId() + "_revise";
        pageId = DigestUtils.md5DigestAsHex((byte[])pageId.getBytes());
        showParameter.setPageId(pageId);
        view.showForm((FormShowParameter)showParameter);
    }

    public void editNoTimeLineCurrentPage(FormView view, Object fId, IFormPlugin plugin, IDataModel model) {
        String billFormId = view instanceof ListView ? ((ListView)view).getBillFormId() : view.getModel().getDataEntityType().getName();
        BillShowParameter showParameter = this.newBillShowParameter(billFormId);
        showParameter.setFormId(billFormId);
        showParameter.setPkId(fId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setHasRight(true);
        view.showForm((FormShowParameter)showParameter);
    }

    public void openChooseChangeStylePage(IFormView view, Object pkId, IFormPlugin plugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hbp_hischangestyle");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        HRPageCache pageCache = new HRPageCache(view.getPageCache());
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap != null) {
            parameter.setCustomParams(customParamMap);
        }
        parameter.setCustomParam("boid", pkId);
        parameter.setCustomParam("entityId", (Object)view.getEntityId());
        parameter.setCloseCallBack(new CloseCallBack(plugin, "hbp_hischangestyle"));
        view.showForm(parameter);
    }

    public void openHisDataEditByViewWindow(IFormView view, String entityId, Object pkId) {
        BillShowParameter showParameter = this.newBillShowParameter(entityId);
        showParameter.setFormId(entityId);
        showParameter.setHasRight(true);
        showParameter.setPkId(pkId);
        this.setModalStyle((FormShowParameter)showParameter);
        showParameter.setShowTitle(false);
        showParameter.setCustomParams(view.getFormShowParameter().getCustomParams());
        showParameter.setCustomParam("fromPage", (Object)"fromHisViewWindow");
        view.showForm((FormShowParameter)showParameter);
    }

    public void openHisDataChangeByModal(IFormView view, String entityId, Object pkId, IFormPlugin plugin) {
        BillShowParameter showParameter = this.newBillShowParameter(entityId);
        showParameter.setFormId(entityId);
        showParameter.setHasRight(true);
        showParameter.setCustomParam("fromTreeOpTips", (Object)"1");
        showParameter.setCustomParam("fromPage", (Object)"fromHisAction");
        showParameter.setCustomParam("option", (Object)"insertdata_his");
        showParameter.setCustomParam("currentDataId", pkId);
        showParameter.setCustomParam("his_action", (Object)"open_insert_data_page");
        showParameter.setCustomParam("boid", pkId);
        HashSet ids = Sets.newHashSetWithExpectedSize((int)1);
        ids.add(pkId);
        List attachments = HisAttachmentService.generateAttachmentMapById((Set)ids, (String)entityId);
        if (!attachments.isEmpty()) {
            showParameter.setCustomParam("attachments", (Object)attachments);
        }
        this.setModalStyle((FormShowParameter)showParameter);
        showParameter.setShowTitle(false);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "hisDataChange"));
        view.showForm((FormShowParameter)showParameter);
    }

    private void setModalStyle(FormShowParameter parameter) {
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("90%");
        cssValue.setHeight("90%");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        parameter.setOpenStyle(style);
    }

    public void openTempVersionDataEditPage(IFormView view, String entityId, Object boId, Object pkId) {
        BillShowParameter showParameter = this.newBillShowParameter(entityId);
        showParameter.setFormId(entityId);
        showParameter.setStatus(OperationStatus.EDIT);
        showParameter.setHasRight(true);
        showParameter.setPkId(pkId);
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        HRPageCache pageCache = new HRPageCache(view.getPageCache());
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap != null) {
            showParameter.setCustomParams(customParamMap);
        }
        showParameter.setCustomParam("fromPage", (Object)"fromHisAction");
        showParameter.setCustomParam("his_action", (Object)"open_data_page");
        showParameter.setCustomParam("boid", boId);
        view.showForm((FormShowParameter)showParameter);
    }

    public void openConfirmOpTips(IFormView view, String opNum, IFormPlugin plugin, HisVersionCalcTipsVo hisVersionCalcTipsVo, String entityNumber) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hbp_hisoptips");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"HisShowFormHandler_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack(plugin, opNum));
        String newTips = JSONObject.toJSON((Object)hisVersionCalcTipsVo).toString();
        parameter.setCustomParam("newTips", (Object)newTips);
        parameter.setCustomParam("entityNumber", (Object)entityNumber);
        view.showForm(parameter);
    }

    public void openTreeConfirmOpTips(IFormView view, String tips, String treeNodes, IFormPlugin plugin) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hbp_histreeoptips");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("tips", (Object)tips);
        parameter.setCustomParam("treeNodes", (Object)treeNodes);
        parameter.setCustomParam("entityId", (Object)view.getEntityId());
        parameter.setCustomParam("bsed", view.getModel().getValue("bsed"));
        parameter.setCustomParam("bsled", view.getModel().getValue("bsled"));
        DynamicObject parent = (DynamicObject)view.getModel().getValue("parent");
        if (parent != null) {
            parameter.setCustomParam("parentLongNumber", (Object)parent.getString("longnumber"));
        }
        parameter.setCaption(ResManager.loadKDString((String)"\u53d8\u66f4\u63d0\u793a", (String)"HisShowFormHandler_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
        parameter.setCloseCallBack(new CloseCallBack(plugin, "hbp_histreeoptips"));
        view.showForm(parameter);
    }

    public void changeData(IFormView view, IFormPlugin plugin) {
        String formId = view.getModel().getDataEntityType().getName();
        BillShowParameter showParameter = this.newBillShowParameter(formId);
        showParameter.setFormId(formId);
        HRPageCache pageCache = new HRPageCache(view.getPageCache());
        Map customParamMap = (Map)pageCache.get("customParamMap", Map.class);
        if (customParamMap != null) {
            showParameter.setCustomParams(customParamMap);
        }
        HisAttachmentTool.putAttachmentsIntoCustomParam(view, (FormShowParameter)showParameter);
        Object pkId = view.getModel().getDataEntity().get("boid");
        String useOrgId = (String)view.getFormShowParameter().getCustomParam("useorgId");
        if (HRStringUtils.isNotEmpty((String)useOrgId)) {
            showParameter.setCustomParam("useorgId", (Object)useOrgId);
        }
        showParameter.setCustomParam("fromPage", (Object)"fromHisAction");
        showParameter.setCustomParam("option", (Object)"insertdata_his");
        showParameter.setCustomParam("currentDataId", pkId);
        showParameter.setCustomParam("his_action", (Object)"open_insert_data_page");
        showParameter.setCustomParam("boid", pkId);
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setCloseCallBack(new CloseCallBack(plugin, "changeDataCloseCallBack"));
        showParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
        showParameter.setHasRight(true);
        view.showForm((FormShowParameter)showParameter);
    }

    private void setPersonalCustomParams(Map<String, Object> customParams, String billFormId) {
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)billFormId);
        if (!isBaseDataCtrl.booleanValue()) {
            return;
        }
        Long boid = Long.valueOf(customParams.get("boid").toString());
        DynamicObject curDy = HisCommonEntityRepository.getNonLineRelCurEffectingDy((HRBaseServiceHelper)new HRBaseServiceHelper(billFormId), (Long)boid);
        Long id = curDy.getLong("id");
        Long masterId = curDy.getLong("masterid");
        if (id != 0L && masterId != 0L && !id.equals(masterId)) {
            customParams.put("isPersonalizeSaveData", Boolean.TRUE);
        }
    }

    public BillShowParameter newBillShowParameter(String entityId) {
        Boolean isBaseDataCtrl = BaseDataServiceHelper.checkBaseDataCtrl((String)entityId);
        if (isBaseDataCtrl.booleanValue()) {
            return new BillShowParameter();
        }
        return new BaseShowParameter();
    }

    public void openF7BsExample(IFormView view) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hbp_hislistf7bsexample");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        view.showForm(parameter);
    }
}

