/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util.newhismodel;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HisTreeTplTool {
    private static final Log LOGGER = LogFactory.getLog(HisTreeTplTool.class);

    public static List<Map<String, Object>> validateTreeSaveOrConfirmChange(String entityId, String opNum, Date effStartDate, Date effEndDate, String parentLongNumber, StringBuilder tips) {
        String[] numbers;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (effStartDate == null) {
            return null;
        }
        if (effEndDate == null) {
            try {
                effEndDate = format.parse("2999-12-31");
            }
            catch (ParseException ex) {
                LOGGER.error((Throwable)ex);
                return null;
            }
        }
        if (parentLongNumber == null) {
            return null;
        }
        String longNumberDLM = ".";
        IDataEntityProperty property = (IDataEntityProperty)EntityMetadataCache.getDataEntityType((String)entityId).getProperties().get((Object)"parent");
        if (property instanceof ParentBasedataProp) {
            longNumberDLM = ((ParentBasedataProp)property).getLongNumberDLM();
        }
        if (parentLongNumber.contains(longNumberDLM)) {
            if (HRStringUtils.equals((String)longNumberDLM, (String)".")) {
                longNumberDLM = "\\.";
            }
            numbers = parentLongNumber.split(longNumberDLM);
        } else {
            numbers = new String[]{parentLongNumber};
        }
        ArrayList results = Lists.newArrayListWithExpectedSize((int)numbers.length);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityId);
        QFilter numberQFilter = new QFilter("number", "in", (Object)numbers);
        QFilter dataStatusQFilter = new QFilter("datastatus", "in", Arrays.asList(EnumHisDataVersionStatus.TO_BE_EFFECT.getStatus(), EnumHisDataVersionStatus.EFFECTING.getStatus(), EnumHisDataVersionStatus.INVALIDED.getStatus()));
        QFilter versionQFilter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('0'));
        QFilter enableQFilter = new QFilter("enable", "=", (Object)"0");
        QFilter effDateQFilter = new QFilter("bsled", ">=", (Object)effStartDate);
        effDateQFilter.and(new QFilter("bsed", "<=", (Object)effEndDate));
        try (DataSet dataSet = helper.queryDataSet(HisTreeTplTool.class.getName() + ".validateTreeSaveOrConfirmChange", "id, name, level", new QFilter[]{numberQFilter, dataStatusQFilter, versionQFilter, enableQFilter, effDateQFilter});){
            for (Row row : dataSet) {
                HashMap map2 = Maps.newHashMapWithExpectedSize((int)2);
                map2.put("id", row.get("id"));
                map2.put("name", row.get("name"));
                map2.put("level", row.get("level"));
                results.add(map2);
            }
        }
        if (results.isEmpty()) {
            return null;
        }
        if (tips != null) {
            tips.append(ResManager.loadKDString((String)"\u82e5\u6570\u636e\u662f\u201c\u53ef\u7528\u201d\u72b6\u6001\uff0c\u5176\u4e0a\u7ea7\u6570\u636e\u5fc5\u987b\u540c\u6837\u4e3a\u201c\u53ef\u7528\u201d\u72b6\u6001\u3002", (String)"HisLineTimeTreeTplFormEdit_0", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]));
            tips.append("\r\n");
            String startDateStr = HRDateTimeUtils.getUserSettingFormat().format(effStartDate);
            String endDateStr = HRDateTimeUtils.getUserSettingFormat().format(effEndDate);
            if (HRStringUtils.equals((String)opNum, (String)"save")) {
                tips.append(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u540e\uff0c\u6570\u636e\u5c06\u5728%1$s~%2$s\u88ab\u7f6e\u4e3a\u201c\u53ef\u7528\u201d\u72b6\u6001\uff0c\u68c0\u6d4b\u5230\u6811\u5f62\u5206\u652f\u4e2d\uff0c\u4e0a\u7ea7\u6570\u636e\u5728\u6b64\u65f6\u6bb5\u4e3a\u201c\u7981\u7528\u201d\u72b6\u6001\uff0c\u5982\u4e0b\u56fe\u6240\u793a\u3002\u8bf7\u5148\u5c06\u5176\u542f\u7528\u3002", (String)"HisLineTimeTreeTplFormEdit_1", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), startDateStr, endDateStr));
            } else {
                tips.append(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u53d8\u66f4\u540e\uff0c\u6570\u636e\u5c06\u5728%1$s~%2$s\u88ab\u7f6e\u4e3a\u201c\u53ef\u7528\u201d\u72b6\u6001\u3002\u68c0\u6d4b\u5230\u6811\u5f62\u5206\u652f\u4e2d\uff0c\u4e0a\u7ea7\u6570\u636e\u5728\u6b64\u65f6\u6bb5\u4e3a\u201c\u7981\u7528\u201d\u72b6\u6001\uff0c\u5982\u4e0b\u56fe\u6240\u793a\u3002\u8bf7\u5148\u5c06\u5176\u542f\u7528\u3002", (String)"HisLineTimeTreeTplFormEdit_2", (String)"hrmp-hbp-formplugin", (Object[])new Object[0]), startDateStr, endDateStr));
            }
        }
        return results.stream().sorted(Comparator.comparing(map -> (Integer)map.get("level"))).collect(Collectors.toList());
    }
}

