/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.formplugin.web.util.perm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRPermUtil {
    public static Long getDynamicObjectFieldId(DynamicObject dataDyn, String fieldName) {
        Object obj = dataDyn.get(fieldName);
        if (obj == null) {
            return 0L;
        }
        Long objId = 0L;
        if (obj instanceof DynamicObject) {
            objId = ((DynamicObject)obj).getLong("id");
        } else if (obj != null) {
            objId = (Long)obj;
        }
        return objId;
    }

    public static String getAppIdFromShowParam(FormShowParameter showParameter) {
        String appNumber = showParameter.getAppId();
        if (HRStringUtils.isEmpty((String)appNumber)) {
            return null;
        }
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        if (appInfo != null) {
            return appInfo.getId();
        }
        return null;
    }

    public static Map<String, Object> queryPermConfig(String formId) {
        return (Map)HRMServiceHelper.invokeHRMPService((String)"hbss", (String)"IHBSSPermService", (String)"queryPermConfig", (Object[])new Object[]{formId});
    }

    public static String queryPermScheme() {
        Map<String, Object> permConfig = HRPermUtil.queryPermConfig("PERM_SCHEME_SELECT");
        return (String)permConfig.get("queryentitynumber");
    }

    public static IFormView getParentNoPlugin(IFormView curView) {
        return curView.getViewNoPlugin(curView.getFormShowParameter().getParentPageId());
    }

    public static String getF7ParentEntityId(IFormView curView) {
        IFormView parentView = HRPermUtil.getParentNoPlugin(curView);
        String customEntityNumber = (String)parentView.getFormShowParameter().getCustomParam("customHREntityNumber");
        if (HRStringUtils.isNotEmpty((String)customEntityNumber)) {
            return customEntityNumber;
        }
        ListShowParameter parentListParameter = null;
        if (parentView.getFormShowParameter() instanceof ListShowParameter) {
            parentListParameter = (ListShowParameter)parentView.getFormShowParameter();
            return parentListParameter.getBillFormId();
        }
        return parentView.getFormShowParameter().getFormId();
    }

    public static String getF7ParentPermItemId(IFormView curView) {
        IFormView parentView = HRPermUtil.getParentNoPlugin(curView);
        String customPermItemId = (String)parentView.getFormShowParameter().getCustomParam("customHRPermItemId");
        if (HRStringUtils.isNotEmpty((String)customPermItemId)) {
            return customPermItemId;
        }
        return parentView.getFormShowParameter().getPermissionItemId();
    }

    public static void setAdminOrgF7IgnorePerm(BeforeFilterF7SelectEvent arg) {
    }

    public static void setAdminOrgF7CustomPermList(BeforeFilterF7SelectEvent arg, Collection<Long> adminOrgs) {
        arg.addCustomQFilter(new QFilter("id", "in", adminOrgs));
    }

    public static void setAdminOrgF7IgnorePerm(BeforeF7SelectEvent arg) {
        arg.getFormShowParameter().setCustomParam("ignoreF7PermFilter", (Object)true);
    }

    public static void setAdminOrgF7CustomPermList(BeforeF7SelectEvent arg, Collection<Long> adminOrgs) {
        arg.getFormShowParameter().setCustomParam("ignoreF7PermFilter", (Object)true);
        arg.getFormShowParameter().setCustomParam("customF7PermOrgIds", adminOrgs);
        ArrayList customQFilterList = Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "in", adminOrgs)});
        arg.setCustomQFilters((List)customQFilterList);
    }
}

