/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.api;

import java.io.Serializable;
import kd.hr.hbp.common.api.EnumResponseCode;

public class HrApiResponse<T>
implements Serializable {
    private static final long serialVersionUID = -785841031846559358L;
    private boolean success = true;
    private String code = EnumResponseCode.SUCCESS.getCode();
    private String errorMessage;
    private T data;

    public HrApiResponse() {
    }

    public static <T> HrApiResponse<T> success(T data) {
        HrApiResponse<T> result = new HrApiResponse<T>();
        result.setData(data);
        return result;
    }

    public static <T> HrApiResponse<T> success() {
        HrApiResponse<T> result = new HrApiResponse<T>();
        return result;
    }

    public static <T> HrApiResponse<T> fail(String msg) {
        HrApiResponse<T> result = new HrApiResponse<T>();
        result.setCode(EnumResponseCode.FAIL.getCode());
        result.setErrorMessage(msg);
        result.setSuccess(false);
        return result;
    }

    public static <T> HrApiResponse<T> fail(T data) {
        HrApiResponse<T> result = new HrApiResponse<T>();
        result.setCode(EnumResponseCode.FAIL.getCode());
        result.setErrorMessage(null);
        result.setData(data);
        result.setSuccess(false);
        return result;
    }

    public static <T> HrApiResponse<T> fail(String code, String msg) {
        HrApiResponse<T> result = new HrApiResponse<T>();
        result.setCode(code);
        result.setErrorMessage(msg);
        result.setSuccess(false);
        return result;
    }

    public HrApiResponse(boolean success, String code, String errorMessage, T data) {
        this.success = success;
        this.code = code;
        this.errorMessage = errorMessage;
        this.data = data;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

