/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.encryptapi;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.encryptapi.HrEncryptApiRequest;
import kd.hr.hbp.common.encryptapi.HrEncryptMServiceUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HrEncryptApiResponse<T>
implements Serializable {
    private static final Log log = LogFactory.getLog(HrEncryptApiResponse.class);
    private static final long serialVersionUID = 3387455593507729046L;
    private static final String SUCCESS = "success";
    private static final String ERROR = "fail";
    private String cloudId;
    private String appId;
    private String serviceName;
    private String methodName;
    private Long encryptSchemeId;
    private boolean isEncrypt;
    private boolean success = true;
    private T data;
    private Class<?> dataType;
    private String message;
    private String errorCode;

    public HrEncryptApiResponse() {
    }

    public HrEncryptApiResponse(HrEncryptApiRequest request) {
        this.cloudId = request.getCloudId();
        this.appId = request.getAppId();
        this.serviceName = request.getServiceName();
        this.methodName = request.getMethodName();
        this.encryptSchemeId = request.getEncryptSchemeId();
        this.isEncrypt = request.getEncrypt();
        this.dataType = Object.class;
    }

    public HrEncryptApiResponse(String cloudId, String appId, String serviceName, String methodName) {
        this.cloudId = cloudId;
        this.appId = appId;
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.dataType = Object.class;
        this.initEncryptInfo();
    }

    private void initEncryptInfo() {
        Long systemParamSchemeId = HrEncryptMServiceUtils.getSchemeIdFromSystemParam();
        if (systemParamSchemeId != 0L) {
            this.encryptSchemeId = systemParamSchemeId;
            this.isEncrypt = true;
        }
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public Long getEncryptSchemeId() {
        return this.encryptSchemeId;
    }

    public void setEncryptSchemeId(Long encryptSchemeId) {
        this.encryptSchemeId = encryptSchemeId;
    }

    public Boolean getEncrypt() {
        return this.isEncrypt;
    }

    public void setSuccess(boolean success) {
        if (StringUtils.isEmpty((CharSequence)this.errorCode)) {
            this.errorCode = success ? SUCCESS : ERROR;
        }
        this.success = success;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public Class<?> getDataType() {
        return this.dataType;
    }

    public void setDataType(Class<?> dataType) {
        this.dataType = dataType;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setEncryptData(T dataT) {
        if (this.isEncrypt && this.encryptSchemeId != null && this.encryptSchemeId != 0L) {
            if (dataT == null) {
                return;
            }
            try {
                String dataStr = SerializationUtils.toJsonString(dataT);
                JSONObject jsonObject = PermissionServiceHelper.encryptData((long)this.encryptSchemeId, (String)dataStr);
                Boolean flag = jsonObject.getBoolean(SUCCESS);
                if (!flag.booleanValue()) {
                    this.message = jsonObject.getString("description");
                    log.error("HrEncryptApiResponse encryptData error :" + this.message);
                    throw new KDBizException(this.message);
                }
                this.data = jsonObject.getString("data");
            }
            catch (Exception e) {
                this.dealException(e, ResManager.loadKDString((String)"\u52a0\u5bc6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HrEncryptMServiceUtils_1", (String)"hrmp-hbp-common", (Object[])new Object[0]));
                log.error("HrEncryptApiResponse encryptData exception error :" + this.message);
                throw new KDBizException(this.message);
            }
        } else {
            this.data = dataT;
        }
        if (dataT != null) {
            this.dataType = dataT.getClass();
        }
    }

    public T getDecryptData() {
        if (this.isEncrypt && this.encryptSchemeId != null && this.encryptSchemeId != 0L) {
            Object decryptData;
            if (this.data == null) {
                return null;
            }
            try {
                JSONObject jsonObject = PermissionServiceHelper.decryptData((long)this.encryptSchemeId, (String)this.data.toString());
                Boolean flag = jsonObject.getBoolean(SUCCESS);
                if (!flag.booleanValue()) {
                    this.message = jsonObject.getString("description");
                    log.error("HrEncryptApiResponse decryptData error :" + this.message);
                    throw new KDBizException(this.message);
                }
                String dataStr = jsonObject.getString("data");
                decryptData = SerializationUtils.fromJsonString((String)dataStr, this.dataType);
            }
            catch (Exception e) {
                this.dealException(e, ResManager.loadKDString((String)"\u89e3\u5bc6\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"HrEncryptMServiceUtils_2", (String)"hrmp-hbp-common", (Object[])new Object[0]));
                log.error("HrEncryptApiResponse decryptData exception error :" + this.message);
                throw new KDBizException(this.message);
            }
            return (T)decryptData;
        }
        return this.data;
    }

    private void dealException(Exception e, String errorMessage) {
        this.errorCode = ERROR;
        this.success = false;
        this.message = e.getMessage();
        if (HRStringUtils.isEmpty(this.message)) {
            this.message = errorMessage;
        }
    }

    public static <T> HrEncryptApiResponse<T> success(T data) {
        HrEncryptApiResponse<T> result = new HrEncryptApiResponse<T>();
        result.setSuccess(true);
        result.setEncryptData(data);
        result.setErrorCode(SUCCESS);
        return result;
    }

    public static <T> HrEncryptApiResponse<T> success() {
        return new HrEncryptApiResponse<T>();
    }

    public static <T> HrEncryptApiResponse<T> fail(String msg) {
        return HrEncryptApiResponse.fail(msg, ERROR);
    }

    public static <T> HrEncryptApiResponse<T> fail(String msg, String errorCode) {
        HrEncryptApiResponse<T> result = new HrEncryptApiResponse<T>();
        result.setSuccess(false);
        result.setMessage(msg);
        result.setErrorCode(errorCode);
        return result;
    }

    public static <T> HrEncryptApiResponse<T> ex(Throwable ex) {
        HrEncryptApiResponse<T> result = new HrEncryptApiResponse<T>();
        result.setSuccess(false);
        result.setMessage(ex.getMessage());
        result.setErrorCode(HrEncryptApiResponse.getErrorCode(ex));
        return result;
    }

    public static <T> HrEncryptApiResponse<T> ex(Throwable ex, boolean showStackTrace) {
        HrEncryptApiResponse<T> result = new HrEncryptApiResponse<T>();
        result.setSuccess(false);
        if (ex instanceof KDBizException) {
            result.setMessage(ex.getMessage());
        } else {
            result.setMessage(showStackTrace ? ImportLogger.formatException((Throwable)ex) : ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"HrEncryptMServiceUtils_3", (String)"hrmp-hbp-common", (Object[])new Object[0]));
        }
        result.setErrorCode(HrEncryptApiResponse.getErrorCode(ex));
        return result;
    }

    private static String getErrorCode(Throwable ex) {
        if (ex instanceof KDException) {
            ErrorCode errorCode = ((KDException)ex).getErrorCode();
            if (errorCode != null && StringUtils.isNotBlank((CharSequence)errorCode.getCode())) {
                return errorCode.getCode();
            }
            return ERROR;
        }
        return ERROR;
    }

    public String toString() {
        return "HrEncryptApiResponse{cloudId='" + this.cloudId + '\'' + ", appId='" + this.appId + '\'' + ", serviceName='" + this.serviceName + '\'' + ", methodName='" + this.methodName + '\'' + ", encryptSchemeId=" + this.encryptSchemeId + ", isEncrypt=" + this.isEncrypt + ", success=" + this.success + ", data=" + this.data + ", message='" + this.message + '\'' + ", errorCode='" + this.errorCode + '\'' + '}';
    }
}

