/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hbp.common.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;

public class DynamicObjectCandidate
implements Comparable {
    private DynamicObject obj;
    private double score = 0.0;
    private ArrayList keyList;
    private ArrayList orderList;
    private static final Set<Class<?>> NUMBER_CLS_SET = new HashSet();

    private static boolean isNumber(Class<?> cls) {
        return NUMBER_CLS_SET.contains(cls);
    }

    public DynamicObjectCandidate(DynamicObject obj, String[] searchKey, Boolean bHasName, Boolean bHasNumber, ArrayList keyList, ArrayList orderList) {
        this.keyList = keyList;
        this.orderList = orderList;
        for (int i = 0; i < searchKey.length; ++i) {
            double sc;
            String keyStr = searchKey[i];
            keyStr = keyStr.toLowerCase(Locale.ROOT);
            this.obj = obj;
            String name = obj.getString("name").toLowerCase(Locale.ROOT);
            String number = obj.getString("number").toLowerCase(Locale.ROOT);
            if (bHasName.booleanValue() && name.length() > 0 && name.toLowerCase(Locale.ROOT).contains(keyStr) && this.score < (sc = (double)keyStr.length() * 1.0 / (double)name.length())) {
                this.score = sc;
            }
            if (!bHasNumber.booleanValue() || number.length() <= 0 || !number.toLowerCase(Locale.ROOT).contains(keyStr) || !(this.score < (sc = (double)keyStr.length() * 1.0 / (double)number.length()))) continue;
            this.score = sc;
        }
    }

    public DynamicObject getDynamicObject() {
        return this.obj;
    }

    public int compareTo(Object other) {
        DynamicObjectCandidate otherObj = (DynamicObjectCandidate)other;
        double differ = otherObj.score - this.score;
        if (differ > 1.0E-5) {
            return 1;
        }
        if (differ < -1.0E-5) {
            return -1;
        }
        return this.compareToOther(other);
    }

    private int compareToOther(Object other) {
        DynamicObjectCandidate otherObj = (DynamicObjectCandidate)other;
        int ret = 0;
        for (int i = 0; i < this.keyList.size(); ++i) {
            String order;
            String key = (String)this.keyList.get(i);
            Object value = this.obj.get(key);
            Object otherValue = otherObj.getDynamicObject().get(key);
            if (value != null && otherValue != null) {
                ret = DynamicObjectCandidate.compareByObj(value, otherValue, (String)this.orderList.get(i));
            } else if (value != null) {
                order = (String)this.orderList.get(i);
                ret = 1;
                if (order.equalsIgnoreCase("desc")) {
                    ret = -1 * ret;
                }
            } else if (otherValue != null) {
                order = (String)this.orderList.get(i);
                ret = -1;
                if (order.equalsIgnoreCase("desc")) {
                    ret = -1 * ret;
                }
            } else {
                ret = 0;
            }
            if (ret != 0) break;
        }
        return ret;
    }

    private static int compareByObj(Object v1, Object v2, String order) {
        int ret = 0;
        Class<?> cls = v1.getClass();
        if (DynamicObjectCandidate.isNumber(cls)) {
            ret = DynamicObjectCandidate.getRet((Number)v1, (Number)v2, ret, cls);
        } else if (cls == String.class) {
            String s1 = (String)v1;
            String s2 = (String)v2;
            ret = s1.compareToIgnoreCase(s2);
        } else if (Date.class.isAssignableFrom(cls)) {
            Date date1 = (Date)v1;
            Date date2 = (Date)v2;
            ret = date1.compareTo(date2);
        } else if (cls == OrmLocaleValue.class) {
            OrmLocaleValue o1 = (OrmLocaleValue)v1;
            OrmLocaleValue o2 = (OrmLocaleValue)v2;
            ret = o1.getDefaultItem().compareToIgnoreCase(o2.getDefaultItem());
        } else {
            String s1 = v1.toString();
            String s2 = v2.toString();
            ret = s1.compareToIgnoreCase(s2);
        }
        if (order.equalsIgnoreCase("desc")) {
            ret = -1 * ret;
        }
        return ret;
    }

    private static int getRet(Number v1, Number v2, int ret, Class<?> cls) {
        Double d1 = null;
        Double d2 = null;
        if (cls == Integer.class) {
            d1 = new Double(((Integer)v1).intValue());
            d2 = new Double(((Integer)v2).intValue());
        } else if (cls == Long.class) {
            d1 = new Double(((Long)v1).longValue());
            d2 = new Double(((Long)v2).longValue());
        } else if (cls == Double.class) {
            d1 = (Double)v1;
            d2 = (Double)v2;
        } else if (cls == BigDecimal.class) {
            BigDecimal b1 = (BigDecimal)v1;
            BigDecimal b2 = (BigDecimal)v2;
            ret = b1.compareTo(b2);
        }
        if (d1 != null && d2 != null) {
            double d3 = d1 - d2;
            ret = d3 > 1.0E-5 ? 1 : (d3 < -1.0E-5 ? -1 : 0);
        }
        return ret;
    }

    static {
        NUMBER_CLS_SET.add(Integer.class);
        NUMBER_CLS_SET.add(Long.class);
        NUMBER_CLS_SET.add(Double.class);
        NUMBER_CLS_SET.add(BigDecimal.class);
    }
}

